% p_7_1_1.m
% Copyright
% T. Schmitz
% June 1, 2008

clc
clear
close all

% Define parameters in local coordinates
m1 = 3;             % kg
c1 = 200;           % N-s/m
k1 = 2e6;           % N/m

m2 = 2;             % kg
c2 = 100;           % N-s/m
k2 = 1e6;           % N/m

kc = 5e5;           % N/m

% Define I and II FRFs
w = (0:0.1:300)'*2*pi; % frequency, rad/s
FRF_I = 1./(-w.^2*m1 + 1i*w*c1 + k1);
FRF_II = 1./(-w.^2*m2 + 1i*w*c2 + k2);

% Receptance coupling
FRF_III_rc = FRF_II - FRF_II./(FRF_I + FRF_II + 1/kc).*FRF_II;

% Modal analysis
s_squared = roots([(m1*m2) (m1*(k2+kc)+m2*(k1+kc)) ((k1+kc)*(k2+kc)-kc^2)]);
s1_squared = s_squared(1);
s2_squared = s_squared(2);
% Order natural frequencies so that wn1 < wn2
if s1_squared < s2_squared
    temp = s1_squared;
    s1_squared = s2_squared;
    s2_squared = temp;
end
wn1 = sqrt(-s1_squared);
wn2 = sqrt(-s2_squared);

p1 = kc/(m1*s1_squared + (k1+kc));
p2 = kc/(m1*s2_squared + (k1+kc));

% Local matrices
M = [m1 0; 0 m2];
C = [c1 0; 0 c2];
K = [k1+kc -kc; -kc k2+kc];

% Modal matrices
P = [p1 p2; 1 1];
mq = P'*M*P;
cq = P'*C*P;
kq = P'*K*P;

mq1 = mq(1,1);
mq2 = mq(2,2);
cq1 = cq(1,1);
cq2 = cq(2,2);
kq1 = kq(1,1);
kq2 = kq(2,2);

zetaq1 = cq1/(2*sqrt(kq1*mq1));
zetaq2 = cq2/(2*sqrt(kq2*mq2));

r1 = w/wn1;
r2 = w/wn2;

FRF_III_modal = 1/kq1*((1-r1.^2) - 1i*(2*zetaq1*r1))./((1-r1.^2).^2 + (2*zetaq1*r1).^2) + 1/kq2*((1-r2.^2) - 1i*(2*zetaq2*r2))./((1-r2.^2).^2 + (2*zetaq2*r2).^2);

% Complex matrix inversion
FRF_III_inversion = (-w.^2*m1 + 1i*w*c1 + k1 + kc)./((-w.^2*m1 + 1i*w*c1 + k1 + kc).*(-w.^2*m2 + 1i*w*c2 + k2 + kc) - kc^2);

figure(1)
subplot(211)
plot(w/2/pi, real(FRF_I), 'b:', w/2/pi, real(FRF_II), 'b-.', w/2/pi, real(FRF_III_rc), 'b', w/2/pi, real(FRF_III_modal), 'g', w/2/pi, real(FRF_III_inversion), 'r')
ylim([-8e-6 9e-6])
set(gca,'FontSize', 14)
ylabel('Real (m/N)')
subplot(212)
plot(w/2/pi, imag(FRF_I), 'b:', w/2/pi, imag(FRF_II), 'b-.', w/2/pi, imag(FRF_III_rc), 'b', w/2/pi, imag(FRF_III_modal), 'g', w/2/pi, imag(FRF_III_inversion), 'r')
ylim([-16e-6 16e-7])
set(gca,'FontSize', 14)
xlabel('Frequency (Hz)')
ylabel('Imag (m/N)')

% Calculate differences
diff_modal = FRF_III_inversion - FRF_III_modal;
diff_rc = FRF_III_inversion - FRF_III_rc;

figure(2)
subplot(211)
plot(w/2/pi, real(diff_modal), 'b', w/2/pi, imag(diff_modal), 'r:')
legend('Re', 'Im')
ylim([-2e-7 2e-7])
set(gca,'FontSize', 14)
ylabel('Modal errors (m/N)')
subplot(212)
plot(w/2/pi, real(diff_rc), 'b', w/2/pi, imag(diff_rc), 'r:')
legend('Re', 'Im')
ylim([-6e-21 4e-21])
set(gca,'FontSize', 14)
xlabel('Frequency (Hz)')
ylabel('Receptance errors (m/N)')
