

## ----learn-for-prada-no-eval, include = FALSE, fig.cap = "Ein Dozentenbeispiel: Üben macht schlau, angeblich", fig.asp = .8----
data(stats_test, package = "pradadata")

library(tidyverse)

stats_test %>%
  filter(study_time %in% 1:5) %>%
  select(bestanden, study_time, score) %>%
  na.omit() %>%
  ggplot(aes(x = factor(study_time), y = score)) +
  geom_jitter(aes(color = bestanden, shape = bestanden), alpha = .56) +
  geom_boxplot(alpha = .7) +
  geom_smooth(aes(group = 1), method = "lm", se = FALSE) +
  theme(legend.position = "bottom") +
  labs(y = "Prozent richtiger Lösungen",
       x = "Lernaufwand",
       title = "Mehr Lernen, bessere Noten",
       subtitle = "Der Zusammenhang von Lernzeit und Klausurerfolg in der Statistik",
       caption = paste0("n = ", nrow(stats_test), " Studenten"))

