
## ----signal-noise, echo = FALSE, fig.cap = "Muster und Rauschen", out.width = "100%"----
data(wo_men, package = "pradadata")
library(tidyverse)

wo_men %>%
  drop_na(sex, height) %>%
  filter(height > 150, height < 220) -> df


p1 <- wo_men %>%
  drop_na(sex, height) %>%
  filter(height > 150, height < 220) %>%
  ggplot(aes(x = sex, y = height)) +
  geom_jitter(width = .2, alpha = .7) +
  ylim(150, 220) +
  theme_gray() -> p1


df %>%
  ggplot(aes(x = sex, y = height)) +
  stat_summary(fun.y = "mean", geom = "point", size = 10,
               color = "red", alpha = .5, shape = 15) +
  stat_summary(fun.y = "mean", geom = "line", group = 1,
               color = "red", alpha = .5) +
  geom_jitter(width = .2, alpha = .7) +
  ylim(150, 220) +
  theme_gray() -> p2


gridExtra::grid.arrange(p1, p2, nrow = 1)



## ----signal-noise2, echo = FALSE, out.width = "100%", fig.cap = "Das Ziehen von Stichproben  birgt Zufall"----

# sample
set.seed(123456)
sample_m <- sample(df$row_number[df$sex == "man"], size = 1)
sample_f <- sample(df$row_number[df$sex == "woman"], size = 1)

df %>%
  filter(row_number %in% c(sample_m, sample_f)) %>%
  ggplot(aes(x = sex, y = height)) +
  stat_summary(fun.y = "mean", geom = "point", size = 10,
               color = "red", alpha = .5, shape = 15) +
  stat_summary(fun.y = "mean", geom = "line", group = 1,
               color = "red", alpha = .5) +
  geom_point(alpha = .7) +
  ylim(150, 220) +
  theme_gray() -> p3


set.seed(123456)
sample_m2 <- sample(df$row_number[df$sex == "man"], size = 5)
sample_f2 <- sample(df$row_number[df$sex == "woman"], size = 5)

df %>%
  filter(row_number %in% c(sample_m2, sample_f2)) %>%
  ggplot(aes(x = sex, y = height)) +
  stat_summary(fun.y = "mean", geom = "point", size = 10,
               color = "red", alpha = .5, shape = 15) +
  stat_summary(fun.y = "mean", geom = "line", group = 1,
               color = "red", alpha = .5) +
  geom_jitter(width = .2, alpha = .7) +
  ylim(150, 220) +
  theme_gray() -> p4


gridExtra::grid.arrange(p3, p4, nrow = 1)


