
## ------------------------------------------------------------------------
library(tidyverse)

## ----load-extra----------------------------------------------------------
data(profiles, package = "okcupiddata")

## ----date-deutsch-no-eval, eval = FALSE----------------------------------
daten_deutsch <- read_delim("daten_deutsch.csv",
                            delim = ";",
                            locale = locale(decimal_mark = ","))

daten_deutsch <- read_csv2("daten_deutsch.csv")


## ----prada-stats-test-download, eval = TRUE------------------------------
prada_stats_test_url <-
  paste0("https://raw.github.com/",  # Domain, Webseitenname
         "sebastiansauer/",  # Nutzer
         "Praxis_der_Datenanalyse/",  # Projekt/Repositorium
         "master/",  # Variante
         "data/stats_test.csv")  # Ordner und Dateinamen

stats_test <- read_csv(prada_stats_test_url)



## ----eval = TRUE---------------------------------------------------------
stats_test_normaler_df <- as.data.frame(stats_test)
str(stats_test_normaler_df[, c("self_eval", "score")])  # Output: df
str(stats_test_normaler_df[, "self_eval"])  # output: Vektor!

## ----class-tibble--------------------------------------------------------
class(stats_test)
class(data.frame(stats_test))
attr(stats_test, "class")

## Speichern Sie R-Textdateien wie Skripte stets mit UTF-8-Kodierung ab.

## ----write-csv, eval = FALSE---------------------------------------------
write_csv(name_der_tabelle, "Dateiname.csv")



## ----eval = FALSE--------------------------------------------------------
## # nur die ersten paar Zeilen zeigen, daher mit head()
as_tibble(head(profiles))  # tibble
as.data.frame(head(profiles))  # normaler Dataframe

