## ----echo = FALSE--------------------------------------------------------
knitr::include_graphics("images/komm/Kommunizieren-crop.pdf")

## Lernziele:

## ----libs-rmd------------------------------------------------------------
library(knitr)
library(tidyverse)
library(xtable)
library(stargazer)
library(kableExtra)
library(formattable)
library(apaTables)
data(stats_test, package = "pradadata")

## ----libs-hiden-rmd, echo = FALSE, eval = FALSE--------------------------
library(yart)
library(papaja)
library(komaletter)
library(pradadata)




## ------------------------------------------------------------------------
mtcars %>%
  slice(1:3)

## ----kable---------------------------------------------------------------
mtcars %>%
  slice(1:3) %>%
  kable(caption = "Eine Tabelle mit kable aus knitr")

## ----lm1xtable-no-eval, eval = FALSE-------------------------------------
lm1 <- lm(score ~ interest + study_time + interest:study_time,
          data = stats_test)
print(xtable(lm1), type = "html")  # oder: type = "latex"

## ----lm1xtable, echo = FALSE, result = "asis"----------------------------
lm1 <- lm(score ~ interest + study_time + interest:study_time,
          data = stats_test)
if (knitr:::is_html_output()) print(xtable(lm1), type = "html")
if (knitr:::is_html_output()) print(xtable(lm1), type = "latex")

## ----eval = FALSE--------------------------------------------------------
options(knitr.table.format = "html")  # oder knitr.table.format = "latex"

## ----kableExtra-output, echo = FALSE-------------------------------------
if (knitr:::is_html_output()) options(knitr.table.format = "html")
if (knitr:::is_html_output())options(knitr.table.format = "latex")

## ----eval = FALSE--------------------------------------------------------
kable(head(stats_test), "html") %>%
  kable_styling(bootstrap_options = "striped", full_width = F)

## ----eval = FALSE--------------------------------------------------------
kable(head(stats_test), "html") %>%
  kable_styling(bootstrap_options = "striped", full_width = F) %>%
   column_spec(7, bold = T) %>%
   row_spec(3:4, bold = T, color = "white", background = "red")

## ----df-stats, include = FALSE-------------------------------------------
df <- stats_test %>%
  select(interest, study_time, score, bestanden) %>%
  na.omit() %>%
  arrange(bestanden) %>%
  filter(row_number() %in% c(1,2,3, 1629, 1630, 1631))

## ----eval = FALSE--------------------------------------------------------
df  %>%
  mutate(bestanden = ifelse(bestanden == "nein",
                            cell_spec(bestanden, "html",
                                      color = "red", bold = T),
                            cell_spec(bestanden, "html",
                                      color = "green", italic = T)),
         score = color_bar("lightblue")(score),
         interest = color_tile("orange", "green")(interest)
  ) %>%
  kable("html", escape = F) %>%
  kable_styling("hover", full_width = F) %>%
  column_spec(3, width = "3cm")




