
## ----libs-polit-twitter-silent, echo = FALSE-----------------------------
library(huxtable)
library(tidyverse)

## ----sentiws, echo = FALSE-----------------------------------------------
library(sentiws, package = "pradadata")

sentiws %>%
  select(-4) %>%
  group_by(neg_pos) %>%
  top_n(3, wt = abs(value)) %>%
  knitr::kable(caption = "Ausschnitt aus dem SentiWS-Emotionslexikon",
booktabs = TRUE)


## ----p-party-pop-scores-details-no-trump-point-limited-grey, eval = FALSE, out.height="100%"----
polits_df_long %>%
  ggplot +
  aes(x = Indikator, y = z_Wert,) +
  geom_point(color = "grey80", position = "jitter") +
  facet_wrap(~party, nrow = 1) +
  scale_color_manual(values = party_pal) +
  scale_x_discrete(labels = pop_vars_de) +
  scale_y_continuous(limits = c(-1.5,1.5), breaks = c(-1,0,1)) +
  theme(legend.position = "none") +
  coord_flip() +
  labs(caption =
       "dargestellt sind Mediane über alle Tweets aller Politiker",
       y = "*z*-Wert",
       color = "Partei") +
  geom_point(data = party_pop_scores_md_long, aes(color = party), size = 4) +
  geom_line(data = party_pop_scores_md_long, aes(color = party), group = 1)



