
## ----libs-progr----------------------------------------------------------
library(tidyverse)
library(magrittr)
library(gridExtra)

data(extra, package = "pradadata")
data(Affairs, package = "AER")


## ----abfolge-------------------------------------------------------------
x <- c(1, 2, 3)

x %>%
  subtract(mean(x)) %>%
  raise_to_power(2) %>%
  sum() %>%
  divide_by(length(x)) %>%
  sqrt()

## ----eval = FALSE--------------------------------------------------------
# sd2 <- function(eingabevektor){
#   # hier unsere Rechenschritte, der "Körper" der Funktion
# }

## ----abfolge-fun---------------------------------------------------------
sd2 <- function(eingabevektor){
eingabevektor %>%
  subtract(mean(eingabevektor)) %>%
  raise_to_power(2) %>%
  sum() %>%
  divide_by(length(eingabevektor)) %>%
  sqrt()
}

## ------------------------------------------------------------------------
sd2(x)



## ----prefix-funtion------------------------------------------------------
`+`(1, 1)

## ----strange-fun---------------------------------------------------------
sd2 <- function(eingabevektor){
eingabevektor %>%
  `-`(mean(eingabevektor)) %>%
  `^`(2) %>%
  sum() %>%
  `/`(length(eingabevektor)) %>%
  sqrt() -> ausgabe
  return(ausgabe)

}
sd2_von_x <- sd2(x)
str(sd2_von_x)


## ------------------------------------------------------------------------
x <- 1:3
y <- 4:6
x+y

## ----for-loop------------------------------------------------------------
z <- vector(mode = "numeric", length = length(x))
for(i in seq_along(x)) {
      z[i] <- x[i] + y[i]
}
z

## ------------------------------------------------------------------------
extra %>%
  summarise_at(vars(i01:i02r), funs(max, median, sd, IQR), na.rm = TRUE)

## ----favstats------------------------------------------------------------
extra %>%
  select(i01, i02r) %>%
  map(mosaic::favstats)

## ------------------------------------------------------------------------
extra %>%
  select(i01:i02r) %>%
  map(mean, na.rm = TRUE)

## Nimm den Datensatz `extra` UND DANN

## ----results = "hide"----------------------------------------------------
extra %>%
  select(i01:i10) %>%
  map(~mean(., na.rm = TRUE))

## ------------------------------------------------------------------------
extra %>%
  select(i01:i02r) %>%
  map_dbl(~mean(., na.rm = TRUE))


## ----write-csvs----------------------------------------------------------
1:3 %>%
  map(~filter(extra, row_number() == .)) %>%
  map(~select(., 1:3)) %>%
  imap(~write_csv(., path = paste0("dummy/df", .y, ".csv")))

## ----csv-names-----------------------------------------------------------
1:3 %>%
  map(~filter(extra, row_number() == .)) %>%
  map(~select(., 1:3)) %>%
  imap(~paste0("dummy/df", .y, ".csv"))

## ----eval = FALSE--------------------------------------------------------
df1 <- read_csv("dummy/df1.csv")
df2 <- read_csv("dummy/df2.csv")
df3 <- read_csv("dummy/df3.csv")

## ------------------------------------------------------------------------
df_filenames <- dir(path = "dummy", pattern = "*.csv")
str(df_filenames)

## ----eval = FALSE--------------------------------------------------------
df_filenames %>%
  map(read_csv)

## ----df-filenames--------------------------------------------------------
df_filenames %>%
  map_df(~read_csv(file = paste0("dummy/", .))) -> df
df

## ------------------------------------------------------------------------
extra %>%
  select(i01, i02r, i03, n_facebook_friends, sex) %>%
  split(.$sex) %>%
  map(~lm(n_facebook_friends ~ i01 + i02r + i03, data = .)) -> extra_models

## ----map-r-sq------------------------------------------------------------
extra_models %>%
  map(summary) %>%
  map_dbl("r.squared")

## ------------------------------------------------------------------------
Affairs %>%
select_if(is.numeric) %>% head

## ------------------------------------------------------------------------
Affairs %>%
  select_if(is.numeric) %>%
  map(~t.test(. ~ Affairs$gender)) %>%
  map_dbl("p.value")


## ----lapply-demo, results = "hide"---------------------------------------
lapply(Affairs[c("affairs", "age", "yearsmarried")],
       function(x) t.test(x ~ Affairs$gender))

## ----p-map-ttest, fig.cap = "Multiple t-Tests und deren *p*-Werte"-------
Affairs %>%
  select_if(is.numeric) %>%
  map_df(~t.test(. ~ Affairs$gender)$p.value) %>%
  gather() %>%
  mutate(signif = ifelse(value < .05, "significant", "ns")) %>%
  ggplot(aes(x = reorder(key, value), y = value)) +
  geom_point(aes(color = signif, shape = signif)) +
  coord_flip() +
  labs(x = "Untersuchte Variablen",
       y = "p-Wert")

## ----map-pvalue----------------------------------------------------------
Affairs %>%
  select_if(is.numeric) %>%
  map(~t.test(. ~ Affairs$gender)) %>%
  keep(~.$p.value < .05) %>%
  map("p.value")

----blinke, eval = FALSE------------------------------------------------
abbiegen <- function(richtung, krass = FALSE){
  schulterblick(richtung)
  blinke(richtung)
  zustand <- lenke(richtung)
  return(zustand)
}

## ----p-simple-code, fig.cap = "Den Code vereinfachen, hilft Fehler zu finden", out.width = "100%"----
extra %>%
  select(extra_mean) %>%
  drop_na(extra_mean) %>%
  ggplot +
  aes(x = extra_mean, fill = "sex") +
  geom_histogram() +
  labs(title = "Was für ein Histogramm",
       subtitle = "Aber was ist mit den Farben?!") +
  theme(legend.position  = "bottom") -> p1


extra %>%
  ggplot() +
  aes(x = extra_mean, color = sex) +
  geom_histogram() -> p2

grid.arrange(p1, p2, nrow = 1)

## ----stop-if-not-demo, eval = FALSE--------------------------------------
stopifnot(is.numeric(extra$sex))
stopifnot(is.numeric(extra$n_party))

stopifnot(sum(is.na(extra$n_party)) == 0)
sum(is.na(extra$n_party))


## ------------------------------------------------------------------------

s <- c("Hallo", "R", "wie", "geht's")

paste0(s, "!")


