function [K] = ...
    formStiffnessMatrixK(GDof,numberElements, ...
    elementNodes,numberNodes,nodeCoordinates, ...
    C_bending,quadType,dof_per_node)

% computation of stiffness matrix for Kirchhoff plate element

% K: stiffness matrix
K = zeros(GDof);

% Gauss quadrature for bending part
[gaussWeights,gaussLocations] = gaussQuadrature(quadType);

% cycle for element
for e = 1:numberElements
    % indice: nodal connectivities for each element
    % elementDof: element degrees of freedom
    indice = elementNodes(e,:);
    if dof_per_node == 3
        elementDof = [indice indice+numberNodes ...
            indice+2*numberNodes];
    else % 4 dof
        elementDof = [indice indice+numberNodes ...
            indice+2*numberNodes indice+3*numberNodes];
    end
    ndof = length(elementDof);
    
    % cycle for Gauss point
    for q = 1:size(gaussWeights,1)
        GaussPoint = gaussLocations(q,:);
        xi = GaussPoint(1);
        eta = GaussPoint(2);
        
        % part related to the mapping
        % shape functions and derivatives
        [~,natDerQ4] = shapeFunctionKQ4(xi,eta);
        if dof_per_node == 3
            [~,naturalDerivatives] = shapeFunctionK12(xi,eta);
        else % 4 dof
            [~,naturalDerivatives] = shapeFunctionK16(xi,eta);
        end
        
        % Jacobian matrix, inverse of Jacobian,
        % derivatives w.r.t. x,y
        [Jacob,invJacobian,XYDerQ4] = ...
            JacobianK(nodeCoordinates(indice,:),natDerQ4);
        detJ = det(Jacob);
        
        detJ_xi = XYDerQ4(1,1)*XYDerQ4(2,5) ...
            - XYDerQ4(2,1)*XYDerQ4(1,5) ...
            + XYDerQ4(2,2)*XYDerQ4(1,3) ...
            - XYDerQ4(1,2)*XYDerQ4(2,3);
        detJ_eta = -XYDerQ4(1,2)*XYDerQ4(2,5) ...
            + XYDerQ4(2,2)*XYDerQ4(1,5) ...
            - XYDerQ4(2,1)*XYDerQ4(1,4) ...
            + XYDerQ4(1,1)*XYDerQ4(2,4);
        
        xi_x = invJacobian(1,1);
        xi_y = invJacobian(2,1);
        eta_x = invJacobian(1,2);
        eta_y = invJacobian(2,2);
        xi_xx = detJ^-2*(XYDerQ4(2,2)*XYDerQ4(2,5) ...
            - XYDerQ4(2,2)^2/detJ*detJ_xi ...
            - XYDerQ4(2,1)*XYDerQ4(2,4) ...
            + XYDerQ4(2,1)*XYDerQ4(2,2)/detJ*detJ_eta);
        xi_yy = detJ^-2*(XYDerQ4(1,2)*XYDerQ4(1,5) ...
            - XYDerQ4(1,2)^2/detJ*detJ_xi ...
            - XYDerQ4(1,1)*XYDerQ4(1,4) ...
            + XYDerQ4(1,1)*XYDerQ4(1,2)/detJ*detJ_eta);
        
        eta_xx = detJ^-2*(-XYDerQ4(2,2)*XYDerQ4(2,3) ...
            + XYDerQ4(2,2)*XYDerQ4(2,1)/detJ*detJ_xi ...
            + XYDerQ4(2,1)*XYDerQ4(2,5) ...
            - XYDerQ4(2,1)^2/detJ*detJ_eta);
        eta_yy = detJ^-2*(-XYDerQ4(1,2)*XYDerQ4(1,3) ...
            + XYDerQ4(1,2)*XYDerQ4(1,1)/detJ*detJ_xi ...
            + XYDerQ4(1,1)*XYDerQ4(1,5) ...
            - XYDerQ4(1,1)^2/detJ*detJ_eta);
        
        xi_xy = detJ^-2*(-XYDerQ4(2,2)*XYDerQ4(1,5) ...
            + XYDerQ4(2,2)*XYDerQ4(1,2)/detJ*detJ_xi ...
            + XYDerQ4(2,1)*XYDerQ4(1,4) ...
            - XYDerQ4(2,1)*XYDerQ4(1,2)/detJ*detJ_eta);
        eta_xy = detJ^-2*(-XYDerQ4(2,1)*XYDerQ4(1,5) ...
            - XYDerQ4(2,2)*XYDerQ4(1,1)/detJ*detJ_xi ...
            + XYDerQ4(2,2)*XYDerQ4(1,3) ...
            + XYDerQ4(2,1)*XYDerQ4(1,1)/detJ*detJ_eta);
        
        % [B] matrix bending
        B_b = zeros(3,ndof);
        B_b(1,1:ndof) = xi_x^2*naturalDerivatives(:,3)' + ...
            eta_x^2*naturalDerivatives(:,4)' + ...
            2*xi_x*eta_x*naturalDerivatives(:,5)' + ...
            xi_xx*naturalDerivatives(:,1)' + ...
            eta_xx*naturalDerivatives(:,2)';
        B_b(2,1:ndof) = xi_y^2*naturalDerivatives(:,3)' + ...
            eta_y^2*naturalDerivatives(:,4)' + ...
            2*xi_y*eta_y*naturalDerivatives(:,5)' + ...
            xi_yy*naturalDerivatives(:,1)' + ...
            eta_yy*naturalDerivatives(:,2)';
        B_b(3,1:ndof) = 2*(xi_x*xi_y*naturalDerivatives(:,3)' + ...
            eta_x*eta_y*naturalDerivatives(:,4)' + ...
            (xi_x*eta_y + xi_y*eta_x)*naturalDerivatives(:,5)' + ...
            xi_xy*naturalDerivatives(:,1)' + ...
            eta_xy*naturalDerivatives(:,2)');
        
        % stiffness matrix bending
        K(elementDof,elementDof) = K(elementDof,elementDof) + ...
            B_b'*C_bending*B_b*gaussWeights(q)*det(Jacob);
        
    end  % Gauss point
end    % element

end