function [prescribedDof,activeDof,fixedNodeW] = ...
    EssentialBC5dof(typeBC,GDof,xx,yy,nodeCoordinates,numberNodes)

% essentialBoundary conditions for recatngular plates (5Dof)
switch typeBC
    case 'ssss'
        fixedNodeW =find(xx==max(nodeCoordinates(:,1))|...
            xx==min(nodeCoordinates(:,1))|...
            yy==min(nodeCoordinates(:,2))|...
            yy==max(nodeCoordinates(:,2)));
        
        fixedNodeTX =find(yy==max(nodeCoordinates(:,2))|...
            yy==min(nodeCoordinates(:,2)));
        fixedNodeTY =find(xx==max(nodeCoordinates(:,1))|...
            xx==min(nodeCoordinates(:,1)));
        % fixedNodeU =find(xx==min(nodeCoordinates(:,1)));
        % fixedNodeV =find(yy==min(nodeCoordinates(:,2)));
        fixedNodeU =find(yy==max(nodeCoordinates(:,2))|...
            yy==min(nodeCoordinates(:,2)));
        fixedNodeV =find(xx==max(nodeCoordinates(:,1))|...
            xx==min(nodeCoordinates(:,1)));
        
    case 'ssss2'
        fixedNodeW =find(xx==max(nodeCoordinates(:,1))|...
            xx==min(nodeCoordinates(:,1))|...
            yy==min(nodeCoordinates(:,2))|...
            yy==max(nodeCoordinates(:,2)));
        
        fixedNodeTX =find(yy==max(nodeCoordinates(:,2))|...
            yy==min(nodeCoordinates(:,2)));
        fixedNodeTY =find(xx==max(nodeCoordinates(:,1))|...
            xx==min(nodeCoordinates(:,1)));
        fixedNodeU =find(xx==max(nodeCoordinates(:,1))|...
            xx==min(nodeCoordinates(:,1)));
        fixedNodeV =find(yy==max(nodeCoordinates(:,2))|...
            yy==min(nodeCoordinates(:,2)));
        
    case 'cccc'
        fixedNodeW =find(xx==max(nodeCoordinates(:,1))|...
            xx==min(nodeCoordinates(:,1))|...
            yy==min(nodeCoordinates(:,2))|...
            yy==max(nodeCoordinates(:,2)));
        fixedNodeTX =fixedNodeW;
        fixedNodeTY =fixedNodeTX;
        fixedNodeU =fixedNodeTX;
        fixedNodeV =fixedNodeTX;
        
end

prescribedDof=[fixedNodeW;fixedNodeTX+numberNodes;...
    fixedNodeTY+2*numberNodes;...
    fixedNodeU+3*numberNodes;fixedNodeV+4*numberNodes];
activeDof=setdiff([1:GDof]',[prescribedDof]);