function varargout = Contour_Lines_Gradient(varargin)
% CONTOUR_LINES_GRADIENT M-file for Contour_Lines_Gradient.fig
%      CONTOUR_LINES_GRADIENT, by itself, creates a new CONTOUR_LINES_GRADIENT or raises the existing
%      singleton*.
%
%      H = CONTOUR_LINES_GRADIENT returns the handle to a new CONTOUR_LINES_GRADIENT or the handle to
%      the existing singleton*.
%
%      CONTOUR_LINES_GRADIENT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in CONTOUR_LINES_GRADIENT.M with the given input arguments.
%
%      CONTOUR_LINES_GRADIENT('Property','Value',...) creates a new CONTOUR_LINES_GRADIENT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Contour_Lines_Gradient_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Contour_Lines_Gradient_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help Contour_Lines_Gradient

% Last Modified by GUIDE v2.5 18-Jul-2005 22:13:45

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Contour_Lines_Gradient_OpeningFcn, ...
                   'gui_OutputFcn',  @Contour_Lines_Gradient_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Contour_Lines_Gradient is made visible.
function Contour_Lines_Gradient_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Contour_Lines_Gradient (see VARARGIN)

% Choose default command line output for Contour_Lines_Gradient
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Contour_Lines_Gradient wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Contour_Lines_Gradient_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in checkbox1.
function checkbox1_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox1



function editFunction_Callback(hObject, eventdata, handles)
% hObject    handle to editFunction (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editFunction as text
%        str2double(get(hObject,'String')) returns contents of editFunction as a double


% --- Executes during object creation, after setting all properties.
function editFunction_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editFunction (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editxy_Callback(hObject, eventdata, handles)
% hObject    handle to editxy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editxy as text
%        str2double(get(hObject,'String')) returns contents of editxy as a double


% --- Executes during object creation, after setting all properties.
function editxy_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editxy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editNlines_Callback(hObject, eventdata, handles)
% hObject    handle to editNlines (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editNlines as text
%        str2double(get(hObject,'String')) returns contents of editNlines as a double


% --- Executes during object creation, after setting all properties.
function editNlines_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editNlines (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in checkboxLabels.
function checkboxLabels_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxLabels (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxLabels


% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

example = get(handles.checkbox1,'Value');

if example
   ex1 = get(handles.radiobuttonf1,'Value');
   ex2 = get(handles.radiobuttonf2,'Value');
   ex3 = get(handles.radiobuttonf3,'Value');
   ex4 = get(handles.radiobuttonf4,'Value');
   if ex1
       Function1;
   elseif ex2
       Function2;
   elseif ex3
       Function3
   elseif ex4
       Function4
   end
else
    xypoints = str2num(get(handles.editxy,'String'));
    [x,y] = meshgrid(xypoints);
    m1 = get(handles.editFunction,'String');
    z = eval(m1);
    
    figure(1)
    subplot('position',[0.3 0.53 0.4 0.4]) 
    surf(x,y,z); 
    title(['f(x,y) = ',m1]); xlabel('x'); ylabel('y'); zlabel('z')
    
    NL = str2num(get(handles.editNlines,'String'));
    labs = get(handles.checkboxLabels,'Value');
    
    subplot('position',[0.10 0.10 0.36 0.36]) 
    [c,h] = contour(x,y,z,NL);
    if labs
    clabel(c)
    end
    title('Contour Lines'); xlabel('x'); ylabel('y')

    subplot('position',[0.55 0.10 0.35 0.35]) 
    [dx,dy] = gradient(z);
    contour(x,y,z,10)
    hold on
    quiver(x,y,dx,dy,1.2,'k');
    title('Gradient'); xlabel('x'); ylabel('y')
    hold off
    
end


%--------------------------------------------------------------------------
function Function1

[x,y] = meshgrid(-3:0.3:3);
z = 16 -(x.^2 + y.^2);

figure(1)
subplot('position',[0.3 0.53 0.4 0.4]) 
surf(x,y,z); 
title('f(x,y) = 16 - (x^2 + y^2)'); xlabel('x'); ylabel('y'); zlabel('z')

subplot('position',[0.10 0.10 0.36 0.36]) 
[c,h] = contour(x,y,z,10);
clabel(c)
title('Contour Lines'); xlabel('x'); ylabel('y')

subplot('position',[0.55 0.10 0.35 0.35]) 
[dx,dy] = gradient(z);
contour(x,y,z,10)
hold on
quiver(x,y,dx,dy,1.2,'k');
title('Gradient'); xlabel('x'); ylabel('y')
hold off

% --------------------------------------------------------------------
function Function2

[x,y] = meshgrid(-2:0.2:2);
z = x.^2.*y-3.*x+3;

figure(1)
subplot('position',[0.3 0.53 0.4 0.4]) 
surf(x,y,z); 
title('f(x,y) = x^2y -3x + 3'); xlabel('x'); ylabel('y'); zlabel('z')

subplot('position',[0.10 0.10 0.35 0.35])
lines = [13 11.6 10.3 9 7.6 6.3 5 3.6 2.3 1 -0.3 -1.6 -3 -4.3 -5.6 -7 -8 -11];
[c,h] = contour(x,y,z,lines);%without numeration use just contour(z,20)
clabel(c,h)
title('Contour Lines'); xlabel('x'); ylabel('y')


subplot('position',[0.55 0.10 0.35 0.35]) 
[dx,dy] = gradient(z);
contour(x,y,z,10)
hold on
quiver(x,y,dx,dy,1.2,'k');
title('Gradient'); xlabel('x'); ylabel('y')
hold off

% --------------------------------------------------------------------
function Function3()

[x,y] = meshgrid(-2:0.2:2);
z = x.*exp(-x.^2 -y.^2);
figure(1)
subplot('position',[0.3 0.53 0.4 0.4])
surf(x,y,z); 
title('f(x,y) = x.exp(-x^2 -y^2)'); xlabel('x'); ylabel('y'); zlabel('z')

subplot('position',[0.10 0.10 0.35 0.35])
[c,h] = contour(x,y,z,8);
clabel(c)
title('Contour Lines'); xlabel('x'); ylabel('y')
%clabel(c,h,'LabelSpacing',300)
%clabel(c,h,'FontSize',12,'Color','k','Rotation',0)

subplot('position',[0.55 0.10 0.35 0.35]) 
[dx,dy] = gradient(z);
contour(x,y,z,10)
hold on
quiver(x,y,dx,dy,1.2,'k');
title('Gradient'); xlabel('x'); ylabel('y')
hold off

% --------------------------------------------------------------------
function Function4()

[x,y] = meshgrid(-3:0.15:3, -3:0.15:3);
z = 3*(1-x).^2.*exp(-(x.^2) - (y+1).^2) ...
   - 10*(x/5 - x.^3 - y.^5).*exp(-x.^2-y.^2) ...
   - 1/3*exp(-(x+1).^2 - y.^2);
figure(1)
subplot('position',[0.3 0.53 0.4 0.4])
surf(x,y,z); 
title('f(x,y) = 3(1-x)^2exp(-x^2 - (y-1)^2)-10(x/5 -x^3 -y^5)exp(-x^2 -y^2)-1/3exp(-(x+1)^2 - y^2)'); 
xlabel('x'); ylabel('y'); zlabel('z')

subplot('position',[0.10 0.10 0.35 0.35])
[c,h] = contour(x,y,z,30);
title('Contour Lines'); xlabel('x'); ylabel('y')

subplot('position',[0.55 0.10 0.35 0.35]) 
[dx,dy] = gradient(z);
contour(x,y,z,10)
hold on
quiver(x,y,dx,dy,1.2,'k');
title('Gradient'); xlabel('x'); ylabel('y')
hold off
% --------------------------------------------------------------------
function radiobuttonf1_Callback(hObject, eventdata, handles)

flag = get(handles.checkbox1,'Value');
if flag
  set(handles.editxy,'String',['-3:0.3:3']) 
  set(handles.editFunction,'String',['16 -(x.^2 + y.^2)']) 
  guidata(hObject,handles);%store changes 
end

function radiobuttonf2_Callback(hObject, eventdata, handles)

flag = get(handles.checkbox1,'Value');
if flag
  set(handles.editxy,'String',['-2:0.2:2']) 
  set(handles.editFunction,'String',['x.^2.*y-3.*x+3']) 
  guidata(hObject,handles);%store changes 
end

function radiobuttonf3_Callback(hObject, eventdata, handles)

flag = get(handles.checkbox1,'Value');
if flag
  set(handles.editxy,'String',['-2:0.2:2']) 
  set(handles.editFunction,'String',['x.*exp(-x.^2 -y.^2)']) 
  guidata(hObject,handles);%store changes 
end

function radiobuttonf4_Callback(hObject, eventdata, handles)

flag = get(handles.checkbox1,'Value');
if flag
  set(handles.editxy,'String',['-3:0.15:3']) 
  set(handles.editFunction,'String',[' 3*(1-x).^2.*exp(-(x.^2) - (y+1).^2)' ...
   '- 10*(x/5 - x.^3 - y.^5).*exp(-x.^2-y.^2)' ...
   '- 1/3*exp(-(x+1).^2 - y.^2)']) 
  guidata(hObject,handles);%store changes 
end



% --------------------------------------------------------------------
function Untitled_12_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_13_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_5_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_7_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_8_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_9_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_10_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_1_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_2_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


