function varargout = Electrical_Current(varargin)
% ELECTRICAL_CURRENT M-file for Electrical_Current.fig
%      ELECTRICAL_CURRENT, by itself, creates a new ELECTRICAL_CURRENT or raises the existing
%      singleton*.
%
%      H = ELECTRICAL_CURRENT returns the handle to a new ELECTRICAL_CURRENT or the handle to
%      the existing singleton*.
%
%      ELECTRICAL_CURRENT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in ELECTRICAL_CURRENT.M with the given input arguments.
%
%      ELECTRICAL_CURRENT('Property','Value',...) creates a new ELECTRICAL_CURRENT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Electrical_Current_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Electrical_Current_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help Electrical_Current

% Last Modified by GUIDE v2.5 14-Jul-2005 15:53:43

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Electrical_Current_OpeningFcn, ...
                   'gui_OutputFcn',  @Electrical_Current_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Electrical_Current is made visible.
function Electrical_Current_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Electrical_Current (see VARARGIN)

% Choose default command line output for Electrical_Current
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Electrical_Current wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Electrical_Current_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in checkboxForce.
function checkboxForce_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxForce (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxForce



function editI1_Callback(hObject, eventdata, handles)
% hObject    handle to editI1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editI1 as text
%        str2double(get(hObject,'String')) returns contents of editI1 as a double


% --- Executes during object creation, after setting all properties.
function editI1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editI1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editI2_Callback(hObject, eventdata, handles)
% hObject    handle to editI2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editI2 as text
%        str2double(get(hObject,'String')) returns contents of editI2 as a double


% --- Executes during object creation, after setting all properties.
function editI2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editI2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in pushbutton2D.
function pushbutton2D_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton2D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

I1 = str2num(get(handles.editI1,'String'));%get value input text
I2 = str2num(get(handles.editI2,'String'));%get value input text
force = get(handles.checkboxForce,'Value');%

x = linspace(-1,2,48);
y = linspace(-1,1,32);

position1 = 0;%position of the currente1 on the x axis
position2 = 1;%position of the currente1 on the x axis

figure(1); subplot('position',[0.1 0.1 0.8 0.8])
if I1>0
plot(position1,0,'r*'); hold on
end
if I1<0
plot(position1,0,'b*'); hold on
end
if I2>0
plot(position2,0,'r*'); hold on
end
if I2<0
plot(position2,0,'b*'); hold on
end

for n=1:length(x)
  for m=1:length(y)
    theta1 = atan(y(m)/(x(n) - position1));  
    rho1 = sqrt((x(n)- position1)^2 + y(m)^2);
    Ic1 = I1/(2*pi*rho1);
    theta2 = atan(y(m)/(x(n) - position2));  
    rho2 = sqrt((x(n)- position2)^2 + y(m)^2);
    Ic2 = I2/(2*pi*rho2);
    if x(n)< position1
      Hi1(m,n) = Ic1*sin(theta1) - Ic1*cos(theta1)*i;
    else
      Hi1(m,n) = -Ic1*sin(theta1) + Ic1*cos(theta1)*i;
    end
    if x(n)< position2
      Hi2(m,n) = Ic2*sin(theta2) - Ic2*cos(theta2)*i;
    else
      Hi2(m,n) = -Ic2*sin(theta2) + Ic2*cos(theta2)*i;
    end
    Hi(m,n) = Hi1(m,n)+ Hi2(m,n); 
 end
end

H = abs(Hi);
u = real(Hi);
v = imag(Hi);

h = streamslice(x,y,u,v,0.7);
set(h,'color',[0.5 0.5 0.5]);axis equal
axis([-1 2 -1 1 ]);  
title('Electrical Currents - Magnetic Field')
xlabel('x'); ylabel('y');

%force
if force
if ((I1<0 & I2<0) | (I1>0 & I2>0))
p1 = [position1 0];
p2 = [position1+1 0];
plotvec2D(p1,p2,0.3,'k'); 
p1 = [position2 0];
p2 = [position2-1 0];
plotvec2D(p1,p2,0.3,'k');
elseif((I1<0 & I2>0) | (I1>0 & I2<0))
p1 = [position2 0];
p2 = [position2+1 0];
plotvec2D(p1,p2,0.3,'k');
p1 = [position1 0];
p2 = [position1-1 0];
plotvec2D(p1,p2,0.3,'k');
end
end
hold off

function editI13D_Callback(hObject, eventdata, handles)
% hObject    handle to editI13D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editI13D as text
%        str2double(get(hObject,'String')) returns contents of editI13D as a double


% --- Executes during object creation, after setting all properties.
function editI13D_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editI13D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editI23D_Callback(hObject, eventdata, handles)
% hObject    handle to editI23D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editI23D as text
%        str2double(get(hObject,'String')) returns contents of editI23D as a double


% --- Executes during object creation, after setting all properties.
function editI23D_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editI23D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in pushbutton3D.
function pushbutton3D_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

I1 = str2num(get(handles.editI13D,'String'));%get value input text
I2 = str2num(get(handles.editI23D,'String'));%get value input text

x = linspace(-1,2,48);
y = linspace(-1,1,32);
z = linspace(0,1,16);

position1 = 0;%position of the currente1 on the x axis
position2 = 1;%position of the currente1 on the x axis

for o = 1:length(z)
for n=1:length(x)
  for m=1:length(y)
      
    theta1 = atan(y(m)/(x(n) - position1));  
    rho1 = sqrt((x(n)- position1)^2 + y(m)^2);
    Ic1 = I1/(2*pi*rho1);
    
    theta2 = atan(y(m)/(x(n) - position2));  
    rho2 = sqrt((x(n)- position2)^2 + y(m)^2);
    Ic2 = I2/(2*pi*rho2);
    
    if x(n)< position1
      Hi1(m,n) = Ic1*sin(theta1) - Ic1*cos(theta1)*i;
    else
      Hi1(m,n) = -Ic1*sin(theta1) + Ic1*cos(theta1)*i;
    end
    if x(n)< position2
      Hi2(m,n) = Ic2*sin(theta2) - Ic2*cos(theta2)*i;
    else
      Hi2(m,n) = -Ic2*sin(theta2) + Ic2*cos(theta2)*i;
    end

    Hi(m,n,o) = Hi1(m,n)+ Hi2(m,n); 
  
 end
end
end

figure(1); subplot('position',[0.1 0.1 0.8 0.8]); 

if I1>0
plot3([0 0],[0 0],[-0.3 1.3],'r','LineWidth',2);hold on
else
plot3([0 0],[0 0],[-0.3 1.3],'b','LineWidth',2);hold on
end
if I2>0
plot3([1 1],[0 0],[-0.3 1.3],'r','LineWidth',2);hold on
else
plot3([1 1],[0 0],[-0.3 1.3],'b','LineWidth',2);hold on
end
u = real(Hi(:,:,:));
v = imag(Hi(:,:,:));
w = zeros(32,48,16);

[sx,sy,sz] = meshgrid(-1:1,-1:1,0:0.5:1);
h = streamline(x,y,z,u,v,w,sx,sy,sz,0.4); 
title('Electrical Currents - Magnetic Field')
xlabel('x'); ylabel('y'); zlabel('z')
set(h,'color',[0.5 0.5 0.5]); axis equal; 
view(3)
hold off

% --- Executes on button press in pushbuttonClose.
function pushbuttonClose_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonClose (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --------------------------------------------------------------------
%functions used for me
% --------------------------------------------------------------------
function plotvec2D(p1,p2,size,color)
%plot a vector in 2D,  p1[x1 y1] p2[x2 y2] - two points deffine a vector

[x,y] = meshgrid([p1(1) p2(1)], [p1(2) p2(2)]);

u = [(p2(1)-p1(1)) 0; 0 0];
v = [(p2(2)-p1(2)) 0; 0 0];

if nargin<3
quiver(x,y,u,v,0); 
elseif nargin<4
quiver(x,y,u,v,size); 
else
quiver(x,y,u,v,size,color);    
end
xlabel('x'); ylabel('y');
% --------------------------------------------------------------------


% --------------------------------------------------------------------
function Untitled_12_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_13_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_14_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_15_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_16_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_17_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_5_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_6_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_7_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_8_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_9_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_10_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_3_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_4_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_1_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_2_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


