function varargout = Electrical_Potential(varargin)
% ELECTRICAL_POTENTIAL M-file for Electrical_Potential.fig
%      ELECTRICAL_POTENTIAL, by itself, creates a new ELECTRICAL_POTENTIAL or raises the existing
%      singleton*.
%
%      H = ELECTRICAL_POTENTIAL returns the handle to a new ELECTRICAL_POTENTIAL or the handle to
%      the existing singleton*.
%
%      ELECTRICAL_POTENTIAL('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in ELECTRICAL_POTENTIAL.M with the given input arguments.
%
%      ELECTRICAL_POTENTIAL('Property','Value',...) creates a new ELECTRICAL_POTENTIAL or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Electrical_Potential_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Electrical_Potential_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help Electrical_Potential

% Last Modified by GUIDE v2.5 14-Jul-2005 15:48:05

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Electrical_Potential_OpeningFcn, ...
                   'gui_OutputFcn',  @Electrical_Potential_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Electrical_Potential is made visible.
function Electrical_Potential_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Electrical_Potential (see VARARGIN)

% Choose default command line output for Electrical_Potential
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Electrical_Potential wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Electrical_Potential_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pushbuttonClose.
function pushbuttonClose_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonClose (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

function editV1_Callback(hObject, eventdata, handles)
% hObject    handle to editV1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editV1 as text
%        str2double(get(hObject,'String')) returns contents of editV1 as a double


% --- Executes during object creation, after setting all properties.
function editV1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editV1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function editV2_Callback(hObject, eventdata, handles)
% hObject    handle to editV2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editV2 as text
%        str2double(get(hObject,'String')) returns contents of editV2 as a double


% --- Executes during object creation, after setting all properties.
function editV2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editV2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editV3_Callback(hObject, eventdata, handles)
% hObject    handle to editV3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editV3 as text
%        str2double(get(hObject,'String')) returns contents of editV3 as a double


% --- Executes during object creation, after setting all properties.
function editV3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editV3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editV4_Callback(hObject, eventdata, handles)
% hObject    handle to editV4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editV4 as text
%        str2double(get(hObject,'String')) returns contents of editV4 as a double


% --- Executes during object creation, after setting all properties.
function editV4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editV4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editDxy_Callback(hObject, eventdata, handles)
% hObject    handle to editDxy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editDxy as text
%        str2double(get(hObject,'String')) returns contents of editDxy as a double


% --- Executes during object creation, after setting all properties.
function editDxy_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editDxy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editI_Callback(hObject, eventdata, handles)
% hObject    handle to editI (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editI as text
%        str2double(get(hObject,'String')) returns contents of editI as a double


% --- Executes during object creation, after setting all properties.
function editI_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editI (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editJ_Callback(hObject, eventdata, handles)
% hObject    handle to editJ (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editJ as text
%        str2double(get(hObject,'String')) returns contents of editJ as a double


% --- Executes during object creation, after setting all properties.
function editJ_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editJ (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editNiteraction_Callback(hObject, eventdata, handles)
% hObject    handle to editNiteraction (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editNiteraction as text
%        str2double(get(hObject,'String')) returns contents of editNiteraction as a double


% --- Executes during object creation, after setting all properties.
function editNiteraction_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editNiteraction (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in pushbuttonFDM.
function pushbuttonFDM_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonFDM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Potention calculation using FDM inside of a box
V1 = str2num(get(handles.editV1,'String'));
V2 = str2num(get(handles.editV2,'String'));
V3 = str2num(get(handles.editV3,'String'));
V4 = str2num(get(handles.editV4,'String'));

Dxy = str2num(get(handles.editDxy,'String'));
I = str2num(get(handles.editI,'String'));
J = str2num(get(handles.editJ,'String'));
Nr = str2num(get(handles.editNiteraction,'String'));

a = I*Dxy;
b = J*Dxy;

I = I + 1;
J = J + 1;

V = zeros(I,J);

%Boundary condition
V(2:I-1,1) = V1;%down horizontal
V(I,2:J-1) = V2;%right vertical
V(2:I-1,J) = V3;%up horizontal
V(1,2:J-1) = V4;%left vertical

%corners
V(1,1) = (V1+V4)/2;
V(1,J) = (V3+V4)/2;
V(I,1) = (V1+V2)/2;
V(I,J) = (V2+V3)/2;

for n = 1:Nr
  for i=2:I-1
    for j=2:J-1
      V(i,j) = 0.25*(V(i+1,j) + V(i-1,j) + V(i,j+1) + V(i,j-1));
    end
  end
end

x=0:Dxy:a;
y=0:Dxy:b;
figure(1); subplot('position',[0.1 0.1 0.8 0.8]) 
c = contour(x,y,V'); xlabel('x'); ylabel('y'); 
title('Finite Difference Method')
axis([-Dxy a+Dxy -Dxy b+Dxy]); axis equal
hold on

[u,v] = gradient(-V');
h = streamslice(x,y,u,v,0.5);
set(h,'color',[0.5 0.5 0.5])
 
plot([0 a],[0 0],'b','LineWidth',2);
plot([0 a],[b b],'b','LineWidth',2);
plot([0 0],[(0+b/100) (b-b/100)],'k','LineWidth',2);
plot([a a],[(0+b/100) (b-b/100)],'k','LineWidth',2);
hold off

function editDxFEM_Callback(hObject, eventdata, handles)
% hObject    handle to editDxFEM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editDxFEM as text
%        str2double(get(hObject,'String')) returns contents of editDxFEM as a double


% --- Executes during object creation, after setting all properties.
function editDxFEM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editDxFEM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function editDyFEM_Callback(hObject, eventdata, handles)
% hObject    handle to editDyFEM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editDyFEM as text
%        str2double(get(hObject,'String')) returns contents of editDyFEM as a double


% --- Executes during object creation, after setting all properties.
function editDyFEM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editDyFEM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editIFEM_Callback(hObject, eventdata, handles)
% hObject    handle to editIFEM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editIFEM as text
%        str2double(get(hObject,'String')) returns contents of editIFEM as a double


% --- Executes during object creation, after setting all properties.
function editIFEM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editIFEM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function editJFEM_Callback(hObject, eventdata, handles)
% hObject    handle to editJFEM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editJFEM as text
%        str2double(get(hObject,'String')) returns contents of editJFEM as a double


% --- Executes during object creation, after setting all properties.
function editJFEM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editJFEM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editBoundaries_Callback(hObject, eventdata, handles)
% hObject    handle to editBoundaries (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editBoundaries as text
%        str2double(get(hObject,'String')) returns contents of editBoundaries as a double


% --- Executes during object creation, after setting all properties.
function editBoundaries_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editBoundaries (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editProperties_Callback(hObject, eventdata, handles)
% hObject    handle to editProperties (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editProperties as text
%        str2double(get(hObject,'String')) returns contents of editProperties as a double


% --- Executes during object creation, after setting all properties.
function editProperties_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editProperties (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in pushbuttonFEM.
function pushbuttonFEM_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonFEM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

exemplo = get(handles.checkboxRunExemplo,'Value');

if exemplo
   ex1 = get(handles.radiobuttonPointEffect,'Value');
   ex2 = get(handles.radiobuttonShapes,'Value');
   ex3 = get(handles.radiobuttonCapacitor1,'Value');
   ex4 = get(handles.radiobuttonCapacitor2,'Value');
   ex5 = get(handles.radiobuttonCapacitor3,'Value');
   m1 = str2num(get(handles.editMaterial1,'String'));
   m2 = str2num(get(handles.editMaterial2,'String'));
   if ex1
     set(handles.editDxFEM,'String',['1'])  
     set(handles.editDyFEM,'String',['1'])
     set(handles.editIFEM,'String',['20'])
     set(handles.editJFEM,'String',['20'])
     set(handles.editBoundaries,'String',['0  0  20  0  0; 10 0  10 13  0; 0 20 20 20  1;'])
     set(handles.editProperties,'String',['0 0 20 0 20 20 0 20 1'])
   elseif ex2
     set(handles.editDxFEM,'String',['1'])  
     set(handles.editDyFEM,'String',['1'])
     set(handles.editIFEM,'String',['32'])
     set(handles.editJFEM,'String',['13'])
     set(handles.editBoundaries,'String',['0 0 14 0 0;14 0 14 2 0;14 2 12 4 0;'...
         '12 4 12 7 0;12 7 20 7 0;20 7 20 4 0;20 4 18 2 0;18 2 18 0 0;'...
         '18 0 32 0 0;0 13 11 13 1;11 13 14 10 1;14 10 23 10 1;23 10 23 13 1;23 13 32 13 1;'])
     set(handles.editProperties,'String',['0 0 32 0 32 13 0 13  1'])
   elseif ex3 
     set(handles.editDxFEM,'String',['1'])  
     set(handles.editDyFEM,'String',['1'])
     set(handles.editIFEM,'String',['20'])
     set(handles.editJFEM,'String',['20'])
     set(handles.editBoundaries,'String',['0 0 20 0 0; 0 20 20 20 100;'])
     set(handles.editProperties,'String',['0 0 20 0 20 20 0 20 ' num2str(m1)...
             ';8 8 16 8 16 12 8 12 ' num2str(m2) ';12 12 16 12 16 16 12 16 ' num2str(m2)])    
   elseif ex4
     set(handles.editDxFEM,'String',['1'])  
     set(handles.editDyFEM,'String',['1'])
     set(handles.editIFEM,'String',['30'])
     set(handles.editJFEM,'String',['10'])
     set(handles.editBoundaries,'String',['0 0 30 0 0; 0 10 30 10 1;'])
     set(handles.editProperties,'String',['0 0 30 0 30 10 0 10 ' num2str(m1)...
             ';9 3 21 3 21 7 9 7 ' num2str(m2)])  
   elseif ex5
     set(handles.editDxFEM,'String',['1'])  
     set(handles.editDyFEM,'String',['1'])
     set(handles.editIFEM,'String',['35'])
     set(handles.editJFEM,'String',['35'])
     set(handles.editBoundaries,'String',['6 5 25 5 0; 5 6 5 25 1;'])
     set(handles.editProperties,'String',['5 5 35 5 35 35 5 35 ' num2str(m1)...
             ';25 5 25 25 5 25 5 25 ' num2str(m2)])  
   end
end

Dx = str2num(get(handles.editDxFEM,'String'));
Dy = str2num(get(handles.editDyFEM,'String'));
I = str2num(get(handles.editIFEM,'String'));
J = str2num(get(handles.editJFEM,'String'));
xyb = str2num(get(handles.editBoundaries,'String'));
xyp = str2num(get(handles.editProperties,'String'));

[el,xy] = mesh2FEM(I,J,Dx,Dy);%mesh generation
[elPer,el] = assemb_elPer(xyp,xy,el,I,J,Dx,Dy);
NVin = assemb_NVin(xyb,xy,Dx,Dy);
Vout = FEM_electric(el,xy,NVin,elPer);
%--------------------------------------------------------------------------
%plot results
n = 1;
for j=1:J+1
    for i=1:I+1
      V(i,j)=Vout(n);
      n = n + 1;        
    end
end

yy = 0:Dy:J*Dy;
xx = 0:Dx:I*Dx;
figure(1); subplot('position',[0.1 0.1 0.8 0.8]) 

plotpot = get(handles.checkboxPontentialLines,'Value');
plotfield = get(handles.checkboxElectricField,'Value');
Lines = get(handles.radiobuttonLines,'Value');
Arrows = get(handles.radiobuttonArrows,'Value');

if plotpot
contour(xx,yy,V',20)
end

hold on
plotmeshFEM(xyb,xyp,I,J,Dx,Dy)
xlabel('x')
ylabel('y')
title('Finite Element Method')
[u,v] = gradient(-V'); 

if plotfield
if Lines
h = streamslice(xx,yy,u,v,1.8);%streamslice(x,y,u,v,4,'noarrows');
set(h,'color',[0.5 0.5 0.5])
elseif Arrows
h = quiver(xx,yy,u,v,0.8,'k');
end
end
axis equal; 
axis([-Dx I*Dx+Dx -Dy J*Dy+Dy]);
hold off



% --- Executes on button press in checkboxRunExemplo.
function checkboxRunExemplo_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxRunExemplo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxRunExemplo



function editMaterial1_Callback(hObject, eventdata, handles)
% hObject    handle to editMaterial1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editMaterial1 as text
%        str2double(get(hObject,'String')) returns contents of editMaterial1 as a double


% --- Executes during object creation, after setting all properties.
function editMaterial1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editMaterial1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editMaterial2_Callback(hObject, eventdata, handles)
% hObject    handle to editMaterial2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editMaterial2 as text
%        str2double(get(hObject,'String')) returns contents of editMaterial2 as a double


% --- Executes during object creation, after setting all properties.
function editMaterial2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editMaterial2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
%----------------------------------------------------------------------
function radiobuttonCapacitor1_Callback(hObject, eventdata, handles)

flag = get(handles.radiobuttonCapacitor1,'Value');
if flag
  set(handles.editMaterial1,'String',['1']) 
  set(handles.editMaterial2,'String',['5']) 
  guidata(hObject,handles);%store changes 
end

%----------------------------------------------------------------------
function radiobuttonCapacitor2_Callback(hObject, eventdata, handles)

flag = get(handles.radiobuttonCapacitor2,'Value');
if flag
  set(handles.editMaterial1,'String',['4']) 
  set(handles.editMaterial2,'String',['1']) 
  guidata(hObject,handles);%store changes 
end
%----------------------------------------------------------------------
function radiobuttonCapacitor3_Callback(hObject, eventdata, handles)

flag = get(handles.radiobuttonCapacitor3,'Value');
if flag
  set(handles.editMaterial1,'String',['10']) 
  set(handles.editMaterial2,'String',['1']) 
  guidata(hObject,handles);%store changes 
end
%----------------------------------------------------------------------


% --- Executes on button press in checkboxPontentialLines.
function checkboxPontentialLines_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxPontentialLines (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxPontentialLines




% --- Executes on button press in checkboxElectricField.
function checkboxElectricField_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxElectricField (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxElectricField


function plotmeshFEM(xyb,xyp,I,J,Dx,Dy,xys,k)
%--------------------------------------------------------------------------
%draw of the mesh to FEM like generated in mesh2FEM
%xyp = [x1 y1 x2 y2 x3 y3 x4 y4 Per], ver function <assemb_elPer>
%xyb = [x1 y1 x2 y2 Vb] , ver function <assemb_NVin> 
%I = nr of divisions on x direction 
%J = nr of divisions on y direction
%Dx = space increment to x (Delta x)
%Dy = space increment to y (Delta y) 
%k = any number if want see grid and points of the mesh, empty other wise
%--------------------------------------------------------------------------

if nargin>7
  yy = 0:Dy:J*Dy;
  xx = 0:Dx:I*Dx;
  [X,Y] = meshgrid(xx,yy);
  plot(X,Y,'ro'); axis([0 I*Dx 0 J*Dy]); xlabel('x'); ylabel('y') 
  set(gca,'Xtick',xx)
  set(gca,'Ytick',yy)
  grid
end
hold on

for n=1:length(xyp(:,1))

    x1 = xyp(n,1);
    y1 = xyp(n,2);
    x2 = xyp(n,3);
    y2 = xyp(n,4);
    x3 = xyp(n,5);
    y3 = xyp(n,6);
    x4 = xyp(n,7);
    y4 = xyp(n,8);
    plot([x1 x2],[y1 y2],'k','LineWidth',1)
    plot([x2 x3],[y2 y3],'k','LineWidth',1)
    plot([x3 x4],[y3 y4],'k','LineWidth',1)
    plot([x4 x1],[y4 y1],'k','LineWidth',1)
   
end

for n = 1:length(xyb(:,1))
  plot([xyb(n,1) xyb(n,3)],[xyb(n,2) xyb(n,4)],'b','LineWidth',2) 
  if ((xyb(n,1)==xyb(n,3)) & (xyb(n,2)==xyb(n,4)))%plot one point
    plot(xyb(n,1),xyb(n,2),'*b')
  end
end

if nargin>6
  for n = 1:length(xys(:,1))
  plot([xys(n,1) xys(n,3)],[xys(n,2) xys(n,4)],'k','LineWidth',1) 
  if ((xys(n,1)==xys(n,3)) & (xys(n,2)==xys(n,4)))%plot one point
    plot(xys(n,1),xys(n,2),'*k')
  end
end  
end

function [el,xy] = mesh2FEM(I,J,Dx,Dy)
%------------- Mesh generation to Finite Element Method -------------------
%I = nr of divisions on x direction 
%J = nr of divisions on y direction
%Dx = space increment to x (Delta x)
%Dy = space increment to y (Delta y)  
%--------------------------------------------------------------------------
%Ex.: 
%  J=2
%   ^     (16 triangular elements)     /|
%   |                                 / | Dy
%   |                                /  |
%    --  --  --  -- > I=4  [axis]    ---
%elements and nodes organization     Dx
%  11---12---13---14---15
%   |13/ |14/ |15/ |16/ |
%   | / 9| /10| /11| /12|
%   6----7----8----9---10
%   | 5/ | 6/ | 7/ | 8/ |
%Dy | / 1| / 2| / 3| /4 |
%   1----2----3----4----5
%     Dx
%--------------------------------------------------------------------------
%output:
%el   = (Ne,1:3) -> element and its nod numeration (Ne = Nr of elements)
%xy   = (Nn,1:2) -> nodes  coordinates (x y) (Nn = Nr of nodes)
%--------------------------------------------------------------------------

if nargin < 3 %defaul to space x and y
    Dx = 1;
    Dy = 1;
end

%--------------------------------------------------------------------------
%mesh generation
%--------------------------------------------------------------------------
for j = 1:J+1 %auxiliar for nod localization
 Ii(j) = (j-1)*(I+1);
end

n = 1;
m = I+1;
aux = 0;
for j=1:J
  for i=1:I%element [nod1 nod2 nod3] 
   el(n,1:3) = [(Ii(j)+i) (Ii(j)+i+1) (Ii(j+1)+i+1)];   
   n = n + 1; 
   el(m,1:3) = [(Ii(j)+i) (Ii(j+1)+i+1) (Ii(j+1)+i)];
   m = m + 1;
  end
  aux = aux + I;
  n = aux*2 + 1;
  m = n + I;
end

%coordenates
n = 1;
for j=0:J
  for i=0:I
      xy(n,1:2)=[i*Dx j*Dy];
      n = n +1;
  end
end
%--------------------------------------------------------------------------

function Vout = FEM_electric(el,xy,NVin,elPer)
%------------- Finite Element Method for static electric fields -----------
%el   = (Ne,1:3) -> element and its nod numeration (Ne = Nr of elements)
%xy   = (Nn,1:2) -> nod  coordinates (x y) (Nn = Nr of nodes)
%NVin  = [Nod Vin] -> nodes with known values Vin (volts) - (N,1:2)
%elPer = [el  Per] -> elements with determined relative electric 
%                     permittivity, default = 1 (free space) for all ones
%                     not assigned - (M,1:2)
%Vout = volts values of the nodes 
%--------------------------------------------------------------------------

Nv  = NVin(:,1)';%nodes
Vin = NVin(:,2)';%values of the nodes

Ne = length(el(:,1));%nr of elements
Nn = length(xy(:,1));%nr of nodes

ep = ones(1,Ne);%defaul values of permittivity

if nargin > 3%correct ep if elPer is used
  K = elPer(:,1);%vector with the assigned permittivity elements
  Per = elPer(:,2);%permittivities of the elements
  for i = 1:length(K)
    ep(K(i)) = Per(i);
  end
end

ep = ep*8.854e-12;%relative permittivity * vacuo permittivity

B = zeros(Nn,1);
C = zeros(Nn,Nn);
%--------------------------------------------------------------------------
for n=1:Ne 
  
  nod = [el(n,1) el(n,2) el(n,3)];%nodes of the element n
  x = xy(nod,1);%x coordinates for each nod
  y = xy(nod,2);%y coordinates for each nod
  
  q(1) = y(2) - y(3);
  q(2) = y(3) - y(1);
  q(3) = y(1) - y(2);

  r(1) = x(3) - x(2);
  r(2) = x(1) - x(3);
  r(3) = x(2) - x(1);

  D = 0.5*abs(q(2)*r(3)-r(2)*q(3)); 

  c = ep(n)*(q'*q + r'*r)/(4*D); %element local matrix

  ii = 1;
  for i = nod %Assembling the global matrix C
    jj = 1;
    for j = nod  
      C(i,j) = C(i,j) + c(ii,jj);
      jj = jj + 1;   
    end
    ii = ii + 1;
  end
  
end
%--------------------------------------------------------------------------
i = 1;
for k = Nv %comput B e the new C
  for n=1:Nn
    if(n~=k) 
      B(n) = B(n) - C(n,k)*Vin(i);
      C(n,k) = 0;
    end
  end
  C(k,:) = 0;
  C(k,k) = 1;
  B(k) = Vin(i);
  i = i + 1;
end
%--------------------------------------------------------------------------
Vout = inv(C)*B;
%--------------------------------------------------------------------------
%Exemple from  Elements of Electromagnetics (Sadiku)
%--------------------------------------------------------------------------
% Nn = 4; %Nr of nodes
% Ne = 2; %Nr of elements
% NVin = [1 0; 3 10];
% 
% el(1,1:3)=[1 2 4];
% el(2,1:3)=[2 3 4];
% 
% xy(1,1:2) = [0.8 1.8];
% xy(2,1:2) = [1.4 1.4];
% xy(3,1:2) = [2.1 2.1];
% xy(4,1:2) = [1.2 2.7];
% 
% V = FEM_electric(el,xy,NVin)
%--------------------------------------------------------------------------

function NVin = assemb_NVin(xyb,xy,Dx,Dy)
%--------------------------------------------------------------------------
%Assembling matrix NVin to use in FEM_eletric-magnetic
%xyb = [x1 y1 x2 y2 Vb] - two points for one line, 
%                         if one point use x1 y1 x1 y1
%Vb -> potencial over the boundary condition [(x1,y1)--(x2,y2)]
%xy, Dx, Dy same used in mesh2FEM
%--------------------------------------------------------------------------

xy(:,1) = round(xy(:,1)/Dx);
xy(:,2) = round(xy(:,2)/Dy);

xyb(:,1) = round(xyb(:,1)/Dx);
xyb(:,2) = round(xyb(:,2)/Dy);
xyb(:,3) = round(xyb(:,3)/Dx);
xyb(:,4) = round(xyb(:,4)/Dy);

Dx = 1;
Dy = 1;

Nb = length(xyb(:,1));%Nr of boundaries condition (straight lines or points)
%--------------------------------------------------------------------------
m = 1;
for n=1:Nb
 Vb = xyb(n,5);
 
 x1 = xyb(n,1);
 x2 = xyb(n,3);
 y1 = xyb(n,2);
 y2 = xyb(n,4);

 x21 = x2 - x1;
 y21 = y2 - y1;
 %-------------------------------------------------------------------------
 if ((x1==x2) & (y1==y2))%point
    px(1) = x1;
    py(1) = y1; 
 elseif ((x1==x2) & (y1~=y2))%vertical
    K = abs(y21/Dy)+1;
    auy = 0;
    for k=1:K
      if y21>0
        px(k) = x1;
        py(k) = y1 + auy;
        auy = auy + Dy;
      else%y21>0
        px(k) = x1;
        py(k) = y1 + auy;
        auy = auy - Dy;
      end  
    end
 elseif ((x1~=x2) & (y1==y2))%horizontal
    K = abs(x21/Dx)+1;
    aux = 0;
    for k=1:K
      if x21>0
        py(k) = y1;
        px(k) = x1 + aux;
        aux = aux + Dx;
      else%x21<0
        py(k) = y1;
        px(k) = x1 + aux;
        aux = aux - Dx;
      end  
    end
 elseif ((x1~=x2) & (y1~=y2))%tilt
   K = abs(x21/Dx)+1;
   aux = 0;
   auy = 0;
   if ((x21>0) & (y21>0))
      for k=1:K
        px(k) = x1 + aux;
        py(k) = y1 + auy;
        aux = aux + Dx;
        auy = auy + Dy;
      end
   end
   if ((x21<0) & (y21<0))
      for k=1:K
        px(k) = x1 + aux;
        py(k) = y1 + auy;
        aux = aux - Dx;
        auy = auy - Dy;
      end
   end
   if ((x21>0) & (y21<0))
      for k=1:K
        px(k) = x1 + aux;
        py(k) = y1 + auy;
        aux = aux + Dx;
        auy = auy - Dy;
      end
   end
   if ((x21<0) & (y21>0))
      for k=1:K
        px(k) = x1 + aux;
        py(k) = y1 + auy;
        aux = aux - Dx;
        auy = auy + Dy;
      end
   end   
 end
 %-------------------------------------------------------------------------
 for k=1:length(px)
   p = find((xy(:,1)==px(k)) & (xy(:,2)==py(k)));  
   NVin(m,1) = p;
   NVin(m,2) = Vb;
   m = m +1;
 end
 clear px py
 %------------------------------------------------------------------------- 
end
%-------------------------------------------------------------------------
NVin = sortrows(NVin,1);
N = [];
n = 1;
while n < length(NVin(:,1))+1%cut copies
    aux = find(NVin(:,1)==NVin(n,1));
    al = aux(length(aux));  
    if length(aux)>1
      N = [N; NVin(al,:)];
    else      
      N = [N; NVin(n,:)];
    end
    n = n + length(aux);    
end
NVin = N;

function [elPer,el] = assemb_elPer(xyp,xy,el,I,J,Dx,Dy)
%-------------------------------------------------------------------------------------
%Assembling matrix elPer to use in FEM_eletric-magnetic
%xyp = [x1 y1 x2 y2 x3 y3 x4 y4 Per],  four points a box
%     for triangle use x3 = x4 and y3 = y4, it MUST always be isosceles
%     (same number of CELLS on x and y direction) with a rigth angle (ex. |_ ) 
%     points(x,y) MUST always be anti-clokwise direction starting from the lowest y
%     and after the lowest (xmin,ymin) 
%     The permittivities are assigned in descendent order (first element to last one)
%     elements not assigned will have per = 1
%
%         3   3      3 --2   3 --2   4-----3
%       / |   | \     \  |   |  /    |     |
%      /  |   |  \     \ |   | /     |     |
%     1 --2   1 --2      1   1       1-----2
%
%Per -> electric permittivity inside the xyp area 
%xy, el, I, J, Dx, Dy same used in mesh2FEM , el can be changed according to xyp
%-------------------------------------------------------------------------------------

xy(:,1) = round(xy(:,1)/Dx);
xy(:,2) = round(xy(:,2)/Dy);

xyp(:,1) = round(xyp(:,1)/Dx);
xyp(:,2) = round(xyp(:,2)/Dy);
xyp(:,3) = round(xyp(:,3)/Dx);
xyp(:,4) = round(xyp(:,4)/Dy);
xyp(:,5) = round(xyp(:,5)/Dx);
xyp(:,6) = round(xyp(:,6)/Dy);
xyp(:,7) = round(xyp(:,7)/Dx);
xyp(:,8) = round(xyp(:,8)/Dy);

Dx = 1;
Dy = 1;

Ne = 2*I*J;
elPer = [[1:Ne]' ones(Ne,1)];%defaul value to permittivity

for n = 1:length(xyp(:,1))
    %---------------------------------------------------------------------------------- 
    x1 = xyp(n,1);
    y1 = xyp(n,2);
    x2 = xyp(n,3);
    y2 = xyp(n,4);
    x3 = xyp(n,5);
    y3 = xyp(n,6);
    x4 = xyp(n,7);
    y4 = xyp(n,8);
    per = xyp(n,9);%permittivity value
   %----------------------------------------------------------------------------------    
   if (x3==x4 & y3==y4)%triangle
     %--------------------------------------------------------------------------------
     if (x2>x1 & x3==x2)%triangle _| no nod inversion
       AUX = [];  
       Kx = (x2-x1)/Dx;%number of divisions on X
       nod1 = y1*(I+1) + x1 + 1;%get the first nod
       fe = ((y1*I)*2 + x1 + 1);%get the first original element
       %correct mesh numeration
       aux1 = nod1;
       aux2 = Kx;
       h1 = fe;
       v1 = fe + I;
       for j=1:Kx
         for i=1:aux2
            nodh = [nod1 (nod1+1) (nod1+I+2)];
            nodv = [nod1 (nod1+I+2) (nod1+I+1)]; 
            el(h1+i-1,:)= nodh;
            el(v1+i-1,:)= nodv;    
            nod1 = nod1 + 1; 
         end
         h1 = h1 + 2*I + 1;
         v1 = v1 + 2*I + 1;
         nod1 = aux1 + I*j + j + j;
         aux2 = aux2-1;
       end
       
       if Kx==1
         AUX = fe;%1 row elements
       else
         h = fe:fe+Kx-1;%horizontal elements
         v = fe+I+1:fe+I+Kx-1;%vertical elements
         fr = [h v];
         AUX = fr(1,:);
         for i = 2:Kx-1
           h = v + I;
           v = (h(1)+I+1):h(length(h))+I;
           fr = [h v];
           AUX = [AUX fr]; 
         end
         AUX = [AUX (fr(length(fr))+I)];
       end
       for m = 1:length(AUX)
         elPer(AUX(m),2) = per;  
       end
      end%triangle _| no nod inversion
      %------------------------------------------------------------------------------
      if (x1==x3 & y2==y3)%triangle :- no nod inversion
        AUX = [];  
        Kx = (x2-x3)/Dx;%number of divisions on X
        nod1 = y1*(I+1) + x1 + 1;%get the first nod
        fe = ((y1*I)*2 + x1 + 1);%get the first original element
        nodh = [nod1 (nod1+1) (nod1+I+2)];
        nodv = [nod1 (nod1+I+2) (nod1+I+1)];
        el(fe,:) = nodh;%first el. correction
        el(fe+I,:) = nodv;
        if Kx==1
          AUX = fe+I;%1 row elements
        else
          h = fe + 2*I;
          v = [h+I h+I+1]; 
          fr = [fe+I h v];
          AUX = fr;
          nodh = [nodv(3) nodv(2) nodv(2)+I+1];
          el(h,:) = nodh;
          el(h+1,:)= nodh+1;
          nodv = [nodh(1) nodh(3) nodh(3)-1];
          el(v(1),:)= nodv;
          el(v(2),:)= nodv+1;
          for i = 2:Kx-1
            h = v + I; 
            v = [(h)+I h(length(h))+I+1];
            fr = [h v];
            AUX = [AUX fr];
            nodh = [nodv(3) nodv(2) nodv(2)+I+1];
            nodv = [nodh(1) nodh(3) nodh(3)-1];
            H = [h h(length(h))+1];
            for j = 1:length(v)
               el(H(j),:)= nodh;
               el(v(j),:)= nodv; 
               nodh = nodh + 1;
               nodv = nodv + 1;
            end
         end
        end
        for m = 1:length(AUX)
          elPer(AUX(m),2) = per;  
        end
      end%triangle :- no nod inversion
      %------------------------------------------------------------------------------
      if (x1==x2)%triangle -: change nodes numeration
         AUX = []; 
         Kx = (x2-x3)/Dx;%number of divisions on X
         fn2 = find(xy(:,1)==x1 & xy(:,2)==y1);%find 2nd nod of the el.
         fn3= fn2 + I + 1;%find 3th nod of el.
         fe = find(el(:,2)==fn2 & el(:,3)==fn3);%find 1 el.
         aux = fe;
         if((el(fe,2) - el(fe,1))==1)%nodes of the element weren't changed yet
           for k=1:Kx%change nod numeration
           el(fe,3) = el(fe,3)-1;
           el(fe+I,1:3) = [el(fe,3) el(fe,2) el(fe,3)+1];
           AUX = [AUX fe+I];%assing the new el. permittivity
           fe = fe + 2*I -1;
           end
           aux = aux + I;
         else% el(fe,3)==fe+I+1
          for k=1:Kx%
           AUX = [AUX fe];
           fe = fe + 2*I -1;
          end 
         end
         fe = aux;    
         h1 = fe + I;
         v1 = fe + 2*I;
         if Kx>1
          AUX = [AUX h1 v1];%Kx=2
            if Kx>2
               for k=3:Kx
                  h1 = (v1(1)-1:v1(length(v1)))+ I;
                  v1 = (h1(1):h1(length(h1)))+ I;
                  fr = [h1 v1];
                  AUX = [AUX fr];
               end 
            end  
         end 
         for m = 1:length(AUX)
           elPer(AUX(m),2) = per;  
         end
      end%triangle -: change nodes numeration 
      %------------------------------------------------------------------------------
      if(y2==y1 & x3==x1)%triangle |_ change nodes numeration
        AUX=[];  
        Kx = (x2-x1)/Dx;%number of divisions on X
        fn2 = find(xy(:,1)==x2 & xy(:,2)==y2);%find 2nd nod of the el.
        fn3= fn2 + I + 1;%find 3th nod of el.
        fe = find(el(:,2)==fn2 & el(:,3)==fn3);%find 1 el.
        aux = fe;
       if((el(fe,2) - el(fe,1))==1)%nodes of the element weren't changed yet
         for k=1:Kx%change nod numeration
           el(fe,3) = el(fe,3)-1;
           el(fe+I,1:3) = [el(fe,3) el(fe,2) el(fe,3)+1];
           AUX = [AUX fe];%assing the new el. permittivity
           fe = fe + 2*I -1;
         end
       else% el(fe,3)==fe+I+1
         fe = fe - I;
         for k=1:Kx%change nod numeration
           AUX = [AUX fe];%assing the new el. permittivity
           fe = fe + 2*I -1;
         end
         aux = aux - I;
       end
       fe = aux; 
       if Kx==2
         fr = [(fe-1) (fe-1+I)];
         AUX = [AUX fr];%1ft line
       end
       if Kx>2
         hf = fe - Kx + 1;
         hl = fe - 1;
         vf = hf + I;
         vl = hl + I;
         h = (hf:hl);
         v = (vf:vl);
         fr = [h v];     
         AUX = [AUX fr];%1ft line 
         for k = 2:Kx-1 
           hl = h(length(h)-1);
           vl = v(length(v)-1);
           h = (hf:hl)+ 2*I;
           v = (vf:vl)+ 2*I;
           fr = [h v]; 
           AUX = [AUX fr]; 
           hf = hf + 2*I;
           vf = vf + 2*I;
         end 
       end
       for m = 1:length(AUX)
         elPer(AUX(m),2) = per;  
       end
      end%triangle |_ change nodes numeration
      %------------------------------------------------------------------------------
  else%box
   %----------------------------------------------------------------------------------   
    AUX = [ ];
    Kx = (x2-x1)/Dx;%number of divisions on X
    Ky = (y4-y1)/Dy;%number of divisions on Y
    fn = find(xy(:,1)==x1 & xy(:,2)==y1);%find pos. 1 el. nod
    fe = find(el(:,1)==fn & el(:,2)==(fn+1) & el(:,3)==(fn+I+2));%find 1 el.
    h = fe:fe+Kx-1;%horizontal elements
    v = fe+I:fe+I+Kx-1;%vertical elements
    fr(1,:) = [h v];%1 row elements
    ner = length(fr(1,:));
    AUX = [AUX fr(1,:)];
     for j = 2:Ky
       fr(j,:) = fr(j-1,:)+2*I;
       AUX = [AUX fr(j,:)]; 
     end
     for m = 1:length(AUX)
       elPer(AUX(m),2) = per;  
     end
   %----------------------------------------------------------------------------------
   end%if box or triangle
   clear fr
end%n
%--------------------------------------------------------------------------


% --------------------------------------------------------------------
function Untitled_5_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_6_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_7_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_8_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_9_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_10_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_3_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_4_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_1_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_2_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_12_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_13_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_14_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_15_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_16_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_17_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


