function varargout = Magnetostatics(varargin)
% MAGNETOSTATICS M-file for Magnetostatics.fig
%      MAGNETOSTATICS, by itself, creates a new MAGNETOSTATICS or raises the existing
%      singleton*.
%
%      H = MAGNETOSTATICS returns the handle to a new MAGNETOSTATICS or the handle to
%      the existing singleton*.
%
%      MAGNETOSTATICS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MAGNETOSTATICS.M with the given input arguments.
%
%      MAGNETOSTATICS('Property','Value',...) creates a new MAGNETOSTATICS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Magnetostatics_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Magnetostatics_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help Magnetostatics

% Last Modified by GUIDE v2.5 14-Jul-2005 15:59:04

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Magnetostatics_OpeningFcn, ...
                   'gui_OutputFcn',  @Magnetostatics_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Magnetostatics is made visible.
function Magnetostatics_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Magnetostatics (see VARARGIN)

% Choose default command line output for Magnetostatics
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Magnetostatics wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Magnetostatics_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


function editM1_Callback(hObject, eventdata, handles)
% hObject    handle to editM1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editM1 as text
%        str2double(get(hObject,'String')) returns contents of editM1 as a double


% --- Executes during object creation, after setting all properties.
function editM1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editM1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editM2_Callback(hObject, eventdata, handles)
% hObject    handle to editM2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editM2 as text
%        str2double(get(hObject,'String')) returns contents of editM2 as a double


% --- Executes during object creation, after setting all properties.
function editM2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editM2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editM3_Callback(hObject, eventdata, handles)
% hObject    handle to editM3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editM3 as text
%        str2double(get(hObject,'String')) returns contents of editM3 as a double


% --- Executes during object creation, after setting all properties.
function editM3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editM3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editM4_Callback(hObject, eventdata, handles)
% hObject    handle to editM4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editM4 as text
%        str2double(get(hObject,'String')) returns contents of editM4 as a double


% --- Executes during object creation, after setting all properties.
function editM4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editM4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editM5_Callback(hObject, eventdata, handles)
% hObject    handle to editM5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editM5 as text
%        str2double(get(hObject,'String')) returns contents of editM5 as a double


% --- Executes during object creation, after setting all properties.
function editM5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editM5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editDx_Callback(hObject, eventdata, handles)
% hObject    handle to editDx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editDx as text
%        str2double(get(hObject,'String')) returns contents of editDx as a double


% --- Executes during object creation, after setting all properties.
function editDx_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editDx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editDy_Callback(hObject, eventdata, handles)
% hObject    handle to editDy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editDy as text
%        str2double(get(hObject,'String')) returns contents of editDy as a double


% --- Executes during object creation, after setting all properties.
function editDy_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editDy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editI_Callback(hObject, eventdata, handles)
% hObject    handle to editI (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editI as text
%        str2double(get(hObject,'String')) returns contents of editI as a double


% --- Executes during object creation, after setting all properties.
function editI_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editI (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editJ_Callback(hObject, eventdata, handles)
% hObject    handle to editJ (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editJ as text
%        str2double(get(hObject,'String')) returns contents of editJ as a double


% --- Executes during object creation, after setting all properties.
function editJ_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editJ (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editB_Callback(hObject, eventdata, handles)
% hObject    handle to editB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editB as text
%        str2double(get(hObject,'String')) returns contents of editB as a double


% --- Executes during object creation, after setting all properties.
function editB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editP_Callback(hObject, eventdata, handles)
% hObject    handle to editP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editP as text
%        str2double(get(hObject,'String')) returns contents of editP as a double


% --- Executes during object creation, after setting all properties.
function editP_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in pushbuttonStaticP.
function pushbuttonStaticP_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonStaticP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

exemplo = get(handles.checkboxRunExemple,'Value');

if exemplo
   ex1 = get(handles.checkbox2,'Value');
   m1 = str2num(get(handles.editM1,'String'));
   m2 = str2num(get(handles.editM2,'String'));
%    if ex1
     set(handles.editDx,'String',['1'])  
     set(handles.editDy,'String',['1'])
     set(handles.editI,'String',['20'])
     set(handles.editJ,'String',['10'])
     set(handles.editB,'String',['0 0 20 0 0; 0 10 20 10 100;'])
     set(handles.editP,'String',['10 0 15 0 15 4 10 4 ' num2str(m1)...
             ';5 6 10 6 10 10 5 10 ' num2str(m2)])    
%    end
end

Dx = str2num(get(handles.editDx,'String'));
Dy = str2num(get(handles.editDy,'String'));
I = str2num(get(handles.editI,'String'));
J = str2num(get(handles.editJ,'String'));
xyb = str2num(get(handles.editB,'String'));
xyp = str2num(get(handles.editP,'String'));


[el,xy] = mesh2FEM(I,J,Dx,Dy);%mesh generation
[elPer,el] = assemb_elPer(xyp,xy,el,I,J,Dx,Dy);
NVin = assemb_NVin(xyb,xy,Dx,Dy);
Vout = FEM_magneticS(el,xy,NVin,elPer);
%--------------------------------------------------------------------------
%plot results
n = 1;
for j=1:J+1
    for i=1:I+1
      V(i,j)=Vout(n);
      n = n + 1;        
    end
end

figure(1); subplot('position',[0.1 0.1 0.8 0.8]) 
yy = 0:Dy:J*Dy;
xx = 0:Dx:I*Dx;
contour(xx,yy,V',30);hold on;
plotmeshFEM(xyb,xyp,I,J,Dx,Dy);
axis equal; axis([0 I*Dx 0 J*Dy]);
title('Magnetic Scalar Potential')
xlabel('x')
ylabel('y')
hold off

% --- Executes on button press in checkboxRunExemple.
function checkboxRunExemple_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxRunExemple (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxRunExemple


% --- Executes on button press in pushbuttonVectorP.
function pushbuttonVectorP_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonVectorP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

exemplo = get(handles.checkboxRunExemple,'Value');

if exemplo
   ex1 = get(handles.radiobutton11,'Value');
   ex2 = get(handles.radiobutton12,'Value');
   ex3 = get(handles.radiobutton13,'Value');
   ex4 = get(handles.radiobutton14,'Value');
   m1 = str2num(get(handles.editM1,'String'));
   m2 = str2num(get(handles.editM2,'String'));
   m3 = str2num(get(handles.editM3,'String'));
   m4 = str2num(get(handles.editM4,'String'));
   m5 = str2num(get(handles.editM5,'String'));
  if ex1
     set(handles.editDx,'String',['0.005'])  
     set(handles.editDy,'String',['0.005'])
     set(handles.editI,'String',['12'])
     set(handles.editJ,'String',['12'])
     set(handles.editB,'String',['0 0 0.06 0 0; 0.06 0 0.06 0.06 0; 0.06 0.06 0 0.06 0; 0 0.06 0 0 0'])
     set(handles.editP,'String',['0 0 0.06 0 0.06 0.06 0 0.06 ' num2str(m1)...
             ';0.02 0.02 0.04 0.02 0.04 0.04 0.02 0.04 ' num2str(m2)])  
     set(handles.editS,'String',['0.02 0.02 0.04 0.02 -1e6;'...
         '0.02 0.025 0.04 0.025 -1e6;'...
         '0.02 0.03 0.04 0.03 -1e6;'...
         '0.02 0.035 0.04 0.035 -1e6;'...
         '0.02 0.04 0.04 0.04 -1e6;'])
  elseif ex3
     set(handles.editDx,'String',['1'])  
     set(handles.editDy,'String',['1'])
     set(handles.editI,'String',['27'])
     set(handles.editJ,'String',['23'])
     set(handles.editB,'String',['0 0 27 0 0;'...
                                 '27 0 27 23 0;'...
                                 '27 23 0 23 0;'...
                                 '0 23 0 0 0;'])
     set(handles.editP,'String',['0 0 27 0 27 23 0 23 1;' ...
       '2 2 25 2 25 20 2 20 ' num2str(m1) ...
       ';8 8 19 8 19 14 8 14 1;' ...
       '10 2 17 2 17 8 10 8 1;' ...
       '10 2 13 5 10 5 10 5 ' num2str(m2) ...
       ';17 2 17 5 14 5 14 5 ' num2str(m3) ...
       ';14 5 17 5 17 8 17 8 ' num2str(m4) ...
       ';10 5 13 5 10 8 10 8 ' num2str(m5)])
     set(handles.editS,'String',['11 13 16 13 1e6;'...
         '11 14 16 14 1e6; 11 20 16 20 -1e6; 11 21 16 21 -1e6'])
  elseif ex2
     set(handles.editDx,'String',['1'])  
     set(handles.editDy,'String',['1'])
     set(handles.editI,'String',['31'])
     set(handles.editJ,'String',['29'])
     set(handles.editB,'String',['0 0 31 0 0;'...
                                 '31 0 31 29 0;'...
                                 '31 29 0 29 0;'...
                                 '0 29 0 0 0;'])
     set(handles.editP,'String',['0 0 31 0 31 29 0 29 1;' ...
       '2 11 29 11 29 26 2 26 ' num2str(m1) ...
       ';7 11 24 11 24 21 7 21 1;' ...
       ';2 2 29 2 29 9 2 9 ' num2str(m2)])
     set(handles.editS,'String',['12 19 19 19 1e6;'...
         '12 20 19 20 1e6; 12 21 19 21 1e6; 12 26 19 26 -1e6;' ...
         '12 27 19 27 -1e6; 12 28 19 28 -1e6;'])
  elseif ex4
     set(handles.editDx,'String',['1'])  
     set(handles.editDy,'String',['1'])
     set(handles.editI,'String',['31'])
     set(handles.editJ,'String',['29'])
     set(handles.editB,'String',['0 0 31 0 0;'...
                                 '31 0 31 29 0;'...
                                 '31 29 0 29 0;'...
                                 '0 29 0 0 0;'])
     set(handles.editP,'String',['0 0 31 0 31 29 0 29 1' ...
       ';2 6 29 6 29 26 2 26 ' num2str(m1) ...
       ';10 6 21 6 21 11 10 11 1' ...
       ';7 11 24 11 24 21 7 21 1' ...
       ';12 3 19 3 19 14 12 14 ' num2str(m2) ...
       ';14 5 17 5 17 12 14 12 ' num2str(m3)])
     set(handles.editS,'String',['12 19 19 19 1e6;'...
         '12 20 19 20 1e6; 12 21 19 21 1e6; 12 26 19 26 -1e6;' ...
         '12 27 19 27 -1e6; 12 28 19 28 -1e6;'])
  end
end

Dx = str2num(get(handles.editDx,'String'));
Dy = str2num(get(handles.editDy,'String'));
I = str2num(get(handles.editI,'String'));
J = str2num(get(handles.editJ,'String'));
xyb = str2num(get(handles.editB,'String'));
xyp = str2num(get(handles.editP,'String'));
xys = str2num(get(handles.editS,'String'));

[el,xy] = mesh2FEM(I,J,Dx,Dy);%mesh generation
NVin = assemb_NVin(xyb,xy,Dx,Dy);
nodSor = assemb_NVin(xys,xy,Dx,Dy);
[elPer,el] = assemb_elPer(xyp,xy,el,I,J,Dx,Dy);

%--------------------------------------------------------------------------
Vout = FEM_magneticV(el,xy,NVin,elPer,nodSor);
%--------------------------------------------------------------------------
%plot results
n = 1;
for j=1:J+1
    for i=1:I+1
      V(i,j)=Vout(n);
      n = n + 1;        
    end
end

figure(1); subplot('position',[0.1 0.1 0.8 0.8]) 
yy = 0:Dy:J*Dy;
xx = 0:Dx:I*Dx;
contour(xx,yy,V',30);hold on
axis equal; axis([0 I*Dx 0 J*Dy]);
title('Magnetic Vector Potential')
xlabel('x')
ylabel('y')
plotmeshFEM(xyb,xyp,I,J,Dx,Dy,xys);
if exemplo
if ex3
%plot source
plot([11 16],[13 13],'k','LineWidth',1)
plot([11 11],[13 14],'k','LineWidth',1)
plot([16 16],[13 14],'k','LineWidth',1)
% plot([11 16],[13 14],'k','LineWidth',1)
% plot([11 16],[14 13],'k','LineWidth',1)
  
plot([11 16],[21 21],'k','LineWidth',1)
plot([11 11],[20 21],'k','LineWidth',1)
plot([16 16],[20 21],'k','LineWidth',1)
% plot([11 16],[20 21],'k','LineWidth',1)
% plot([11 16],[21 20],'k','LineWidth',1)

plot([10 17],[2 2],'w','LineWidth',1)
plot([10 17],[8 8],'w','LineWidth',1)
plot([13 14],[5 5],'w','LineWidth',1)
elseif ex2
%plot source
plot([12 19],[19 19],'k','LineWidth',1)
plot([12 12],[19 21],'k','LineWidth',1)
plot([19 19],[19 21],'k','LineWidth',1)
% plot([12 19],[21 19],'k','LineWidth',1)
% plot([12 19],[19 21],'k','LineWidth',1)
    
plot([12 19],[28 28],'k','LineWidth',1)
plot([12 12],[28 26],'k','LineWidth',1)
plot([19 19],[28 26],'k','LineWidth',1)
% plot([12 19],[26 28],'k','LineWidth',1)
% plot([12 19],[28 26],'k','LineWidth',1) 
 
plot([7 24],[11 11],'w','LineWidth',1)
elseif ex4
%------------------------------------------------------------   
%plot source
plot([12 19],[19 19],'k','LineWidth',1)
plot([12 12],[19 21],'k','LineWidth',1)
plot([19 19],[19 21],'k','LineWidth',1)
% plot([12 19],[21 19],'k','LineWidth',1)
% plot([12 19],[19 21],'k','LineWidth',1)
plot([12 19],[28 28],'k','LineWidth',1)
plot([12 12],[28 26],'k','LineWidth',1)
plot([19 19],[28 26],'k','LineWidth',1)
% plot([12 19],[26 28],'k','LineWidth',1)
% plot([12 19],[28 26],'k','LineWidth',1)
x1 = xyp(3,1);
y1 = xyp(3,2);
x2 = xyp(3,3);
y2 = xyp(3,4);
x3 = xyp(3,5);
y3 = xyp(3,6);
x4 = xyp(3,7);
y4 = xyp(3,8);
plot([x1 x2],[y1 y2],'w','LineWidth',1)
plot([x2 x3],[y2 y3],'k','LineWidth',1)
plot([x3 x4],[y3 y4],'w','LineWidth',1)
plot([x4 x1],[y4 y1],'k','LineWidth',1)
%------------------------------------------------------------     
end
end
hold off


function editS_Callback(hObject, eventdata, handles)
% hObject    handle to editS (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editS as text
%        str2double(get(hObject,'String')) returns contents of editS as a double


% --- Executes during object creation, after setting all properties.
function editS_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editS (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

%-------------------------------------------------------------------------
%-------------------------------------------------------------------------
%Square Current
function radiobutton11_Callback(hObject, eventdata, handles)
flag = get(handles.radiobutton11,'Value');
if flag
  set(handles.editM1,'String',['10'])
  set(handles.editM2,'String',['1']) 
  set(handles.checkbox2,'Value',0)
  guidata(hObject,handles);%store changes 
end

%-------------------------------------------------------------------------
%Magneto 1
function radiobutton12_Callback(hObject, eventdata, handles)

flag = get(handles.radiobutton12,'Value');
if flag
  set(handles.editM1,'String',['1000'])
  set(handles.editM2,'String',['10000']) 
  set(handles.checkbox2,'Value',0)
  guidata(hObject,handles);%store changes 
end


%-------------------------------------------------------------------------
%Magneto 2
function radiobutton13_Callback(hObject, eventdata, handles)

flag = get(handles.radiobutton13,'Value');
if flag
  set(handles.editM1,'String',['1000'])
  set(handles.editM2,'String',['1000']) 
  set(handles.editM3,'String',['1'])
  set(handles.editM4,'String',['1000']) 
  set(handles.editM5,'String',['1'])
  set(handles.checkbox2,'Value',0)
  guidata(hObject,handles);%store changes 
end

%-------------------------------------------------------------------------
%Shield
function radiobutton14_Callback(hObject, eventdata, handles)
flag = get(handles.radiobutton14,'Value');
if flag
  set(handles.editM1,'String',['1000'])
  set(handles.editM2,'String',['1000']) 
  set(handles.editM3,'String',['1'])
  set(handles.checkbox2,'Value',0)
  guidata(hObject,handles);%store changes 
end
%-------------------------------------------------------------------------
function checkbox2_Callback(hObject, eventdata, handles)
flag = get(handles.checkbox2,'Value');
if flag
  set(handles.editM1,'String',['100'])
  set(handles.editM2,'String',['100']) 
  set(handles.radiobutton11,'Value',0)
  set(handles.radiobutton12,'Value',0)
  set(handles.radiobutton13,'Value',0)
  set(handles.radiobutton14,'Value',0)
  guidata(hObject,handles);%store changes 
end

%-------------------------------------------------------------------------

function plotmeshFEM(xyb,xyp,I,J,Dx,Dy,xys,k)
%--------------------------------------------------------------------------
%draw of the mesh to FEM like generated in mesh2FEM
%xyp = [x1 y1 x2 y2 x3 y3 x4 y4 Per], ver function <assemb_elPer>
%xyb = [x1 y1 x2 y2 Vb] , ver function <assemb_NVin> 
%I = nr of divisions on x direction 
%J = nr of divisions on y direction
%Dx = space increment to x (Delta x)
%Dy = space increment to y (Delta y) 
%k = any number if want see grid and points of the mesh, empty other wise
%--------------------------------------------------------------------------

if nargin>7
  yy = 0:Dy:J*Dy;
  xx = 0:Dx:I*Dx;
  [X,Y] = meshgrid(xx,yy);
  plot(X,Y,'ro'); axis([0 I*Dx 0 J*Dy]); xlabel('x'); ylabel('y') 
  set(gca,'Xtick',xx)
  set(gca,'Ytick',yy)
  grid
end
hold on

for n=1:length(xyp(:,1))

    x1 = xyp(n,1);
    y1 = xyp(n,2);
    x2 = xyp(n,3);
    y2 = xyp(n,4);
    x3 = xyp(n,5);
    y3 = xyp(n,6);
    x4 = xyp(n,7);
    y4 = xyp(n,8);
    plot([x1 x2],[y1 y2],'k','LineWidth',1)
    plot([x2 x3],[y2 y3],'k','LineWidth',1)
    plot([x3 x4],[y3 y4],'k','LineWidth',1)
    plot([x4 x1],[y4 y1],'k','LineWidth',1)
   
end

for n = 1:length(xyb(:,1))
  plot([xyb(n,1) xyb(n,3)],[xyb(n,2) xyb(n,4)],'b','LineWidth',2) 
  if ((xyb(n,1)==xyb(n,3)) & (xyb(n,2)==xyb(n,4)))%plot one point
    plot(xyb(n,1),xyb(n,2),'*b')
  end
end

if nargin>6
  for n = 1:length(xys(:,1))
  plot([xys(n,1) xys(n,3)],[xys(n,2) xys(n,4)],'k','LineWidth',1) 
  if ((xys(n,1)==xys(n,3)) & (xys(n,2)==xys(n,4)))%plot one point
    plot(xys(n,1),xys(n,2),'*k')
  end
end  
end

% for j=1:J
%  for i=1:I
%   plot([xx(i) xx(i+1)],[yy(j) yy(j+1)],'k:')
%  end
% end

% %get the plot position to draw the element number
% pos = get(gca,'Position');
% dpx = pos(3)/(6*(length(xx)-1));
% xp = pos(1):dpx:(pos(3)+pos(1));
% dpy = pos(4)/(6*(length(yy)-1));
% yp = pos(2):dpy:(pos(4) + pos(2));
% 
% h = 1;
% v = I + 1;
% for j=1:6:length(yp)-1  
%   for i=6:6:length(xp)-1
%     set(scribe.textbox,'String',h,'Position',[xp(i-2) yp(j) 0.05 0.05],'LineStyle','none','Color','b','Fontsize',7)
%     h = h + 1;
%     set(scribe.textbox,'String',v,'Position',[xp(i-5) yp(j+3) 0.05 0.05],'LineStyle','none','Color','k','Fontsize',7)
%     v = v + 1;  
%   end
%    v = I + v;
%    h = I + h;
% end
% hold off

% dpx = pos(3)/(3*(length(xx)-1));
% xp = pos(1):dpx:(pos(3)+pos(1));
% dpy = pos(4)/(3*(length(yy)-1));
% yp = pos(2):dpy:(pos(4) + pos(2));
% 
% h = 1;
% v = I + 1;
% for j=2:3:length(yp)-1  
%   for i=3:3:length(xp)-1
%     set(scribe.textbox,'String',h,'Position',[xp(i) yp(j) 0.05 0.05],'LineStyle','none','Color','b','Fontsize',7)
%     h = h + 1;
%     set(scribe.textbox,'String',v,'Position',[xp(i-1) yp(j+1) 0.05 0.05],'LineStyle','none','Color','k','Fontsize',7)
%     v = v + 1;  
%   end
%    v = I + v;
%    h = I + h;
% end
% hold off

function [el,xy] = mesh2FEM(I,J,Dx,Dy)
%------------- Mesh generation to Finite Element Method -------------------
%I = nr of divisions on x direction 
%J = nr of divisions on y direction
%Dx = space increment to x (Delta x)
%Dy = space increment to y (Delta y)  
%--------------------------------------------------------------------------
%Ex.: 
%  J=2
%   ^     (16 triangular elements)     /|
%   |                                 / | Dy
%   |                                /  |
%    --  --  --  -- > I=4  [axis]    ---
%elements and nodes organization     Dx
%  11---12---13---14---15
%   |13/ |14/ |15/ |16/ |
%   | / 9| /10| /11| /12|
%   6----7----8----9---10
%   | 5/ | 6/ | 7/ | 8/ |
%Dy | / 1| / 2| / 3| /4 |
%   1----2----3----4----5
%     Dx
%--------------------------------------------------------------------------
%output:
%el   = (Ne,1:3) -> element and its nod numeration (Ne = Nr of elements)
%xy   = (Nn,1:2) -> nodes  coordinates (x y) (Nn = Nr of nodes)
%--------------------------------------------------------------------------

if nargin < 3 %defaul to space x and y
    Dx = 1;
    Dy = 1;
end

%--------------------------------------------------------------------------
%mesh generation
%--------------------------------------------------------------------------
for j = 1:J+1 %auxiliar for nod localization
 Ii(j) = (j-1)*(I+1);
end

n = 1;
m = I+1;
aux = 0;
for j=1:J
  for i=1:I%element [nod1 nod2 nod3] 
   el(n,1:3) = [(Ii(j)+i) (Ii(j)+i+1) (Ii(j+1)+i+1)];   
   n = n + 1; 
   el(m,1:3) = [(Ii(j)+i) (Ii(j+1)+i+1) (Ii(j+1)+i)];
   m = m + 1;
  end
  aux = aux + I;
  n = aux*2 + 1;
  m = n + I;
end

%coordenates
n = 1;
for j=0:J
  for i=0:I
      xy(n,1:2)=[i*Dx j*Dy];
      n = n +1;
  end
end
%--------------------------------------------------------------------------

function NVin = assemb_NVin(xyb,xy,Dx,Dy)
%--------------------------------------------------------------------------
%Assembling matrix NVin to use in FEM_eletric-magnetic
%xyb = [x1 y1 x2 y2 Vb] - two points for one line, 
%                         if one point use x1 y1 x1 y1
%Vb -> potencial over the boundary condition [(x1,y1)--(x2,y2)]
%xy, Dx, Dy same used in mesh2FEM
%--------------------------------------------------------------------------

xy(:,1) = round(xy(:,1)/Dx);
xy(:,2) = round(xy(:,2)/Dy);

xyb(:,1) = round(xyb(:,1)/Dx);
xyb(:,2) = round(xyb(:,2)/Dy);
xyb(:,3) = round(xyb(:,3)/Dx);
xyb(:,4) = round(xyb(:,4)/Dy);

Dx = 1;
Dy = 1;

Nb = length(xyb(:,1));%Nr of boundaries condition (straight lines or points)
%--------------------------------------------------------------------------
m = 1;
for n=1:Nb
 Vb = xyb(n,5);
 
 x1 = xyb(n,1);
 x2 = xyb(n,3);
 y1 = xyb(n,2);
 y2 = xyb(n,4);

 x21 = x2 - x1;
 y21 = y2 - y1;
 %-------------------------------------------------------------------------
 if ((x1==x2) & (y1==y2))%point
    px(1) = x1;
    py(1) = y1; 
 elseif ((x1==x2) & (y1~=y2))%vertical
    K = abs(y21/Dy)+1;
    auy = 0;
    for k=1:K
      if y21>0
        px(k) = x1;
        py(k) = y1 + auy;
        auy = auy + Dy;
      else%y21>0
        px(k) = x1;
        py(k) = y1 + auy;
        auy = auy - Dy;
      end  
    end
 elseif ((x1~=x2) & (y1==y2))%horizontal
    K = abs(x21/Dx)+1;
    aux = 0;
    for k=1:K
      if x21>0
        py(k) = y1;
        px(k) = x1 + aux;
        aux = aux + Dx;
      else%x21<0
        py(k) = y1;
        px(k) = x1 + aux;
        aux = aux - Dx;
      end  
    end
 elseif ((x1~=x2) & (y1~=y2))%tilt
   K = abs(x21/Dx)+1;
   aux = 0;
   auy = 0;
   if ((x21>0) & (y21>0))
      for k=1:K
        px(k) = x1 + aux;
        py(k) = y1 + auy;
        aux = aux + Dx;
        auy = auy + Dy;
      end
   end
   if ((x21<0) & (y21<0))
      for k=1:K
        px(k) = x1 + aux;
        py(k) = y1 + auy;
        aux = aux - Dx;
        auy = auy - Dy;
      end
   end
   if ((x21>0) & (y21<0))
      for k=1:K
        px(k) = x1 + aux;
        py(k) = y1 + auy;
        aux = aux + Dx;
        auy = auy - Dy;
      end
   end
   if ((x21<0) & (y21>0))
      for k=1:K
        px(k) = x1 + aux;
        py(k) = y1 + auy;
        aux = aux - Dx;
        auy = auy + Dy;
      end
   end   
 end
 %-------------------------------------------------------------------------
 for k=1:length(px)
   p = find((xy(:,1)==px(k)) & (xy(:,2)==py(k)));  
   NVin(m,1) = p;
   NVin(m,2) = Vb;
   m = m +1;
 end
 clear px py
 %------------------------------------------------------------------------- 
end
%-------------------------------------------------------------------------
NVin = sortrows(NVin,1);
N = [];
n = 1;
while n < length(NVin(:,1))+1%cut copies
    aux = find(NVin(:,1)==NVin(n,1));
    al = aux(length(aux));  
    if length(aux)>1
      N = [N; NVin(al,:)];
    else      
      N = [N; NVin(n,:)];
    end
    n = n + length(aux);    
end
NVin = N;

function [elPer,el] = assemb_elPer(xyp,xy,el,I,J,Dx,Dy)
%-------------------------------------------------------------------------------------
%Assembling matrix elPer to use in FEM_eletric-magnetic
%xyp = [x1 y1 x2 y2 x3 y3 x4 y4 Per],  four points a box
%     for triangle use x3 = x4 and y3 = y4, it MUST always be isosceles
%     (same number of CELLS on x and y direction) with a rigth angle (ex. |_ ) 
%     points(x,y) MUST always be anti-clokwise direction starting from the lowest y
%     and after the lowest (xmin,ymin) 
%     The permittivities are assigned in descendent order (first element to last one)
%     elements not assigned will have per = 1
%
%         3   3      3 --2   3 --2   4-----3
%       / |   | \     \  |   |  /    |     |
%      /  |   |  \     \ |   | /     |     |
%     1 --2   1 --2      1   1       1-----2
%
%Per -> electric permittivity inside the xyp area 
%xy, el, I, J, Dx, Dy same used in mesh2FEM , el can be changed according to xyp
%-------------------------------------------------------------------------------------

xy(:,1) = round(xy(:,1)/Dx);
xy(:,2) = round(xy(:,2)/Dy);

xyp(:,1) = round(xyp(:,1)/Dx);
xyp(:,2) = round(xyp(:,2)/Dy);
xyp(:,3) = round(xyp(:,3)/Dx);
xyp(:,4) = round(xyp(:,4)/Dy);
xyp(:,5) = round(xyp(:,5)/Dx);
xyp(:,6) = round(xyp(:,6)/Dy);
xyp(:,7) = round(xyp(:,7)/Dx);
xyp(:,8) = round(xyp(:,8)/Dy);

Dx = 1;
Dy = 1;

Ne = 2*I*J;
elPer = [[1:Ne]' ones(Ne,1)];%defaul value to permittivity

for n = 1:length(xyp(:,1))
    %---------------------------------------------------------------------------------- 
    x1 = xyp(n,1);
    y1 = xyp(n,2);
    x2 = xyp(n,3);
    y2 = xyp(n,4);
    x3 = xyp(n,5);
    y3 = xyp(n,6);
    x4 = xyp(n,7);
    y4 = xyp(n,8);
    per = xyp(n,9);%permittivity value
   %----------------------------------------------------------------------------------    
   if (x3==x4 & y3==y4)%triangle
     %--------------------------------------------------------------------------------
     if (x2>x1 & x3==x2)%triangle _| no nod inversion
       AUX = [];  
       Kx = (x2-x1)/Dx;%number of divisions on X
       nod1 = y1*(I+1) + x1 + 1;%get the first nod
       fe = ((y1*I)*2 + x1 + 1);%get the first original element
       %correct mesh numeration
       aux1 = nod1;
       aux2 = Kx;
       h1 = fe;
       v1 = fe + I;
       for j=1:Kx
         for i=1:aux2
            nodh = [nod1 (nod1+1) (nod1+I+2)];
            nodv = [nod1 (nod1+I+2) (nod1+I+1)]; 
            el(h1+i-1,:)= nodh;
            el(v1+i-1,:)= nodv;    
            nod1 = nod1 + 1; 
         end
         h1 = h1 + 2*I + 1;
         v1 = v1 + 2*I + 1;
         nod1 = aux1 + I*j + j + j;
         aux2 = aux2-1;
       end
       
       if Kx==1
         AUX = fe;%1 row elements
       else
         h = fe:fe+Kx-1;%horizontal elements
         v = fe+I+1:fe+I+Kx-1;%vertical elements
         fr = [h v];
         AUX = fr(1,:);
         for i = 2:Kx-1
           h = v + I;
           v = (h(1)+I+1):h(length(h))+I;
           fr = [h v];
           AUX = [AUX fr]; 
         end
         AUX = [AUX (fr(length(fr))+I)];
       end
       for m = 1:length(AUX)
         elPer(AUX(m),2) = per;  
       end
      end%triangle _| no nod inversion
      %------------------------------------------------------------------------------
      if (x1==x3 & y2==y3)%triangle :- no nod inversion
        AUX = [];  
        Kx = (x2-x3)/Dx;%number of divisions on X
        nod1 = y1*(I+1) + x1 + 1;%get the first nod
        fe = ((y1*I)*2 + x1 + 1);%get the first original element
        nodh = [nod1 (nod1+1) (nod1+I+2)];
        nodv = [nod1 (nod1+I+2) (nod1+I+1)];
        el(fe,:) = nodh;%first el. correction
        el(fe+I,:) = nodv;
        if Kx==1
          AUX = fe+I;%1 row elements
        else
          h = fe + 2*I;
          v = [h+I h+I+1]; 
          fr = [fe+I h v];
          AUX = fr;
          nodh = [nodv(3) nodv(2) nodv(2)+I+1];
          el(h,:) = nodh;
          el(h+1,:)= nodh+1;
          nodv = [nodh(1) nodh(3) nodh(3)-1];
          el(v(1),:)= nodv;
          el(v(2),:)= nodv+1;
          for i = 2:Kx-1
            h = v + I; 
            v = [(h)+I h(length(h))+I+1];
            fr = [h v];
            AUX = [AUX fr];
            nodh = [nodv(3) nodv(2) nodv(2)+I+1];
            nodv = [nodh(1) nodh(3) nodh(3)-1];
            H = [h h(length(h))+1];
            for j = 1:length(v)
               el(H(j),:)= nodh;
               el(v(j),:)= nodv; 
               nodh = nodh + 1;
               nodv = nodv + 1;
            end
         end
        end
        for m = 1:length(AUX)
          elPer(AUX(m),2) = per;  
        end
      end%triangle :- no nod inversion
      %------------------------------------------------------------------------------
      if (x1==x2)%triangle -: change nodes numeration
         AUX = []; 
         Kx = (x2-x3)/Dx;%number of divisions on X
         fn2 = find(xy(:,1)==x1 & xy(:,2)==y1);%find 2nd nod of the el.
         fn3= fn2 + I + 1;%find 3th nod of el.
         fe = find(el(:,2)==fn2 & el(:,3)==fn3);%find 1 el.
         aux = fe;
         if((el(fe,2) - el(fe,1))==1)%nodes of the element weren't changed yet
           for k=1:Kx%change nod numeration
           el(fe,3) = el(fe,3)-1;
           el(fe+I,1:3) = [el(fe,3) el(fe,2) el(fe,3)+1];
           AUX = [AUX fe+I];%assing the new el. permittivity
           fe = fe + 2*I -1;
           end
           aux = aux + I;
         else% el(fe,3)==fe+I+1
          for k=1:Kx%
           AUX = [AUX fe];
           fe = fe + 2*I -1;
          end 
         end
         fe = aux;    
         h1 = fe + I;
         v1 = fe + 2*I;
         if Kx>1
          AUX = [AUX h1 v1];%Kx=2
            if Kx>2
               for k=3:Kx
                  h1 = (v1(1)-1:v1(length(v1)))+ I;
                  v1 = (h1(1):h1(length(h1)))+ I;
                  fr = [h1 v1];
                  AUX = [AUX fr];
               end 
            end  
         end 
         for m = 1:length(AUX)
           elPer(AUX(m),2) = per;  
         end
      end%triangle -: change nodes numeration 
      %------------------------------------------------------------------------------
      if(y2==y1 & x3==x1)%triangle |_ change nodes numeration
        AUX=[];  
        Kx = (x2-x1)/Dx;%number of divisions on X
        fn2 = find(xy(:,1)==x2 & xy(:,2)==y2);%find 2nd nod of the el.
        fn3= fn2 + I + 1;%find 3th nod of el.
        fe = find(el(:,2)==fn2 & el(:,3)==fn3);%find 1 el.
        aux = fe;
       if((el(fe,2) - el(fe,1))==1)%nodes of the element weren't changed yet
         for k=1:Kx%change nod numeration
           el(fe,3) = el(fe,3)-1;
           el(fe+I,1:3) = [el(fe,3) el(fe,2) el(fe,3)+1];
           AUX = [AUX fe];%assing the new el. permittivity
           fe = fe + 2*I -1;
         end
       else% el(fe,3)==fe+I+1
         fe = fe - I;
         for k=1:Kx%change nod numeration
           AUX = [AUX fe];%assing the new el. permittivity
           fe = fe + 2*I -1;
         end
         aux = aux - I;
       end
       fe = aux; 
       if Kx==2
         fr = [(fe-1) (fe-1+I)];
         AUX = [AUX fr];%1ft line
       end
       if Kx>2
         hf = fe - Kx + 1;
         hl = fe - 1;
         vf = hf + I;
         vl = hl + I;
         h = (hf:hl);
         v = (vf:vl);
         fr = [h v];     
         AUX = [AUX fr];%1ft line 
         for k = 2:Kx-1 
           hl = h(length(h)-1);
           vl = v(length(v)-1);
           h = (hf:hl)+ 2*I;
           v = (vf:vl)+ 2*I;
           fr = [h v]; 
           AUX = [AUX fr]; 
           hf = hf + 2*I;
           vf = vf + 2*I;
         end 
       end
       for m = 1:length(AUX)
         elPer(AUX(m),2) = per;  
       end
      end%triangle |_ change nodes numeration
      %------------------------------------------------------------------------------
  else%box
   %----------------------------------------------------------------------------------   
    AUX = [ ];
    Kx = (x2-x1)/Dx;%number of divisions on X
    Ky = (y4-y1)/Dy;%number of divisions on Y
    fn = find(xy(:,1)==x1 & xy(:,2)==y1);%find pos. 1 el. nod
    fe = find(el(:,1)==fn & el(:,2)==(fn+1) & el(:,3)==(fn+I+2));%find 1 el.
    h = fe:fe+Kx-1;%horizontal elements
    v = fe+I:fe+I+Kx-1;%vertical elements
    fr(1,:) = [h v];%1 row elements
    ner = length(fr(1,:));
    AUX = [AUX fr(1,:)];
     for j = 2:Ky
       fr(j,:) = fr(j-1,:)+2*I;
       AUX = [AUX fr(j,:)]; 
     end
     for m = 1:length(AUX)
       elPer(AUX(m),2) = per;  
     end
   %----------------------------------------------------------------------------------
   end%if box or triangle
   clear fr
end%n
%--------------------------------------------------------------------------

function Vout = FEM_magneticS(el,xy,NVin,elPer)
%-- Finite Element Method for static magnetic fields : Static Potential ---
%el   = (Ne,1:3) -> element and its nod numeration (Ne = Nr of elements)
%xy   = (Nn,1:2) -> nod  coordinates (x y) (Nn = Nr of nodes)
%NVin  = [Nod Vin] -> nodes with known values Vin - (N,1:2)
%elPer = [el  Per] -> elements with determined relative magnetic permeability
%Vout = potentials values of the nodes 
%--------------------------------------------------------------------------

Nv  = NVin(:,1)';%nodes
Vin = NVin(:,2)';%values of the nodes

Ne = length(el(:,1));%nr of elements
Nn = length(xy(:,1));%nr of nodes

ep = elPer(:,2);%elements permeability
ep = ep*4*pi*1e-7;%mu x vacuo permeability

B = zeros(Nn,1);
C = zeros(Nn,Nn);
%--------------------------------------------------------------------------
for n=1:Ne 
  
  nod = [el(n,1) el(n,2) el(n,3)];%nodes of the element n
  x = xy(nod,1);%x coordinates for each nod
  y = xy(nod,2);%y coordinates for each nod
  
  q(1) = y(2) - y(3);
  q(2) = y(3) - y(1);
  q(3) = y(1) - y(2);

  r(1) = x(3) - x(2);
  r(2) = x(1) - x(3);
  r(3) = x(2) - x(1);

  D = 0.5*abs(q(2)*r(3)-r(2)*q(3)); 

  c = ep(n)*(q'*q + r'*r)/(4*D); %element local matrix

  ii = 1;
  for i = nod %Assembling the global matrix C
    jj = 1;
    for j = nod  
      C(i,j) = C(i,j) + c(ii,jj);
      jj = jj + 1;   
    end
    ii = ii + 1;
  end
  
end
%--------------------------------------------------------------------------
i = 1;
for k = Nv %comput B e the new C
  for n=1:Nn
    if(n~=k) 
      B(n) = B(n) - C(n,k)*Vin(i);
      C(n,k) = 0;
    end
  end
  C(k,:) = 0;
  C(k,k) = 1;
  B(k) = Vin(i);
  i = i + 1;
end
%--------------------------------------------------------------------------
Vout = inv(C)*B;
%--------------------------------------------------------------------------

function Vout = FEM_magneticV(el,xy,NVin,elPer,nodSor)
%-- Finite Element Method for static magnetic fields : Vector Potential ------
%el   = (Ne,1:3) -> element and its nod numeration (Ne = Nr of elements)
%xy   = (Nn,1:2) -> nod  coordinates (x y) (Nn = Nr of nodes)
%NVin  = [Nod Vin] -> nodes with known values Vin - (N,1:2)
%elPer = [el  Per] -> elements with determined relative magnetic permeability
%nodSor = [Nod Val] - > nodes with sorces J
%Vout = potentials values of the nodes 
%-----------------------------------------------------------------------------

Nv  = NVin(:,1)';%nodes
Vin = NVin(:,2)';%values of the nodes

Ne = length(el(:,1));%nr of elements
Nn = length(xy(:,1));%nr of nodes

ep = elPer(:,2);%elements permeability

Sor = zeros(Nn,1);%Sorce of current for not assigned nodes
Ns = nodSor(:,1);

nod = [el(1,1) el(1,2) el(1,3)];%nodes of the element 1
x = xy(nod,1);%x coordinates 
y = xy(nod,2);%y coordinates
%D is the same for all the elemts (all of them are equal)
D = (x(2)*y(3) - x(3)*y(2)) + (x(3)*y(1)-x(1)*y(3)) + (x(1)*y(2)-x(2)*y(1));

ep = 1./(ep*4*pi*1e-7);%reluctivity of the material

C = zeros(Nn,Nn);
%--------------------------------------------------------------------------
for n=1:Ne 
  
  nod = [el(n,1) el(n,2) el(n,3)];%nodes of the element n
  x = xy(nod,1);%x coordinates for each nod
  y = xy(nod,2);%y coordinates for each nod
  
  q(1) = y(2) - y(3);
  q(2) = y(3) - y(1);
  q(3) = y(1) - y(2);

  r(1) = x(3) - x(2);
  r(2) = x(1) - x(3);
  r(3) = x(2) - x(1);

  c = ep(n)*(q'*q + r'*r)/(2*D); %element local matrix

  ii = 1;
  for i = nod %Assembling the global matrix C
    jj = 1;
    for j = nod  
      C(i,j) = C(i,j) + c(ii,jj);
      jj = jj + 1;   
    end
    ii = ii + 1;
  end
  
end
%--------------------------------------------------------------------------
i = 1;
for k = Nv %comput the new C
  for n=1:Nn
    if(n~=k) 
      C(n,k) = C(n,k)*Vin(i);
    end
  end
  C(k,:) = 0;
  C(k,k) = 1;
  i = i + 1;
end
i=1;
for n = Ns
   Sor(n) =  (D/6)*nodSor(i,2);
   i=i+1;
end
i=1;
for n = Nv
   Sor(n) =  NVin(i,2);%Assign to the source the know potentails
   i=i+1;
end
%--------------------------------------------------------------------------
Vout = inv(C)*Sor;
%--------------------------------------------------------------------------


% --------------------------------------------------------------------
function Untitled_12_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_13_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_14_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_15_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_16_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_17_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_5_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_6_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_7_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_8_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_9_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_10_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_3_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_4_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_1_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_2_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


