function varargout = Point_Charges(varargin)
%POINT_CHARGES M-file for Point_Charges.fig
%      POINT_CHARGES, by itself, creates a new POINT_CHARGES or raises the existing
%      singleton*.
%
%      H = POINT_CHARGES returns the handle to a new POINT_CHARGES or the handle to
%      the existing singleton*.
%
%      POINT_CHARGES('Property','Value',...) creates a new POINT_CHARGES using the
%      given property value pairs. Unrecognized properties are passed via
%      varargin to Point_Charges_OpeningFcn.  This calling syntax produces a
%      warning when there is an existing singleton*.
%
%      POINT_CHARGES('CALLBACK') and POINT_CHARGES('CALLBACK',hObject,...) call the
%      local function named CALLBACK in POINT_CHARGES.M with the given input
%      arguments.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Point_Charges

% Last Modified by GUIDE v2.5 13-Jul-2005 13:02:48

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Point_Charges_OpeningFcn, ...
                   'gui_OutputFcn',  @Point_Charges_OutputFcn, ...
                   'gui_LayoutFcn',  [], ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
   gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Point_Charges is made visible.
function Point_Charges_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   unrecognized PropertyName/PropertyValue pairs from the
%            command line (see VARARGIN)

% Choose default command line output for Point_Charges
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Point_Charges wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Point_Charges_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --- Executes on button press in Positive3D.
function Positive3D_Callback(hObject, eventdata, handles)
% hObject    handle to Positive3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Positive3D


% --- Executes on button press in pushbutton10.
function One3D_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

po = get(handles.Positive3D,'Value');%get value input text
%q1 can be positive or negative
e_o = 8.854e-12;
if po
q1 = +10e-12;
else
q1 = -10e-12;
end

[x,y,z] = meshgrid(linspace(-1,1,6));

E = -q1./(4*pi*e_o*(sqrt(x.^2 + y.^2 + z.^2).^0.15)); 

[u,v,w] = gradient(E);
figure(1); subplot('position',[0.1 0.1 0.8 0.8])
quiver3(x,y,z,u,v,w,0.8,'b');
axis square; axis([-1 1 -1 1 -1 1]);hold on
plot3(0,0,0,'ro')

if q1>0
plot3(0,0,0,'r+')
elseif q1<0
plot3(0,0,0,'bo-'); 
end

hold off


function Q13D_Callback(hObject, eventdata, handles)
% hObject    handle to Q13D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q13D as text
%        str2double(get(hObject,'String')) returns contents of Q13D as a double


% --- Executes during object creation, after setting all properties.
function Q13D_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q13D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Q23D_Callback(hObject, eventdata, handles)
% hObject    handle to Q23D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q23D as text
%        str2double(get(hObject,'String')) returns contents of Q23D as a double


% --- Executes during object creation, after setting all properties.
function Q23D_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q23D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in Two3D.
function Two3D_Callback(hObject, eventdata, handles)
% hObject    handle to Two3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

q1 = str2num(get(handles.Q13D,'String'));%get value input text
q2 = str2num(get(handles.Q23D,'String'));%get value input text

%q1 can be positive or negative
e_o = 8.854e-12;

[x,y,z] = meshgrid(linspace(-1,3,18),linspace(-1,1,6),linspace(-1,1,6));

E = q1./(4*pi*e_o*(sqrt(x.^2 + y.^2 + z.^2).^0.15)) + ...
    q2./(4*pi*e_o*(sqrt((x-2).^2 + y.^2 + z.^2).^0.15)); 

[u,v,w] = gradient(-E);
figure(1); subplot('position',[0.1 0.1 0.8 0.8])
quiver3(x,y,z,u,v,w,0.6,'b'); axis square; axis([-1 3 -1 1 -1 1])
xlabel('x'); ylabel('y'); zlabel('z')
hold on
plot3(2,0,0,'o')
plot3(0,0,0,'o')

if q1>0
plot3(0,0,0,'ro')
plot3(0,0,0,'r+')
elseif q1<0
plot3(0,0,0,'*'); 
end

if q2>0
plot3(0,0,0,'ro')
plot3(2,0,0,'r+')
elseif q2<0
plot3(2,0,0,'*'); 
end

hold off



% --- Executes on button press in One2D.
function One2D_Callback(hObject, eventdata, handles)
% hObject    handle to One2D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

pos = get(handles.Positive2D,'Value');%use projection

if pos
  q1 = +10e-12;
else
  q1 = -10e-12;
end

e_o = 8.854e-12;
[x,y] = meshgrid(linspace(-1,1,20));

E = -q1./(4*pi*e_o*(sqrt(x.^2 + y.^2).^0.15)); 

X = [0.06 0.11 0.19 0.3 0.43 0.65 0.9];
lines = -q1./(4*pi*e_o*(sqrt(X.^2 + X.^2).^0.1));

figure(1); subplot('position',[0.1 0.1 0.8 0.8])
contour(x,y,E,lines); title('Electric Field')
hold on

[u,v] = gradient(E);

plot(0,0,'ro')
if q1>0
plot(0,0,'r+')
elseif q1<0
plot(0,0,'bo-'); 
% u(10:11,10:11)=0;
% v(10:11,10:11)=0;
end

h = streamslice(x,y,u,v,0.5);%streamslice(x,y,u,v,4,'noarrows');
set(h,'color',[0.5 0.5 0.5])
% quiver(x,y,u,v,0.8,'k');
axis square
colormap hsv
hold off


function Q1Two_Callback(hObject, eventdata, handles)
% hObject    handle to Q1Two (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q1Two as text
%        str2double(get(hObject,'String')) returns contents of Q1Two as a double


% --- Executes during object creation, after setting all properties.
function Q1Two_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q1Two (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Q2Two_Callback(hObject, eventdata, handles)
% hObject    handle to Q2Two (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Q2Two as text
%        str2double(get(hObject,'String')) returns contents of Q2Two as a double


% --- Executes during object creation, after setting all properties.
function Q2Two_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Q2Two (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in Two2D.
function Two2D_Callback(hObject, eventdata, handles)
% hObject    handle to Two2D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

q1 = str2num(get(handles.Q1Two,'String'));%get value input text
q2 = str2num(get(handles.Q2Two,'String'));%get value input text

force = get(handles.Force2D,'Value');%use projection

e_o = 8.854e-12;

[x,y] = meshgrid(linspace(-1,3,35), linspace(-1,1,15));
E = q1./(4*pi*e_o*(sqrt(x.^2 + y.^2).^0.1)) + ...
    q2./(4*pi*e_o*(sqrt((x-2).^2 + y.^2).^0.1)); 

Y = [0.2:0.2:2];
lines = q1./(4*pi*e_o*(sqrt(0.^2 + Y.^2).^0.1)) + ...
     q2./(4*pi*e_o*(sqrt((0-2).^2 + Y.^2).^0.1));
lines = [-lines lines];

[u,v] = gradient(-E);

figure(1); subplot('position',[0.1 0.1 0.8 0.8])
if abs(q1)~=abs(q2)
contour(x,y,E,20)
else
contour(x,y,E,lines)
end
hold on

plot(0,0,'ro'); title('Electric Field')
plot(2,0,'ro')
if q1<0 
u(8,[8 11]) = 0;
v(8,[8 11]) = 0;
u(7:9,9:10) = 0;
v(7:9,9:10) = 0;
plot(0,0,'bo-')
end
if q2<0
u(8,[25 28]) = 0;
v(8,[25 28]) = 0;
u(7:9,26:27) = 0;
v(7:9,26:27) = 0;    
plot(2,0,'bo-')
end
if q1>0
plot(0,0,'r+')
end
if q2>0
plot(2,0,'r+')
end

h = streamslice(x,y,u,v,0.8); axis equal; axis([-1 3 -1 1])
set(h,'color',[0.5 0.5 0.5])

%plot force
if force
  if ((q1<0 & q2<0) | (q1>0 & q2>0))
   p1=[0 0];
   p2=[-0.5 0];
   plotvec2D(p1,p2,2,'k')
   p1=[2 0];
   p2=[2.5 0];
   plotvec2D(p1,p2,2,'k')
  else
   p1=[0 0];
   p2=[0.5 0];
   plotvec2D(p1,p2,2,'k')
   p1=[2 0];
   p2=[1.5 0];
   plotvec2D(p1,p2,2,'k')    
  end
end
colormap jet
hold off

% --- Executes on button press in AnyNrCharge.
function AnyNrCharge_Callback(hObject, eventdata, handles)
% hObject    handle to AnyNrCharge (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

QP = str2num(get(handles.ChargesPosition,'String'));%get value input text
force = get(handles.ForceAny,'Value');%use projection
flines = get(handles.FieldLines,'Value');%use projection

Q = QP(:,1);%charges
P = QP(:,2:3); %charges position 

Xx = [[min(P(:,1))-1] [max(P(:,1))+1]];
Yy = [[min(P(:,2))-1] [max(P(:,2))+1]];

Nd = 8;%number of vector for ploting (0->1)

[x,y] = meshgrid(linspace(Xx(1),Xx(2),(Xx(2)-Xx(1))*Nd), linspace(Yy(1),Yy(2),(Yy(2)-Yy(1))*Nd));

e_o = 8.854e-12;

E = zeros((Yy(2)-Yy(1))*Nd,(Xx(2)-Xx(1))*Nd);

for n=1:length(Q)
E = E + Q(n)./(4*pi*e_o*(sqrt((x - P(n,1)).^2 + (y - P(n,2)).^2).^0.1));
end
figure(1); subplot('position',[0.1 0.1 0.8 0.8])
contour(x,y,E,30); axis equal; axis([Xx(1) Xx(2) Yy(1) Yy(2)])
hold on 

for n=1:length(Q)
  plot(P(n,1),P(n,2),'k*')
end

[u,v] = gradient(-E);
if flines
h = streamslice(x,y,u,v,0.8); 
set(h,'color',[0.5 0.5 0.5])
end

if force
%vector force plot
contour(x,y,E,30);
for n=1:length(Q)
  plot(P(n,1),P(n,2),'k*')
end
Px = P;%vector auxiliar 
for n=1:length(Q)
  if n>1
    aux = Q(1);
    Q(1)= Q(n);
    Q(n)= aux;
    aux1   = Px(1,:);
    Px(1,:) = Px(n,:);
    Px(n,:) = aux1;    
  end
  for m=1:length(Q)-1
    X = Px(m+1,1)-Px(1,1);
    Y = Px(m+1,2)-Px(1,2);
    R = sqrt(X^2 + Y^2);  
    F(n,m) = Q(1)*Q(m+1)/(4*pi*e_o*R^2); 
    if F(n,m)<0
      Pr(n,m) = (P(n,1)+X) + (P(n,2)+Y)*i;
    else
      Pr(n,m) = (P(n,1)-X) + (P(n,2)-Y)*i;
    end
  end
end
%force vectors plot
Fn = abs(F)./max(max(abs(F)));%force normalized
for n=1:length(Q)
  for m=1:length(Q)-1
   x1 = P(n,1);        y1 = P(n,2);
   x2 = real(Pr(n,m)); y2 = imag(Pr(n,m));
   Y = y2 - y1;  X = x2 - x1;
    if (x1~=x2 & y1~=y2)%don't do for ortogonal vectors (x1==x2 or y1==y2)
     ang = atand(Y/X);
       if X<0 & Y>0
         ang = - ang + 90;%2 q
       elseif X<0 &Y<0
         ang = ang + 180;%3 q  
       end
     x = Fn(n,m)*cosd(ang)+ P(n,1);
     y = Fn(n,m)*sind(ang)+ P(n,2);
     Pr(n,m) = x + y*i;
    else%ortogonals (x1==x2 | y1==y2)
      if x1==x2  
       Pr(n,m)= x2 + ((y2-y1)*Fn(n,m)+P(n,2))*i;
      else% y1==y2  
       Pr(n,m)= (x2-x1)*Fn(n,m)+P(n,1) + y2*i;
      end          
    end
    plotvec2D(P(n,:),[real(Pr(n,m)) imag(Pr(n,m))],0.9,'r')
  end
end

%ploting the resulted force
for n=1:length(Q)
    Fx = 0;
    Fy = 0;
   for m=1:length(Q)-1
    x1 = P(n,1);    
    y1 = P(n,2);
    x2 = real(Pr(n,m)); 
    y2 = imag(Pr(n,m)); 
    Fx = Fx + x2 - x1; 
    Fy = Fy + y2 - y1;
   end
    Fx = Fx + x1;
    Fy = Fy + y1;
    plotvec2D(P(n,:),[Fx Fy],0.9,'k')
end
end%force
hold off



function ChargesPosition_Callback(hObject, eventdata, handles)
% hObject    handle to ChargesPosition (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ChargesPosition as text
%        str2double(get(hObject,'String')) returns contents of ChargesPosition as a double


% --- Executes during object creation, after setting all properties.
function ChargesPosition_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ChargesPosition (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

% --- Executes on button press in Capacitor.
function Capacitor_Callback(hObject, eventdata, handles)
% hObject    handle to Capacitor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Nc = str2num(get(handles.NrQcapacitor,'String'));%get value input text
lg = str2num(get(handles.lcapacitor,'String'));%get value input text
ht = str2num(get(handles.hcapacitor,'String'));%get value input text

Q = [ones(Nc,1); -ones(Nc,1)]*1e-12;%charges

v1 =[linspace(0,lg,Nc) linspace(0,lg,Nc)]';
v2 =[zeros(Nc,1); ones(Nc,1)*ht];

P = [v1 v2] ;

Xx = [[min(P(:,1))-1] [max(P(:,1))+1]];
Yy = [[min(P(:,2))-1] [max(P(:,2))+1]];

Nd = 8;%number of vector for ploting (0->1)
arr = 0.9;%vector size

[x,y] = meshgrid(linspace(Xx(1),Xx(2),(Xx(2)-Xx(1))*Nd), linspace(Yy(1),Yy(2),(Yy(2)-Yy(1))*Nd));

e_o = 8.854e-12;

E = zeros((Yy(2)-Yy(1))*Nd,(Xx(2)-Xx(1))*Nd);

for n=1:length(Q)
E = E + Q(n)./(4*pi*e_o*(sqrt((x - P(n,1)).^2 + (y - P(n,2)).^2).^0.1));
end
figure(1); subplot('position',[0.1 0.1 0.8 0.8])
contour(x,y,E,30); axis equal; axis([Xx(1) Xx(2) Yy(1) Yy(2)]);
title('Capacitor using Point Charges')
hold on 

for n=1:length(Q)
  if Q(n)>0
   plot(P(n,1),P(n,2),'k+')
  else
   plot(P(n,1),P(n,2),'k.')
  end
end

[u,v] = gradient(-E);
h = streamslice(x,y,u,v,1); 
set(h,'color',[0.5 0.5 0.5])

% quiver(x,y,u,v,arr,'k');

% plot([0 lg],[0 0],'b','LineWidth',3)
% plot([0 lg],[ht ht],'b','LineWidth',3)
hold off


function hcapacitor_Callback(hObject, eventdata, handles)
% hObject    handle to hcapacitor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of hcapacitor as text
%        str2double(get(hObject,'String')) returns contents of hcapacitor as a double


% --- Executes during object creation, after setting all properties.
function hcapacitor_CreateFcn(hObject, eventdata, handles)
% hObject    handle to hcapacitor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function lcapacitor_Callback(hObject, eventdata, handles)
% hObject    handle to lcapacitor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of lcapacitor as text
%        str2double(get(hObject,'String')) returns contents of lcapacitor as a double


% --- Executes during object creation, after setting all properties.
function lcapacitor_CreateFcn(hObject, eventdata, handles)
% hObject    handle to lcapacitor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function NrQcapacitor_Callback(hObject, eventdata, handles)
% hObject    handle to NrQcapacitor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of NrQcapacitor as text
%        str2double(get(hObject,'String')) returns contents of NrQcapacitor as a double


% --- Executes during object creation, after setting all properties.
function NrQcapacitor_CreateFcn(hObject, eventdata, handles)
% hObject    handle to NrQcapacitor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --------------------------------------------------------------------
%functions used for me
% --------------------------------------------------------------------
function plotvec2D(p1,p2,size,color)
%plot a vector in 2D,  p1[x1 y1] p2[x2 y2] - two points deffine a vector

[x,y] = meshgrid([p1(1) p2(1)], [p1(2) p2(2)]);

u = [(p2(1)-p1(1)) 0; 0 0];
v = [(p2(2)-p1(2)) 0; 0 0];

if nargin<3
quiver(x,y,u,v,0); 
elseif nargin<4
quiver(x,y,u,v,size); 
else
quiver(x,y,u,v,size,color);    
end
xlabel('x'); ylabel('y');
% --------------------------------------------------------------------

% --- Executes on button press in radiobutton7.
function Positive2D_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton7
% --------------------------------------------------------------------
% Check Box Force
function Force2D_Callback(hObject, eventdata, handles)
% --------------------------------------------------------------------

%Check Box ForceAny.
function ForceAny_Callback(hObject, eventdata, handles)
% hObject    handle to ForceAny (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of ForceAny


% --- Executes on button press in FieldLines.
function FieldLines_Callback(hObject, eventdata, handles)
% hObject    handle to FieldLines (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of FieldLines

% --- Executes on button press in Negative.
function Negative_Callback(hObject, eventdata, handles)
% hObject    handle to Negative (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Negative



function QImage1_Callback(hObject, eventdata, handles)
% hObject    handle to QImage1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of QImage1 as text
%        str2double(get(hObject,'String')) returns contents of QImage1 as a double


% --- Executes during object creation, after setting all properties.
function QImage1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to QImage1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in OneImage.
function OneImage_Callback(hObject, eventdata, handles)
% hObject    handle to OneImage (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Qo = str2num(get(handles.QImage1,'String'));
ht = str2num(get(handles.hImage1,'String'));
image = get(handles.Image1,'Value');

Q = [+Qo -Qo ];%charges
P = [ 0 ht; 0 -ht]; %charges position 

Xx = [[min(P(:,1))-1.5] [max(P(:,1))+1.5]];
Yy = [[min(P(:,2))-1] [max(P(:,2))+1]];

Nd = 8;%number of vector for ploting (0->1)

[x,y] = meshgrid(linspace(Xx(1),Xx(2),(Xx(2)-Xx(1))*Nd), linspace(Yy(1),Yy(2),(Yy(2)-Yy(1))*Nd));

e_o = 8.854e-12;

E = zeros((Yy(2)-Yy(1))*Nd,(Xx(2)-Xx(1))*Nd);

for n=1:length(Q)
E = E + Q(n)./(4*pi*e_o*(sqrt((x - P(n,1)).^2 + (y - P(n,2)).^2).^0.1));
end

figure(1); subplot('position',[0.1 0.1 0.8 0.8])
contour(x,y,E,20); axis equal; axis([Xx(1) Xx(2) 0 Yy(2)])
xlabel('x')
ylabel('y')
title('Image Theory')
hold on 
[u,v] = gradient(-E);

h = streamslice(x,y,u,v,1); 
set(h,'color',[0.5 0.5 0.5])
% quiver(x,y,u,v,1.3,'k');

for n=1:length(Q)
  if Q(n)>0  
  plot(P(n,1),P(n,2),'*r')
  elseif Q(n)<0
  plot(P(n,1),P(n,2),'*b')  
  end
end
plot([Xx(1) Xx(2)],[0 0],'b','LineWidth',5)

if image
axis([Xx(1) Xx(2) Yy(1) Yy(2)])
end
hold off



% --- Executes on button press in Image1.
function Image1_Callback(hObject, eventdata, handles)
% hObject    handle to Image1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Image1



function hImage1_Callback(hObject, eventdata, handles)
% hObject    handle to hImage1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of hImage1 as text
%        str2double(get(hObject,'String')) returns contents of hImage1 as a double


% --- Executes during object creation, after setting all properties.
function hImage1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to hImage1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

%------------------------------------------------------------

function AnyImage_Callback(hObject, eventdata, handles)
% hObject    handle to AnyImage (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of AnyImage as text
%        str2double(get(hObject,'String')) returns contents of AnyImage as a double


% --- Executes during object creation, after setting all properties.
function AnyImage_CreateFcn(hObject, eventdata, handles)
% hObject    handle to AnyImage (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

% --- Executes on button press in CheckAnyImage.
function CheckAnyImage_Callback(hObject, eventdata, handles)
% hObject    handle to CheckAnyImage (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of CheckAnyImage


% --- Executes on button press in AnyImage2.
function AnyImage2_Callback(hObject, eventdata, handles)
% hObject    handle to AnyImage2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%for any number of charges
QP = str2num(get(handles.AnyImage,'String'));
image = get(handles.CheckAnyImage,'Value');

Q = QP(:,1)';%charges
P = QP(:,2:3); %charges position 

Q = [Q -Q];%creat image charges and position
P = [P(:,1) abs(P(:,2)); P(:,1) (-abs(P(:,2)))];

Xx = [[min(P(:,1))-1] [max(P(:,1))+1]];
Yy = [[min(P(:,2))-1] [max(P(:,2))+1]];

Nd = 8;%number of vector for ploting (0->1)

[x,y] = meshgrid(linspace(Xx(1),Xx(2),(Xx(2)-Xx(1))*Nd), linspace(Yy(1),Yy(2),(Yy(2)-Yy(1))*Nd));

e_o = 8.854e-12;

E = zeros((Yy(2)-Yy(1))*Nd,(Xx(2)-Xx(1))*Nd);

for n=1:length(Q)
E = E + Q(n)./(4*pi*e_o*(sqrt((x - P(n,1)).^2 + (y - P(n,2)).^2).^0.1));
end

figure(1); subplot('position',[0.1 0.1 0.8 0.8])
contour(x,y,E,20);
xlabel('x')
ylabel('y')
title('Image Theory')
axis equal; axis([Xx(1) Xx(2) 0 Yy(2)])
hold on 

[u,v] = gradient(-E);
h = streamslice(x,y,u,v,2);
set(h,'color',[0.5 0.5 0.5])

for n=1:length(Q)
  if Q(n)>0
  plot(P(n,1),P(n,2),'r.')
  else
  plot(P(n,1),P(n,2),'b.')
  end
end
plot([Xx(1) Xx(2)],[0 0],'b','LineWidth',5)
if image
axis([Xx(1) Xx(2) Yy(1) Yy(2)])
end
hold off



function editQAngle_Callback(hObject, eventdata, handles)
% hObject    handle to editQAngle (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editQAngle as text
%        str2double(get(hObject,'String')) returns contents of editQAngle as a double


% --- Executes during object creation, after setting all properties.
function editQAngle_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editQAngle (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editxyAngle_Callback(hObject, eventdata, handles)
% hObject    handle to editxyAngle (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editxyAngle as text
%        str2double(get(hObject,'String')) returns contents of editxyAngle as a double


% --- Executes during object creation, after setting all properties.
function editxyAngle_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editxyAngle (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in checkboxAngle.
function checkboxAngle_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxAngle (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxAngle


% --- Executes on button press in pushbuttonAngle.
function pushbuttonAngle_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonAngle (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Q = str2num(get(handles.editQAngle,'String'));
P = str2num(get(handles.editxyAngle,'String'));
ang30 = get(handles.radiobutton30Angle,'Value');
ang45 = get(handles.radiobutton45Angle,'Value');
ang60 = get(handles.radiobutton60Angle,'Value');
ang90 = get(handles.radiobutton90Angle,'Value');
image = get(handles.checkboxAngle,'Value');

%4 angles
P = [abs(P(1,1)) abs(P(1,2))];

if ang30
    ang = 30;
elseif ang45
    ang = 45;
elseif ang60
    ang = 60;
elseif ang90
    ang = 90;
end

alf1 = atand(P(1,2)/P(1,1)); 
hip = P(1,2)/sind(alf1);

if ang==90
  Q = [Q -Q Q -Q];
  P = [P(1,1) P(1,2); -P(1,1) P(1,2); -P(1,1) -P(1,2); P(1,1) -P(1,2)];
elseif ang==60
  alf2 = 60 - alf1;
  alf3 = 60 + alf2;
  P(2,1:2) = [hip*cosd(alf3) hip*sind(alf3)];
  P(3,1:2) = [-hip*cosd(alf2) hip*sind(alf2)];
  P(4,1:2) = [P(3,1) -P(3,2)];
  P(5,1:2) = [P(2,1) -P(2,2)];
  P(6,1:2) = [P(1,1) -P(1,2)];
  Q = [Q -Q Q -Q Q -Q];
elseif ang==45
  alf2 = 45 - alf1;
  alf3 = 45 + alf2;
  P(2,1:2) = [hip*cosd(alf3) hip*sind(alf3)];
  P(3,1:2) = [-P(2,1) P(2,2)];
  P(4,1:2) = [-P(1,1) P(1,2)];
  P(5,1:2) = [-P(1,1) -P(1,2)];
  P(6,1:2) = [P(3,1) -P(3,2)];
  P(7,1:2) = [P(2,1) -P(2,2)];
  P(8,1:2) = [P(1,1) -P(1,2)];
  Q = [Q -Q Q -Q Q -Q Q -Q];
elseif ang==30
  alf2 = 60 - alf1;
  alf3 = 60 + alf1;
  P(2,1:2) = [hip*cosd(alf2) hip*sind(alf2)];
  P(3,1:2) = [hip*cosd(alf3) hip*sind(alf3)];
  P(4,1:2) = [-P(3,1) P(3,2)];
  P(5,1:2) = [-P(2,1) P(2,2)];
  P(6,1:2) = [-P(1,1) P(1,2)];
  P(7,1:2) = [-P(1,1) -P(1,2)];
  P(8,1:2) = [-P(2,1) -P(2,2)];
  P(9,1:2) = [-P(3,1) -P(3,2)];
  P(10,1:2) = [P(3,1) -P(3,2)];
  P(11,1:2) = [P(2,1) -P(2,2)];
  P(12,1:2) = [P(1,1) -P(1,2)];
  Q = [Q -Q Q -Q Q -Q Q -Q Q -Q Q -Q];
end
%automatic scaling
Xx = [fix(-max(P(:,1)+1)) fix(max(P(:,1)+1))];
Yy = [fix(-max(P(:,2)+1)) fix(max(P(:,2)+1))];

figure(1); subplot('position',[0.1 0.1 0.8 0.8])
for n=1:length(Q)%ploting charges
  if Q(n) > 0
  plot(P(n,1),P(n,2),'r.')
  else
  plot(P(n,1),P(n,2),'b.')
  end
  hold on
end

%ploting lines
plot([Xx(1) Xx(2)],[0 0],'b','LineWidth',2)
if ang == 90
plot([0 0],[Yy(1) Yy(2)],'b','LineWidth',2)
elseif ang==60
plot([Yy(1)*cosd(60) Yy(2)*cosd(60)],[Yy(1)*sind(60) Yy(2)*sind(60)],'b','LineWidth',2)
plot([-Yy(1)*cosd(60) -Yy(2)*cosd(60)],[Yy(1)*sind(60) Yy(2)*sind(60)],'b','LineWidth',2)
elseif ang==45
plot([0 0],[Yy(1) Yy(2)],'b','LineWidth',2)
plot([Yy(1)*cosd(45) Yy(2)*cosd(45)],[Yy(1)*sind(45) Yy(2)*sind(45)],'b','LineWidth',2)
plot([-Yy(1)*cosd(45) -Yy(2)*cosd(45)],[Yy(1)*sind(45) Yy(2)*sind(45)],'b','LineWidth',2)
elseif ang==30
plot([0 0],[Yy(1) Yy(2)],'b','LineWidth',2)
plot([Yy(1)*cosd(30) Yy(2)*cosd(30)],[Yy(1)*sind(30) Yy(2)*sind(30)],'b','LineWidth',2)
plot([-Yy(1)*cosd(30) -Yy(2)*cosd(30)],[Yy(1)*sind(30) Yy(2)*sind(30)],'b','LineWidth',2)
plot([Yy(1)*cosd(60) Yy(2)*cosd(60)],[Yy(1)*sind(60) Yy(2)*sind(60)],'b','LineWidth',2)
plot([-Yy(1)*cosd(60) -Yy(2)*cosd(60)],[Yy(1)*sind(60) Yy(2)*sind(60)],'b','LineWidth',2)
end
axis equal
axis([0 Xx(2) 0 Yy(2)]); 

%--------------------------------------------------------------------------
Nd = 10;%number of vector for ploting (0->1)

[x,y] = meshgrid(linspace(Xx(1),Xx(2),(Xx(2)-Xx(1))*Nd), linspace(Yy(1),Yy(2),(Yy(2)-Yy(1))*Nd));

e_o = 8.854e-12;

E = zeros((Yy(2)-Yy(1))*Nd,(Xx(2)-Xx(1))*Nd);

for n=1:length(Q)
E = E + Q(n)./(4*pi*e_o*(sqrt((x - P(n,1)).^2 + (y - P(n,2)).^2).^0.1));
end

contour(x,y,E,20); 
xlabel('x')
ylabel('y')
title('Image Theory')

[u,v] = gradient(-E);

h = streamslice(x,y,u,v,2);%streamslice(x,y,u,v,4,'noarrows');
set(h,'color',[0.5 0.5 0.5])

hip = Yy(2)/sind(ang);
fill([0 hip*cosd(ang) 0],[0 Yy(2) Yy(2)],'w')
hold off

if image
%------------------------------------------------------------------
for n=1:length(Q)%ploting charges
  if Q(n) > 0
  plot(P(n,1),P(n,2),'r.')
  else
  plot(P(n,1),P(n,2),'b.')
  end
  hold on
end
axis equal
contour(x,y,E,20); xlabel('x')
ylabel('y')
title('Image Theory')
h = streamslice(x,y,u,v,2);%streamslice(x,y,u,v,4,'noarrows');
set(h,'color',[0.5 0.5 0.5])
%ploting lines
plot([Xx(1) Xx(2)],[0 0],'b','LineWidth',2)
if ang == 90
plot([0 0],[Yy(1) Yy(2)],'b','LineWidth',2)
elseif ang==60
plot([Yy(1)/tand(60) Yy(2)/tand(60)],[Yy(1) Yy(2)],'b','LineWidth',2)
plot([Yy(2)/tand(60) Yy(1)/tand(60)],[Yy(1) Yy(2)],'b','LineWidth',2)    
elseif ang==45
plot([0 0],[Yy(1) Yy(2)],'b','LineWidth',2)
plot([Yy(1)/tand(45) Yy(2)/tand(45)],[Yy(1) Yy(2)],'b','LineWidth',2)
plot([Yy(2)/tand(45) Yy(1)/tand(45)],[Yy(1) Yy(2)],'b','LineWidth',2)
elseif ang==30
plot([0 0],[Yy(1) Yy(2)],'b','LineWidth',2)
plot([Yy(1)/tand(30) Yy(2)/tand(30)],[Yy(1) Yy(2)],'b','LineWidth',2)
plot([Yy(2)/tand(30) Yy(1)/tand(30)],[Yy(1) Yy(2)],'b','LineWidth',2)    
plot([Yy(1)/tand(60) Yy(2)/tand(60)],[Yy(1) Yy(2)],'b','LineWidth',2)
plot([Yy(2)/tand(60) Yy(1)/tand(60)],[Yy(1) Yy(2)],'b','LineWidth',2)    
end
axis([Xx(1) Xx(2) Yy(1) Yy(2)]);
end
hold off



function editQbox_Callback(hObject, eventdata, handles)
% hObject    handle to editQbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editQbox as text
%        str2double(get(hObject,'String')) returns contents of editQbox as a double


% --- Executes during object creation, after setting all properties.
function editQbox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editQbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editxybox_Callback(hObject, eventdata, handles)
% hObject    handle to editxybox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editxybox as text
%        str2double(get(hObject,'String')) returns contents of editxybox as a double


% --- Executes during object creation, after setting all properties.
function editxybox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editxybox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function editlbox_Callback(hObject, eventdata, handles)
% hObject    handle to editlbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editlbox as text
%        str2double(get(hObject,'String')) returns contents of editlbox as a double


% --- Executes during object creation, after setting all properties.
function editlbox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editlbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edithbox_Callback(hObject, eventdata, handles)
% hObject    handle to edithbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edithbox as text
%        str2double(get(hObject,'String')) returns contents of edithbox as a double


% --- Executes during object creation, after setting all properties.
function edithbox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edithbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

% --- Executes on button press in checkboxbox.
function checkboxbox_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxbox


% --- Executes on button press in pushbuttonbox.
function pushbuttonbox_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Q = str2num(get(handles.editQbox,'String'));
P = str2num(get(handles.editxybox,'String'));
a = str2num(get(handles.editlbox,'String'));
b = str2num(get(handles.edithbox,'String'));
image = get(handles.checkboxbox,'Value');

Nb = 5;%number of boxes

if P(1)>=a
    P(1)=a/2;
end

if P(2)>=b
    P(2)=b/2;
end

x1 = P(1,1);
y1 = P(1,2);

x2 = a - x1;
y2 = b - y1;

n = 1;
auxb = [y1 y2];
for i=1:Nb
  auxa = [x1 x2];  
  for j=1:Nb
     P(n,1:2)=[(j*a - auxa(2)) (i*b - auxb(2))];  
     auxa = [auxa(2) auxa(1)]; 
     n = n + 1;
     Q(n) = -Q(n-1);
  end
  auxb = [auxb(2) auxb(1)]; 
end
Q = Q(1:length(Q)-1);


Xx = [0 Nb*a];
Yy = [0 Nb*b];

Nd = 10;%number of vector for ploting (0->1)

[x,y] = meshgrid(linspace(Xx(1),Xx(2),(Xx(2)-Xx(1))*Nd), linspace(Yy(1),Yy(2),(Yy(2)-Yy(1))*Nd));

e_o = 8.854e-12;

E = zeros((Yy(2)-Yy(1))*Nd,(Xx(2)-Xx(1))*Nd);

for n=1:length(Q)
E = E + Q(n)./(4*pi*e_o*(sqrt((x - P(n,1)).^2 + (y - P(n,2)).^2).^0.1));
end
figure(1); subplot('position',[0.1 0.1 0.8 0.8])
contour(x,y,E,20);hold on
axis equal
xlabel('x')
ylabel('y')
title('Image Theory')
axis([2*a 3*a 2*b 3*b]); 
set(gca,'yticklabel',[0:0.5:b])
set(gca,'xticklabel',[0:0.5:a])

[u,v] = gradient(-E);

h = streamslice(x,y,u,v,6);%streamslice(x,y,u,v,4,'noarrows');
set(h,'color',[0.5 0.5 0.5])

for n=0:Nb
plot([0 a*Nb],[n*b n*b],'b','LineWidth',2);
plot([a*n a*n],[ 0 b*Nb],'b','LineWidth',2);
end

for n=1:length(Q)
  if Q(n)>0
  plot(P(n,1),P(n,2),'r.')
  else
  plot(P(n,1),P(n,2),'b.')
  end
end

if image
plot([2*a 3*a],[2*b 2*b],'r','LineWidth',2);
plot([3*a 3*a],[2*b 3*b],'r','LineWidth',2);
plot([3*a 2*a],[3*b 3*b],'r','LineWidth',2);
plot([2*a 2*a],[3*b 2*b],'r','LineWidth',2);
axis([Xx(1) Xx(2) Yy(1) Yy(2)])
set(gca,'xticklabel',[])
set(gca,'yticklabel',[])
end
hold off

% --------------------------------------------------------------------
function Untitled_6_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_7_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_8_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_9_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_10_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_11_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_11 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_3_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_5_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_1_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_2_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_13_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_14_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_15_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_16_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_17_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_18_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_18 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


