function varargout = Vector_Addition(varargin)
% Vector_Addition M-file for Vector_Addition.fig
%      Vector_Addition, by itself, creates a new Vector_Addition or raises the existing
%      singleton*.
%
%      H = Vector_Addition returns the handle to a new Vector_Addition or the handle to
%      the existing singleton*.
%
%      Vector_Addition('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in Vector_Addition.M with the given input arguments.
%
%      Vector_Addition('Property','Value',...) creates a new Vector_Addition or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Vector_Addition_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Vector_Addition_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help Vector_Addition

% Last Modified by GUIDE v2.5 13-Jul-2005 12:56:08

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Vector_Addition_OpeningFcn, ...
                   'gui_OutputFcn',  @Vector_Addition_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT
%-----------------------------------------------------------------

% --- Executes just before Vector_Addition is made visible.
function Vector_Addition_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Vector_Addition (see VARARGIN)

% Choose default command line output for Vector_Addition
handles.output = hObject;
%-----------------------------------------------------------------
%my variables
handles.vector = [];
handles.vector3D = [];
%-----------------------------------------------------------------
% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Vector_Addition wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% --- Outputs from this function are returned to the command line.
function varargout = Vector_Addition_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

function EnterVector_Callback(hObject, eventdata, handles)
% hObject    handle to EnterVector (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of EnterVector as text
%        str2double(get(hObject,'String')) returns contents of EnterVector as a double

% --- Executes during object creation, after setting all properties.
function EnterVector_CreateFcn(hObject, eventdata, handles)
% hObject    handle to EnterVector (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in Projection.
function Projection_Callback(hObject, eventdata, handles)
% hObject    handle to Projection (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Projection

% --- Executes on button press in Enter.
function Enter_Callback(hObject, eventdata, handles)
% hObject    handle to Enter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

aux = str2num(get(handles.EnterVector,'String'));%get value input text
proj = get(handles.Projection,'Value');%use projection

handles.vector = [handles.vector; aux];%handles.vector define over
guidata(hObject,handles);%store changes 

close(figure(1))
for n = 1: length(aux(:,1))
  p1 = aux(n,1:2);
  p2 = aux(n,3:4);
  figure(1); subplot('position',[0.1 0.1 0.8 0.8]); hold on 
  x = (p1(1)==p2(1));
  y = (p1(2)==p2(2));
  if proj==1
      if x %don't projet axis paralel
      elseif y %don't projet axis paralel
      else
        plotvec2D([p1(1) 0],[p2(1) 0],2,'c');
        plotvec2D([0 p1(2)],[0 p2(2)],2,'c');
      end
  end
end

for n = 1: length(aux(:,1))
  p1 = aux(n,1:2);
  p2 = aux(n,3:4);
  figure(1); subplot('position',[0.1 0.1 0.8 0.8]) 
  plotvec2D(p1,p2,2,'b');  
end
axis equal; grid on
hold off

% --- Executes on button press in Add.
function Add_Callback(hObject, eventdata, handles)
% hObject    handle to Add (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

aux = handles.vector;
% dv = get(handles.DistanceVector,'Value');%plot distance vector

%add vectors
nv = length(aux(:,1));
% s1 = aux(1,1:2);
% s2 = aux(1,3:4);
p1 = aux(1,1:2);
p2 = aux(1,3:4);
if nv>1
 for n = 1: length(aux(:,1))-1
  p3 = aux(n+1,1:2);
  p4 = aux(n+1,3:4);
  auxp = p3 - p2;
  p5 = p4 - auxp;
  p2 = p5;
%   s1 = [(s1(1) + p3(1) - p1(1)) (s1(2) + p3(2) - p1(2))];
%   s2 = [(s2(1) + p4(1) - p3(1)) (s2(2) + p4(2) - p3(2))];
  figure(1); hold on; subplot('position',[0.1 0.1 0.8 0.8]);
%   if dv==1
%     plotvec2D(p2,p4,2,'k');
%   end
 end
end
% plotvec2D(s1,s2,2,'r'); 
plotvec2D(p1,p5,2,'r'); axis equal; grid on 
hold off

% --- Executes on button press in pushbutton3.
function pushbutton3_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in DistanceVector.
function DistanceVector_Callback(hObject, eventdata, handles)
% hObject    handle to DistanceVector (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of DistanceVector


% --------------------------------------------------------------------
%functions used for me
% --------------------------------------------------------------------
function plotvec2D(p1,p2,size,color)
%plot a vector in 2D,  p1[x1 y1] p2[x2 y2] - two points deffine a vector

[x,y] = meshgrid([p1(1) p2(1)], [p1(2) p2(2)]);

u = [(p2(1)-p1(1)) 0; 0 0];
v = [(p2(2)-p1(2)) 0; 0 0];

if nargin<3
quiver(x,y,u,v,0); 
elseif nargin<4
quiver(x,y,u,v,size); 
else
quiver(x,y,u,v,size,color);    
end
xlabel('x'); ylabel('y');
% --------------------------------------------------------------------


% --- Executes on button press in clear.
function clear_Callback(hObject, eventdata, handles)
% hObject    handle to clear (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set(handles.EnterVector,'String',['']);%clear input text
handles.vector = [];
guidata(hObject,handles);%store changes 



% --- Executes on button press in Enter3D.
function Enter3D_Callback(hObject, eventdata, handles)
% hObject    handle to Enter3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

aux1 = str2num(get(handles.edit3D,'String'));%get value input text
proj = get(handles.projection3D,'Value');%use projection

handles.vector3D = [handles.vector3D; aux1];%handles.vector define over
guidata(hObject,handles);%store changes 

close(figure(1))
for n = 1: length(aux1(:,1))
  p1 = aux1(n,1:3);
  p2 = aux1(n,4:6);
  figure(1);
  plotvec3D(p1,p2,0,'b'); hold on;
  x = (p1(1)==p2(1));
  y = (p1(2)==p2(2));
  z = (p1(3)==p2(3));
  if proj==1
     if ((x & y) | (x & z) | (y & z))
         %no projections for axis paralels
     elseif x
      plotvec3D([p1(1) p1(2) 0],[p2(1) p2(2) 0],0,'c'); 
      plotvec3D([p1(1) 0 p1(3)],[p2(1) 0 p2(3)],0,'c');        
     elseif y
      plotvec3D([p1(1) p1(2) 0],[p2(1) p2(2) 0],0,'c'); 
      plotvec3D([0 p1(2) p1(3)],[0 p2(2) p2(3)],0,'c');    
     elseif z
      plotvec3D([p1(1) 0 p1(3)],[p2(1) 0 p2(3)],0,'c'); 
      plotvec3D([0 p1(2) p1(3)],[0 p2(2) p2(3)],0,'c');
     else
      plotvec3D([p1(1) p1(2) 0],[p2(1) p2(2) 0],0,'c'); 
      plotvec3D([p1(1) 0 p1(3)],[p2(1) 0 p2(3)],0,'c'); 
      plotvec3D([0 p1(2) p1(3)],[0 p2(2) p2(3)],0,'c'); 
     end
  end
end
figure(1)
for n = 1: length(aux1(:,1))
  p1 = aux1(n,1:3);
  p2 = aux1(n,4:6);
  if (p1(1)==p2(1) & p1(2)==p2(2))%if in z axis put a mark 
    plotvec3D(p1,p2,0,'+b');   
  else
  plotvec3D(p1,p2,0,'b'); 
  end
end
axis equal
hold off

% --- Executes on button press in ADD3D.
function ADD3D_Callback(hObject, eventdata, handles)
% hObject    handle to ADD3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

aux1 = handles.vector3D;
% dv = get(handles.Distance3D,'Value');%plot distance vector

%add vectors
nv = length(aux1(:,1));
% s1 = aux(1,1:3);
% s2 = aux(1,4:6);
p1 = aux1(1,1:3);
p2 = aux1(1,4:6);
if nv>1
 for n = 1: length(aux1(:,1))-1
  p3 = aux1(n+1,1:3);
  p4 = aux1(n+1,4:6);
  auxp = p3 - p2;
  p5 = p4 - auxp;
  p2 = p5;
%   s1 = [(s1(1) + p3(1) - p1(1)) (s1(2) + p3(2) - p1(2)) (s1(3) + p3(3) - p1(3))];
%   s2 = [(s2(1) + p4(1) - p3(1)) (s2(2) + p4(2) - p3(2)) (s2(3) + p4(3) - p3(3))];
  
%   if dv==1
%     plotvec3D(p2,p4,0,'k'); axis equal
%   end
 end
end
% plotvec3D(s1,s2,0,'r'); axis equal 
figure(1); 
hold on; 
if (p1(1)==p5(1) & p1(2)==p5(2))%if in z axis put a mark 
    plotvec3D(p1,p2,0,'+r');   
else
plotvec3D(p1,p5,0,'r'); axis equal
end
hold off

% --- Executes on button press in clear3D.
function clear3D_Callback(hObject, eventdata, handles)
% hObject    handle to clear3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set(handles.edit3D,'String',['']);%clear input text
handles.vector3D = [];
guidata(hObject,handles);%store changes 

% --- Executes on button press in projection3D.
function projection3D_Callback(hObject, eventdata, handles)
% hObject    handle to projection3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of projection3D


% --- Executes on button press in Distance3D.
function Distance3D_Callback(hObject, eventdata, handles)
% hObject    handle to Distance3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of Distance3D

function edit3D_Callback(hObject, eventdata, handles)
% hObject    handle to edit3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3D as text
%        str2double(get(hObject,'String')) returns contents of edit3D as a double


% --- Executes during object creation, after setting all properties.
function edit3D_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

% --------------------------------------------------------------------
%functions used for me
% --------------------------------------------------------------------
function plotvec3D(p1,p2,size,color)
%plot a vector in 3D,  p1[x1 y1 z1] p2[x2 y2 z2] - two points deffine a vector

[x,y,z] = meshgrid([p1(1) p2(1)], [p1(2) p2(2)],[p1(3) p2(3)]);

u = zeros(2,2,2);
v = zeros(2,2,2);
w = zeros(2,2,2);

u(1,1,1) = p2(1) - p1(1); 
v(1,1,1) = p2(2) - p1(2); 
w(1,1,1) = p2(3) - p1(3); 
quiver3(x,y,z,u,v,w,size,color);xlabel('x'); ylabel('y'); zlabel('z')
% --------------------------------------------------------------------
% --------------------------------------------------------------------
function Untitled_1_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_3_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_4_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_2_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_7_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_8_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_9_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_10_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_12_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_13_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_5_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_6_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_11_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_11 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_14_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_15_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_16_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --------------------------------------------------------------------
function Function1_Callback(hObject, eventdata, handles)
% hObject    handle to Function1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[x,y] = meshgrid(-3:.3:3);
z = 16 -(x.^2 + y.^2);

figure(1)
subplot('position',[0.3 0.53 0.4 0.4]) 
surf(x,y,z); 
title('f(x,y) = 16 - (x^2 + y^2)'); xlabel('x'); ylabel('y'); zlabel('z')

subplot('position',[0.10 0.10 0.36 0.36]) 
[c,h] = contour(x,y,z,10);
clabel(c)
title('Contour Lines'); xlabel('x'); ylabel('y')

subplot('position',[0.55 0.10 0.35 0.35]) 
[dx,dy] = gradient(z);
contour(x,y,z,10)
hold on
quiver(x,y,dx,dy,1.2,'k');
title('Gradient'); xlabel('x'); ylabel('y')
hold off

% --------------------------------------------------------------------
function Function2_Callback(hObject, eventdata, handles)
% hObject    handle to Funct2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[x,y] = meshgrid(-2:0.2:2, -2:0.2:2);
z = x.^2.*y-3.*x+3;

figure(1)
subplot('position',[0.3 0.53 0.4 0.4]) 
surf(x,y,z); 
title('f(x,y) = x^2y -3x + 3'); xlabel('x'); ylabel('y'); zlabel('z')

subplot('position',[0.10 0.10 0.35 0.35])
lines = [13 11.6 10.3 9 7.6 6.3 5 3.6 2.3 1 -0.3 -1.6 -3 -4.3 -5.6 -7 -8 -11];
[c,h] = contour(x,y,z,lines);%without numeration use just contour(z,20)
clabel(c,h)
title('Contour Lines'); xlabel('x'); ylabel('y')


subplot('position',[0.55 0.10 0.35 0.35]) 
[dx,dy] = gradient(z);
contour(x,y,z,10)
hold on
quiver(x,y,dx,dy,1.2,'k');
title('Gradient'); xlabel('x'); ylabel('y')
hold off

% --------------------------------------------------------------------
function Function3_Callback(hObject, eventdata, handles)
% hObject    handle to Function3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[x,y] = meshgrid(-2:0.2:2, -2:0.2:2);
z = x.*exp(-x.^2 -y.^2);
figure(1)
subplot('position',[0.3 0.53 0.4 0.4])
surf(x,y,z); 
title('f(x,y) = x.exp(-x^2 -y^2)'); xlabel('x'); ylabel('y'); zlabel('z')

subplot('position',[0.10 0.10 0.35 0.35])
[c,h] = contour(x,y,z,8);
clabel(c)
title('Contour Lines'); xlabel('x'); ylabel('y')
%clabel(c,h,'LabelSpacing',300)
%clabel(c,h,'FontSize',12,'Color','k','Rotation',0)

subplot('position',[0.55 0.10 0.35 0.35]) 
[dx,dy] = gradient(z);
contour(x,y,z,10)
hold on
quiver(x,y,dx,dy,1.2,'k');
title('Gradient'); xlabel('x'); ylabel('y')
hold off

% --------------------------------------------------------------------
function Function4_Callback(hObject, eventdata, handles)
% hObject    handle to Function4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[x,y] = meshgrid(-3:0.15:3, -3:0.15:3);
z = 3*(1-x).^2.*exp(-(x.^2) - (y+1).^2) ...
   - 10*(x/5 - x.^3 - y.^5).*exp(-x.^2-y.^2) ...
   - 1/3*exp(-(x+1).^2 - y.^2);
figure(1)
subplot('position',[0.3 0.53 0.4 0.4])
surf(x,y,z); 
title('f(x,y) = 3(1-x)^2exp(-x^2 - (y-1)^2)-10(x/5 -x^3 -y^5)exp(-x^2 -y^2)-1/3exp(-(x+1)^2 - y^2)'); 
xlabel('x'); ylabel('y'); zlabel('z')

subplot('position',[0.10 0.10 0.35 0.35])
[c,h] = contour(x,y,z,30);
title('Contour Lines'); xlabel('x'); ylabel('y')

subplot('position',[0.55 0.10 0.35 0.35]) 
[dx,dy] = gradient(z);
contour(x,y,z,10)
hold on
quiver(x,y,dx,dy,1.2,'k');
title('Gradient'); xlabel('x'); ylabel('y')
hold off


