function varargout = waves(varargin)
% WAVES M-file for waves.fig
%      WAVES, by itself, creates a new WAVES or raises the existing
%      singleton*.
%
%      H = WAVES returns the handle to a new WAVES or the handle to
%      the existing singleton*.
%
%      WAVES('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in WAVES.M with the given input arguments.
%
%      WAVES('Property','Value',...) creates a new WAVES or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before waves_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to waves_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help waves

% Last Modified by GUIDE v2.5 14-Jul-2005 16:02:10

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @waves_OpeningFcn, ...
                   'gui_OutputFcn',  @waves_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before waves is made visible.
function waves_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to waves (see VARARGIN)

% Choose default command line output for waves
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes waves wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = waves_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function editfM_Callback(hObject, eventdata, handles)
% hObject    handle to editfM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editfM as text
%        str2double(get(hObject,'String')) returns contents of editfM as a double


% --- Executes during object creation, after setting all properties.
function editfM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editfM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editTM_Callback(hObject, eventdata, handles)
% hObject    handle to editTM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editTM as text
%        str2double(get(hObject,'String')) returns contents of editTM as a double


% --- Executes during object creation, after setting all properties.
function editTM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editTM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editPt1M_Callback(hObject, eventdata, handles)
% hObject    handle to editPt1M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editPt1M as text
%        str2double(get(hObject,'String')) returns contents of editPt1M as a double


% --- Executes during object creation, after setting all properties.
function editPt1M_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editPt1M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editPb1M_Callback(hObject, eventdata, handles)
% hObject    handle to editPb1M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editPb1M as text
%        str2double(get(hObject,'String')) returns contents of editPb1M as a double


% --- Executes during object creation, after setting all properties.
function editPb1M_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editPb1M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editC1M_Callback(hObject, eventdata, handles)
% hObject    handle to editC1M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editC1M as text
%        str2double(get(hObject,'String')) returns contents of editC1M as a double


% --- Executes during object creation, after setting all properties.
function editC1M_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editC1M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editD1_Callback(hObject, eventdata, handles)
% hObject    handle to editD1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editD1 as text
%        str2double(get(hObject,'String')) returns contents of editD1 as a double


% --- Executes during object creation, after setting all properties.
function editD1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editD1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editPt2M_Callback(hObject, eventdata, handles)
% hObject    handle to editPt2M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editPt2M as text
%        str2double(get(hObject,'String')) returns contents of editPt2M as a double


% --- Executes during object creation, after setting all properties.
function editPt2M_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editPt2M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editPb2M_Callback(hObject, eventdata, handles)
% hObject    handle to editPb2M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editPb2M as text
%        str2double(get(hObject,'String')) returns contents of editPb2M as a double


% --- Executes during object creation, after setting all properties.
function editPb2M_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editPb2M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editC2M_Callback(hObject, eventdata, handles)
% hObject    handle to editC2M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editC2M as text
%        str2double(get(hObject,'String')) returns contents of editC2M as a double


% --- Executes during object creation, after setting all properties.
function editC2M_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editC2M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editD2_Callback(hObject, eventdata, handles)
% hObject    handle to editD2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editD2 as text
%        str2double(get(hObject,'String')) returns contents of editD2 as a double


% --- Executes during object creation, after setting all properties.
function editD2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editD2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editPt3M_Callback(hObject, eventdata, handles)
% hObject    handle to editPt3M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editPt3M as text
%        str2double(get(hObject,'String')) returns contents of editPt3M as a double


% --- Executes during object creation, after setting all properties.
function editPt3M_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editPt3M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editPb3M_Callback(hObject, eventdata, handles)
% hObject    handle to editPb3M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editPb3M as text
%        str2double(get(hObject,'String')) returns contents of editPb3M as a double


% --- Executes during object creation, after setting all properties.
function editPb3M_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editPb3M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editC3M_Callback(hObject, eventdata, handles)
% hObject    handle to editC3M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editC3M as text
%        str2double(get(hObject,'String')) returns contents of editC3M as a double


% --- Executes during object creation, after setting all properties.
function editC3M_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editC3M (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editD3_Callback(hObject, eventdata, handles)
% hObject    handle to editD3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editD3 as text
%        str2double(get(hObject,'String')) returns contents of editD3 as a double


% --- Executes during object creation, after setting all properties.
function editD3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editD3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in pushbuttonRunM.
function pushbuttonRunM_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonRunM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

 ex0 = get(handles.radiobuttonMW,'Value');
 ex1 = get(handles.radiobutton1M,'Value');
 ex2 = get(handles.radiobutton2M,'Value');
 ex3 = get(handles.radiobutton3M,'Value');
 
ptr = get(handles.checkboxTransmitted,'Value');
pre = get(handles.checkboxReflected,'Value');
pto = get(handles.checkboxTotal,'Value');
 
if ex0
 N = str2num(get(handles.editMW,'String'));%nr de iteracoes
 reflex0M(N)    
elseif ex1
 er = str2num(get(handles.editPt1M,'String'));%permittivity
 ur = str2num(get(handles.editPb1M,'String'));%permeability 
 sig = str2num(get(handles.editC1M,'String'));%condutivity
 f = str2num(get(handles.editfM,'String'));%freq.
 D = str2num(get(handles.editD1,'String'));%Length
 Ts = str2num(get(handles.editTM,'String'));%time simulation
 wavereflexion1M(f,D,Ts,er,ur,sig)
elseif ex2
 er1 = str2num(get(handles.editPt1M,'String'));%permittivity
 ur1 = str2num(get(handles.editPb1M,'String'));%permeability 
 er2 = str2num(get(handles.editPt2M,'String'));%permittivity
 ur2 = str2num(get(handles.editPb2M,'String'));%permeability 
 sig1 = str2num(get(handles.editC1M,'String'));%condutivity
 sig2 = str2num(get(handles.editC2M,'String'));%condutivity
 f = str2num(get(handles.editfM,'String'));%freq.
 D1 = str2num(get(handles.editD1,'String'));%Length
 D2 = str2num(get(handles.editD2,'String'));%Length
 Ts = str2num(get(handles.editTM,'String'));%time simulation    
 er = [er1 er2];
 ur = [ur1 ur2];
 sig = [sig1 sig2];
 wavereflexion2M(f,D1,D2,Ts,er,ur,sig,ptr,pre,pto)    
elseif ex3
 er1 = str2num(get(handles.editPt1M,'String'));%permittivity
 ur1 = str2num(get(handles.editPb1M,'String'));%permeability 
 er2 = str2num(get(handles.editPt2M,'String'));%permittivity
 ur2 = str2num(get(handles.editPb2M,'String'));%permeability 
 er3 = str2num(get(handles.editPt3M,'String'));%permittivity
 ur3 = str2num(get(handles.editPb3M,'String'));%permeability
 sig1 = str2num(get(handles.editC1M,'String'));%condutivity
 sig2 = str2num(get(handles.editC2M,'String'));%condutivity
 sig3 = str2num(get(handles.editC3M,'String'));%condutivity
 f = str2num(get(handles.editfM,'String'));%freq.
 D1 = str2num(get(handles.editD1,'String'));%Length
 D2 = str2num(get(handles.editD2,'String'));%Length
 D3 = str2num(get(handles.editD3,'String'));%Length
 Ts = str2num(get(handles.editTM,'String'));%time simulation    
 er = [er1 er2 er3];
 ur = [ur1 ur2 ur3];
 sig = [sig1 sig2 sig3]; 
 wavereflexion3M(f,D1,D2,D3,Ts,er,ur,sig,ptr,pre,pto)    
end


%-------------------------------------------------------------------------
function reflex0M(N)

I = 100; %n_r de clulas em x
J = 10; %n_r de clulas em y (nao ha necessidade de mudar, pois, aonda
D = 0.001; %Delta_x = Delta_y, altura vert = horizontal = 1 mm
u_o = 4*pi*1e-7; %permeabilidade magnetica do vacuo
e_o = 8.854e-12; %permissividade eletrica do vacuo	
c = 1/(sqrt(u_o*e_o)); %velocidade da luz
D_t = 0.95*D/(c*sqrt(2)); %condio de estabilidade
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Desl = 200*D_t;%
L = 100*D_t;%largura do pulso gaussiano
t=0:D_t:500*D_t-D_t;%300 amostras do Pulso Gaussiano
Pg = 377*exp(-18*((t-Desl)/L).^2);
% plot(Pg)
%**************************************************************************
%Inicializao das variveis de campo - Modo TE
%Incluindo condies de contorno
%**************************************************************************
Hz = zeros(I,J);
Ex = zeros(I,J+1);
Ey = zeros(I+1,J);
%**************************************************************************
%variveis auxiliares
A = D_t/(e_o*D);
B = D_t/(u_o*D);
%********************************************************************************
%Calculo dos campos
for n=1:N
   %excitacao
   if n <= length(Pg)
       Ey(1,:) = Pg(n);
   end
   
   %Clculo de Hz
   for i=1:I
      for j=1:J
         Hz(i,j) = Hz(i,j) + B*(Ex(i,j+1) - Ex(i,j) - Ey(i,j) + Ey(i+1,j));
      end
   end
   %Clculo de Ex
   for i=1:I
      for j=2:J
         Ex(i,j) = Ex(i,j) + A*(Hz(i,j) - Hz(i,j-1));
      end
   end
   %Clculo de Ey
   for i=2:I
      for j=1:J
         Ey(i,j) = Ey(i,j) - A*(Hz(i-1,j) - Hz(i,j));
      end
   end
   %armazena Ey e Hz com passo de tempo determinado
   if mod(n,5)==0;

    E1 = Ey(:,5);
    H1 = Hz(:,5);

    figure(1);  
    subplot('position',[0.15 0.58 0.7 0.3])
    plot(E1,'r'),  axis([0 I -400 400]),  set(gca,'XGrid','on','YGrid','on');
    title(['Electric Field - Ey']);
    ylabel('[V/m]');

    subplot('position',[0.15 0.13 0.7 0.3]) 
    plot(H1),  axis([0 I -2 0]), set(gca,'XGrid','on','YGrid','on');
    title(['Magnetic Field - Hz']);
    xlabel('x [mm]');
    ylabel('[A/m]');
    pause(0.04)
   end
  
% n
end%N
%**************************************************************************
%**************************************************************************
function wavereflexion1M(f,D,Ts,er,ur,sig)

uo = 4*pi*1e-7;
eo = 8.854e-12;
w = 2*pi*f;
u = uo*ur;
e = eo*er;

a = w.*sqrt((u.*e/2).*(sqrt(1 + (sig./(w.*e)).^2) - 1));
b = w.*sqrt((u.*e/2).*(sqrt(1 + (sig./(w.*e)).^2) + 1));
c = 1./sqrt(u.*e);
lamb = c/f;
Per = 1/f;

pw = 20;
Dt = Per/pw;
Dz = lamb/pw;

D1 = D*lamb(1);%distance 1
DT = D1;

T = Ts*Per;%time simulation

t = 0:Dt:T;
z1 = 0:Dz(1):D1;
dz1 = length(z1);
%fields in the medium 1
E10t = zeros(1,dz1);
%auxiliar medium 1
a10 = 1;
aux0 = 1;
for n = 1:length(t) 
  %----------------------------------------------------------------------
  Z = 1;
  while Z<=aux0 
     E10t(Z) = a10*exp(-a(1)*z1(Z))*sin(w*t(n) - b(1)*z1(Z));
     Z = Z + 1;
  end
  if aux0 < dz1
   aux0 = aux0 + 1;
   t0 = n;
  else
   aux0 = dz1;
  end
  Time = (n-1)*Dt;
  time = num2str(Time,'%10.2e');  
  figure(1); subplot('position',[0.1 0.1 0.8 0.8]) 
  plot(z1,E10t,'r');
  axis([1 D1 -1.1 1.1]);
  title(['Plane Wave Transmission, Time = ', time,' [s]']);
  ylabel('Electric Field')
  xlabel('[m]')
  grid
  %----------------------------------------------------------------------
  pause(0.05)
end
%------------------------------------------------------------------------
function wavereflexion2M(f,D1,D2,Ts,er,ur,sig,ptr,pre,pto)

uo = 4*pi*1e-7;
eo = 8.854e-12;
w = 2*pi*f;
u = uo*ur;
e = eo*er;

a = w.*sqrt((u.*e/2).*(sqrt(1 + (sig./(w.*e)).^2) - 1));
b = w.*sqrt((u.*e/2).*(sqrt(1 + (sig./(w.*e)).^2) + 1));
j = sqrt(-1);

N = sqrt(j.*w.*u./(sig + j.*w.*e));

T12 =  2*N(2)/(N(2)+N(1));
R12 = (N(2)-N(1))/(N(2)+N(1));
at12 = angle(T12);
ar12 = angle(R12);
t12 = abs(T12);
r12 = abs(R12);
    
c = 1./sqrt(u.*e);
lamb = c/f;
Per = 1/f;

pw = 20;
Dt = Per/pw;
Dz = lamb/pw;

D1 = D1*lamb(1);%distance 1
D2 = D2*lamb(2);%distance 2

DT = D1+D2;

d1p = 0.7*D1/DT;
d2p = 0.7*D2/DT;

T = Ts*Per;%time simulation

t = 0:Dt:T;
z1 = 0:Dz(1):D1;
z2 = 0:Dz(2):D2;
dz1 = length(z1);
dz2 = length(z2);

%fields in the medium 1
E10t = zeros(1,dz1);
E11r = zeros(1,dz1);
%fields in the medium 2
E20t= zeros(1,dz2);

%auxiliar medium 2
at1 = exp(-a(1)*z1(dz1));
at2 = exp(-a(2)*z2(dz2));
a20 = t12*at1;
%auxiliar medium 1
a10 = 1;
a11 = r12*at1;
aux0 = 1;
aux1 = 1;
aux2 = 1;

p1 = (a10+a11) + 0.1*(a10+a11);
p2 = a20 + 0.1*a20;
if p1>p2
    pa = p1;
else
    pa = p2;
end

f0 = 0; f1 = 0; ff=0;

figure(1);
subplot('position',[0.15 0.2 d1p 0.65]);
plot([D1 D1],[-pa pa],'b','LineWidth',4) 
axis([0 D1 -pa pa]);
ylabel('Electric Field')
grid on
figure(1)
subplot('position',[0.15+d1p 0.2 d2p 0.65]);
plot([D1 D1],[-pa pa],'b','LineWidth',4); 
axis([D1 D1+D2 -pa pa]);
set(gca,'YtickLabel',[])
xlabel('[m]')
grid on

for n = 1:length(t) 
    
    
  %----------------------------------------------------------------------
  Z = 1;
  while Z<=aux0 
     E10t(Z) = a10*exp(-a(1)*z1(Z))*sin(w*t(n) - b(1)*z1(Z));
     Z = Z + 1;
  end
  if aux0 < dz1
   aux0 = aux0 + 1;
   t0 = n;
  else
   aux0 = dz1;
   f0 = 1;
  end
  
  Time = (n-1)*Dt;
  time = num2str(Time,'%10.2e');  
  
  figure(1)
  subplot('position',[0.15 0.2 d1p 0.65]);
  plot([D1 D1],[-pa pa],'b','LineWidth',4); hold on 
  axis([0 D1 -pa pa]); ylabel('Electric Field'); 
  title(['Plane Wave, Time = ', time,' [s]']);grid on
    
  if ptr
  figure(1)
  subplot('position',[0.15 0.2 d1p 0.65]);
  plot([D1 D1],[-pa pa],'b','LineWidth',4); hold on 
  axis([0 D1 -pa pa]); ylabel('Electric Field'); 
  title(['Plane Wave, Time = ', time,' [s]']);grid on
  plot(z1,E10t,'r');hold off
  ff = 1;
  end
  %----------------------------------------------------------------------
  if f0==1 %z1 done
    Z = 1;
    while Z<=aux1  
       E11r(dz1-Z+1) = a11*exp(-a(1)*z1(Z))*sin(w*t(n-t0) - b(1)*z1(Z) + ar12);   
       Z = Z + 1;
    end
    if aux1 < dz1
     aux1 = aux1 + 1;
    else
     aux1 = dz1;
     f1 = 1;
    end
    
    if ptr~=0 & pre
        figure(1)
    subplot('position',[0.15 0.2 d1p 0.65]); hold on
    plot([D1 D1],[-pa pa],'b','LineWidth',4); 
    title(['Plane Wave, Time = ', time,' [s]']);
    axis([0 D1 -pa pa]); ylabel('Electric Field'); grid on
    plot(z1,E11r,'g'); hold off 
    elseif pre 
        figure(1)
    subplot('position',[0.15 0.2 d1p 0.65]);
    plot([D1 D1],[-pa pa],'b','LineWidth',4);
    title(['Plane Wave, Time = ', time,' [s]']); hold on
    axis([0 D1 -pa pa]); ylabel('Electric Field'); grid on
    plot(z1,E11r,'g'); hold off 
    ff = 1;
    end
 
    %----------------------------------------------------------------------
    ZZ = 1;
    while ZZ<=aux2
      E20t(ZZ) = a20*exp(-a(2)*z2(ZZ))*sin(w*t(n-t0) - b(2)*z2(ZZ) + at12);
      ZZ = ZZ + 1;
    end
    if aux2 < dz2
     aux2 = aux2 + 1;
    else
     aux2 = dz2;
    end

    if f0==1
     if ptr | pto
         figure(1)
      subplot('position',[0.15+d1p 0.2 d2p 0.65]);
      plot([D1 D1],[-pa pa],'b','LineWidth',3); hold on
      plot(z2+D1,E20t,'r');
      axis([D1 D1+D2 -pa pa]);
      set(gca,'YtickLabel',[]); xlabel('[m]'); grid on; hold off
     end
    end

    if f1==1
      if ff~=0 & pto
          figure(1)
       subplot('position',[0.15 0.2 d1p 0.65]); hold on
       plot([D1 D1],[-pa pa],'b','LineWidth',4); 
       title(['Plane Wave, Time = ', time,' [s]']); 
       axis([0 D1 -pa pa]); ylabel('Electric Field'); grid on
       plot(z1,E10t + E11r,'b');hold off  
      elseif pto
          figure(1)
       subplot('position',[0.15 0.2 d1p 0.65]); 
       plot([D1 D1],[-pa pa],'b','LineWidth',4); 
       title(['Plane Wave, Time = ', time,' [s]']);hold on 
       axis([0 D1 -pa pa]); ylabel('Electric Field'); grid on
       plot(z1,E10t + E11r,'b');hold off 
      end
     end

%     end
    %----------------------------------------------------------------------
  end
  pause(0.05)
end
%-------------------------------------------------------------------------
function wavereflexion3M(f,D1,D2,D3,Ts,er,ur,sig,ptr,pre,pto)

uo = 4*pi*1e-7;
eo = 8.854e-12;

w = 2*pi*f;
u = uo*ur;
e = eo*er;

a = w.*sqrt((u.*e/2).*(sqrt(1 + (sig./(w.*e)).^2) - 1));
b = w.*sqrt((u.*e/2).*(sqrt(1 + (sig./(w.*e)).^2) + 1));
j = sqrt(-1);

N = sqrt(j.*w.*u./(sig + j.*w.*e));

T12 =  2*N(2)/(N(2)+N(1));
R12 = (N(2)-N(1))/(N(2)+N(1));
T21 = 2*N(1)/(N(1)+N(2));
R21 = (N(1)-N(2))/(N(1)+N(2));
T23 = 2*N(3)/(N(3)+N(2));
R23 = (N(3)-N(2))/(N(3)+N(2));
t12 = abs(T12); at12 = angle(T12);
r12 = abs(R12); ar12 = angle(R12);
t21 = abs(T21); at21 = angle(T21);
r21 = abs(R21); ar21 = angle(R21);
t23 = abs(T23); at23 = angle(T23);
r23 = abs(R23); ar23 = angle(R23);

c = 1./sqrt(u.*e);
lamb = c/f;
Per = 1/f;
pw = 20;
Dt = Per/pw;
Dz = lamb/pw;

D1 = D1*lamb(1);%distance 1
D2 = D2*lamb(2);%distance 2
D3 = D3*lamb(3);%distance 3

DT = D1+D2+D3;

d1p = 0.7*D1/DT;
d2p = 0.7*D2/DT;
d3p = 0.7*D3/DT;

T = Ts*Per;%time simulation

t = 0:Dt:T;
z1 = 0:Dz(1):D1;
z2 = 0:Dz(2):D2;
z3 = 0:Dz(3):D3;

dz1 = length(z1);
dz2 = length(z2);
dz3 = length(z3);

%fields in the medium 1
E10t = zeros(1,dz1);
E11r = zeros(1,dz1);
E12t = zeros(1,dz1);
E13t = zeros(1,dz1);

%fields in the medium 2
E20t= zeros(1,dz2);
E21r= zeros(1,dz2);
E22r= zeros(1,dz2);
E23r= zeros(1,dz2);
E24r= zeros(1,dz2);

%fiels in the medium 3
E30t= zeros(1,dz3);
E31t= zeros(1,dz3);
E32t= zeros(1,dz3);

%auxiliar medium 2
at1 = exp(-a(1)*z1(dz1));
at2 = exp(-a(2)*z2(dz2));

a20 = t12*at1;                                  aa20 = at12;                           
a21 = t12*r23*at1*at2;                          aa21 = at12 + ar23;
a22 = t12*r23*r21*at1*at2*at2;                  aa22 = at12 + ar23 + ar21;
a23 = t12*r23*r21*r23*at1*at2*at2*at2;          aa23 = at12 + ar23 + ar21 + ar23;
a24 = t12*r23*r21*r23*r21*at1*at2*at2*at2*at2;  aa24 = at12 + ar23 + ar21 + ar23 + ar21;

%auxiliar medium 1
a10 = 1;
a11 = r12*at1;      aa11 = ar12;
a12 = a21*t21*at2;  aa12 = aa21 + at21;
a13 = a23*t21*at2;  aa13 = aa23 + at21;

%auxiliar medium 3
a30 = a20*t23*at2;  aa30 = aa20 + at23;
a31 = a22*t23*at2;  aa31 = aa22 + at23;
a32 = a24*t23*at2;  aa32 = aa24 + at23;

p1 = 1.1*(a10+a11+a12+a13);
p2 = 1.1*(a20+a21+a22+a23+a24);
p3 = 1.1*(a30+a31+a32);

if p1>p2 & p1>p3
    pa = p1;
elseif p2>p1 & p2>p3
    pa = p2;
else
    pa = p3;
end

aux0 = 1; aux1 = 1; aux2 = 1; aux3 = 1; aux4 = 1; aux5 = 1; aux6 = 1;
aux7 = 1; aux8 = 1; aux9 = 1; aux10 = 1; aux11 = 1;
f0 = 0; f1 = 0; f2 = 0; f3 = 0; f4 = 0; f5 = 0; ff = 0;

figure(1);
subplot('position',[0.15 0.2 d1p 0.65]);
plot([D1 D1],[-pa pa],'b','LineWidth',4) 
axis([0 D1 -pa pa]); ylabel('Electric Field');
grid on
figure(1)
subplot('position',[0.15+d1p 0.2 d2p 0.65]);
plot([D1 D1],[-pa pa],'b','LineWidth',4); hold on
plot([D1+D2 D1+D2],[-pa pa],'b','LineWidth',4);hold off
axis([D1 D1+D2 -pa pa]);
set(gca,'YtickLabel',[]); xlabel('[m]')
grid on
figure(1)
subplot('position',[0.15+d1p+d2p 0.2 d3p 0.65]);
plot([D1+D2 D1+D2],[-pa pa],'b','LineWidth',4); 
axis([D1+D2 D1+D2+D3 -pa pa]);
set(gca,'YtickLabel',[])
grid on

for n = 1:length(t) 
  %----------------------------------------------------------------------
  Z = 1;
  while Z<=aux0 
     E10t(Z) = a10*exp(-a(1)*z1(Z))*sin(w*t(n) - b(1)*z1(Z));
     Z = Z + 1;
  end
  if aux0 < dz1
   aux0 = aux0 + 1;
   t0 = n;
  else
   aux0 = dz1;
   f0 = 1;
  end
  
  Time = (n-1)*Dt;
  time = num2str(Time,'%10.2e'); 
    
  figure(1)
  subplot('position',[0.15 0.2 d1p 0.65]);
  plot([D1 D1],[-pa pa],'b','LineWidth',4); hold on 
  title(['Plane Wave, Time = ', time,' [s]']);
  axis([0 D1 -pa pa]); ylabel('Electric Field'); grid on
  hold off
    
  if ptr
  figure(1)
  subplot('position',[0.15 0.2 d1p 0.65]);
  plot([D1 D1],[-pa pa],'b','LineWidth',4); hold on 
  plot(z1,E10t,'r');title(['Plane Wave, Time = ', time,' [s]']);
  axis([0 D1 -pa pa]); ylabel('Electric Field'); grid on
  hold off
  ff=1;
  end
  %----------------------------------------------------------------------
  if f0==1 %z1 done
    Z = 1;
    while Z<=aux1  
       E11r(dz1-Z+1) = a11*exp(-a(1)*z1(Z))*sin(w*t(n-t0) - b(1)*z1(Z) + aa11);   
       Z = Z + 1;
    end
    if aux1 < dz1
     aux1 = aux1 + 1;
    else
     aux1 = dz1;
    end
    %----------------------------------------------------------------------
    ZZ = 1;
    while ZZ<=aux2
      E20t(ZZ) = a20*exp(-a(2)*z2(ZZ))*sin(w*t(n-t0) - b(2)*z2(ZZ) + aa20);
      ZZ = ZZ + 1;
    end
    if aux2 < dz2
     aux2 = aux2 + 1;
     t1 = n;
    else
     aux2 = dz2;
     f1 = 1;
    end
    if ptr
        figure(1)
    subplot('position',[0.15+d1p 0.2 d2p 0.65]);
    plot([D1 D1],[-pa pa],'b','LineWidth',4); hold on
    plot(z2+D1, E20t,'r');
    plot([D1+D2 D1+D2],[-pa pa],'b','LineWidth',4);
    axis([D1 D1+D2 -pa pa]);
    set(gca,'YtickLabel',[]); xlabel('[m]')
    grid on; hold off
    end
  %----------------------------------------------------------------------
  end
  %----------------------------------------------------------------------
  if f1==1%z2 done
    ZZZ = 1;
    while ZZZ<=aux3
      E30t(ZZZ) = a30*exp(-a(3)*z3(ZZZ))*sin(w*t(n-t1) - b(3)*z3(ZZZ) + aa30);
      ZZZ = ZZZ + 1;
    end
    if aux3 < dz3
     aux3 = aux3 + 1;
    else
     aux3 = dz3;
    end  
    %----------------------------------------------------------------------  
    ZZ = 1;
    while ZZ<=aux4  
      E21r(dz2-ZZ+1) = a21*exp(-a(2)*z2(ZZ))*sin(w*t(n-t1) - b(2)*z2(ZZ) + aa21);
      ZZ = ZZ + 1;
    end
    if aux4 < dz2
     aux4 = aux4 + 1;
     t2 = n;
    else
     aux4 = dz2;
     f2 = 1;
    end 
  end
  %----------------------------------------------------------------------
  if f2==1
    ZZ = 1;
    while ZZ<=aux5
      E22r(ZZ) = a22*exp(-a(2)*z2(ZZ))*sin(w*t(n-t2) - b(2)*z2(ZZ) + aa22);
      ZZ = ZZ + 1;
    end
    if aux5 < dz2
     aux5 = aux5 + 1;
     t3 = n;
    else
     aux5 = dz2;
     f3 = 1;
    end
    Z = 1;
    while Z<=aux6     
       E12t(dz1-Z+1) = a12*exp(-a(1)*z1(Z))*sin(w*t(n-t2) - b(1)*z1(Z) + aa12);   
       Z = Z + 1;
    end
    if aux6 < dz1
     aux6 = aux6 + 1;
     else
     aux6 = dz1;
    end
  end  
  if f3==1  
    ZZZ = 1;
    while ZZZ<=aux7
      E31t(ZZZ) = a31*exp(-a(3)*z3(ZZZ))*sin(w*t(n-t3) - b(3)*z3(ZZZ) + aa31);
      ZZZ = ZZZ + 1;
    end  
    if aux7 < dz3
     aux7 = aux7 + 1;
     else
     aux7 = dz3;
    end
    ZZ = 1;
    while ZZ<=aux8
      E23r(dz2-ZZ+1) = a23*exp(-a(2)*z2(ZZ))*sin(w*t(n-t3) - b(2)*z2(ZZ) + aa23);
      ZZ = ZZ + 1;
    end
    if aux8 < dz2
     aux8 = aux8 + 1;
     t4 = n;
    else
     aux8 = dz2;
     f4 = 1;
    end
  end
  if f4==1  
    Z = 1;
    while Z<=dz1     
       E13t(dz1-Z+1) = a13*exp(-a(1)*z1(Z))*sin(w*t(n-t4) - b(1)*z1(Z) + aa13);   
       Z = Z + 1;
    end 
    if aux9 < dz2
     aux9 = aux9 + 1;
    else
     aux9 = dz1;
    end
    ZZ = 1;
    while ZZ<=aux10
      E24r(ZZ) = a24*exp(-a(2)*z2(ZZ))*sin(w*t(n-t4) - b(2)*z2(ZZ) + aa24);
      ZZ = ZZ + 1;
    end
    if aux10 < dz2
     aux10 = aux10 + 1;
     t5 = n;
    else
     aux10 = dz2;
     f5 = 1;
    end
  end
  if f5==1
    ZZZ = 1;
    while ZZZ<=aux11
      E32t(ZZZ) = a32*exp(-a(3)*z3(ZZZ))*sin(w*t(n-t5) - b(3)*z3(ZZZ) + aa32);
      ZZZ = ZZZ + 1;
    end  
    if aux11 < dz3
     aux11 = aux11 + 1;
     else
     aux11 = dz3;
    end 
  end
  E1R = E11r + E12t + E13t;
  E2R = E21r + E22r + E23r + E24r;
  E3T = E30t + E31t + E32t;
  ET1 = E10t + E1R;
  ET2 = E20t + E2R;
  if f0==1
   if ptr~=0 & pre  
       figure(1)
   subplot('position',[0.15 0.2 d1p 0.65]);hold on 
   plot([D1 D1],[-pa pa],'b','LineWidth',4); 
   plot(z1,E1R,'g');title(['Plane Wave, Time = ', time,' [s]']);
   axis([0 D1 -pa pa]); ylabel('Electric Field'); grid on
   hold off
   elseif pre
       figure(1)
   subplot('position',[0.15 0.2 d1p 0.65]); 
   plot([D1 D1],[-pa pa],'b','LineWidth',4); hold on
   plot(z1,E1R,'g');title(['Plane Wave, Time = ', time,' [s]']);
   axis([0 D1 -pa pa]); ylabel('Electric Field'); grid on
   hold off
   ff = 1;   
   end
   
  end
  if f1==1
   if ptr~=0 & pre 
       figure(1)
    subplot('position',[0.15+d1p 0.2 d2p 0.65]);hold on
    plot([D1 D1],[-pa pa],'b','LineWidth',4); 
    plot(z2+D1, E2R,'g');
    plot([D1+D2 D1+D2],[-pa pa],'b','LineWidth',4);
    axis([D1 D1+D2 -pa pa]);
    set(gca,'YtickLabel',[]); xlabel('[m]')
    grid on; hold off
   elseif pre
       figure(1)
    subplot('position',[0.15+d1p 0.2 d2p 0.65]);
    plot([D1 D1],[-pa pa],'b','LineWidth',4); hold on
    plot(z2+D1, E2R,'g');
    plot([D1+D2 D1+D2],[-pa pa],'b','LineWidth',4);
    axis([D1 D1+D2 -pa pa]);
    set(gca,'YtickLabel',[]); xlabel('[m]')
    grid on; hold off
   end
   if ptr | pto
       figure(1)
   subplot('position',[0.15+d1p+d2p 0.2 d3p 0.65]);
   plot([D1+D2 D1+D2],[-pa pa],'b','LineWidth',4); hold on
   plot(z3+D1+D2,E3T,'r')
   axis([D1+D2 D1+D2+D3 -pa pa]);
   set(gca,'YtickLabel',[])
   grid on; hold off
   end
  end
  if f2==1
    if ff~=0 & pto
        figure(1)
     subplot('position',[0.15 0.2 d1p 0.65]); hold on
     plot([D1 D1],[-pa pa],'b','LineWidth',4);  
     plot(z1,ET1,'b');title(['Plane Wave, Time = ', time,' [s]']);
     axis([0 D1 -pa pa]); ylabel('Electric Field'); grid on
     hold off
   figure(1)
     subplot('position',[0.15+d1p 0.2 d2p 0.65]);hold on
     plot([D1 D1],[-pa pa],'b','LineWidth',4); 
     plot(z2+D1, ET2,'b');
     plot([D1+D2 D1+D2],[-pa pa],'b','LineWidth',4);
     axis([D1 D1+D2 -pa pa]);
     set(gca,'YtickLabel',[]); xlabel('[m]')
     grid on; hold off 
    elseif pto
        figure(1)
     subplot('position',[0.15 0.2 d1p 0.65]); 
     plot([D1 D1],[-pa pa],'b','LineWidth',4); hold on 
     plot(z1,ET1,'b');title(['Plane Wave, Time = ', time,' [s]']);
     axis([0 D1 -pa pa]); ylabel('Electric Field'); grid on
     hold off
   figure(1)
     subplot('position',[0.15+d1p 0.2 d2p 0.65]);
     plot([D1 D1],[-pa pa],'b','LineWidth',4); hold on
     plot(z2+D1, ET2,'b');
     plot([D1+D2 D1+D2],[-pa pa],'b','LineWidth',4);
     axis([D1 D1+D2 -pa pa]);
     set(gca,'YtickLabel',[]); xlabel('[m]')
     grid on; hold off  
    end
%    if ptr
%    subplot('position',[0.15+d1p+d2p 0.2 d3p 0.65]); hold on
%    plot([D1+D2 D1+D2],[-2.1 2.1],'b','LineWidth',4);
%    plot(z3+D1+D2,E3T,'b')
%    axis([D1+D2 D1+D2+D3 -2.1 2.1]);
%    set(gca,'YtickLabel',[])
%    grid on; hold off  
%    end
  end
  pause(0.04)
end

%--------------------------------------------------------------------------
function transmissionLine(f,Zo,Zg,Zl,l,ls,a,b,Vg,TTM)

if Zl==0
    Zl = 1e-12;
end
%--------------------------------------------------------------------------
% a = a/8.686; %dB 2 [Np/m]

v = a +i*b;%propagation constant
w = 2*pi*f;

%Zg to Zo
R12 = (Zo - Zg)/(Zo + Zg);
% T12 =  1 + R12;
T12 =  Zo/(Zg+Zo);
TI12 = 1/(Zg+Zo);

%Zo to Zg
R21 = (Zg - Zo)/(Zg + Zo);
T21 = 1 + R21;

%Zo to Zl
R23 = (Zl - Zo)/(Zl + Zo);
T23 = 1 + R23;

t12 = abs(T12);
at12 = angle(T12);

ti12 = abs(TI12);
ati12 = angle(TI12);


r12 = abs(R12); 
ar12 = angle(R12);

t21 = abs(T21); 
at21 = angle(T21);
r21 = abs(R21);
ar21 = angle(R21);

t23 = abs(T23); at23 = angle(T23);
r23 = abs(R23); ar23 = angle(R23);

c = w/b;
lamb = c/f;
Per = 1/f;

pw = 40;
Dt = Per/pw;
Dz = lamb/pw;

if l<Dz
    l = Dz
end

D2 = l;%distance 2

T = TTM*Per;%time simulation

z2 = 0:Dz:D2;
dz2 = length(z2);
Dz = D2/dz2;
z2 = 0:Dz:D2;
lamb = Dz*pw;
f = c/lamb;
Per = 1/f;
Dt = Per/pw;
t = 0:Dt:T;
dz2 = length(z2);

% lin = l - z2;
lin = l;
ZIN = Zo.*((Zl + Zo*tanh(v.*lin))./(Zo + Zl*tanh(v.*lin)));

MZin = abs(ZIN);
AZin = angle(ZIN);
MZl = abs(Zl);
AZl = angle(Zl);

%fields in the medium 2
E20t= zeros(1,dz2);
E21r= zeros(1,dz2);
E22r= zeros(1,dz2);
E23r= zeros(1,dz2);
E24r= zeros(1,dz2);

H20t= zeros(1,dz2);
H21r= zeros(1,dz2);
H22r= zeros(1,dz2);
H23r= zeros(1,dz2);
H24r= zeros(1,dz2);

%auxiliar medium 1
a10 = Vg;
%auxiliar medium 2
at2 = exp(-a*z2(dz2));%attenuatian

a20 = a10*t12;       aa20 = at12;                           
a21 = a20*r23*at2;   aa21 = at12 + ar23;
a22 = a21*r21*at2;   aa22 = at12 + ar23 + ar21;
a23 = a22*r23*at2;   aa23 = at12 + ar23 + ar21 + ar23;
a24 = a23*r21*at2;   aa24 = at12 + ar23 + ar21 + ar23 + ar21;

a20i =  a10*ti12;      aa20i = ati12;                           
a21i = -a20i*r23*at2;  aa21i = ati12 + ar23;
a22i = -a21*r21*at2;   aa22i = ati12 + ar23 + ar21;
a23i = -a22*r23*at2;   aa23i = ati12 + ar23 + ar21 + ar23;
a24i = -a23*r21*at2;   aa24i = ati12 + ar23 + ar21 + ar23 + ar21;

aux2 = 1; aux4 = 1; aux5 = 1; aux8 = 1; aux10 = 1;
auxVl = 0; auxIl = 0; aux13 = 0;
f1 = 0; f2 = 0; f3 = 0; f4 = 0; f5 = 0;
pa = a20+a21+a22+a23+a24 + 0.1*(a20+a21+a22+a23+a24);
pb = a20i-a21i-a22i-a23i-a24i + 0.1*(a20i-a21i-a22i-a23i-a24i);

for n = 1:length(t) 
  %----------------------------------------------------------------------
    ZZ = 1;
    while ZZ<=aux2
      E20t(ZZ) = a20*exp(-a*z2(ZZ))*sin(w*t(n) - b*z2(ZZ) + aa20);
      H20t(ZZ) = a20i*exp(-a*z2(ZZ))*sin(w*t(n) - b*z2(ZZ) + aa20i);
      ZZ = ZZ + 1;
    end
    if aux2 < dz2
     aux2 = aux2 + 1;
     t1 = n;
    else
     aux2 = dz2;
     f1 = 1;
    end
  %----------------------------------------------------------------------
  if f1==1%z2 done
     ZZ = 1;
    while ZZ<=aux4  
      E21r(dz2-ZZ+1) = a21*exp(-a*z2(ZZ))*sin(w*t(n-t1) - b*z2(ZZ) + aa21);
      H21r(dz2-ZZ+1) = a21i*exp(-a*z2(ZZ))*sin(w*t(n-t1) - b*z2(ZZ) + aa21i);
      ZZ = ZZ + 1;
    end
    if aux4 < dz2
     aux4 = aux4 + 1;
     t2 = n;
    else
     aux4 = dz2;
     f2 = 1;
    end 
  end
  %----------------------------------------------------------------------
  if f2==1
    ZZ = 1;
    while ZZ<=aux5
      E22r(ZZ) = a22*exp(-a*z2(ZZ))*sin(w*t(n-t2) - b*z2(ZZ) + aa22);
      H22r(ZZ) = a22i*exp(-a*z2(ZZ))*sin(w*t(n-t2) - b*z2(ZZ) + aa22i);
      ZZ = ZZ + 1;
    end
    if aux5 < dz2
     aux5 = aux5 + 1;
     t3 = n;
    else
     aux5 = dz2;
     f3 = 1;
    end
  end  
  if f3==1  
    ZZ = 1;
    while ZZ<=aux8
      E23r(dz2-ZZ+1) = a23*exp(-a*z2(ZZ))*sin(w*t(n-t3) - b*z2(ZZ) + aa23);
      H23r(dz2-ZZ+1) = a23i*exp(-a*z2(ZZ))*sin(w*t(n-t3) - b*z2(ZZ) + aa23i);
      ZZ = ZZ + 1;
    end
    if aux8 < dz2
     aux8 = aux8 + 1;
     t4 = n;
    else
     aux8 = dz2;
     f4 = 1;
    end
  end
  if f4==1  
    ZZ = 1;
    while ZZ<=aux10
      E24r(ZZ) = a24*exp(-a*z2(ZZ))*sin(w*t(n-t4) - b*z2(ZZ) + aa24);
      H24r(ZZ) = a24i*exp(-a*z2(ZZ))*sin(w*t(n-t4) - b*z2(ZZ) + aa24i);
      ZZ = ZZ + 1;
    end
    if aux10 < dz2
     aux10 = aux10 + 1;
     t5 = n;
    else
     aux10 = dz2;
     f5 = 1;
    end
  end
  E2R = E21r + E22r + E23r + E24r;
  ET2 = E20t + E2R;
  
  H2R = (H21r + H22r + H23r + H24r);
  HT2 = (H20t + H2R);
 
  Vl = num2str(auxVl);
  Il = auxIl;
  IlAbs = num2str(abs(Il));
  Ilangle = num2str(180*angle(Zl)/pi);
  figure(1);    
  subplot('position',[0.15 0.58 0.7 0.3]); 
  plot(z2,E20t,'r'); title(['Transmission Line, V load = ', Vl,' [V] - angle = 0']);
  axis([0 D2 -pa pa]); grid on; xlabel('[m]');ylabel('Volts')
  
  subplot('position',[0.15 0.13 0.7 0.3]) ; 
  plot(z2,H20t,'r');title(['Transmission Line, |I load| = ', IlAbs,' [A] - ', 'angle = ',Ilangle,'']);xlabel('[m]');ylabel('Amperes')
  axis([0 D2 -pb pb]); grid on
  if f1==1
    subplot('position',[0.15 0.58 0.7 0.3]); hold on
    plot(z2,E2R,'g'); axis([0 D2 -pa pa]); grid on;title(['Transmission Line, V load = ', Vl,' [V] - angle = 0']);
    xlabel('[m]');ylabel('Volts');hold off
  
    subplot('position',[0.15 0.13 0.7 0.3]);hold on
    plot(z2,H2R,'g'); axis([0 D2 -pb pb]); grid on
    title(['Transmission Line, |I load| = ', IlAbs,' [A] - ', 'angle = ',Ilangle,'']);xlabel('[m]');ylabel('Amperes'); hold off
  end
  if f2==1
    subplot('position',[0.15 0.58 0.7 0.3]); hold on
    plot(z2,ET2,'b'); axis([0 D2 -pa pa]); grid on;title(['Transmission Line, V load = ', Vl,' [V] - angle = 0']);
    xlabel('[m]');ylabel('Volts');hold off
  
    subplot('position',[0.15 0.13 0.7 0.3]);hold on
    plot(z2,HT2,'b'); axis([0 D2 -pb pb]); grid on
    title(['Transmission Line, |I load| = ', IlAbs,' [A] - ', 'angle = ',Ilangle,'']);xlabel('[m]');ylabel('Amperes'); hold off  
  end
  pause(0.01)
    if auxVl < ET2(dz2)
       auxVl = ET2(dz2);
    end
    if auxIl < HT2(dz2)
       auxIl = HT2(dz2);
    end
end


%-------------------------------------------------------------------------
function editMW_Callback(hObject, eventdata, handles)
% hObject    handle to editMW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editMW as text
%        str2double(get(hObject,'String')) returns contents of editMW as a double


% --- Executes during object creation, after setting all properties.
function editMW_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editMW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

%--------------------------------------------------------------------
%Metallic Walls
function radiobuttonMW_Callback(hObject, eventdata, handles)
flag = get(handles.radiobuttonMW,'Value');
if flag
  set(handles.editMW,'String',['1450'])
  guidata(hObject,handles);%store changes 
end

%--------------------------------------------------------------------
%1 Medium
function radiobutton1M_Callback(hObject, eventdata, handles)
flag = get(handles.radiobutton1M,'Value');
if flag
  set(handles.editPt1M,'String',['1'])
  set(handles.editPb1M,'String',['1'])
  set(handles.editC1M,'String',['3e-5'])
  set(handles.editfM,'String',['1e6'])
  set(handles.editTM,'String',['10'])
  set(handles.editD1,'String',['3'])
  guidata(hObject,handles);%store changes 
end

%--------------------------------------------------------------------
%2 Medium
function radiobutton2M_Callback(hObject, eventdata, handles)
flag = get(handles.radiobutton2M,'Value');
if flag
  set(handles.editPt1M,'String',['1'])
  set(handles.editPb1M,'String',['1'])
  set(handles.editC1M,'String',['5e-6'])
  set(handles.editPt2M,'String',['5'])
  set(handles.editPb2M,'String',['1'])
  set(handles.editC2M,'String',['0'])
  set(handles.editfM,'String',['1e6'])
  set(handles.editTM,'String',['10'])
  set(handles.editD1,'String',['2'])
  set(handles.editD2,'String',['2'])
  guidata(hObject,handles);%store changes 
end

%--------------------------------------------------------------------
%3 Medium
function radiobutton3M_Callback(hObject, eventdata, handles)
flag = get(handles.radiobutton3M,'Value');
if flag
  set(handles.editPt1M,'String',['1'])
  set(handles.editPb1M,'String',['1'])
  set(handles.editC1M,'String',['0'])
  set(handles.editPt2M,'String',['5'])
  set(handles.editPb2M,'String',['1'])
  set(handles.editC2M,'String',['0'])
  set(handles.editPt3M,'String',['1'])
  set(handles.editPb3M,'String',['1'])
  set(handles.editC3M,'String',['0'])
  set(handles.editfM,'String',['1e6'])
  set(handles.editTM,'String',['20'])
  set(handles.editD1,'String',['2'])
  set(handles.editD2,'String',['2'])
  set(handles.editD3,'String',['2'])
  guidata(hObject,handles);%store changes 
end

% --- Executes on button press in pushbuttonClose.
function pushbuttonClose_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonClose (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)




% --- Executes on button press in checkboxTransmitted.
function checkboxTransmitted_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxTransmitted (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxTransmitted


% --- Executes on button press in checkboxReflected.
function checkboxReflected_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxReflected (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxReflected


% --- Executes on button press in checkboxTotal.
function checkboxTotal_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxTotal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxTotal

% --- Executes on button press in pushbuttonTL.
function pushbuttonTL_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonTL (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

f =  str2num(get(handles.editfTL,'String'));
Zo =  str2num(get(handles.editZo,'String'));
Zg =  str2num(get(handles.editZg,'String'));
Zl =  str2num(get(handles.editZl,'String'));
l =  str2num(get(handles.editl,'String'));
ls =  str2num(get(handles.editlg,'String'));
a = str2num(get(handles.editAttenuation,'String'));
b = str2num(get(handles.editFAseConstant,'String'));
Vg = str2num(get(handles.editVg,'String'));
TTL = str2num(get(handles.editPeriodoTL,'String'));

transmissionLine(f,Zo,Zg,Zl,l,ls,a,b,Vg,TTL)

function editfTL_Callback(hObject, eventdata, handles)
% hObject    handle to editfTL (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editfTL as text
%        str2double(get(hObject,'String')) returns contents of editfTL as a double


% --- Executes during object creation, after setting all properties.
function editfTL_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editfTL (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editZo_Callback(hObject, eventdata, handles)
% hObject    handle to editZo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editZo as text
%        str2double(get(hObject,'String')) returns contents of editZo as a double


% --- Executes during object creation, after setting all properties.
function editZo_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editZo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editZg_Callback(hObject, eventdata, handles)
% hObject    handle to editZg (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editZg as text
%        str2double(get(hObject,'String')) returns contents of editZg as a double


% --- Executes during object creation, after setting all properties.
function editZg_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editZg (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editZl_Callback(hObject, eventdata, handles)
% hObject    handle to editZl (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editZl as text
%        str2double(get(hObject,'String')) returns contents of editZl as a double


% --- Executes during object creation, after setting all properties.
function editZl_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editZl (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editl_Callback(hObject, eventdata, handles)
% hObject    handle to editl (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editl as text
%        str2double(get(hObject,'String')) returns contents of editl as a double


% --- Executes during object creation, after setting all properties.
function editl_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editl (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editlg_Callback(hObject, eventdata, handles)
% hObject    handle to editlg (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editlg as text
%        str2double(get(hObject,'String')) returns contents of editlg as a double


% --- Executes during object creation, after setting all properties.
function editlg_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editlg (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


function editFAseConstant_Callback(hObject, eventdata, handles)
% hObject    handle to editFAseConstant (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editFAseConstant as text
%        str2double(get(hObject,'String')) returns contents of editFAseConstant as a double


% --- Executes during object creation, after setting all properties.
function editFAseConstant_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editFAseConstant (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editAttenuation_Callback(hObject, eventdata, handles)
% hObject    handle to editAttenuation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editAttenuation as text
%        str2double(get(hObject,'String')) returns contents of editAttenuation as a double


% --- Executes during object creation, after setting all properties.
function editAttenuation_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editAttenuation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in pushbuttonZin.
function pushbuttonZin_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonZin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Zo =  str2num(get(handles.editZo,'String'));
Zl =  str2num(get(handles.editZl,'String'));
l =  str2num(get(handles.editl,'String'));
ls =  str2num(get(handles.editlg,'String'));
a = str2num(get(handles.editAttenuation,'String'));
b = str2num(get(handles.editFAseConstant,'String'));
f =  str2num(get(handles.editfTL,'String'));
if ls<0
    ls=0;
    set(handles.editlg,'String',['0']);
elseif ls> l
    ls = l;
    lls = num2str(l);
    set(handles.editlg,'String',lls);
end

lin = l - ls;
%a = a/8.686;  %dB 2 [Np/m]
v = a +i*b;%propagation constant
Zin = Zo*((Zl + Zo*tanh(v*lin))/(Zo + Zl*tanh(v*lin)));
zin = num2str(Zin);
set(handles.textZin,'String',[zin])
%%%%%%%%%%%%%%%
w = 2*pi*f;
c = w/b;
lamb = c/f;
Per = 1/f;

pw = 100;
Dt = Per/pw;
Dz = lamb/pw;
if l<Dz
    l = Dz
end
D2 = l;%distance 2
z2 = 0:Dz:D2;
dz2 = length(z2);
Dz = D2/dz2;
z2 = D2:-Dz:0;
axisx = 0:Dz:D2;
ZIN = Zo.*((Zl + Zo*tanh(v.*z2))./(Zo + Zl*tanh(v.*z2)));
MZin = abs(ZIN);
AZin = angle(ZIN)*180/pi;
MZl = num2str(abs(Zl));
AAZin = angle(Zl)*180/pi;
AZl = num2str(AAZin);
figure(2)
subplot(2,1,1); plot(axisx,MZin);
title(['Input  Impedance (Magnitude), |Z load| = ', MZl,' Ohms']); ylabel('|Zin|'); grid on
subplot(2,1,2); plot(axisx,AZin,'r');
title(['Input Impedance (Angle), Angle load = ',AZl,'']); xlabel('Line Length [m]'); ylabel('Degree'); grid on

function editfFDTD_Callback(hObject, eventdata, handles)
% hObject    handle to editfFDTD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editfFDTD as text
%        str2double(get(hObject,'String')) returns contents of editfFDTD as a double


% --- Executes during object creation, after setting all properties.
function editfFDTD_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editfFDTD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in checkboxMettBound.
function checkboxMettBound_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxMettBound (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxMettBound


% --- Executes on button press in checkboxPropert.
function checkboxPropert_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxPropert (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxPropert



function editIP_Callback(hObject, eventdata, handles)
% hObject    handle to editIP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editIP as text
%        str2double(get(hObject,'String')) returns contents of editIP as a double


% --- Executes during object creation, after setting all properties.
function editIP_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editIP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editIFDTD_Callback(hObject, eventdata, handles)
% hObject    handle to editIFDTD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editIFDTD as text
%        str2double(get(hObject,'String')) returns contents of editIFDTD as a double


% --- Executes during object creation, after setting all properties.
function editIFDTD_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editIFDTD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editJFDTD_Callback(hObject, eventdata, handles)
% hObject    handle to editJFDTD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editJFDTD as text
%        str2double(get(hObject,'String')) returns contents of editJFDTD as a double


% --- Executes during object creation, after setting all properties.
function editJFDTD_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editJFDTD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editTFDTD_Callback(hObject, eventdata, handles)
% hObject    handle to editTFDTD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editTFDTD as text
%        str2double(get(hObject,'String')) returns contents of editTFDTD as a double


% --- Executes during object creation, after setting all properties.
function editTFDTD_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editTFDTD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editExcitation_Callback(hObject, eventdata, handles)
% hObject    handle to editExcitation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editExcitation as text
%        str2double(get(hObject,'String')) returns contents of editExcitation as a double


% --- Executes during object creation, after setting all properties.
function editExcitation_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editExcitation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editMettal_Callback(hObject, eventdata, handles)
% hObject    handle to editMettal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editMettal as text
%        str2double(get(hObject,'String')) returns contents of editMettal as a double


% --- Executes during object creation, after setting all properties.
function editMettal_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editMettal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editProperties_Callback(hObject, eventdata, handles)
% hObject    handle to editProperties (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editProperties as text
%        str2double(get(hObject,'String')) returns contents of editProperties as a double


% --- Executes during object creation, after setting all properties.
function editProperties_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editProperties (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in pushbuttonFDTD.
function pushbuttonFDTD_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonFDTD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close(figure(1))

I = str2num(get(handles.editIFDTD,'String'));
J = str2num(get(handles.editJFDTD,'String'));
%------------------------------------------------------------------
%excitation
GP = get(handles.radiobuttonGP,'Value');
if GP
  SP = 2;  
else
  SP = 1;  
end
Exy = get(handles.radiobuttonExEy,'Value');
if Exy
  EH2 = 1;  
else
  EH2 = 2;  
end
f = str2num(get(handles.editfFDTD,'String'));
if f>1e9
    f=1e9;
    set(handles.editfFDTD,'String',num2str(1e9,'%1.e' ))
end
TypeExc = [SP EH2 f];
%------------------------------------------------------------------
%plot
Nr_it = str2num(get(handles.editTFDTD,'String'));
PE = get(handles.radiobuttonPE,'Value');
PEx = get(handles.radiobuttonPEx,'Value');
PEy = get(handles.radiobuttonPEy,'Value');
PHz = get(handles.radiobuttonPHz,'Value');
if PE
    EH1 = 1;
elseif PEx
    EH1 = 2;
elseif PEy
    EH1 = 3;
elseif PHz
    EH1 = 4;
end
MB = get(handles.checkboxMettBound,'Value');
Pr = get(handles.checkboxPropert,'Value');
if MB & Pr
    Pbp = 3;
elseif MB
    Pbp = 1;
elseif Pr
    Pbp = 2;
else
    Pbp = 0;
end
Nr_it_plot = str2num(get(handles.editIP,'String'));
if Nr_it_plot==0
    Nr_it_plot=[];
end
if isempty(Nr_it_plot)
Tp = [Nr_it   EH1  Pbp];    
else
Tp = [Nr_it   EH1  Pbp Nr_it_plot];
end
%------------------------------------------------------------------
xyExc = str2num(get(handles.editExcitation,'String'));
xyp = str2num(get(handles.editProperties,'String'));
xym = str2num(get(handles.editMettal,'String'));

FDTDM = get(handles.radiobuttonFDTDM,'Value');
FDTDPML = get(handles.radiobuttonFDTDPML,'Value'); 

exemple = get(handles.checkboxRunExemple,'Value');

if exemple
    
 ex1 = get(handles.radiobuttonFreeSpaceGP,'Value');
 ex2 = get(handles.radiobuttonCavidade,'Value');
 ex3 = get(handles.radiobuttonScatter1,'Value');
 ex4 = get(handles.radiobuttonDifraction,'Value');
 ex5 = get(handles.radiobuttonCylinder,'Value');
 ex6 = get(handles.radiobuttonManyChapes,'Value');
 ex7 = get(handles.radiobuttonMonople,'Value');
 ex8 = get(handles.radiobuttonDipole,'Value');
 ex9 = get(handles.radiobuttonWaveGuide,'Value'); 
 
 if ex1
   propag2D_OC_TE_PML();  
 elseif ex2
   cavidade()
 elseif ex3
   espalham2D_OC_PG_TE_PML();  
 elseif ex4
   espalham2D_OP_PM_TE_PML();
 elseif (ex5 | ex6 | ex7 | ex8 | ex9)
   if FDTDM   
    if isempty(xym)
       FDTD2D_TE_MB(I,J,Tp,TypeExc,xyExc,xyp);  
    else
       FDTD2D_TE_MB(I,J,Tp,TypeExc,xyExc,xyp,xym);
    end
   elseif FDTDPML
    if isempty(xym)
       FDTD2D_TE_PML(I,J,Tp,TypeExc,xyExc,xyp);  
    else
       FDTD2D_TE_PML(I,J,Tp,TypeExc,xyExc,xyp,xym);
    end
   end  
  end

else
  
  if FDTDM   
    if isempty(xym)
       FDTD2D_TE_MB(I,J,Tp,TypeExc,xyExc,xyp);  
    else
       FDTD2D_TE_MB(I,J,Tp,TypeExc,xyExc,xyp,xym);
    end
  elseif FDTDPML
    if isempty(xym)
       FDTD2D_TE_PML(I,J,Tp,TypeExc,xyExc,xyp);  
    else
       FDTD2D_TE_PML(I,J,Tp,TypeExc,xyExc,xyp,xym);
    end
  end
   
end
 
% --- Executes on button press in checkboxRunExemple.
function checkboxRunExemple_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxRunExemple (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxRunExemple


%---------------------------------------------------------------------
function propag2D_OC_TE_PML ()

T = 100;%nr de iteracoes
I = 51; %nr de clulas em x
J = 51; %nr de clulas em y

u_o = 4*pi*1e-7; %permeabilidade magntica do vcuo
e_o = 8.854e-12; %permissvidade eltrica do vcuo	
D = 0.003; %Delta (largura, altura da clula FDTD)
D_t = 5e-12; %Delta t (espao temporal)
c = 1/(sqrt(u_o*e_o)); %velocidade da luz no vcuo
w = 26;%excitao em Hz(w,z)
z = 26;
%************************************************************************************
t = 1:T;
Exc = 10*sin(2*pi*6e9*D_t*(t-1)); 
%************************************************************************************
%PML
R_0 = 0.0001; %fator de reflexao (0.01%)
n = 2; % variao linear(1) ou parabolica(2) da condutividade na PML
N = 8; %n_r de celulas na PML
Sig = N*D; %Sigma = espessura total da PML
ho_m = - e_o*c*log(R_0)/(2/(n+1)*Sig);%condutividade da camada + externa

HO(1) = ho_m/((n+1)*2^(n+1)*N^n);%condutividade da primeira camada L=0

i=1;
for L=1:N-1%condutividade para L inteiro -usa para Ex e Ey
   i=i+1;
   HO(i) = HO(1)*((2*L +1)^(n+1) - (2*L - 1)^(n+1));   
end

i=0;
for L=0.5:1:N-0.5%condutividade para L -> 0.5 - usa para Hzx e Hzy
   i=i+1;
   H_O(i) = HO(1)*((2*L +1)^(n+1) - (2*L - 1)^(n+1));   
end

HOm = H_O*u_o/e_o;%condutividade magntica  - usa para Hzx e Hzy

%************************************************************************************
%Inicializao das variveis de campo - Modo TE 
Ex = zeros(I+2*N,J+2*N+1);
Ey = zeros(I+2*N+1,J+2*N);
Hz = zeros(I,J); 

Hzxi = zeros(I+2*N,N);%matriz inferior de Hzx 
Hzxc = zeros(2*N,J);  %matriz central de Hzx 
Hzxs = zeros(I+2*N,N);%matriz superior de Hzx 
Hzyi = zeros(I+2*N,N);%matriz inferior de Hyz 
Hzyc = zeros(2*N,J);  %matriz inferior de Hyz 
Hzys = zeros(I+2*N,N);%matriz inferior de Hyz  
%************************************************************************************
%variveis auxiliares
a = D_t/e_o;
b = D_t/u_o;
A = a/D;%D_t/(e_o*D);
B = b/D;%D_t/(u_o*D);
%*************************************************************************************
%*************************************************************************************
for t=1:T
   %**********************************************************************************
   %Clculo de Ex ->NO DOMINIO DE ESTUDO
   for i=(N+1):(I+N)
      for j=(N+2):(J+N)
         Ex(i,j) = Ex(i,j) + A*(Hz(i-N,j-N) - Hz(i-N,j-N-1));
      end
   end
   %**********************************************************************************
   %Clculo de Ey ->NO DOMINIO DE ESTUDO   
   for i=(N+2):(I+N)
      for j=(N+1):(J+N)
         Ey(i,j) = Ey(i,j) - A*(Hz(i-N,j-N) - Hz(i-N-1,j-N));
      end
   end
   %**********************************************************************************
   %Clculo na PML
   %clculo de Ex na superfcie inferior
   for i=1:(2*N+I)
      for j=2:N
         Ex(i,j) = (1-HO(N+2-j)*a)*Ex(i,j) + A*(Hzxi(i,j) - Hzxi(i,j-1) + Hzyi(i,j) - Hzyi(i,j-1));
      end
   end
   %clculo na linha intermediaria inferior - da esquerda para a direita
   for i=1:N
      Ex(i,N+1) = (1-HO(1)*a)*Ex(i,N+1) + A*(Hzxc(i,1) - Hzxi(i,N) + Hzyc(i,1) - Hzyi(i,N));
   end
   for i=(N+1):(N+I)
      Ex(i,N+1) = (1-HO(1)*a)*Ex(i,N+1) + A*(Hz(i-N,1) - Hzxi(i,N)  - Hzyi(i,N));
   end
   for i=(N+I+1):(2*N+I)
      Ex(i,N+1) = (1-HO(1)*a)*Ex(i,N+1) + A*(Hzxc(i-I,1) - Hzxi(i,N) + Hzyc(i-I,1) - Hzyi(i,N));
   end
   %clculo de Ex no parte central esquerda - hoy = 0;
   for i=1:N
      for j=(N+2):(N+J)
         Ex(i,j) = Ex(i,j) + A*(Hzxc(i,j-N) - Hzxc(i,j-N-1) + Hzyc(i,j-N) - Hzyc(i,j-N-1));
      end
   end
   %**********************************************************************************
   %clculo de Ex no parte central direita - hoy = 0;
   for i=(N+I+1):(2*N+I)
      for j=(N+2):(N+J)
         Ex(i,j) = Ex(i,j) + A*(Hzxc(i-I,j-N) - Hzxc(i-I,j-N-1) + Hzyc(i-I,j-N) - Hzyc(i-I,j-N-1));
      end
   end
   %clculo na linha intermediaria superior - da esquerda para a direita
   for i=1:N
      Ex(i,N+J+1) = (1-HO(1)*a)*Ex(i,N+J+1) + A*(Hzxs(i,1) - Hzxc(i,J) + Hzys(i,1) - Hzyc(i,J));
   end
   for i=(N+1):(N+I)
      Ex(i,N+J+1) = (1-HO(1)*a)*Ex(i,N+J+1) + A*(Hzxs(i,1) - Hz(i-N,J) + Hzys(i,1) );
   end
   for i=(N+I+1):(2*N+I)
      Ex(i,N+J+1) = (1-HO(1)*a)*Ex(i,N+J+1) + A*(Hzxs(i,1) - Hzxc(i-I,J) + Hzys(i,1) - Hzyc(i-I,J));
   end
   %clculo de Ex na superfcie superior
   for i=1:(2*N+I)
      for j=(N+J+2):(2*N+J)
         Ex(i,j) = (1-HO(j-N-J)*a)*Ex(i,j) + A*(Hzxs(i,j-N-J) - Hzxs(i,j-N-J-1) + Hzys(i,j-N-J) - Hzys(i,j-N-J-1));
      end
   end
   %**********************************************************************************
   %clculo de Ey parte inferior esquerda p/ direita
   for i=2:(N+1) 
      for j=1:N
         Ey(i,j) = (1-HO(N-i+2)*a)*Ey(i,j) - A*(Hzxi(i,j) - Hzxi(i-1,j) + Hzyi(i,j) - Hzyi(i-1,j));
      end
   end
   for i=(N+2):(N+I) %hox=0
      for j=1:N
         Ey(i,j) = Ey(i,j) - A*(Hzxi(i,j) - Hzxi(i-1,j) + Hzyi(i,j) - Hzyi(i-1,j));
      end
   end
   for i=(N+I+1):(2*N+I) 
      for j=1:N
         Ey(i,j) = (1-HO(i-N-I)*a)*Ey(i,j) - A*(Hzxi(i,j) - Hzxi(i-1,j) + Hzyi(i,j) - Hzyi(i-1,j));
      end
   end
   %clculo de Ey na lateral esquerda
   for i=2:N 
      for j=(N+1):(N+J)
         Ey(i,j) = (1-HO(N-i+2)*a)*Ey(i,j) - A*(Hzxc(i,j-N) - Hzxc(i-1,j-N) + Hzyc(i,j-N) - Hzyc(i-1,j-N));
      end
   end
   for j=(N+1):(N+J)%linha lateral esquerda
        Ey(N+1,j) = (1-HO(1)*a)*Ey(N+1,j) - A*(Hz(1,j-N) - Hzxc(N,j-N)  - Hzyc(N,j-N));
   end
   %**********************************************************************************
   for j=(N+1):(N+J)%linha lateral direita
        Ey(N+I+1,j) = (1-HO(1)*a)*Ey(N+I+1,j) - A*(Hzxc(N+1,j-N) - Hz(I,j-N) + Hzyc(N+1,j-N) );
   end
   %clculo de Ey na lateral direita
   for i=(N+I+2):(2*N+I) 
      for j=(N+1):(N+J)
         Ey(i,j) = (1-HO(i-N-I)*a)*Ey(i,j) - A*(Hzxc(i-I,j-N) - Hzxc(i-I-1,j-N) + Hzyc(i-I,j-N) - Hzyc(i-I-1,j-N));
      end
   end
   %clculo de Ey parte superior esquerda p/ direita
   for i=2:(N+1) 
      for j=(N+J+1):(2*N+J)
         Ey(i,j) = (1-HO(N-i+2)*a)*Ey(i,j) - A*(Hzxs(i,j-N-J) - Hzxs(i-1,j-N-J) + Hzys(i,j-N-J) - Hzys(i-1,j-N-J));
      end
   end
   for i=(N+2):(N+I) %hox=0
      for j=(N+J+1):(2*N+J)
         Ey(i,j) = Ey(i,j) - A*(Hzxs(i,j-N-J) - Hzxs(i-1,j-N-J) + Hzys(i,j-N-J) - Hzys(i-1,j-N-J));
      end
   end
   for i=(N+I+1):(2*N+I) 
      for j=(N+J+1):(2*N+J)
         Ey(i,j) = (1-HO(i-N-I)*a)*Ey(i,j) - A*(Hzxs(i,j-N-J)- Hzxs(i-1,j-N-J) + Hzys(i,j-N-J) - Hzys(i-1,j-N-J));
      end
   end
   %**********************************************************************************
   %Clculo do Hzxi (i=inferior)
   for i=1:N
      for j=1:N
        Hzxi(i,j) = (1- HOm(N+1-i)*b)*Hzxi(i,j) - B*(Ey(i+1,j) - Ey(i,j));  
      end
   end
   for i=(N+1):(N+I)%homx=0
      for j=1:N
        Hzxi(i,j) = Hzxi(i,j) - B*(Ey(i+1,j) - Ey(i,j));  
      end
   end
   for i=(N+I+1):(2*N+I)
      for j=1:N
        Hzxi(i,j)= (1- HOm(i-N-I)*b)*Hzxi(i,j) - B*(Ey(i+1,j) - Ey(i,j));  
      end
   end
   %clculo de Hzxc (c=central)
   for i=1:N
      for j=1:J
        Hzxc(i,j) = (1- HOm(N+1-i)*b)*Hzxc(i,j) - B*(Ey(i+1,j+N) - Ey(i,j+N));  
      end
   end
   for i=(N+1):(2*N)
      for j=1:J
        Hzxc(i,j) = (1- HOm(i-N)*b)*Hzxc(i,j) - B*(Ey(i+I+1,j+N)-Ey(i+I,j+N));  
      end
   end
   %clculo do Hzxs (s=superior)
   for i=1:N
      for j=1:N
        Hzxs(i,j)= (1- HOm(N+1-i)*b)*Hzxs(i,j) - B*(Ey(i+1,j+N+J) - Ey(i,j+N+J));  
      end
   end
   for i=(N+1):(N+I) %homx = 0
      for j=1:N
        Hzxs(i,j) = Hzxs(i,j) - B*(Ey(i+1,j+N+J) - Ey(i,j+N+J));  
      end
   end
   for i=(N+I+1):(2*N+I)
      for j=1:N
        Hzxs(i,j) = (1- HOm(i-N-I)*b)*Hzxs(i,j) - B*(Ey(i+1,j+N+J) - Ey(i,j+N+J));  
      end
   end
   %**********************************************************************************
   %clculo de Hzyi (i=inferior)
   for i=1:(2*N+I)
      for j=1:N
        Hzyi(i,j) = (1- HOm(N+1-j)*b)*Hzyi(i,j) + B*(Ex(i,j+1) - Ex(i,j));  
      end
   end
   %clculo de Hzyc (c=central) homy=0
   for i=1:N
      for j=1:J
        Hzyc(i,j) = Hzyc(i,j) + B*(Ex(i,j+1+N) - Ex(i,j+N));  
      end
   end
   for i=(N+1):(2*N)
      for j=1:J
        Hzyc(i,j) = Hzyc(i,j) + B*(Ex(i+I,j+1+N) - Ex(i+I,j+N));  
      end
   end
   %clculo de Hzys (s=superior)
   for i=1:(2*N+I)
      for j=1:N
        Hzys(i,j) = (1- HOm(j)*b)*Hzys(i,j) + B*(Ex(i,j+1+J+N)-Ex(i,j+J+N));  
      end
   end
   %**********************************************************************************
   %Clculo de Hz ->NO DOMINIO DE ESTUDO
   for i=1:I
      for j=1:J
         Hz(i,j) = Hz(i,j) + B*(Ex(i+N,j+N+1) - Ex(i+N,j+N) - Ey(i+N+1,j+N) + Ey(i+N,j+N));
      end
   end
   %excitacao em (w,z) da malha Hz
   Hz(w,z) = Hz(w,z)+ Exc(t);
   %**********************************************************************************
   EY = (Ey(N+1:I+N, N+1:J+N) + Ey(N+2:I+N+1,N+1:J+N))/2;
   EX = (Ex(N+1:I+N, N+1:J+N) + Ex(N+1:I+N,N+2:J+N+1))/2;
  
   if mod(t,2)==0;  
   time_step = int2str(t);
   
   figure(1); 
   subplot('position',[0.55 0.60 0.25 0.25])   
   pcolor(EX);
   shading interp;
   caxis([-377 377]);
   colorbar;
   axis image;
   axis off;
   title(['Ex - [', time_step,' x 5ps]']);

   subplot('position',[0.20 0.60 0.25 0.25])
   pcolor(EY);
   shading interp;
   caxis([-377 377]);
   colorbar;
   axis image;
   axis off;
   title(['Ey - [', time_step,' x 5ps]']);
  
   subplot('position',[0.3 0.10 0.4 0.4])
   pcolor(Hz);
   shading interp;
   caxis([-1.0 1.0]);
   colorbar;
   axis image;
   axis off;
   axis square
   title(['Hz - [', time_step,' x 5ps]']);
   pause(0.01)
   end
     
end%T
%*************************************************************************************
%**************************************************************************
function cavidade()
%**************************************************************************
N = 500; %n de iteraes 
I = 50; %n de clulas em x
J = 30; %n de clulas em y
K = 9; %n de clulas em z 

u_o = 4*pi*1e-7; %permeabilidade eletrica do vacuo
e_o = 8.854e-12; %permissividade eletrcia do vacuo
c = 1/(sqrt(u_o*e_o)); %velocidade da luz no vcuo

D = 0.005;  %incremento espacial - celula cubica
D_t=0.95*D/(sqrt(3)*c); %incremento temporal
%**************************************************************************
%Pulso Gaussiano
Desl = 30*D_t;%deslocamento da origem
L = 30*D_t;%largura do pulso gaussiano
%**************************************************************************
%variveis auxiliares
A = D_t/(e_o*D);
B = D_t/(u_o*D);
C = (c*D_t - D)/(c*D_t + D);
%**************************************************************************
%Inicializao das variveis de campo 
Hx = zeros(I+1,J,K);   Ex = zeros(I,J+1,K+1); 
Hy = zeros(I,J+1,K);   Ey = zeros(I+1,J,K+1); 
Hz = zeros(I,J,K+1);   Ez = zeros(I+1,J+1,K); 
%**************************************************************************
%**************************************************************************
for n=1:N
   %*********************************************************************** 
   %Clculo de Ex
   Ex(1:I,2:J,2:K) = Ex(1:I,2:J,2:K) + A*(Hz(1:I,2:J,2:K)...
             - Hz(1:I,1:J-1,2:K) - Hy(1:I,2:J,2:K) + Hy(1:I,2:J,1:K-1));
   %Clculo de Ey
   Ey(2:I,1:J,2:K) = Ey(2:I,1:J,2:K) + A*(Hx(2:I,1:J,2:K)...
             - Hx(2:I,1:J,1:K-1) - Hz(2:I,1:J,2:K) + Hz(1:I-1,1:J,2:K));
   %Clculo de Ez
   Ez(2:I,2:J,1:K) = Ez(2:I,2:J,1:K) + A*(Hy(2:I,2:J,1:K)...
             - Hy(1:I-1,2:J,1:K) - Hx(2:I,2:J,1:K) + Hx(2:I,1:J-1,1:K));
         
   %Excitacao linha em Ez 
   Ez(26,16,1:K) = Ez(26,16,1:K) + 15*exp(-18*(((n-1)*D_t-Desl)/L).^2);    
   %***********************************************************************
   %Clculo de Hx
   Hx(2:I,1:J,1:K) = Hx(2:I,1:J,1:K) + B*(Ey(2:I,1:J,2:K+1)...
             - Ey(2:I,1:J,1:K) - Ez(2:I,2:J+1,1:K) + Ez(2:I,1:J,1:K));
   %***********************************************************************                                   
   %Clculo de Hy
   Hy(1:I,2:J,1:K) = Hy(1:I,2:J,1:K) + B*(Ez(2:I+1,2:J,1:K)...
             - Ez(1:I,2:J,1:K) - Ex(1:I,2:J,2:K+1) + Ex(1:I,2:J,1:K));
   %***********************************************************************
   %Clculo de Hz
   Hz(1:I,1:J,2:K) = Hz(1:I,1:J,2:K) + B*(Ex(1:I,2:J+1,2:K)...
             - Ex(1:I,1:J,2:K) - Ey(2:I+1,1:J,2:K) + Ey(1:I,1:J,2:K));
   %***********************************************************************
   EZ1(:,:) = Ez(:,:,5);
   EZ2(:,:) = Ez(:,16,:);

   time_step = int2str(n);
   
   figure(1);
   subplot('position',[0.15 0.42 0.6 0.5])
   pcolor(EZ1');
   shading interp;
   caxis([-1 1]);
   colorbar;
   title(['Ez( i, j, k = 5) - Time Step = ', time_step]);
   ylabel('Coordinate j');
   xlabel('Coordinate i');
 
   subplot('position',[0.15 0.12 0.6 0.15])
   pcolor(EZ2');
   shading interp;
   caxis([-1 1]);
   colorbar;
   title(['Ez( i, j = 16, k) - Time Step = ', time_step]);
   ylabel('Coordinate k');
   xlabel('Coordinate i');
   pause(0.1)
   
% n     
end%N
%**************************************************************************
%**************************************************************************
function espalham2D_OC_PG_TE_PML ()

T = 600;%nr de iteracoes
I = 130; %nr de clulas em x
J = 130; %nr de clulas em y

u_o = 4*pi*1e-7; %permeabilidade magntica do vcuo
e_o = 8.854e-12; %permissvidade eltrica do vcuo	
D = 0.003; %Delta (largura, altura da clula FDTD)
D_t = 5e-12; %Delta t (espao temporal)
c = 1/(sqrt(u_o*e_o)); %velocidade da luz no vcuo
w = 1;%excitao em Hz(w,z)
z = 1;
ss=0;
%************************************************************************************
n = 0:D_t:T*D_t;
Ds = 15*D_t;%deslocamento do pulso (D=0 centrado em t=0)
L = 25*D_t;%largura do pulso gaussiano
Pg = 200*exp(-18*((n-Ds)/L).^2);
%plot(Pg)
%************************************************************************************
%PML
R_0 = 0.0001; %fator de reflexao (0.01%)
n = 2; % variao linear(1) ou parabolica(2) da condutividade na PML
N = 8; %n_r de celulas na PML
Sig = N*D; %Sigma = espessura total da PML
ho_m = - e_o*c*log(R_0)/(2/(n+1)*Sig);%condutividade da camada + externa

HO(1) = ho_m/((n+1)*2^(n+1)*N^n);%condutividade da primeira camada L=0

i=1;
for L=1:N-1%condutividade para L inteiro -usa para Ex e Ey
   i=i+1;
   HO(i) = HO(1)*((2*L +1)^(n+1) - (2*L - 1)^(n+1));   
end

i=0;
for L=0.5:1:N-0.5%condutividade para L -> 0.5 - usa para Hzx e Hzy
   i=i+1;
   H_O(i) = HO(1)*((2*L +1)^(n+1) - (2*L - 1)^(n+1));   
end

HOm = H_O*u_o/e_o;%condutividade magntica  - usa para Hzx e Hzy

%************************************************************************************
%Inicializao das variveis de campo - Modo TE 
Ex = zeros(I+2*N,J+2*N+1);
Ey = zeros(I+2*N+1,J+2*N);
Hz = zeros(I,J); 

Hzxi = zeros(I+2*N,N);%matriz inferior de Hzx 
Hzxc = zeros(2*N,J);  %matriz central de Hzx 
Hzxs = zeros(I+2*N,N);%matriz superior de Hzx 
Hzyi = zeros(I+2*N,N);%matriz inferior de Hyz 
Hzyc = zeros(2*N,J);  %matriz inferior de Hyz 
Hzys = zeros(I+2*N,N);%matriz inferior de Hyz  
%************************************************************************************
%variveis auxiliares
a = D_t/e_o;
b = D_t/u_o;
A = a/D;%D_t/(e_o*D);
B = b/D;%D_t/(u_o*D);
%*************************************************************************************
%*************************************************************************************
for t=1:T
   %**********************************************************************************
   %Clculo de Ex ->NO DOMINIO DE ESTUDO
   for i=(N+1):(I+N)
      for j=(N+2):(J+N)
         Ex(i,j) = Ex(i,j) + A*(Hz(i-N,j-N) - Hz(i-N,j-N-1));
      end
   end
   %**********************************************************************************
   %Clculo de Ey ->NO DOMINIO DE ESTUDO   
   for i=(N+2):(I+N)
      for j=(N+1):(J+N)
         Ey(i,j) = Ey(i,j) - A*(Hz(i-N,j-N) - Hz(i-N-1,j-N));
      end
   end
   %**********************************************************************************
   %Clculo na PML
   %clculo de Ex na superfcie inferior
   for i=1:(2*N+I)
      for j=2:N
         Ex(i,j) = (1-HO(N+2-j)*a)*Ex(i,j) + A*(Hzxi(i,j) - Hzxi(i,j-1) + Hzyi(i,j) - Hzyi(i,j-1));
      end
   end
   %clculo na linha intermediaria inferior - da esquerda para a direita
   for i=1:N
      Ex(i,N+1) = (1-HO(1)*a)*Ex(i,N+1) + A*(Hzxc(i,1) - Hzxi(i,N) + Hzyc(i,1) - Hzyi(i,N));
   end
   for i=(N+1):(N+I)
      Ex(i,N+1) = (1-HO(1)*a)*Ex(i,N+1) + A*(Hz(i-N,1) - Hzxi(i,N)  - Hzyi(i,N));
   end
   for i=(N+I+1):(2*N+I)
      Ex(i,N+1) = (1-HO(1)*a)*Ex(i,N+1) + A*(Hzxc(i-I,1) - Hzxi(i,N) + Hzyc(i-I,1) - Hzyi(i,N));
   end
   %clculo de Ex no parte central esquerda - hoy = 0;
   for i=1:N
      for j=(N+2):(N+J)
         Ex(i,j) = Ex(i,j) + A*(Hzxc(i,j-N) - Hzxc(i,j-N-1) + Hzyc(i,j-N) - Hzyc(i,j-N-1));
      end
   end
   %**********************************************************************************
   %clculo de Ex no parte central direita - hoy = 0;
   for i=(N+I+1):(2*N+I)
      for j=(N+2):(N+J)
         Ex(i,j) = Ex(i,j) + A*(Hzxc(i-I,j-N) - Hzxc(i-I,j-N-1) + Hzyc(i-I,j-N) - Hzyc(i-I,j-N-1));
      end
   end
   %clculo na linha intermediaria superior - da esquerda para a direita
   for i=1:N
      Ex(i,N+J+1) = (1-HO(1)*a)*Ex(i,N+J+1) + A*(Hzxs(i,1) - Hzxc(i,J) + Hzys(i,1) - Hzyc(i,J));
   end
   for i=(N+1):(N+I)
      Ex(i,N+J+1) = (1-HO(1)*a)*Ex(i,N+J+1) + A*(Hzxs(i,1) - Hz(i-N,J) + Hzys(i,1) );
   end
   for i=(N+I+1):(2*N+I)
      Ex(i,N+J+1) = (1-HO(1)*a)*Ex(i,N+J+1) + A*(Hzxs(i,1) - Hzxc(i-I,J) + Hzys(i,1) - Hzyc(i-I,J));
   end
   %clculo de Ex na superfcie superior
   for i=1:(2*N+I)
      for j=(N+J+2):(2*N+J)
         Ex(i,j) = (1-HO(j-N-J)*a)*Ex(i,j) + A*(Hzxs(i,j-N-J) - Hzxs(i,j-N-J-1) + Hzys(i,j-N-J) - Hzys(i,j-N-J-1));
      end
   end
   %**********************************************************************************
   %clculo de Ey parte inferior esquerda p/ direita
   for i=2:(N+1) 
      for j=1:N
         Ey(i,j) = (1-HO(N-i+2)*a)*Ey(i,j) - A*(Hzxi(i,j) - Hzxi(i-1,j) + Hzyi(i,j) - Hzyi(i-1,j));
      end
   end
   for i=(N+2):(N+I) %hox=0
      for j=1:N
         Ey(i,j) = Ey(i,j) - A*(Hzxi(i,j) - Hzxi(i-1,j) + Hzyi(i,j) - Hzyi(i-1,j));
      end
   end
   for i=(N+I+1):(2*N+I) 
      for j=1:N
         Ey(i,j) = (1-HO(i-N-I)*a)*Ey(i,j) - A*(Hzxi(i,j) - Hzxi(i-1,j) + Hzyi(i,j) - Hzyi(i-1,j));
      end
   end
   %clculo de Ey na lateral esquerda
   for i=2:N 
      for j=(N+1):(N+J)
         Ey(i,j) = (1-HO(N-i+2)*a)*Ey(i,j) - A*(Hzxc(i,j-N) - Hzxc(i-1,j-N) + Hzyc(i,j-N) - Hzyc(i-1,j-N));
      end
   end
   for j=(N+1):(N+J)%linha lateral esquerda
        Ey(N+1,j) = (1-HO(1)*a)*Ey(N+1,j) - A*(Hz(1,j-N) - Hzxc(N,j-N)  - Hzyc(N,j-N));
   end
   %**********************************************************************************
   for j=(N+1):(N+J)%linha lateral direita
        Ey(N+I+1,j) = (1-HO(1)*a)*Ey(N+I+1,j) - A*(Hzxc(N+1,j-N) - Hz(I,j-N) + Hzyc(N+1,j-N) );
   end
   %clculo de Ey na lateral direita
   for i=(N+I+2):(2*N+I) 
      for j=(N+1):(N+J)
         Ey(i,j) = (1-HO(i-N-I)*a)*Ey(i,j) - A*(Hzxc(i-I,j-N) - Hzxc(i-I-1,j-N) + Hzyc(i-I,j-N) - Hzyc(i-I-1,j-N));
      end
   end
   %clculo de Ey parte superior esquerda p/ direita
   for i=2:(N+1) 
      for j=(N+J+1):(2*N+J)
         Ey(i,j) = (1-HO(N-i+2)*a)*Ey(i,j) - A*(Hzxs(i,j-N-J) - Hzxs(i-1,j-N-J) + Hzys(i,j-N-J) - Hzys(i-1,j-N-J));
      end
   end
   for i=(N+2):(N+I) %hox=0
      for j=(N+J+1):(2*N+J)
         Ey(i,j) = Ey(i,j) - A*(Hzxs(i,j-N-J) - Hzxs(i-1,j-N-J) + Hzys(i,j-N-J) - Hzys(i-1,j-N-J));
      end
   end
   for i=(N+I+1):(2*N+I) 
      for j=(N+J+1):(2*N+J)
         Ey(i,j) = (1-HO(i-N-I)*a)*Ey(i,j) - A*(Hzxs(i,j-N-J)- Hzxs(i-1,j-N-J) + Hzys(i,j-N-J) - Hzys(i-1,j-N-J));
      end
   end
   %condicoes de contorno para os objetos metalicos 
   Ex(N+46:N+90,N+31:N+32)=0;
   Ey([N+46:N+91],N+31)=0;
   
   Ex(N+31,[N+46:N+91])=0;
   Ey([N+31 N+32],N+46:N+90)=0;
   
   Ex(N+51:N+80,N+51:N+81)=0;
   Ey(N+51:N+81,N+51:N+80)=0;    
   %**********************************************************************************
   %Clculo do Hzxi (i=inferior)
   for i=1:N
      for j=1:N
        Hzxi(i,j) = (1- HOm(N+1-i)*b)*Hzxi(i,j) - B*(Ey(i+1,j) - Ey(i,j));  
      end
   end
   for i=(N+1):(N+I)%homx=0
      for j=1:N
        Hzxi(i,j) = Hzxi(i,j) - B*(Ey(i+1,j) - Ey(i,j));  
      end
   end
   for i=(N+I+1):(2*N+I)
      for j=1:N
        Hzxi(i,j)= (1- HOm(i-N-I)*b)*Hzxi(i,j) - B*(Ey(i+1,j) - Ey(i,j));  
      end
   end
   %clculo de Hzxc (c=central)
   for i=1:N
      for j=1:J
        Hzxc(i,j) = (1- HOm(N+1-i)*b)*Hzxc(i,j) - B*(Ey(i+1,j+N) - Ey(i,j+N));  
      end
   end
   for i=(N+1):(2*N)
      for j=1:J
        Hzxc(i,j) = (1- HOm(i-N)*b)*Hzxc(i,j) - B*(Ey(i+I+1,j+N)-Ey(i+I,j+N));  
      end
   end
   %clculo do Hzxs (s=superior)
   for i=1:N
      for j=1:N
        Hzxs(i,j)= (1- HOm(N+1-i)*b)*Hzxs(i,j) - B*(Ey(i+1,j+N+J) - Ey(i,j+N+J));  
      end
   end
   for i=(N+1):(N+I) %homx = 0
      for j=1:N
        Hzxs(i,j) = Hzxs(i,j) - B*(Ey(i+1,j+N+J) - Ey(i,j+N+J));  
      end
   end
   for i=(N+I+1):(2*N+I)
      for j=1:N
        Hzxs(i,j) = (1- HOm(i-N-I)*b)*Hzxs(i,j) - B*(Ey(i+1,j+N+J) - Ey(i,j+N+J));  
      end
   end
   %**********************************************************************************
   %clculo de Hzyi (i=inferior)
   for i=1:(2*N+I)
      for j=1:N
        Hzyi(i,j) = (1- HOm(N+1-j)*b)*Hzyi(i,j) + B*(Ex(i,j+1) - Ex(i,j));  
      end
   end
   %clculo de Hzyc (c=central) homy=0
   for i=1:N
      for j=1:J
        Hzyc(i,j) = Hzyc(i,j) + B*(Ex(i,j+1+N) - Ex(i,j+N));  
      end
   end
   for i=(N+1):(2*N)
      for j=1:J
        Hzyc(i,j) = Hzyc(i,j) + B*(Ex(i+I,j+1+N) - Ex(i+I,j+N));  
      end
   end
   %clculo de Hzys (s=superior)
   for i=1:(2*N+I)
      for j=1:N
        Hzys(i,j) = (1- HOm(j)*b)*Hzys(i,j) + B*(Ex(i,j+1+J+N)-Ex(i,j+J+N));  
      end
   end
   %**********************************************************************************
    %Clculo de Hz ->NO DOMINIO DE ESTUDO
   for i=1:I
      for j=1:J
         Hz(i,j) = Hz(i,j) + B*(Ex(i+N,j+N+1) - Ex(i+N,j+N) - Ey(i+N+1,j+N) + Ey(i+N,j+N));
      end
   end
   %excitacao em (w,z) da malha Hz
   Hz(w,z) = Hz(w,z)+Pg(t);
   %**********************************************************************************
%colorir de azul os objetos metalicos
Hz(46:90,31)=-1;
Hz(31,46:90)=-1;
Hz(51:80,51:80)=-1;

   if mod(t,4)==0;  
   time_step = int2str(t);
   ss = ss + 1;  
   figure(1);
   subplot('position',[0.15 0.15 0.70 0.70])  
   pcolor(Hz);
   shading interp;
   caxis([-1.0 1.0]);
   colorbar;
   axis image;
   axis square
   title(['Electric Field Hz [Step Time = ', time_step,' x 5ps]']);
   xlabel('Coordinate i');
   ylabel('Coordinate j');
   pause(0.01)
   end

end%T
%*************************************************************************************
%*************************************************************************************
function espalham2D_OP_PM_TE_PML()
%************************************************************************************
T = 420; %nr de iteracoes
I = 130; %n_r de clulas em x
J = 110; %n_r de clulas em y
u_o = 4*pi*1e-7; %permeabilidade magntica do vcuo
e_o = 8.854e-12; %permissvidade eltrica do vcuo	
c = 1/(sqrt(u_o*e_o)); %velocidade da luz no vcuo
D = 0.001; %Delta (largura, altura da clula FDTD)
D_t = 0.5*D/(sqrt(2)*c); %Delta t (espao temporal)
%************************************************************************************
%Excitacao na freq. de 6 GHz
t = 1:T;
Exc = sin(2*pi*15e9*D_t*(t-1)); 
% plot(Exc)
%************************************************************************************
%PML
R_0 = 0.0001; %fator de reflexao (0.01%)
n = 2; % variao linear(1) ou parabolica(2) da condutividade na PML
N = 6; %n_r de celulas na PML
Sig = N*D; %Sigma = espessura total da PML
ho_m = - e_o*c*log(R_0)/(2/(n+1)*Sig);%condutividade da camada + externa

HO(1) = ho_m/((n+1)*2^(n+1)*N^n);%condutividade da primeira camada L=0

i=1;
for L=1:N-1%condutividade para L inteiro -usa para Ex e Ey
   i=i+1;
   HO(i) = HO(1)*((2*L +1)^(n+1) - (2*L - 1)^(n+1));   
end

i=0;
for L=0.5:1:N-0.5%condutividade para L -> 0.5 - usa para Hzx e Hzy
   i=i+1;
   H_O(i) = HO(1)*((2*L +1)^(n+1) - (2*L - 1)^(n+1));   
end

HOm = H_O*u_o/e_o;%condutividade magntica  - usa para Hzx e Hzy

%************************************************************************************
%Inicializao das variveis de campo - Modo TE 
Ex = zeros(I+2*N,J+2*N+1);
Ey = zeros(I+2*N+1,J+2*N);
Hz = zeros(I,J); 
Hzxi = zeros(I+2*N,N);%matriz inferior de Hzx 
Hzxc = zeros(2*N,J);  %matriz central de Hzx 
Hzxs = zeros(I+2*N,N);%matriz superior de Hzx 
Hzyi = zeros(I+2*N,N);%matriz inferior de Hyz 
Hzyc = zeros(2*N,J);  %matriz inferior de Hyz 
Hzys = zeros(I+2*N,N);%matriz inferior de Hyz  

%variveis auxiliares
a = D_t/e_o;
b = D_t/u_o;
A = a/D;%D_t/(e_o*D);
B = b/D;%D_t/(u_o*D);
%************************************************************************************
%************************************************************************************
for t=1:T
   %*********************************************************************************
   %Clculo de Ex ->NO DOMINIO DE ESTUDO
   for i=(N+1):(I+N)
      for j=(N+2):(J+N)
         Ex(i,j) = Ex(i,j) + A*(Hz(i-N,j-N) - Hz(i-N,j-N-1));
      end
   end
   %*********************************************************************************
   %Clculo de Ey ->NO DOMINIO DE ESTUDO   
   for i=(N+2):(I+N)
      for j=(N+1):(J+N)
         Ey(i,j) = Ey(i,j) - A*(Hz(i-N,j-N) - Hz(i-N-1,j-N));
      end
   end
   %*********************************************************************************
   %clculo na PML
   %clculo de Ex na superfcie inferior
   for i=1:(2*N+I)
      for j=2:N
         Ex(i,j) = (1-HO(N+2-j)*a)*Ex(i,j) + A*(Hzxi(i,j) - Hzxi(i,j-1) + Hzyi(i,j) - Hzyi(i,j-1));
      end
   end
   %clculo na linha intermediaria inferior - da esquerda para a direita
   for i=1:N
      Ex(i,N+1) = (1-HO(1)*a)*Ex(i,N+1) + A*(Hzxc(i,1) - Hzxi(i,N) + Hzyc(i,1) - Hzyi(i,N));
   end
   for i=(N+1):(N+I)
      Ex(i,N+1) = (1-HO(1)*a)*Ex(i,N+1) + A*(Hz(i-N,1) - Hzxi(i,N)  - Hzyi(i,N));
   end
   for i=(N+I+1):(2*N+I)
      Ex(i,N+1) = (1-HO(1)*a)*Ex(i,N+1) + A*(Hzxc(i-I,1) - Hzxi(i,N) + Hzyc(i-I,1) - Hzyi(i,N));
   end
   %clculo de Ex no parte central esquerda - hoy = 0;
   for i=1:N
      for j=(N+2):(N+J)
         Ex(i,j) = Ex(i,j) + A*(Hzxc(i,j-N) - Hzxc(i,j-N-1) + Hzyc(i,j-N) - Hzyc(i,j-N-1));
      end
   end
   %*********************************************************************************
   %clculo de Ex no parte central direita - hoy = 0;
   for i=(N+I+1):(2*N+I)
      for j=(N+2):(N+J)
         Ex(i,j) = Ex(i,j) + A*(Hzxc(i-I,j-N) - Hzxc(i-I,j-N-1) + Hzyc(i-I,j-N) - Hzyc(i-I,j-N-1));
      end
   end
   %clculo na linha intermediaria superior - da esquerda para a direita
   for i=1:N
      Ex(i,N+J+1) = (1-HO(1)*a)*Ex(i,N+J+1) + A*(Hzxs(i,1) - Hzxc(i,J) + Hzys(i,1) - Hzyc(i,J));
   end
   for i=(N+1):(N+I)
      Ex(i,N+J+1) = (1-HO(1)*a)*Ex(i,N+J+1) + A*(Hzxs(i,1) - Hz(i-N,J) + Hzys(i,1) );
   end
   for i=(N+I+1):(2*N+I)
      Ex(i,N+J+1) = (1-HO(1)*a)*Ex(i,N+J+1) + A*(Hzxs(i,1) - Hzxc(i-I,J) + Hzys(i,1) - Hzyc(i-I,J));
   end
   %clculo de Ex na superfcie superior
   for i=1:(2*N+I)
      for j=(N+J+2):(2*N+J)
         Ex(i,j) = (1-HO(j-N-J)*a)*Ex(i,j) + A*(Hzxs(i,j-N-J) - Hzxs(i,j-N-J-1) + Hzys(i,j-N-J) - Hzys(i,j-N-J-1));
      end
   end
   %*********************************************************************************
   %clculo de Ey parte inferior esquerda p/ direita
   for i=2:(N+1) 
      for j=1:N
         Ey(i,j) = (1-HO(N-i+2)*a)*Ey(i,j) - A*(Hzxi(i,j) - Hzxi(i-1,j) + Hzyi(i,j) - Hzyi(i-1,j));
      end
   end
   for i=(N+2):(N+I) %hox=0
      for j=1:N
         Ey(i,j) = Ey(i,j) - A*(Hzxi(i,j) - Hzxi(i-1,j) + Hzyi(i,j) - Hzyi(i-1,j));
      end
   end
   for i=(N+I+1):(2*N+I) 
      for j=1:N
         Ey(i,j) = (1-HO(i-N-I)*a)*Ey(i,j) - A*(Hzxi(i,j) - Hzxi(i-1,j) + Hzyi(i,j) - Hzyi(i-1,j));
      end
   end
   %clculo de Ey na lateral esquerda
   for i=2:N 
      for j=(N+1):(N+J)
         Ey(i,j) = (1-HO(N-i+2)*a)*Ey(i,j) - A*(Hzxc(i,j-N) - Hzxc(i-1,j-N) + Hzyc(i,j-N) - Hzyc(i-1,j-N));
      end
   end
   for j=(N+1):(N+J)%linha lateral esquerda
        Ey(N+1,j) = (1-HO(1)*a)*Ey(N+1,j) - A*(Hz(1,j-N) - Hzxc(N,j-N)  - Hzyc(N,j-N));
   end
   %*********************************************************************************
   for j=(N+1):(N+J)%linha lateral direita
        Ey(N+I+1,j) = (1-HO(1)*a)*Ey(N+I+1,j) - A*(Hzxc(N+1,j-N) - Hz(I,j-N) + Hzyc(N+1,j-N) );
   end
   %clculo de Ey na lateral direita
   for i=(N+I+2):(2*N+I) 
      for j=(N+1):(N+J)
         Ey(i,j) = (1-HO(i-N-I)*a)*Ey(i,j) - A*(Hzxc(i-I,j-N) - Hzxc(i-I-1,j-N) + Hzyc(i-I,j-N) - Hzyc(i-I-1,j-N));
      end
   end
   %clculo de Ey parte superior esquerda p/ direita
   for i=2:(N+1) 
      for j=(N+J+1):(2*N+J)
         Ey(i,j) = (1-HO(N-i+2)*a)*Ey(i,j) - A*(Hzxs(i,j-N-J) - Hzxs(i-1,j-N-J) + Hzys(i,j-N-J) - Hzys(i-1,j-N-J));
      end
   end
   for i=(N+2):(N+I) %hox=0
      for j=(N+J+1):(2*N+J)
         Ey(i,j) = Ey(i,j) - A*(Hzxs(i,j-N-J) - Hzxs(i-1,j-N-J) + Hzys(i,j-N-J) - Hzys(i-1,j-N-J));
      end
   end
   for i=(N+I+1):(2*N+I) 
      for j=(N+J+1):(2*N+J)
         Ey(i,j) = (1-HO(i-N-I)*a)*Ey(i,j) - A*(Hzxs(i,j-N-J)- Hzxs(i-1,j-N-J) + Hzys(i,j-N-J) - Hzys(i-1,j-N-J));
      end
   end
   
   %condicoes de contorno para objetos metalicos 
   Ex(N+76:N+77,[1:N+53 N+58:2*N+J+1])=0;
   Ey(N+76:N+78,[1:N+52 N+58:2*N+J])=0;
   %onda plana
   Ex(1:N+75,[N+1 N+J+1])=0;
   %*********************************************************************************
   %Clculo do Hzxi (i=inferior)
   for i=1:N
      for j=1:N
        Hzxi(i,j) = (1- HOm(N+1-i)*b)*Hzxi(i,j) - B*(Ey(i+1,j) - Ey(i,j));  
      end
   end
   for i=(N+1):(N+I)%homx=0
      for j=1:N
        Hzxi(i,j) = Hzxi(i,j) - B*(Ey(i+1,j) - Ey(i,j));  
      end
   end
   for i=(N+I+1):(2*N+I)
      for j=1:N
        Hzxi(i,j)= (1- HOm(i-N-I)*b)*Hzxi(i,j) - B*(Ey(i+1,j) - Ey(i,j));  
      end
   end
   %clculo de Hzxc (c=central)
   for i=1:N
      for j=1:J
        Hzxc(i,j) = (1- HOm(N+1-i)*b)*Hzxc(i,j) - B*(Ey(i+1,j+N) - Ey(i,j+N));  
      end
   end
   for i=(N+1):(2*N)
      for j=1:J
        Hzxc(i,j) = (1- HOm(i-N)*b)*Hzxc(i,j) - B*(Ey(i+I+1,j+N)-Ey(i+I,j+N));  
      end
   end
   %clculo do Hzxs (s=superior)
   for i=1:N
      for j=1:N
        Hzxs(i,j)= (1- HOm(N+1-i)*b)*Hzxs(i,j) - B*(Ey(i+1,j+N+J) - Ey(i,j+N+J));  
      end
   end
   for i=(N+1):(N+I) %homx = 0
      for j=1:N
        Hzxs(i,j) = Hzxs(i,j) - B*(Ey(i+1,j+N+J) - Ey(i,j+N+J));  
      end
   end
   for i=(N+I+1):(2*N+I)
      for j=1:N
        Hzxs(i,j) = (1- HOm(i-N-I)*b)*Hzxs(i,j) - B*(Ey(i+1,j+N+J) - Ey(i,j+N+J));  
      end
   end
   %*********************************************************************************
   %clculo de Hzyi (i=inferior)
   for i=1:(2*N+I)
      for j=1:N
        Hzyi(i,j) = (1- HOm(N+1-j)*b)*Hzyi(i,j) + B*(Ex(i,j+1) - Ex(i,j));  
      end
   end
   %clculo de Hzyc (c=central) homy=0
   for i=1:N
      for j=1:J
        Hzyc(i,j) = Hzyc(i,j) + B*(Ex(i,j+1+N) - Ex(i,j+N));  
      end
   end
   for i=(N+1):(2*N)
      for j=1:J
        Hzyc(i,j) = Hzyc(i,j) + B*(Ex(i+I,j+1+N) - Ex(i+I,j+N));  
      end
   end
   %clculo de Hzys (s=superior)
   for i=1:(2*N+I)
      for j=1:N
        Hzys(i,j) = (1- HOm(j)*b)*Hzys(i,j) + B*(Ex(i,j+1+J+N)-Ex(i,j+J+N));  
      end
   end
   %*********************************************************************************
   %Clculo de Hz ->NO DOMINIO DE ESTUDO
   for i=1:I
      for j=1:J
         Hz(i,j) = Hz(i,j) + B*(Ex(i+N,j+N+1) - Ex(i+N,j+N) - Ey(i+N+1,j+N) + Ey(i+N,j+N));
      end
   end
   %*********************************************************************************
   %excitacao em (w,z) da malha Hz - excitacao suave
    Hz(1,:) = Hz(1,:) + Exc(t);
    Hz(76:77,[1:52 58:J])=-1;
  
   if mod(t,5)==0;  
   figure(1); 
   subplot('position',[0.15 0.15 0.7 0.65])   
   pcolor(Hz');
   shading interp;
   caxis([-1.0 1.0]);
%    colorbar;
   axis image;
   title(['Magnetic Fiel [Hz] - Freq. 15 GHz']);
   xlabel('[mm]');
   ylabel('[mm]');
   pause(0.1)
  end
% t      
end%T
%************************************************************************************
%************************************************************************************
%--------------------------------------------------------------------
function radiobuttonCylinder_Callback(hObject, eventdata, handles)

flag = get(handles.radiobuttonCylinder,'Value');
if flag
  set(handles.editIFDTD,'String',['100'])
  set(handles.editJFDTD,'String',['100'])
  set(handles.radiobuttonGP,'Value',1);
  set(handles.radiobuttonHz,'Value',1);
%   set(handles.editfFDTD,'String',[])
  set(handles.editTFDTD,'String',['500']) 
  set(handles.radiobuttonPHz,'Value',1);
  set(handles.checkboxMettBound,'Value',1);
  set(handles.checkboxPropert,'Value',1);
  set(handles.editIP,'String',['10']);
  set(handles.editExcitation,'String',['10 1 90 1']);
  set(handles.editProperties,'String',['50 50 30 1 4 0 0 0 3 0.00005']);
  set(handles.editMettal,'String',['50 60 10 1 4']);
  set(handles.radiobuttonFDTDPML,'Value',1); 
  guidata(hObject,handles);%store changes 
end
%--------------------------------------------------------------------
function radiobuttonManyChapes_Callback(hObject, eventdata, handles)
flag = get(handles.radiobuttonManyChapes,'Value');
if flag
  set(handles.editIFDTD,'String',['150'])
  set(handles.editJFDTD,'String',['100'])
  set(handles.radiobuttonSinus,'Value',1);
  set(handles.radiobuttonHz,'Value',1);
  set(handles.editfFDTD,'String',['1e9'])
  set(handles.editTFDTD,'String',['600']) 
  set(handles.radiobuttonPHz,'Value',1);
  set(handles.checkboxMettBound,'Value',1);
  set(handles.checkboxPropert,'Value',1);
  set(handles.editIP,'String',['10']);
  set(handles.editExcitation,'String',['20 1 130 1']);
  set(handles.editProperties,'String',['20 50 50 80 20 80 20 80 3 0;'...
    '110 60 130 60 130 80 110 80 5 0;'...
    '20 20 10 1 3 0 0 0 5 0;'...
    '60 60 60 70 50 70 50 70 10 0;'...
    '120 30 150 30 120 60 120 60 4 0.5;'...
    '60 40 90 40 90 70 90 70 8 0.01;'...
    '70 10 20 1 1 0 0 0 6 0.03;']);
  set(handles.editMettal,'String',['10 70 10 90 0;'...
    '10 90 30 90 0; 100 30 120 50 0; 40 40 30 50 0; 100 80 10 1 2;']);
  set(handles.radiobuttonFDTDPML,'Value',1); 
  guidata(hObject,handles);%store changes 
end
%--------------------------------------------------------------------
function radiobuttonMonople_Callback(hObject, eventdata, handles)
flag = get(handles.radiobuttonMonople,'Value');
if flag
  set(handles.editIFDTD,'String',['200'])
  set(handles.editJFDTD,'String',['100'])
  set(handles.radiobuttonGP,'Value',1);
  set(handles.radiobuttonExEy,'Value',1);
  set(handles.editfFDTD,'String',['0.6e9'])
  set(handles.editTFDTD,'String',['500']) 
  set(handles.radiobuttonPHz,'Value',1);
  set(handles.checkboxMettBound,'Value',1);
  set(handles.checkboxPropert,'Value',0);
  set(handles.editIP,'String',['10']);
  set(handles.editExcitation,'String',['100 1 100 7']);
  set(handles.editProperties,'String',['0 0 200 0 200 100 0 100 1.5 0']);
  set(handles.editMettal,'String',['10 1 190 1 0; 100 7 100 60 0']);
  set(handles.radiobuttonFDTDPML,'Value',1); 
  guidata(hObject,handles);%store changes 
end

%--------------------------------------------------------------------
function radiobuttonDipole_Callback(hObject, eventdata, handles)
flag = get(handles.radiobuttonDipole,'Value');
if flag
  set(handles.editIFDTD,'String',['150'])
  set(handles.editJFDTD,'String',['150'])
  set(handles.radiobuttonSinus,'Value',1);
  set(handles.radiobuttonExEy,'Value',1);
  set(handles.editfFDTD,'String',['0.6e9'])
  set(handles.editTFDTD,'String',['500']) 
  set(handles.radiobuttonPEy,'Value',1);
  set(handles.checkboxMettBound,'Value',1);
  set(handles.checkboxPropert,'Value',0);
  set(handles.editIP,'String',['10']);
  set(handles.editExcitation,'String',['75 73 75 77']);
  set(handles.editProperties,'String',['0 0 150 0 150 150 0 150 1 0']);
  set(handles.editMettal,'String',['75 35 75 73 0; 75 77 75 115 0']);
  set(handles.radiobuttonFDTDPML,'Value',1); 
  guidata(hObject,handles);%store changes 
end

%--------------------------------------------------------------------
function radiobuttonWaveGuide_Callback(hObject, eventdata, handles)

flag = get(handles.radiobuttonWaveGuide,'Value');
if flag
  set(handles.editIFDTD,'String',['200'])
  set(handles.editJFDTD,'String',['170'])
  set(handles.radiobuttonSinus,'Value',1);
  set(handles.radiobuttonHz,'Value',1);
  set(handles.editfFDTD,'String',['1e9'])
  set(handles.editTFDTD,'String',['500']) 
  set(handles.radiobuttonPHz,'Value',1);
  set(handles.checkboxMettBound,'Value',1);
  set(handles.checkboxPropert,'Value',1);
  set(handles.editIP,'String',['10']);
  set(handles.editExcitation,'String',['41 70 41 100']);
  set(handles.editProperties,'String',['0 0 200 0 200 170 0 170 1 5e-2;'...
      '20 20 180 20 180 150 20 150 1 0;']);
  set(handles.editMettal,'String',['120 40 90 70 0; 90 70 40 70 0;'...
      '40 70 40 100 0;40 100 90 100 0;90 100 120 130 0;']);
  set(handles.radiobuttonFDTDM,'Value',1); 
  guidata(hObject,handles);%store changes 
end

%-----------------------------------------------------------------------
%-----------------------------------------------------------------------
%-----------------------------------------------------------------------

function [Ix,Iy] = metalFDTD(xym)

%xym = [x1 y1 x2 y2 0], perfect metalic boundary condictions,
%    a line defined by 2 points, can be vertical, horizontal or tilt,
%    if tilt it MUST always have the same number of CELLS on x and y direction)
%    For a circle xyp = [pox poy R Q1 Q2], same definition used for xyp

%--------------------------------------------------------------------------
%correct xym -> rigth to left coordenates - down - up
for k = 1:length(xym(:,1))
    if xym(k,5)==0%if not a circle correct
      i1 = xym(k,1);
      j1 = xym(k,2);
      i2 = xym(k,3);
      j2 = xym(k,4);
      if i1==i2 & j1>j2%|
       xym(k,1:4)= [i1 j2 i2 j1];
      elseif i1>i2 & j1==j2 %--    
       xym(k,1:4)= [i2 j1 i1 j2];
      elseif i1>i2 & j1>j2 %/  
       xym(k,1:4)= [i2 j2 i1 j1];
      elseif i1>i2 & j2>j1 %\  
       xym(k,1:4)= [i2 j2 i1 j1];
      end
    end
end
%--------------------------------------------------------------------------
Ix =[];
Iy =[];
ix = 1;
iy = 1;
for k = 1:length(xym(:,1))
      i1 = xym(k,1);
      j1 = xym(k,2);
      i2 = xym(k,3);
      j2 = xym(k,4);
   if xym(k,5)==0
      if j1==j2% --
         for ii=i1+1:i2 
         Ix(ix,:) = [ii j1+1]; 
         ix = ix + 1;
         end
      elseif i1==i2% |
         for jj=j1+1:j2  
         Iy(iy,:) = [i1+1  jj]; 
         iy = iy + 1;
         end
      elseif (j2>j1)% /
         for i = 1:i2-i1
            Ix(ix,:) = [i1+i j1+i];    
            Iy(iy,:) = [i1+i+1 j1+i];   
            ix = ix + 1;
            iy = iy + 1;
         end
      elseif (j2<j1)% \
         for i = 1:i2-i1
            Ix(ix,:) = [i1+i  j1-i+1];    
            Iy(iy,:) = [i1+i  j1-i+1];  
            ix = ix + 1;
            iy = iy + 1;
         end 
      end
   else%circle
      pox = i1;
      poy = j1;
      R = i2;
      Q1 = j2;
      Q2 =  xym(k,5);
      [ex,ey,ex1,ey1,ex2,ey2,ex3,ey3,ex4,ey4] = circleFDTD(pox,poy,R);
      if Q1==Q2
           if Q1==1%0-90
              for n=1:R
                Ix(ix,:) = ex1(n,:);  
                Iy(iy,:) = ey1(n,:);   
                ix = ix + 1;
                iy = iy + 1;
              end
           elseif Q1==2%90-180
              for n=1:R
                Ix(ix,:) = ex2(n,:);  
                Iy(iy,:) = ey2(n,:);   
                ix = ix + 1;
                iy = iy + 1;
              end
           elseif Q1==3%180-270
              for n=1:R
                Ix(ix,:) = ex3(n,:);  
                Iy(iy,:) = ey3(n,:);   
                ix = ix + 1;
                iy = iy + 1; 
              end 
           elseif Q1==4%270-360
              for n=1:R
                Ix(ix,:) = ex4(n,:);  
                Iy(iy,:) = ey4(n,:);   
                ix = ix + 1;
                iy = iy + 1;
              end 
           end
       elseif ((Q1==1 & Q2==2) |  (Q1==2 & Q2==1))
            for n=1:R
                Ix(ix,:) = ex1(n,:);  
                Iy(iy,:) = ey1(n,:);   
                ix = ix + 1;
                iy = iy + 1;
            end
            for n=1:R
                Ix(ix,:) = ex2(n,:);  
                Iy(iy,:) = ey2(n,:);   
                ix = ix + 1;
                iy = iy + 1;
             end
       elseif ((Q1==1 & Q2==3) |  (Q1==3 & Q2==1))
            for n=1:R
                Ix(ix,:) = ex1(n,:);  
                Iy(iy,:) = ey1(n,:);   
                ix = ix + 1;
                iy = iy + 1;
            end
            for n=1:R
                Ix(ix,:) = ex2(n,:);  
                Iy(iy,:) = ey2(n,:);   
                ix = ix + 1;
                iy = iy + 1;
             end
            for n=1:R
                Ix(ix,:) = ex3(n,:);  
                Iy(iy,:) = ey3(n,:);   
                ix = ix + 1;
                iy = iy + 1; 
            end 
       elseif ((Q1==1 & Q2==4) |  (Q1==4 & Q2==1))%full circle  
              for n=1:length(ex(:,1))  
                Ix(ix,:) = ex(n,:);  
                Iy(iy,:) = ey(n,:);   
                ix = ix + 1;
                iy = iy + 1;
              end
       elseif ((Q1==2 & Q2==3) |  (Q1==3 & Q2==2))
             for n=1:R
                Ix(ix,:) = ex2(n,:);  
                Iy(iy,:) = ey2(n,:);   
                ix = ix + 1;
                iy = iy + 1;
             end
             for n=1:R
                Ix(ix,:) = ex3(n,:);  
                Iy(iy,:) = ey3(n,:);   
                ix = ix + 1;
                iy = iy + 1; 
             end 
       elseif ((Q1==2 & Q2==4) |  (Q1==4 & Q2==2))
            for n=1:R
                Ix(ix,:) = ex2(n,:);  
                Iy(iy,:) = ey2(n,:);   
                ix = ix + 1;
                iy = iy + 1;
            end
            for n=1:R
                Ix(ix,:) = ex3(n,:);  
                Iy(iy,:) = ey3(n,:);   
                ix = ix + 1;
                iy = iy + 1;
             end
            for n=1:R
                Ix(ix,:) = ex4(n,:);  
                Iy(iy,:) = ey4(n,:);   
                ix = ix + 1;
                iy = iy + 1; 
            end 
       elseif ((Q1==3 & Q2==4) |  (Q1==4 & Q2==3))
            for n=1:R
                Ix(ix,:) = ex3(n,:);  
                Iy(iy,:) = ey3(n,:);   
                ix = ix + 1;
                iy = iy + 1;
            end
            for n=1:R
                Ix(ix,:) = ex4(n,:);  
                Iy(iy,:) = ey4(n,:);   
                ix = ix + 1;
                iy = iy + 1; 
            end 
       end
%--------------------------------------------------------------------------     
   end
end
%--------------------------------------------------------------------------

function [Eps,Cond] = EpsCondFDTD(I,J,xyp)

Eps = ones(I,J);%permissividade relativa do vacuo
Cond = zeros(I,J);%condutividade eletrica

for n = 1:length(xyp(:,1))
    x1 = xyp(n,1);
    y1 = xyp(n,2);
    x2 = xyp(n,3);
    y2 = xyp(n,4);
    x3 = xyp(n,5);
    y3 = xyp(n,6);
    x4 = xyp(n,7);
    y4 = xyp(n,8);
    per = xyp(n,9);
    cond = xyp(n,10);
    if (x3==x4 & y3==y4)%triangle
       if (x2>x1 & x3==x2)%triangle _| x2
           j = y2 + 1;
           for i=1:x2-x1
              Eps(x1+i:x2,j) = per;  
              Cond(x1+i:x2,j) = cond; 
              j = j + 1;
           end
       elseif (x1==x3 & y2==y3)%triangle :- 
           j = y3;
           for i=1:x2-x1
              Eps(x1+1:x2-i+1,j) = per;  
              Cond(x1+1:x2-i+1,j) = cond; 
              j = j -1;
           end 
       elseif (x1==x2)%triangle -: 
           j = y3;
           for i=1:x2-x3
              Eps(x3+i:x2,j) = per;  
              Cond(x3+i:x2,j) = cond; 
              j = j - 1;
           end 
       elseif(y2==y1 & x3==x1)%triangle |_ 
           j = y2 + 1;
           for i=1:x2-x1
              Eps(x1+1:x2-i+1,j) = per;  
              Cond(x1+1:x2-i+1,j) = cond; 
              j = j + 1;
           end
       end
    elseif (y3==0 & x4==0 & y4==0)%circle
       R = x2; 
       Q1 = y2;
       Q2 = x3;
       [ex,ey,ex1,ey1,ex2,ey2,ex3,ey3,ex4,ey4] = circleFDTD(x1,y1,R); 
       if Q1==Q2
           if Q1==1%0-90
              pl = min(ex1(:,1));
              for n=1:R
                Eps(pl:ey1(n,1)-1,ey1(n,2)) = per;  
                Cond(pl:ey1(n,1)-1,ey1(n,2)) = cond; 
              end
           elseif Q1==2%90-180
              pl = max(ex2(:,1));
              for n=1:R
                Eps(ey2(n,1):pl,ey2(n,2)) = per;  
                Cond(ey2(n,1):pl,ey2(n,2)) = cond; 
              end
           elseif Q1==3%180-270
              pl = max(ex3(:,1));
              for n=1:R
                Eps(ey3(n,1):pl,ey3(n,2)) = per;  
                Cond(ey3(n,1):pl,ey3(n,2)) = cond; 
              end 
           elseif Q1==4%270-360
              pl = min(ex4(:,1));
              for n=1:R
                Eps(pl:ey4(n,1)-1,ey4(n,2)) = per;  
                Cond(pl:ey4(n,1)-1,ey4(n,2)) = cond; 
              end 
           end
       elseif ((Q1==1 & Q2==2) |  (Q1==2 & Q2==1))
            pl = min(ex1(:,1));
            for n=1:R
                Eps(pl:ey1(n,1)-1,ey1(n,2)) = per;  
                Cond(pl:ey1(n,1)-1,ey1(n,2)) = cond; 
            end
            pl = max(ex2(:,1));
            for n=1:R
                Eps(ey2(n,1):pl,ey2(n,2)) = per;  
                Cond(ey2(n,1):pl,ey2(n,2)) = cond; 
             end
       elseif ((Q1==1 & Q2==3) |  (Q1==3 & Q2==1))
            pl = min(ex1(:,1));
            for n=1:R
                Eps(pl:ey1(n,1)-1,ey1(n,2)) = per;  
                Cond(pl:ey1(n,1)-1,ey1(n,2)) = cond; 
            end
            pl = max(ex2(:,1));
            for n=1:R
                Eps(ey2(n,1):pl,ey2(n,2)) = per;  
                Cond(ey2(n,1):pl,ey2(n,2)) = cond; 
            end
            pl = max(ex3(:,1));
            for n=1:R
                Eps(ey3(n,1):pl,ey3(n,2)) = per;  
                Cond(ey3(n,1):pl,ey3(n,2)) = cond; 
            end 
       elseif ((Q1==1 & Q2==4) |  (Q1==4 & Q2==1))%full circle  
            pl = min(ex1(:,1));
            for n=1:R
                Eps(pl:ey1(n,1)-1,ey1(n,2)) = per;  
                Cond(pl:ey1(n,1)-1,ey1(n,2)) = cond; 
            end
            pl = max(ex2(:,1));
            for n=1:R
                Eps(ey2(n,1):pl,ey2(n,2)) = per;  
                Cond(ey2(n,1):pl,ey2(n,2)) = cond; 
            end
            pl = max(ex3(:,1));
            for n=1:R
                Eps(ey3(n,1):pl,ey3(n,2)) = per;  
                Cond(ey3(n,1):pl,ey3(n,2)) = cond; 
            end 
            pl = min(ex4(:,1));
            for n=1:R
                Eps(pl:ey4(n,1)-1,ey4(n,2)) = per;  
                Cond(pl:ey4(n,1)-1,ey4(n,2)) = cond; 
            end 
       elseif ((Q1==2 & Q2==3) |  (Q1==3 & Q2==2))
            pl = max(ex2(:,1));
            for n=1:R
                Eps(ey2(n,1):pl,ey2(n,2)) = per;  
                Cond(ey2(n,1):pl,ey2(n,2)) = cond; 
            end
            pl = max(ex3(:,1));
            for n=1:R
                Eps(ey3(n,1):pl,ey3(n,2)) = per;  
                Cond(ey3(n,1):pl,ey3(n,2)) = cond; 
            end            
       elseif ((Q1==2 & Q2==4) |  (Q1==4 & Q2==2))
            pl = max(ex2(:,1));
            for n=1:R
                Eps(ey2(n,1):pl,ey2(n,2)) = per;  
                Cond(ey2(n,1):pl,ey2(n,2)) = cond; 
            end
            pl = max(ex3(:,1));
            for n=1:R
                Eps(ey3(n,1):pl,ey3(n,2)) = per;  
                Cond(ey3(n,1):pl,ey3(n,2)) = cond; 
            end 
            pl = min(ex4(:,1));
            for n=1:R
                Eps(pl:ey4(n,1)-1,ey4(n,2)) = per;  
                Cond(pl:ey4(n,1)-1,ey4(n,2)) = cond; 
            end 
       elseif ((Q1==3 & Q2==4) |  (Q1==4 & Q2==3))
            pl = max(ex3(:,1));
            for n=1:R
                Eps(ey3(n,1):pl,ey3(n,2)) = per;  
                Cond(ey3(n,1):pl,ey3(n,2)) = cond; 
            end 
            pl = min(ex4(:,1));
            for n=1:R
                Eps(pl:ey4(n,1)-1,ey4(n,2)) = per;  
                Cond(pl:ey4(n,1)-1,ey4(n,2)) = cond; 
            end 
       end
    else%box
      Eps(x1+1:x2,y1+1:y3) = per;
      Cond(x1+1:x2,y1+1:y3) = cond;
    end
end


function [ex,ey,ex1,ey1,ex2,ey2,ex3,ey3,ex4,ey4] = circleFDTD(pox,poy,R)
%--------------------------------------------------------------------------
%R -> radius of the circle, nr of cells, must be >= 3 
%pox poy -> position [x,y] of the circle center 
%--------------------------------------------------------------------------

D = 1;

%horizontal intersection
for n=1:R-1
  angl(n) =  asind(n*D/R);
  r(n) = R*cosd(angl(n));
end
%rounding
r = round(r*10000)/10000;
rr = [];
for n=1:length(r)
  if find(r==n)
  else    
   rr = [rr n];
  end
end
rv = sort([rr r]);
rh = -sort(-[rr r]);

RD = R;
x1 = R;%horizontal point
x2 = rh(1);%horizontal point
y1 = rv(1);%vertical point
y2 = 0;
f = 1;

i = 1;
j = 1;

for k = 1:R
    aux = x2 - (RD - D);
    A2(k) = (x1 - x2)*(y1-y2)/2 + (aux)*(y1-y2);
    A1(k) = D*D - A2(k);
    AP(k,1:2) = [i j];%position of the area
  if (aux > 0)
      if f==0
       A1(k) = (x1 - x2)*(y1-y2)/2;
       A2(k) = D*D - A1(k);
       f=1;   
      end
  elseif (aux == 0)%cross vertical line
      RD = RD - D; 
      f=0;
      i = i + 1;
      j = j - 1;
  end
    x1 = x2;
    x2 = rh(k+1);
    y2 = y1;
    y1 = rv(k+1);
    j = j +1;
    int1 = x1 - round(x1);
    int2 = y2 - round(y2);
    if int1==0 & int2==0%cross a point xy in the mesh
        j = j + 1;
    end
end

ex = [];
ey = [];

f=0;
n=1;
i = 1;
j = 1;
while n<R
   if f==0
     if A1(n)< A2(n)
       ey = [ey; i j];
     elseif A1(n) >= A2(n)
       ex = [ex; i j];
       i = i + 1;
       ey = [ey; i j];
       f=1;
     end
   elseif f==1
       ey = [ey; i j];
   end
    j = j + 1;
    n = n + 1;
    if AP(n,1)- AP(n-1,1)  > 0 
     f = 0;
     if AP(n,2)- AP(n-1,2) == 0
       n = n + 1;
     end
    end
end
if AP(R,1) - AP(R-1,1)==0%correct if the last 2 areas are in the same colum
  ex = [ex; i j];  
end

c = R*sind(45);
mn = fix(c);

px = R - mn;
mx = ceil(c);
mxey = length(ey(:,1));
mxex = length(ex(:,1));

if ey(mxey,1)==px & ey(mxey,2)==mx%correct | - final if necessary
  ey = ey; 
else
  mxey = max(find(ey(:,1)==mxex));
  ey = ey(1:mxey,:);
end

%45 to 90 degrees
ney = length(ey(:,1)); 
nex = length(ex(:,1));

ex22 = sort((R+2-ey(:,1)));
ex11 = (ex(nex,1)+1:R)';
ex = [ex; ex11 ex22];

ey22 = (ey(ney,2)+1:R)';
ey11(1) = ey(ney,1)+1;
if nex == 1
ey = [ey; ey11 ey22];
else
  for n=2:nex
     ey11(n) = ey11(n-1) + ex(nex-n+2,2) - ex(nex-n+1,2);     
  end
  ey = [ey; ey11' ey22]; 
end

%90 to 180 degrees   
ey = sortrows([ey; (2*R+2-ey(:,1)) ey(:,2)],1);
ex = sortrows([ex; (2*R:-1:R+1)' ex(:,2)],1);   
%180 to 360   
ey(:,2) = ey(:,2)+ poy; 
aux = -ey(:,2)+2*poy+1;
ey = [ey; ey(:,1) aux];
ey(:,1) = ey(:,1)+pox-R;

ex(:,2) = ex(:,2)+ poy;
aux = -ex(:,2)+2*poy+2;
ex = [ex; ex(:,1) aux];
ex(:,1) = ex(:,1)+pox-R;

% ex = abs(ex);
% ey = abs(ey);
%0 - 90 
ex1(1:R,:) = ex(R+1:2*R,:);
ey1(1:R,:) = ey(R+1:2*R,:);
%90 - 180 
ex2(1:R,:) = ex(1:R,:);
ey2(1:R,:) = ey(1:R,:);
%180 - 270 
ex3(1:R,:) = ex(2*R+1:3*R,:);
ey3(1:R,:) = ey(2*R+1:3*R,:);
%270 - 360 
ex4(1:R,:) = ex(3*R+1:4*R,:);
ey4(1:R,:) = ey(3*R+1:4*R,:);


function [E, EX, EY, HZ] = FDTD2D_TE_MB(I,J,Tp,TypeExc,xyExc,xyp,xym)
%--------------------------------------------------------------------------
%Field calculation for electromagnetic waves in two dimensions using FDTD 
%Transverse Electric  propagation - TE [Ex Ey Hz]
%Metallic boundaries - box
%E = module of Electric field
%--------------------------------------------------------------------------
%I = Nr of cells on x direction
%J = Nr of cells on y direction
%
%Tp = [Nr_it   EH  Pbp Nr_it_plot]
%      Nr_it = number of iteractions (obs.: use just the Nr_it enougth to have
%            a stable result higher Nr can generate instable results due to the PML)
%      EH = 1 to plot E, 2 to Ex, 3 to Ey, and 4 to Hz
%      Pbp = plot boundaries and properties
%          0 - none, 1 - Metallic, 2 - Properties, 3 - Metallic and Properties
%      Nr_it_plot = plot new figure after Nr iteractions (Default-> none)
%
%TypeExc = [SP EH f], SP = 1 Sine excitation
%                     SP = 2 Gaussian Pulse excitation
%                     EH = 1 for excite in Electric field [Ex Ey]
%                     EH = 2 for excite in Magnetic field [Hz]
%                     f <= 1GHz [1e9], freq. to sine excitation
%                     Defaul - TypeExc = [2 2]
%
%xyExc = [x1 y1 x2 y2], excitation points over a line defined by 2 points,
%     must be vertical(Ey) or horizontal(Ex) (0 <= x <= I, 0 <= y <= J,entire values)
%     xyExc can have any nr. of arrows. Defaul = [0 0 1 0], point in the first cell
%
%xyp = [x1 y1 x2 y2 x3 y3 x4 y4 Eps Cond], media properties, four points a box
%     for triangle use x3 = x4 and y3 = y4, it MUST always be isosceles
%     (same number of CELLS on x and y direction) with a rigth angle (ex. |_ ) 
%     points(x,y) MUST always be anti-clokwise direction starting from the lowest y
%     and after the lowest (xmin,ymin) 
%     For circle xyp = [pox poy R Q1 Q2 0 0 0 Eps Cond]
%        pox poy -> position [x,y] of the circle center
%        R -> radius of the circle, nr of cells, must be >= 3 
%        Q1 and Q2 (1 = [0-90], 2 = [90-180], 3 = [180-270], 4 = [270][360])
%        if Q1=Q2 just one quarter of circle is assigned
%        for a complete circle Q1 = 1 and Q2 = 4; The properties are
%        assigned in anti-clock wise
%     The values are assigned in descendent order (first element to last one)
%     elements not assigned will have Eps = 1 and Cond = 0
%
%         3   3      3 --2   3 --2   4-----3
%       / |   | \     \  |   |  /    |     |
%      /  |   |  \     \ |   | /     |     |
%     1 --2   1 --2      1   1       1-----2
%
%Eps -> relative electric permittivity inside the xyp area 
%Cond-> electric conductivity inside the xyp area
%       xyp can have any nr. of arrows. Default values are Eps = 1 and Cond = 0
%
%xym = [x1 y1 x2 y2 0], perfect metalic boundary condictions,
%    a line defined by 2 points, can be vertical, horizontal or tilt,
%    if tilt it MUST always have the same number of CELLS on x and y direction)
%    For a circle xyp = [pox poy R Q1 Q2], same definition used for xyp
%    Default any one
%--------------------------------------------------------------------------

I = I + 1;
J = J + 1;

T = Tp(1);
Pbp = Tp(3);
Plo = 1;
if length(Tp)>3
  Plo = Tp(4):Tp(4):T;%plot after Tp(4) iteractions  
end

if nargin < 5, xyExc = [0 0 1 0]; end 
if nargin < 4, TypeExc = [2 2];   end 

if nargin>5%assign the properties values
 [Eps,Cond] = EpsCondFDTD(I,J,xyp);
else
 Eps = ones(I,J);%permissividade relativa do vacuo
 Cond = zeros(I,J);%condutividade eletrica
end%nargin

if nargin>6 %localize the position of metal 
[Ix,Iy] = metalFDTD(xym);
end

%correct xyExc -> rigth to left coordenates - down - up
for k = 1:length(xyExc(:,1))
    i1 = xyExc(k,1);
    j1 = xyExc(k,2);
    i2 = xyExc(k,3);
    j2 = xyExc(k,4);
    if i1>i2 %j1=j2
        xyExc(k,1:4)= [i2 j1 i1 j2];
    elseif j1>j2 %i1=i2
        xyExc(k,1:4)= [i1 j2 i2 j1];
    end
end
%--------------------------------------------------------------------------
u_o = 4*pi*1e-7; %permeabilidade magntica do vcuo
e_o = 8.854e-12; %permissvidade eltrica do vcuo	
c = 1/(sqrt(u_o*e_o)); %velocidade da luz no vcuo
% lamb = c/f;
% D = lamb/11;%Delta (largura, altura da clula FDTD)
D = 0.0273;%Delta fixo f<=1GHz
D_t = 0.5*D/(sqrt(2)*c); %Delta t (espao temporal)
Eps = e_o*Eps;
%-----------------------------------------------------------------------
if length(TypeExc)>2
    f = TypeExc(3);
    if f>1e9%correct f if > 1e9
        f=1e9;
    end
end   

if TypeExc(1)==1
t = 1:T;
Exc = 1000*sin(2*pi*f*D_t*(t-1));
end
if TypeExc(1)==2
t = 0:D_t:T*D_t-D_t;
Ds = 50*D_t;%deslocamento do pulso (D=0 centrado em t=0)
L = 40*D_t;%largura do pulso gaussiano
Exc = 1000*exp(-18*((t-Ds)/L).^2);
end
% plot(Exc)
%-----------------------------------------------------------------------
%Inicializao das variveis de campo - Modo TE
%Incluindo condies de contorno
%-----------------------------------------------------------------------
Hz = zeros(I,J); Ex = zeros(I,J+1); Ey = zeros(I+1,J);
%-----------------------------------------------------------------------
%variveis auxiliares
%Ex
for i=1:I 
  for j=2:J
      Cond_med =(Cond(i,j) + Cond(i,j-1))/2;
      Eps_med = (Eps(i,j) + Eps(i,j-1))/2;
      Aex(i,j) = (1 - (Cond_med*D_t/(2*Eps_med)))/(1 + (Cond_med*D_t/(2*Eps_med)));
      Bex(i,j) = (D_t/(Eps_med*D))/(1 + (Cond_med*D_t/(2*Eps_med)));
  end
end
%Ey
for i=2:I
  for j=1:J
      Cond_med =(Cond(i,j) + Cond(i-1,j))/2;
      Eps_med = (Eps(i,j) + Eps(i-1,j))/2;
      Aey(i,j) = (1 - (Cond_med*D_t/(2*Eps_med)))/(1 + (Cond_med*D_t/(2*Eps_med)));
      Bey(i,j) = (D_t/(Eps_med*D))/(1 + (Cond_med*D_t/(2*Eps_med)));
  end
end
B = D_t/(u_o*D);
%-----------------------------------------------------------------------
p = 1;
%Calculo dos campos
for t=1:T
   %----------------------------------------------------------------------
   %Clculo de Ex
   for i=1:I
      for j=2:J
         Ex(i,j) = Aex(i,j)*Ex(i,j) + Bex(i,j)*(Hz(i,j) - Hz(i,j-1));
      end
   end
   %Clculo de Ey
   for i=2:I
      for j=1:J
         Ey(i,j) = Aey(i,j)*Ey(i,j) - Bey(i,j)*(Hz(i-1,j) - Hz(i,j));
      end
   end
   %-----------------------------------------------------------------------
   %condicoes de contorno para objetos metalicos 
   if nargin>6
      if Ix 
        for k = 1:length(Ix(:,1))
          Ex(Ix(k,1),Ix(k,2))=0;  
        end
      end
      if Iy
        for k = 1:length(Iy(:,1))
          Ey(Iy(k,1),Iy(k,2))=0;    
        end
      end
   end
   %-----------------------------------------------------------------------
   %excitation
   if TypeExc(2)==1
     for k = 1:length(xyExc(:,1))
      i1 = xyExc(k,1);
      j1 = xyExc(k,2);
      i2 = xyExc(k,3);
      j2 = xyExc(k,4);
        if j1==j2% --
          Ex(i1+1:i2,j1+1) = Ex(i1+1:i2,j1+1) + Exc(t);
        elseif i1==i2% |
          Ey(i1+1,j1+1:j2) = Ey(i1+1,j1+1:j2) + Exc(t);  
        end
     end
   end
   %-----------------------------------------------------------------------
   %Clculo de Hz
   for i=1:I
      for j=1:J
         Hz(i,j) = Hz(i,j) + B*(Ex(i,j+1) - Ex(i,j) - Ey(i,j) + Ey(i+1,j));
      end
   end
   %-----------------------------------------------------------------------
   %excitation
   if TypeExc(2)==2
     for k = 1:length(xyExc(:,1))
       i1 = xyExc(k,1);
       j1 = xyExc(k,2);
       i2 = xyExc(k,3);
       j2 = xyExc(k,4);
       if j1==j2% --
          Hz(i1+1:i2,j1+1) = Hz(i1+1:i2,j1+1) + Exc(t);
       elseif i1==i2% |
          Hz(i1+1,j1+1:j2) = Hz(i1+1,j1+1:j2) + Exc(t);  
       end
     end
   end
   %-----------------------------------------------------------------------
   if (length(Tp)>3 & length(Plo)>=p)%plot after Tp(4) iteraction
      if Plo(p) == t
          if Tp(2)==1
              EX(1:I,1:J) = (Ex(1:I,1:J) +  Ex(1:I,2:J+1))/2;              
              EY(1:I,1:J) = (Ey(1:I,1:J) +  Ey(2:I+1,1:J))/2; 
              E = (EX.^2 + EY.^2).^0.5;
              MM(p,1:I,1:J) = E(1:I,1:J);  
          elseif Tp(2)==2
              EX(1:I,1:J) = (Ex(1:I,1:J) +  Ex(1:I,2:J+1))/2; 
              MM(p,1:I,1:J) = EX(1:I,1:J);  
          elseif Tp(2)==3
              EY(1:I,1:J) = (Ey(1:I,1:J) +  Ey(2:I+1,1:J))/2;
              MM(p,1:I,1:J) = EY(1:I,1:J);  
          elseif Tp(2)==4
              MM(p,1:I,1:J) = Hz(1:I,1:J);  
          end
            p = p + 1;
      end
   end  
   %-----------------------------------------------------------------------
end%T
%-----------------------------------------------------------------------
EX(1:I,1:J) = (Ex(1:I,1:J) +  Ex(1:I,2:J+1))/2;              
EY(1:I,1:J) = (Ey(1:I,1:J) +  Ey(2:I+1,1:J))/2; 
E = (EX.^2 + EY.^2).^0.5;
HZ = Hz;
%-----------------------------------------------------------------------
xx = 0:I-1;
yy = 0:J-1;
aux=0;
figure(1)
if Tp(2)==1
  Mx = max(max(E));
  Mn = min(min(E));  
elseif Tp(2)==2
  Mx = max(max(EX));
  Mn = min(min(EX));  
elseif Tp(2)==3
 Mx = max(max(EY));
 Mn = min(min(EY));   
elseif Tp(2)==4
 Mx = max(max(HZ));
 Mn = min(min(HZ));   
end

for n=1:length(Plo)
    figure(1)
    if length(Tp)>3
      AUX(1:I,1:J) = MM(n,1:I,1:J);
      pcolor(xx,yy,AUX')
      time = int2str(Plo(n));  
    else
      time = int2str(T);  
       if Tp(2)==1
          pcolor(xx,yy,E')
       elseif Tp(2)==2
          pcolor(xx,yy,EX') 
       elseif Tp(2)==3
          pcolor(xx,yy,EY')  
       elseif Tp(2)==4
          pcolor(xx,yy,HZ')  
       end
    end
    figure(1)
    shading flat
    axis equal
    colormap(jet(200))
    caxis([Mn Mx]);title(['Wave Propagation Mode TE, Time Step = ', time])
    axis([0 I-1 0 J-1]); xlabel('i'); ylabel('j') 
    hold on
    %plot boundary conditions
   if Pbp==1 | Pbp==3
    if nargin>6
    for kk = 1:length(xym(:,1))
       i1 = xym(kk,1);
       j1 = xym(kk,2);
       i2 = xym(kk,3);
       j2 = xym(kk,4);
       if xym(kk,5)==0   
            for k = 1:length(xym(:,1))
               plot([i1 i2],[j1 j2],'k','LineWidth',1)
            end
       else
        pox = i1;
        poy = j1;
        R = i2;
        Q1 = j2;
        Q2 =  xym(kk,5);
          if Q1==Q2
                if Q1==1%0-90
                   theta = linspace(0,pi/2,30);
                elseif Q1==2%90-180
                   theta = linspace(pi/2,pi,30);
                elseif Q1==3%180-270
                    theta = linspace(pi,3*pi/2,30);
                elseif Q1==4%270-360
                    theta = linspace(3*pi/2,2*pi,30);
                end
           elseif ((Q1==1 & Q2==2) |  (Q1==2 & Q2==1))
              theta = linspace(0,pi,30);
           elseif ((Q1==1 & Q2==3) |  (Q1==3 & Q2==1))
              theta = linspace(0,3*pi/2,30);
           elseif ((Q1==1 & Q2==4) |  (Q1==4 & Q2==1))%full circle  
              theta = linspace(0,2*pi,30);
           elseif ((Q1==2 & Q2==3) |  (Q1==3 & Q2==2))
              theta = linspace(pi/2,3*pi/2,30);
           elseif ((Q1==2 & Q2==4) |  (Q1==4 & Q2==2))
              theta = linspace(pi/2,2*pi,30);
           elseif ((Q1==3 & Q2==4) |  (Q1==4 & Q2==3))
              theta = linspace(pi,2*pi,30);
           end
       rho = R;
       [x,y] = pol2cart(theta,rho);
       plot(x+pox,y+poy,'k','LineWidth',1)
       end
    end   
    end
   end 
    
   %plot properties
if Pbp==2 | Pbp==3
for n = 1:length(xyp(:,1))
    figure(1)
    x1 = xyp(n,1);
    y1 = xyp(n,2);
    x2 = xyp(n,3);
    y2 = xyp(n,4);
    x3 = xyp(n,5);
    y3 = xyp(n,6);
    x4 = xyp(n,7);
    y4 = xyp(n,8);
     if (x3==x4 & y3==y4)%triangle
        if (x2>x1 & x3==x2)%triangle _| x2
           plot([x1 x2],[y1 y2],'b','LineWidth',1)
           plot([x2 x3],[y2 y3],'b','LineWidth',1)
           plot([x1 x3],[y1 y3],'b','LineWidth',1)
        elseif (x1==x3 & y2==y3)%triangle :- 
           plot([x1 x3],[y1 y3],'b','LineWidth',1)
           plot([x2 x4],[y2 y4],'b','LineWidth',1)
           plot([x1 x2],[y1 y2],'b','LineWidth',1)
        elseif (x1==x2)%triangle -: 
           plot([x1 x2],[y1 y2],'b','LineWidth',1)
           plot([x2 x3],[y2 y3],'b','LineWidth',1)
           plot([x3 x1],[y3 y1],'b','LineWidth',1)
        elseif(y2==y1 & x3==x1)%triangle |_ 
           plot([x1 x2],[y1 y2],'b','LineWidth',1)
           plot([x2 x3],[y2 y3],'b','LineWidth',1)
           plot([x3 x1],[y3 y1],'b','LineWidth',1)
        end
    elseif (y3==0 & x4==0 & y4==0)%circle
        pox = x1;
        poy = y1;
        R = x2;
        Q1 = y2;
        Q2 =  x3;
        if Q1==Q2
          if Q1==1%0-90
            theta = linspace(0,pi/2,30);
            plot([x1 x1+R],[y1 y1],'b','LineWidth',1)
            plot([x1 x1],[y1 y1+R],'b','LineWidth',1)
          elseif Q1==2%90-180
            theta = linspace(pi/2,pi,30);
            plot([x1 x1-R],[y1 y1],'b','LineWidth',1)
            plot([x1 x1],[y1 y1+R],'b','LineWidth',1)
          elseif Q1==3%180-270
            theta = linspace(pi,3*pi/2,30);
            plot([x1 x1-R],[y1 y1],'b','LineWidth',1)
            plot([x1 x1],[y1 y1-R],'b','LineWidth',1)
          elseif Q1==4%270-360
            theta = linspace(3*pi/2,2*pi,30);
            plot([x1 x1+R],[y1 y1],'b','LineWidth',1)
            plot([x1 x1],[y1 y1-R],'b','LineWidth',1)
          end
        elseif ((Q1==1 & Q2==2) |  (Q1==2 & Q2==1))
           theta = linspace(0,pi,30);
           plot([x1-R x1+R],[y1 y1],'b','LineWidth',1)
        elseif ((Q1==1 & Q2==3) |  (Q1==3 & Q2==1))
           theta = linspace(0,3*pi/2,30);
           plot([x1 x1+R],[y1 y1],'b','LineWidth',1)
           plot([x1 x1],[y1 y1-R],'b','LineWidth',1)
        elseif ((Q1==1 & Q2==4) |  (Q1==4 & Q2==1))%full circle  
           theta = linspace(0,2*pi,30);
        elseif ((Q1==2 & Q2==3) |  (Q1==3 & Q2==2))
           theta = linspace(pi/2,3*pi/2,30);
           plot([x1 x1],[y1+R y1-R],'b','LineWidth',1)
        elseif ((Q1==2 & Q2==4) |  (Q1==4 & Q2==2))
           theta = linspace(pi/2,2*pi,30);
        elseif ((Q1==3 & Q2==4) |  (Q1==4 & Q2==3))
           theta = linspace(pi,2*pi,30);
           plot([x1-R x1+R],[y1 y1],'b','LineWidth',1)
        end
        rho = R;
        [x,y] = pol2cart(theta,rho);
        plot(x+pox,y+poy,'b','LineWidth',1)
    else%box
       plot([x1 x2],[y1 y2],'b','LineWidth',1);figure(1)
       plot([x2 x3],[y2 y3],'b','LineWidth',1)
       plot([x3 x4],[y3 y4],'b','LineWidth',1)
       plot([x4 x1],[y4 y1],'b','LineWidth',1)
    end
end
end
  
pause(0.1)
end 
figure(1)
hold off

function [E, EX, EY, HZ] = FDTD2D_TE_PML(I,J,Tp,TypeExc,xyExc,xyp,xym)
%--------------------------------------------------------------------------
%Field calculation for electromagnetic waves in two dimensions using FDTD 
%Transverse Electric  propagation - TE [Ex Ey Hz]
%absorbation boundary condition - PML 
%E = module of Electric field
%--------------------------------------------------------------------------
%I = Nr of cells on x direction
%J = Nr of cells on y direction
%
%Tp = [Nr_it   EH   Pbp   Nr_it_plot]
%      Nr_it = number of iteractions (obs.: use just the Nr_it enougth to have
%            a stable result higher Nr can generate instable results due to the PML)
%      EH = 1 to plot E, 2 to Ex, 3 to Ey, and 4 to Hz
%      Pbp = plot boundaries and properties
%          0 - none, 1 - Metallic, 2 - Properties, 3 - Metallic and
%          Properties
%      Nr_it_plot = plot new figure after Nr iteractions (Default-> none)
%
%TypeExc = [SP EH f], SP = 1 Sine excitation
%                     SP = 2 Gaussian Pulse excitation
%                     EH = 1 for excite in Electric field [Ex Ey]
%                     EH = 2 for excite in Magnetic field [Hz]
%                     f <= 1GHz [1e9], freq. to sine excitation
%                     Defaul - TypeExc = [2 2]
%
%xyExc = [x1 y1 x2 y2], excitation points over a line defined by 2 points,
%     must be vertical(Ey) or horizontal(Ex) (0 <= x <= I, 0 <= y <= J,entire values)
%     xyExc can have any nr. of arrows. Defaul = [0 0 1 0], point in the first cell
%
%xyp = [x1 y1 x2 y2 x3 y3 x4 y4 Eps Cond], media properties, four points a box
%     for triangle use x3 = x4 and y3 = y4, it MUST always be isosceles
%     (same number of CELLS on x and y direction) with a rigth angle (ex. |_ ) 
%     points(x,y) MUST always be anti-clokwise direction starting from the lowest y
%     and after the lowest (xmin,ymin) 
%     For circle xyp = [pox poy R Q1 Q2 0 0 0 Eps Cond]
%        pox poy -> position [x,y] of the circle center
%        R -> radius of the circle, nr of cells, must be >= 3 
%        Q1 and Q2 (1 = [0-90], 2 = [90-180], 3 = [180-270], 4 = [270][360])
%        if Q1=Q2 just one quarter of circle is assigned
%        for a complete circle Q1 = 1 and Q2 = 4; The properties are
%        assigned in anti-clock wise
%     The values are assigned in descendent order (first element to last one)
%     elements not assigned will have Eps = 1 and Cond = 0
%
%         3   3      3 --2   3 --2   4-----3
%       / |   | \     \  |   |  /    |     |
%      /  |   |  \     \ |   | /     |     |
%     1 --2   1 --2      1   1       1-----2
%
%Eps -> relative electric permittivity inside the xyp area 
%Cond-> electric conductivity inside the xyp area
%       xyp can have any nr. of arrows. Default values are Eps = 1 and Cond = 0
%
%xym = [x1 y1 x2 y2 0], perfect metalic boundary condictions,
%    a line defined by 2 points, can be vertical, horizontal or tilt,
%    if tilt it MUST always have the same number of CELLS on x and y direction)
%    For a circle xyp = [pox poy R Q1 Q2], same definition used for xyp
%    Default any one
%--------------------------------------------------------------------------

I = I + 1;
J = J + 1;

T = Tp(1);
Pbp = Tp(3);
Plo = 1;
if length(Tp)>3
  Plo = Tp(4):Tp(4):T;%plot after Tp(4) iteractions  
end

if nargin < 5, xyExc = [0 0 1 0]; end 
if nargin < 4, TypeExc = [2 2];   end 

if nargin>5%assign the properties values
 [Eps,Cond] = EpsCondFDTD(I,J,xyp);
else
 Eps = ones(I,J);%permissividade relativa do vacuo
 Cond = zeros(I,J);%condutividade eletrica
end%nargin
%--------------------------------------------------------------------------
if nargin>6 %localize the position of metal 
[Ix,Iy] = metalFDTD(xym);
end
% if nargin>6
% for k = 1:length(xym(:,1))
%     i1 = xym(k,1);
%     j1 = xym(k,2);
%     i2 = xym(k,3);
%     j2 = xym(k,4);
%    if i1==i2 & j1>j2%|
%        xym(k,1:4)= [i1 j2 i2 j1];
%    elseif i1>i2 & j1==j2 %--    
%        xym(k,1:4)= [i2 j1 i1 j2];
%    elseif i1>i2 & j1>j2 %/  
%        xym(k,1:4)= [i2 j2 i1 j1];
%    elseif i1>i2 & j2>j1 %\  
%       xym(k,1:4)= [i2 j2 i1 j1];
%    end
% end
% end%nargin

%correct xyExc -> rigth to left coordenates - down - up
for k = 1:length(xyExc(:,1))
    i1 = xyExc(k,1);
    j1 = xyExc(k,2);
    i2 = xyExc(k,3);
    j2 = xyExc(k,4);
    if i1>i2 %j1=j2
        xyExc(k,1:4)= [i2 j1 i1 j2];
    elseif j1>j2 %i1=i2
        xyExc(k,1:4)= [i1 j2 i2 j1];
    end
end
%************************************************************************************
%Espalhamento 2D ao ar livre excitado por seno - malha IxJ
%Usando FDTD (modo TE) com PML - Perfectly Matched Layer
%************************************************************************************
u_o = 4*pi*1e-7; %permeabilidade magntica do vcuo
e_o = 8.854e-12; %permissvidade eltrica do vcuo	
c = 1/(sqrt(u_o*e_o)); %velocidade da luz no vcuo
% lamb = c/f;
% D = lamb/11;%Delta (largura, altura da clula FDTD)
D = 0.0273;%Delta fixo f<=1GHz
D_t = 0.5*D/(sqrt(2)*c); %Delta t (espao temporal)
Eps = e_o*Eps;
%************************************************************************************
if length(TypeExc)>2
    f = TypeExc(3);
    if f>1e9%correct f if > 1e9
        f=1e9;
    end
end   

if TypeExc(1)==1
t = 1:T;
Exc = 1000*sin(2*pi*f*D_t*(t-1));
end
if TypeExc(1)==2
t = 0:D_t:T*D_t-D_t;
Ds = 50*D_t;%deslocamento do pulso (D=0 centrado em t=0)
L = 40*D_t;%largura do pulso gaussiano
Exc = 1000*exp(-18*((t-Ds)/L).^2);
end
% plot(Exc)
%************************************************************************************
%PML
R_0 = 0.0001; %fator de reflexao (0.01%)
n = 2; % variao linear(1) ou parabolica(2) da condutividade na PML
N = 10; %n_r de celulas na PML
Sig = N*D; %Sigma = espessura total da PML
ho_m = - e_o*c*log(R_0)/(2/(n+1)*Sig);%condutividade da camada + externa

HO(1) = ho_m/((n+1)*2^(n+1)*N^n);%condutividade da primeira camada L=0

i=1;
for L=1:N-1%condutividade para L inteiro -usa para Ex e Ey
   i=i+1;
   HO(i) = HO(1)*((2*L +1)^(n+1) - (2*L - 1)^(n+1));   
end

i=0;
for L=0.5:1:N-0.5%condutividade para L -> 0.5 - usa para Hzx e Hzy
   i=i+1;
   H_O(i) = HO(1)*((2*L +1)^(n+1) - (2*L - 1)^(n+1));   
end

HOm = H_O*u_o/e_o;%condutividade magntica  - usa para Hzx e Hzy
%************************************************************************************
%Inicializao das variveis de campo - Modo TE 
Ex = zeros(I+2*N,J+2*N+1);
Ey = zeros(I+2*N+1,J+2*N);
Hzxi = zeros(I+2*N,N);%matriz inferior de Hzx 
Hzxc = zeros(2*N,J);%matriz central de Hzx 
Hzxs = zeros(I+2*N,N);%matriz superior de Hzx 
Hzyi = zeros(I+2*N,N);%matriz inferior de Hyz 
Hzyc = zeros(2*N,J);%matriz inferior de Hyz 
Hzys = zeros(I+2*N,N);%matriz inferior de Hyz  
Hz = zeros(I,J); %unica variavel com indice temporal, para visualizacao c/ o passar do tempo
%variveis auxiliares
a = D_t/e_o;
b = D_t/u_o;
A = a/D;%D_t/(e_o*D);
B = b/D;%D_t/(u_o*D);
%********************************************************************************
%auxiliar variables - media
%Ex
for i=(N+1):(I+N) 
  for j=(N+2):(J+N)
      Cond_med =(Cond(i-N,j-N) + Cond(i-N,j-N-1))/2;
      Eps_med = (Eps(i-N,j-N) + Eps(i-N,j-N-1))/2;
      Aex(i,j) = (1 - (Cond_med*D_t/(2*Eps_med)))/(1 + (Cond_med*D_t/(2*Eps_med)));
      Bex(i,j) = (D_t/(Eps_med*D))/(1 + (Cond_med*D_t/(2*Eps_med)));
  end
end
%Ey
for i=(N+2):(I+N)
  for j=(N+1):(J+N)
      Cond_med =(Cond(i-N,j-N) + Cond(i-N-1,j-N))/2;
      Eps_med = (Eps(i-N,j-N) + Eps(i-N-1,j-N))/2;
      Aey(i,j) = (1 - (Cond_med*D_t/(2*Eps_med)))/(1 + (Cond_med*D_t/(2*Eps_med)));
      Bey(i,j) = (D_t/(Eps_med*D))/(1 + (Cond_med*D_t/(2*Eps_med)));
  end
end
%********************************************************************************
p = 1;
% aux = 0;
for t=1:T
   %****************************************************************************************
   %Clculo de Ex ->NO DOMINIO DE ESTUDO
   for i=(N+1):(I+N)
      for j=(N+2):(J+N)
         Ex(i,j) = Aex(i,j)*Ex(i,j) + Bex(i,j)*(Hz(i-N,j-N) - Hz(i-N,j-N-1));
      end
   end
   %****************************************************************************************
   %Clculo de Ey ->NO DOMINIO DE ESTUDO   
   for i=(N+2):(I+N)
      for j=(N+1):(J+N)
         Ey(i,j) = Aey(i,j)*Ey(i,j) - Bey(i,j)*(Hz(i-N,j-N) - Hz(i-N-1,j-N));
      end
   end
   %****************************************************************************************
   %clculo na PML
   %clculo de Ex na superfcie inferior
   for i=1:(2*N+I)
      for j=2:N
         Ex(i,j) = (1-HO(N+2-j)*a)*Ex(i,j) + A*(Hzxi(i,j) - Hzxi(i,j-1) + Hzyi(i,j) - Hzyi(i,j-1));
      end
   end
   %clculo na linha intermediaria inferior - da esquerda para a direita
   for i=1:N
      Ex(i,N+1) = (1-HO(1)*a)*Ex(i,N+1) + A*(Hzxc(i,1) - Hzxi(i,N) + Hzyc(i,1) - Hzyi(i,N));
   end
   for i=(N+1):(N+I)
      Ex(i,N+1) = (1-HO(1)*a)*Ex(i,N+1) + A*(Hz(i-N,1) - Hzxi(i,N)  - Hzyi(i,N));
   end
   for i=(N+I+1):(2*N+I)
      Ex(i,N+1) = (1-HO(1)*a)*Ex(i,N+1) + A*(Hzxc(i-I,1) - Hzxi(i,N) + Hzyc(i-I,1) - Hzyi(i,N));
   end
   %clculo de Ex no parte central esquerda - hoy = 0;
   for i=1:N
      for j=(N+2):(N+J)
         Ex(i,j) = Ex(i,j) + A*(Hzxc(i,j-N) - Hzxc(i,j-N-1) + Hzyc(i,j-N) - Hzyc(i,j-N-1));
      end
   end
   %************************************************************************************************
   %clculo de Ex no parte central direita - hoy = 0;
   for i=(N+I+1):(2*N+I)
      for j=(N+2):(N+J)
         Ex(i,j) = Ex(i,j) + A*(Hzxc(i-I,j-N) - Hzxc(i-I,j-N-1) + Hzyc(i-I,j-N) - Hzyc(i-I,j-N-1));
      end
   end
   %clculo na linha intermediaria superior - da esquerda para a direita
   for i=1:N
      Ex(i,N+J+1) = (1-HO(1)*a)*Ex(i,N+J+1) + A*(Hzxs(i,1) - Hzxc(i,J) + Hzys(i,1) - Hzyc(i,J));
   end
   for i=(N+1):(N+I)
      Ex(i,N+J+1) = (1-HO(1)*a)*Ex(i,N+J+1) + A*(Hzxs(i,1) - Hz(i-N,J) + Hzys(i,1) );
   end
   for i=(N+I+1):(2*N+I)
      Ex(i,N+J+1) = (1-HO(1)*a)*Ex(i,N+J+1) + A*(Hzxs(i,1) - Hzxc(i-I,J) + Hzys(i,1) - Hzyc(i-I,J));
   end
   %clculo de Ex na superfcie superior
   for i=1:(2*N+I)
      for j=(N+J+2):(2*N+J)
         Ex(i,j) = (1-HO(j-N-J)*a)*Ex(i,j) + A*(Hzxs(i,j-N-J) - Hzxs(i,j-N-J-1) + Hzys(i,j-N-J) - Hzys(i,j-N-J-1));
      end
   end
   %****************************************************************************************
   %clculo de Ey parte inferior esquerda p/ direita
   for i=2:(N+1) 
      for j=1:N
         Ey(i,j) = (1-HO(N-i+2)*a)*Ey(i,j) - A*(Hzxi(i,j) - Hzxi(i-1,j) + Hzyi(i,j) - Hzyi(i-1,j));
      end
   end
   for i=(N+2):(N+I) %hox=0
      for j=1:N
         Ey(i,j) = Ey(i,j) - A*(Hzxi(i,j) - Hzxi(i-1,j) + Hzyi(i,j) - Hzyi(i-1,j));
      end
   end
   for i=(N+I+1):(2*N+I) 
      for j=1:N
         Ey(i,j) = (1-HO(i-N-I)*a)*Ey(i,j) - A*(Hzxi(i,j) - Hzxi(i-1,j) + Hzyi(i,j) - Hzyi(i-1,j));
      end
   end
   %clculo de Ey na lateral esquerda
   for i=2:N 
      for j=(N+1):(N+J)
         Ey(i,j) = (1-HO(N-i+2)*a)*Ey(i,j) - A*(Hzxc(i,j-N) - Hzxc(i-1,j-N) + Hzyc(i,j-N) - Hzyc(i-1,j-N));
      end
   end
   for j=(N+1):(N+J)%linha lateral esquerda
        Ey(N+1,j) = (1-HO(1)*a)*Ey(N+1,j) - A*(Hz(1,j-N) - Hzxc(N,j-N)  - Hzyc(N,j-N));
   end
   %***************************************************************************************************************
   for j=(N+1):(N+J)%linha lateral direita
        Ey(N+I+1,j) = (1-HO(1)*a)*Ey(N+I+1,j) - A*(Hzxc(N+1,j-N) - Hz(I,j-N) + Hzyc(N+1,j-N) );
   end
   %clculo de Ey na lateral direita
   for i=(N+I+2):(2*N+I) 
      for j=(N+1):(N+J)
         Ey(i,j) = (1-HO(i-N-I)*a)*Ey(i,j) - A*(Hzxc(i-I,j-N) - Hzxc(i-I-1,j-N) + Hzyc(i-I,j-N) - Hzyc(i-I-1,j-N));
      end
   end
   %clculo de Ey parte superior esquerda p/ direita
   for i=2:(N+1) 
      for j=(N+J+1):(2*N+J)
         Ey(i,j) = (1-HO(N-i+2)*a)*Ey(i,j) - A*(Hzxs(i,j-N-J) - Hzxs(i-1,j-N-J) + Hzys(i,j-N-J) - Hzys(i-1,j-N-J));
      end
   end
   for i=(N+2):(N+I) %hox=0
      for j=(N+J+1):(2*N+J)
         Ey(i,j) = Ey(i,j) - A*(Hzxs(i,j-N-J) - Hzxs(i-1,j-N-J) + Hzys(i,j-N-J) - Hzys(i-1,j-N-J));
      end
   end
   for i=(N+I+1):(2*N+I) 
      for j=(N+J+1):(2*N+J)
         Ey(i,j) = (1-HO(i-N-I)*a)*Ey(i,j) - A*(Hzxs(i,j-N-J)- Hzxs(i-1,j-N-J) + Hzys(i,j-N-J) - Hzys(i-1,j-N-J));
      end
   end
   %-----------------------------------------------------------------------
   %condicoes de contorno para objetos metalicos 
   if nargin>6
      if Ix 
        for k = 1:length(Ix(:,1))
          Ex(N+Ix(k,1),N+Ix(k,2))=0;  
        end
      end
      if Iy
        for k = 1:length(Iy(:,1))
          Ey(N+Iy(k,1),N+Iy(k,2))=0;    
        end
      end
   end   
%  if nargin>6       
%    for k = 1:length(xym(:,1))
%       i1 = xym(k,1);
%       j1 = xym(k,2);
%       i2 = xym(k,3);
%       j2 = xym(k,4);
%       if j1==j2% --
%          Ex(N+i1+1:N+i2,N+j1+1)=0; 
%       elseif i1==i2% |
%          Ey(N+i1+1,N+j1+1:N+j2)=0;  
%       elseif (j2>j1)% /
%          for i = 1:i2-i1
%             Ex(N+i1+i,N+j1+i)=0;    
%             Ey(N+i1+i+1,N+j1+i)=0;       
%          end
%       elseif (j2<j1)% \
%          for i = 1:i2-i1
%             Ex(N+i1+i,N+j1-i+1)=0;    
%             Ey(N+i1+i,N+j1-i+1)=0;       
%          end 
%       end
%    end
%    end  
   %------------------------------------------------------------------------
   if TypeExc(2)==1
     for k = 1:length(xyExc(:,1))
      i1 = xyExc(k,1);
      j1 = xyExc(k,2);
      i2 = xyExc(k,3);
      j2 = xyExc(k,4);
        if j1==j2% --
          Ex(N+i1+1:N+i2,N+j1+1) = Ex(N+i1+1:N+i2,N+j1+1) + Exc(t);
        elseif i1==i2% |
          Ey(N+i1+1,N+j1+1:N+j2) = Ey(N+i1+1,N+j1+1:N+j2) + Exc(t);  
        end
     end
   end
   %****************************************************************************************
   %Clculo do Hzxi (i=inferior)
   for i=1:N
      for j=1:N
        Hzxi(i,j) = (1- HOm(N+1-i)*b)*Hzxi(i,j) - B*(Ey(i+1,j) - Ey(i,j));  
      end
   end
   for i=(N+1):(N+I)%homx=0
      for j=1:N
        Hzxi(i,j) = Hzxi(i,j) - B*(Ey(i+1,j) - Ey(i,j));  
      end
   end
   for i=(N+I+1):(2*N+I)
      for j=1:N
        Hzxi(i,j)= (1- HOm(i-N-I)*b)*Hzxi(i,j) - B*(Ey(i+1,j) - Ey(i,j));  
      end
   end
   %clculo de Hzxc (c=central)
   for i=1:N
      for j=1:J
        Hzxc(i,j) = (1- HOm(N+1-i)*b)*Hzxc(i,j) - B*(Ey(i+1,j+N) - Ey(i,j+N));  
      end
   end
   for i=(N+1):(2*N)
      for j=1:J
        Hzxc(i,j) = (1- HOm(i-N)*b)*Hzxc(i,j) - B*(Ey(i+I+1,j+N)-Ey(i+I,j+N));  
      end
   end
   %clculo do Hzxs (s=superior)
   for i=1:N
      for j=1:N
        Hzxs(i,j)= (1- HOm(N+1-i)*b)*Hzxs(i,j) - B*(Ey(i+1,j+N+J) - Ey(i,j+N+J));  
      end
   end
   for i=(N+1):(N+I) %homx = 0
      for j=1:N
        Hzxs(i,j) = Hzxs(i,j) - B*(Ey(i+1,j+N+J) - Ey(i,j+N+J));  
      end
   end
   for i=(N+I+1):(2*N+I)
      for j=1:N
        Hzxs(i,j) = (1- HOm(i-N-I)*b)*Hzxs(i,j) - B*(Ey(i+1,j+N+J) - Ey(i,j+N+J));  
      end
   end
  %****************************************************************************************
  %clculo de Hzyi (i=inferior)
   for i=1:(2*N+I)
      for j=1:N
        Hzyi(i,j) = (1- HOm(N+1-j)*b)*Hzyi(i,j) + B*(Ex(i,j+1) - Ex(i,j));  
      end
   end
  %clculo de Hzyc (c=central) homy=0
  for i=1:N
      for j=1:J
        Hzyc(i,j) = Hzyc(i,j) + B*(Ex(i,j+1+N) - Ex(i,j+N));  
      end
   end
  for i=(N+1):(2*N)
      for j=1:J
        Hzyc(i,j) = Hzyc(i,j) + B*(Ex(i+I,j+1+N) - Ex(i+I,j+N));  
      end
  end
  %clculo de Hzys (s=superior)
  for i=1:(2*N+I)
      for j=1:N
        Hzys(i,j) = (1- HOm(j)*b)*Hzys(i,j) + B*(Ex(i,j+1+J+N)-Ex(i,j+J+N));  
      end
   end
   %**********************************************************************************************
   %Clculo de Hz ->NO DOMINIO DE ESTUDO
   for i=1:I
      for j=1:J
         Hz(i,j) = Hz(i,j) + B*(Ex(i+N,j+N+1) - Ex(i+N,j+N) - Ey(i+N+1,j+N) + Ey(i+N,j+N));
      end
   end
   %****************************************************************************************
   if TypeExc(2)==2
     for k = 1:length(xyExc(:,1))
       i1 = xyExc(k,1);
       j1 = xyExc(k,2);
       i2 = xyExc(k,3);
       j2 = xyExc(k,4);
       if j1==j2% --
          Hz(i1+1:i2,j1+1) = Hz(i1+1:i2,j1+1) + Exc(t);
       elseif i1==i2% |
          Hz(i1+1,j1+1:j2) = Hz(i1+1,j1+1:j2) + Exc(t);  
       end
     end
   end
   %-----------------------------------------------------------------------
   if (length(Tp)>3 & length(Plo)>=p)%plot after Tp(4) iteraction
      if Plo(p) == t
          if Tp(2)==1
              EX(1:I,1:J) = (Ex(N+1:N+I,N+1:N+J) +  Ex(N+1:N+I,N+2:N+J+1))/2;              
              EY(1:I,1:J) = (Ey(N+1:N+I,N+1:N+J) +  Ey(N+2:N+I+1,N+1:N+J))/2; 
              E = (EX.^2 + EY.^2).^0.5;
              MM(p,1:I,1:J) = E(1:I,1:J);  
          elseif Tp(2)==2
              EX(1:I,1:J) = (Ex(N+1:N+I,N+1:N+J) +  Ex(N+1:N+I,N+2:N+J+1))/2; 
              MM(p,1:I,1:J) = EX(1:I,1:J);  
          elseif Tp(2)==3
              EY(1:I,1:J) = (Ey(N+1:N+I,N+1:N+J) +  Ey(N+2:N+I+1,N+1:N+J))/2;
              MM(p,1:I,1:J) = EY(1:I,1:J);  
          elseif Tp(2)==4
              MM(p,1:I,1:J) = Hz(1:I,1:J);  
          end
            p = p+1;
      end
   end  
%t      
end%T
%*************************************************************************************************
EX(1:I,1:J) = (Ex(N+1:N+I,N+1:N+J) +  Ex(N+1:N+I,N+2:N+J+1))/2;              
EY(1:I,1:J) = (Ey(N+1:N+I,N+1:N+J) +  Ey(N+2:N+I+1,N+1:N+J))/2; 
E = (EX.^2 + EY.^2).^0.5;
HZ = Hz;
%*************************************************************************************************
xx = 0:I-1;
yy = 0:J-1;
aux=0;
figure(1)
if Tp(2)==1
  Mx = max(max(E));
  Mn = min(min(E));  
elseif Tp(2)==2
  Mx = max(max(EX));
  Mn = min(min(EX));  
elseif Tp(2)==3
 Mx = max(max(EY));
 Mn = min(min(EY));   
elseif Tp(2)==4
 Mx = max(max(HZ));
 Mn = min(min(HZ));   
end

for n=1:length(Plo)
    figure(1)
   if length(Tp)>3
      AUX(1:I,1:J) = MM(n,1:I,1:J);
      pcolor(xx,yy,AUX')
      time = int2str(Plo(n));  
    else
      time = int2str(T);  
       if Tp(2)==1
          pcolor(xx,yy,E')
       elseif Tp(2)==2
          pcolor(xx,yy,EX') 
       elseif Tp(2)==3
          pcolor(xx,yy,EY')  
       elseif Tp(2)==4
          pcolor(xx,yy,HZ')  
       end
   end
    figure(1)
    shading flat
    axis equal
    colormap(jet(200))
    caxis([Mn Mx]);title(['Wave Propagation Mode TE, Time Step = ', time])
    axis([0 I-1 0 J-1]); xlabel('i'); ylabel('j') 
    hold on
    %plot boundary conditions
   if Pbp==1 | Pbp==3
    if nargin>6
    for kk = 1:length(xym(:,1))
       i1 = xym(kk,1);
       j1 = xym(kk,2);
       i2 = xym(kk,3);
       j2 = xym(kk,4);
       if xym(kk,5)==0   
            for k = 1:length(xym(:,1))
               plot([i1 i2],[j1 j2],'k','LineWidth',1)
            end
       else
        pox = i1;
        poy = j1;
        R = i2;
        Q1 = j2;
        Q2 =  xym(kk,5);
          if Q1==Q2
                if Q1==1%0-90
                   theta = linspace(0,pi/2,30);
                elseif Q1==2%90-180
                   theta = linspace(pi/2,pi,30);
                elseif Q1==3%180-270
                    theta = linspace(pi,3*pi/2,30);
                elseif Q1==4%270-360
                    theta = linspace(3*pi/2,2*pi,30);
                end
           elseif ((Q1==1 & Q2==2) |  (Q1==2 & Q2==1))
              theta = linspace(0,pi,30);
           elseif ((Q1==1 & Q2==3) |  (Q1==3 & Q2==1))
              theta = linspace(0,3*pi/2,30);
           elseif ((Q1==1 & Q2==4) |  (Q1==4 & Q2==1))%full circle  
              theta = linspace(0,2*pi,30);
           elseif ((Q1==2 & Q2==3) |  (Q1==3 & Q2==2))
              theta = linspace(pi/2,3*pi/2,30);
           elseif ((Q1==2 & Q2==4) |  (Q1==4 & Q2==2))
              theta = linspace(pi/2,2*pi,30);
           elseif ((Q1==3 & Q2==4) |  (Q1==4 & Q2==3))
              theta = linspace(pi,2*pi,30);
           end
       rho = R;
       [x,y] = pol2cart(theta,rho);
       plot(x+pox,y+poy,'k','LineWidth',1)
       end
    end   
    end
   end 
    
   %plot properties
if Pbp==2 | Pbp==3
for n = 1:length(xyp(:,1))
    x1 = xyp(n,1);
    y1 = xyp(n,2);
    x2 = xyp(n,3);
    y2 = xyp(n,4);
    x3 = xyp(n,5);
    y3 = xyp(n,6);
    x4 = xyp(n,7);
    y4 = xyp(n,8);
    if (x3==x4 & y3==y4)%triangle
        if (x2>x1 & x3==x2)%triangle _| x2
           plot([x1 x2],[y1 y2],'b','LineWidth',1)
           plot([x2 x3],[y2 y3],'b','LineWidth',1)
           plot([x1 x3],[y1 y3],'b','LineWidth',1)
        elseif (x1==x3 & y2==y3)%triangle :- 
           plot([x1 x3],[y1 y3],'b','LineWidth',1)
           plot([x2 x4],[y2 y4],'b','LineWidth',1)
           plot([x1 x2],[y1 y2],'b','LineWidth',1)
        elseif (x1==x2)%triangle -: 
           plot([x1 x2],[y1 y2],'b','LineWidth',1)
           plot([x2 x3],[y2 y3],'b','LineWidth',1)
           plot([x3 x1],[y3 y1],'b','LineWidth',1)
        elseif(y2==y1 & x3==x1)%triangle |_ 
           plot([x1 x2],[y1 y2],'b','LineWidth',1)
           plot([x2 x3],[y2 y3],'b','LineWidth',1)
           plot([x3 x1],[y3 y1],'b','LineWidth',1)
        end
    elseif (y3==0 & x4==0 & y4==0)%circle
        pox = x1;
        poy = y1;
        R = x2;
        Q1 = y2;
        Q2 =  x3;
        if Q1==Q2
          if Q1==1%0-90
            theta = linspace(0,pi/2,30);figure(1)
            plot([x1 x1+R],[y1 y1],'b','LineWidth',1)
            plot([x1 x1],[y1 y1+R],'b','LineWidth',1)
          elseif Q1==2%90-180
            theta = linspace(pi/2,pi,30);figure(1)
            plot([x1 x1-R],[y1 y1],'b','LineWidth',1)
            plot([x1 x1],[y1 y1+R],'b','LineWidth',1)
          elseif Q1==3%180-270
            theta = linspace(pi,3*pi/2,30);
            plot([x1 x1-R],[y1 y1],'b','LineWidth',1)
            plot([x1 x1],[y1 y1-R],'b','LineWidth',1)
          elseif Q1==4%270-360
            theta = linspace(3*pi/2,2*pi,30);figure(1)
            plot([x1 x1+R],[y1 y1],'b','LineWidth',1);figure(1)
            plot([x1 x1],[y1 y1-R],'b','LineWidth',1)
          end
        elseif ((Q1==1 & Q2==2) |  (Q1==2 & Q2==1))
           theta = linspace(0,pi,30);
           plot([x1-R x1+R],[y1 y1],'b','LineWidth',1)
        elseif ((Q1==1 & Q2==3) |  (Q1==3 & Q2==1))
           theta = linspace(0,3*pi/2,30);figure(1)
           plot([x1 x1+R],[y1 y1],'b','LineWidth',1);figure(1)
           plot([x1 x1],[y1 y1-R],'b','LineWidth',1)
        elseif ((Q1==1 & Q2==4) |  (Q1==4 & Q2==1))%full circle  
           theta = linspace(0,2*pi,30);
        elseif ((Q1==2 & Q2==3) |  (Q1==3 & Q2==2))
           theta = linspace(pi/2,3*pi/2,30);figure(1)
           plot([x1 x1],[y1+R y1-R],'b','LineWidth',1)
        elseif ((Q1==2 & Q2==4) |  (Q1==4 & Q2==2))
           theta = linspace(pi/2,2*pi,30);
        elseif ((Q1==3 & Q2==4) |  (Q1==4 & Q2==3))
           theta = linspace(pi,2*pi,30);figure(1)
           plot([x1-R x1+R],[y1 y1],'b','LineWidth',1)
        end
        rho = R;
        [x,y] = pol2cart(theta,rho);figure(1)
        plot(x+pox,y+poy,'b','LineWidth',1)
    else%box
        figure(1)
       plot([x1 x2],[y1 y2],'b','LineWidth',1);figure(1)
       plot([x2 x3],[y2 y3],'b','LineWidth',1);figure(1)
       plot([x3 x4],[y3 y4],'b','LineWidth',1);figure(1)
       plot([x4 x1],[y4 y1],'b','LineWidth',1);figure(1)
    end
end
end
  
pause(0.1)
end   
figure(1)
hold off


% --- Executes on button press in pushbuttonPause.
function pushbuttonPause_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonPause (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbuttonSTOP.
function pushbuttonSTOP_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonSTOP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)




% --- Executes on button press in checkbox7.
function checkbox7_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox7


% --- Executes on button press in checkbox8.
function checkbox8_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox8


% --- Executes on button press in checkbox9.
function checkbox9_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox9



function edit34_Callback(hObject, eventdata, handles)
% hObject    handle to edit34 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit34 as text
%        str2double(get(hObject,'String')) returns contents of edit34 as a double


% --- Executes during object creation, after setting all properties.
function edit34_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit34 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit35_Callback(hObject, eventdata, handles)
% hObject    handle to edit35 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit35 as text
%        str2double(get(hObject,'String')) returns contents of edit35 as a double


% --- Executes during object creation, after setting all properties.
function edit35_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit35 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit36_Callback(hObject, eventdata, handles)
% hObject    handle to edit36 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit36 as text
%        str2double(get(hObject,'String')) returns contents of edit36 as a double


% --- Executes during object creation, after setting all properties.
function edit36_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit36 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit37_Callback(hObject, eventdata, handles)
% hObject    handle to edit37 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit37 as text
%        str2double(get(hObject,'String')) returns contents of edit37 as a double


% --- Executes during object creation, after setting all properties.
function edit37_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit37 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit38_Callback(hObject, eventdata, handles)
% hObject    handle to edit38 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit38 as text
%        str2double(get(hObject,'String')) returns contents of edit38 as a double


% --- Executes during object creation, after setting all properties.
function edit38_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit38 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit39_Callback(hObject, eventdata, handles)
% hObject    handle to edit39 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit39 as text
%        str2double(get(hObject,'String')) returns contents of edit39 as a double


% --- Executes during object creation, after setting all properties.
function edit39_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit39 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit40_Callback(hObject, eventdata, handles)
% hObject    handle to edit40 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit40 as text
%        str2double(get(hObject,'String')) returns contents of edit40 as a double


% --- Executes during object creation, after setting all properties.
function edit40_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit40 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit41_Callback(hObject, eventdata, handles)
% hObject    handle to edit41 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit41 as text
%        str2double(get(hObject,'String')) returns contents of edit41 as a double


% --- Executes during object creation, after setting all properties.
function edit41_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit41 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit42_Callback(hObject, eventdata, handles)
% hObject    handle to edit42 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit42 as text
%        str2double(get(hObject,'String')) returns contents of edit42 as a double


% --- Executes during object creation, after setting all properties.
function edit42_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit42 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit43_Callback(hObject, eventdata, handles)
% hObject    handle to edit43 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit43 as text
%        str2double(get(hObject,'String')) returns contents of edit43 as a double


% --- Executes during object creation, after setting all properties.
function edit43_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit43 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit44_Callback(hObject, eventdata, handles)
% hObject    handle to edit44 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit44 as text
%        str2double(get(hObject,'String')) returns contents of edit44 as a double


% --- Executes during object creation, after setting all properties.
function edit44_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit44 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit45_Callback(hObject, eventdata, handles)
% hObject    handle to edit45 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit45 as text
%        str2double(get(hObject,'String')) returns contents of edit45 as a double


% --- Executes during object creation, after setting all properties.
function edit45_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit45 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit46_Callback(hObject, eventdata, handles)
% hObject    handle to edit46 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit46 as text
%        str2double(get(hObject,'String')) returns contents of edit46 as a double


% --- Executes during object creation, after setting all properties.
function edit46_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit46 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit47_Callback(hObject, eventdata, handles)
% hObject    handle to edit47 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit47 as text
%        str2double(get(hObject,'String')) returns contents of edit47 as a double


% --- Executes during object creation, after setting all properties.
function edit47_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit47 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in pushbutton9.
function pushbutton9_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



function edit48_Callback(hObject, eventdata, handles)
% hObject    handle to edit48 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit48 as text
%        str2double(get(hObject,'String')) returns contents of edit48 as a double


% --- Executes during object creation, after setting all properties.
function edit48_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit48 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end





function editPeriodoTL_Callback(hObject, eventdata, handles)
% hObject    handle to editPeriodoTL (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editPeriodoTL as text
%        str2double(get(hObject,'String')) returns contents of editPeriodoTL as a double


% --- Executes during object creation, after setting all properties.
function editPeriodoTL_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editPeriodoTL (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function editVg_Callback(hObject, eventdata, handles)
% hObject    handle to editVg (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editVg as text
%        str2double(get(hObject,'String')) returns contents of editVg as a double


% --- Executes during object creation, after setting all properties.
function editVg_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editVg (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end




% --------------------------------------------------------------------
function Untitled_12_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_13_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_14_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_15_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_16_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_17_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_5_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_6_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_7_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_8_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_9_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_10_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_11_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_11 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_3_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_4_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_1_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Untitled_2_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


