%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 2, SECTION 2.1.5 %%%%%%%%%%%%%%%%%%%%%%%%%%
% Effect of coils' quality factor (Q) and coupling coefficient (k) on the link %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc

figure_config                       % Set figures style

%% PARAMETERS %%

QTX=[0:1:1000];                     % Tx quality factor
QRX=QTX;                            % Rx quality factor
QL=50;                              % Load quality factor QL=wLRX/Re{ZMN}
QRXL= QRX*QL./(QRX+QL);
kTXRX_vector=[0.005,0.01,0.5];      % Tx-Rx coupling coefficient

VS=1;                               % Tx voltage peak amplitude (when voltage source is used in the Tx), in volts
IS=50e-3;                           % Tx current peak amplitude (when current source is used in the Tx), in amperes
RTX=5;                              % Tx coil series parasitic resistance, in ohms


%% PLOTS %%
for index=1:length(kTXRX_vector)                                                        % For each k in kTXRX_vector, PTE and PDL are calculated
    kTXRX=kTXRX_vector(index);
    name_on_lagend=['k_{Tx-Rx}=' num2str(kTXRX)];                                       % Name used in the legend
    PTE=100*QRXL/QL*kTXRX^2.*QTX.*QRXL./(kTXRX^2*QTX.*QRXL+1);                          % Power Transfer Efficiency (PTE)
    PMN_voltage=0.5*VS^2/RTX*QRXL/QL*kTXRX^2.*QTX.*QRXL./(kTXRX^2*QTX.*QRXL+1).^2;      % Power Delivered to the Load (PDL) with a voltage Tx source
    PMN_current=0.5*IS^2*RTX*QRXL/QL*kTXRX^2.*QTX.*QRXL;                                % Power Delivered to the Load (PDL) with a current Tx source
    figure(1)%PTE%
        h=plot(QTX,PTE);                                                                
        set(h,'color', plots_colors(index,:), 'LineStyle', linestyle{index}, 'DisplayName',name_on_lagend)
        hold on
    figure(2)%PDL, with voltage source%
        h=semilogy(QTX,1000*PMN_voltage);
        set(h,'color', plots_colors(index,:), 'LineStyle', linestyle{index},'DisplayName',name_on_lagend)
        hold on
    figure(3)%PDL, with current source%
        h=semilogy(QTX,1000*PMN_current);
        set(h,'color', plots_colors(index,:), 'LineStyle', linestyle{index}, 'DisplayName',name_on_lagend)
        hold on
end

%% PLOTS STYLE, LABELS AND LEGENDS POSITION %%
figure(1)
    ylabel('\eta_{Link} (%)')
    xlabel('Q_{Rx}=Q_{Tx}')
    grid on
    legend show
figure(2)
    ylabel('P_{MN} (mW)')
    xlabel('Q_{Rx}=Q_{Tx}')
    grid on
	legend show
figure(3)
    ylabel('P_{MN} (mW)')
    xlabel('Q_{Rx}=Q_{Tx}')
    grid on
    legend show

H = findobj('type','legend');
for index=1:length(kTXRX_vector)
    H(index).Location = 'southeast';
end

%% COUPLING COEFFICIENT AS A FUNCTION OF DISTANCE %%

DTXRX_vector=[5:2:60];
radiusTX_vector=[1:0.5:10];                                                                     % Tx coil radius
DTXRX=ones(length(radiusTX_vector),1)*DTXRX_vector;
radiusTX=radiusTX_vector'*ones(1,length(DTXRX_vector));
radiusRX=radiusTX;                                                                              % Rx coil radius
kTXRX=(radiusRX.^2.*radiusTX.^2)./(sqrt(radiusRX.*radiusTX).*(DTXRX.^2+radiusTX.^2).^(3/2));    % Tx to Rx coil coupling coefficient

figure1=figure(4);
h=surf(DTXRX_vector,radiusTX_vector*2,kTXRX);
hold on

ylim([2 20])
xlim([5 60])
h=gca;
set(h,'zscale','log')
zlim([0.0001 1])
set(gca,'ZTick',[0.0001 0.001 0.01 0.1 1])
set(gca,'ZTicklabel',{'0.0001'; '0.001'; '0.01'; '0.1'; '1'})

view(h,[62.5 14]);

ylabel('Tx and Rx Diameter (cm)')
xlabel('D_{Tx-Rx} (cm)')
zlabel('k_{Tx-Rx}')

