%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 2, SECTION 2.1.6 %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%% Effect of Tx and Rx resonance on the link %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc

figure_config                       % Set figures style

%% PARAMETERS %%

QTX=200;                            % Tx quality factor
QRX=QTX;                            % Rx quality factor
QL=50;                              % Load quality factor QL=wLRX/Re{ZMN}
QRXL= QRX*QL./(QRX+QL);
kTXRX=0.01;                         % Tx-Rx coupling coefficient

VS=1;                               % Tx voltage peak amplitude (when voltage source is used in the Tx), in volts
RTX=5;                              % Tx coil series parasitic resistance, in ohms


%% Table 2.5 %%
%Quantification of Tx and Rx resonance%
%A
disp('-----------A-----------')
ZRXTXref=(kTXRX^2*QTX*QRX)/(1+QRX*(j+1/QL))*RTX                             % Reflected impedance
PTE=100*QRX/(QRX+QL)*(real(ZRXTXref))/(real(ZRXTXref)+RTX)                  % Power Transfer Efficiency (PTE)
ZS=RTX*(1+j*QTX+ZRXTXref/RTX);                                              % Voltage source load impedance
PMN=VS^2/(2*abs(ZS)^2)*real(ZS)*PTE/100                                     % Power Delivered to the Load (PDL)
%B
disp('-----------B-----------')
ZRXTXref=kTXRX^2*QTX*QRXL*RTX                                               % Reflected impedance
PTE=100*QRXL/QL*kTXRX^2*QTX*QRXL/(kTXRX^2*QTX*QRXL+1)                       % Power Transfer Efficiency (PTE)
ZS=RTX*(1+j*QTX+ZRXTXref/RTX);                                              % Voltage source load impedance
PMN=VS^2/(2*abs(ZS)^2)*real(ZS)*PTE/100                                     % Power Delivered to the Load (PDL)
%C
disp('-----------C-----------')
ZRXTXref=kTXRX^2*QTX*QRXL*RTX                                               % Reflected impedance
PTE=100*QRXL/QL*kTXRX^2*QTX*QRXL/(kTXRX^2*QTX*QRXL+1)                       % Power Transfer Efficiency (PTE)
ZS=RTX*(1+ZRXTXref/RTX);                                                    % Voltage source load impedance
PMN=VS^2/(2*abs(ZS)^2)*real(ZS)*PTE/100                                     % Power Delivered to the Load (PDL)
%D
disp('-----------D-----------')
ZRXTXref=(kTXRX^2*QTX*QRX)/(1+QRX*(j+1/QL))*RTX                             % Reflected impedance
PTE=100*QRX/(QRX+QL)*(real(ZRXTXref))/(real(ZRXTXref)+RTX)                  % Power Transfer Efficiency (PTE)
ZS=RTX*(1+ZRXTXref/RTX);                                                    % Voltage source load impedance
PMN=VS^2/(2*abs(ZS)^2)*real(ZS)*PTE/100                                     % Power Delivered to the Load (PDL)

%% Table 2.6 %%
%Comparison between series and parallel Rx resonators%

%PARAMETERS%
RRX=5;                                                                                                                  % Rx coil series parasitic resistance, in ohms
RL=logspace(0,6,100);                                                                                                   % Load resistance = Re{ZMN}

%series%
QL_serie=QRX*RRX./RL;                                                                                                   % Load quality factor with a series Rx resonator
QRXL_serie= QRX*QL_serie./(QRX+QL_serie);
PTE_serie=100*(QRXL_serie./QL_serie).*(kTXRX^2*QTX.*QRXL_serie)./(kTXRX^2*QTX*QRXL_serie+1);                            % PTE, calculated for the series resonator case
PDL_serie=VS^2/(2*RTX)*(QRXL_serie./QL_serie).*(kTXRX^2*QTX.*QRXL_serie)./(kTXRX^2*QTX*QRXL_serie+1).^2;                % PDL, calculated for the series resonator case

%parallel%
QL_parallel=RL/(QRX*RRX);                                                                                               % Load quality factor with a parallel Rx resonator
QRXL_parallel= QRX*QL_parallel./(QRX+QL_parallel);
PTE_parallel=100*(QRXL_parallel./QL_parallel).*(kTXRX^2*QTX*QRXL_parallel)./(kTXRX^2*QTX*QRXL_parallel+1);              % PTE, calculated for the parallel resonator case
PDL_parallel=VS^2/(2*RTX)*(QRXL_parallel./QL_parallel).*(kTXRX^2*QTX*QRXL_parallel)./(kTXRX^2*QTX*QRXL_parallel+1).^2;  % PDL, calculated for the parallel resonator case

figure(1)%PTE%
h=semilogx(RL,PTE_serie);
set(h,'color', plots_colors(1,:), 'LineStyle', linestyle{1})      
hold on
h=semilogx(RL,PTE_parallel);
set(h,'color', plots_colors(2,:), 'LineStyle', linestyle{2}) 
ylabel('\eta_{Link} (%)')
xlabel('R_L (\Omega)')
legend('Series-resonator','Parallel-resonator')
grid on
xlim([min(RL) max(RL)])

figure(2)%PDL%
h=semilogx(RL,PDL_serie*1e3);
set(h,'color', plots_colors(1,:), 'LineStyle', linestyle{1})
hold on
h=semilogx(RL,PDL_parallel*1e3);
set(h,'color', plots_colors(2,:), 'LineStyle', linestyle{2})
ylabel('P_{MN} (mW)')
xlabel('R_L (\Omega)')
legend('Series-resonator','Parallel-resonator')
grid on
xlim([min(RL) max(RL)])
