%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 2, SECTION 2.3 %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% Comparison between 2-, 3-, and 4-coil links %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc

figure_config                   % Set figures style

%% PARAMETERS %%

QTX=200;                        % Tx quality factor
QA1=QTX;                        % Additional coil 1 quality factor
QA2=QTX;                        % Additional coil 2 quality factor
QRX=QTX;                        % Rx quality factor
QL=50;                          % Load quality factor QL=wLRX/Re{ZMN}
QRXL= QRX*QL./(QRX+QL);
radiusTX=10;                  	% Tx coil radius
radiusA1=radiusTX;           	% A1 coil radius
radiusA2=radiusTX;             	% A2 coil radius
radiusRX=radiusTX;          	% Rx coil radius

DTXRX=60;                       % Tx to Rx distance
DTXA1=(0:.1:DTXRX);             % Tx to first resonator distace

VS=1;                           % Tx voltage source
RTX=5;                          % Tx coil series parasitic resistance

%% CALCULUS and PLOT 2-coil, Figure 2.25 and 2.26%%

kTXRX=(radiusRX^2*radiusTX^2)./(sqrt(radiusRX*radiusTX).*(DTXRX.^2+radiusTX^2).^(3/2));     % Tx to Rx coil coupling coefficient
XTXRX=kTXRX.^2*QTX*QRXL;                                                                    % Parameter used to calculate efficiency in the 2-coil link
PTE_2coil= QRXL/QL*((XTXRX)./(1+XTXRX));                                                    % PTE for the 2 coil link
PDL_2coil=VS^2/(2*RTX)*QRXL/QL*((XTXRX)/(1+XTXRX))^2;                                       % PDL for the 2 coil link

figure(1)%PTE%
h=plot(DTXA1,100*PTE_2coil*ones(1,length(DTXA1)));
set(h,'color', plots_colors(1,:), 'LineStyle', linestyle{1})
hold on

figure(2)%PDL%
h=plot(DTXA1,1e3*PDL_2coil*ones(1,length(DTXA1)));
set(h,'color', plots_colors(1,:), 'LineStyle', linestyle{1})
hold on

%% CALCULUS and PLOT 3-coil, Figure 2.25 and 2.26%%

kTXA1=(radiusA1^2*radiusTX^2)./(sqrt(radiusA1*radiusTX)*(DTXA1.^2+radiusTX^2).^(3/2));  	% Tx to additional coil coupling coefficient
DA1RX=DTXRX-DTXA1;                                                                          % Additional resonator to Rx distance (swept)
kA1RX=(radiusRX^2*radiusA1^2)./(sqrt(radiusRX*radiusA1)*(DA1RX.^2+radiusA1^2).^(3/2));   	% Additional resonator to Rx coupling coefficient
XTXA1=kTXA1.^2*QTX*QA1;                                                                     % Parameter used to calculate efficiency in the 3-coil link
XA1RX=kA1RX.^2*QA1*QRXL;                                                                    % Parameter used to calculate efficiency in the 3-coil link
PTE_3coil= QRXL/QL*(XA1RX./(XA1RX+1)).*(XTXA1./(XTXA1+XA1RX+1));                            % PTE for the 3-coil link as a function of the additional resonator position, DTXA1
PDL_3coil= VS^2/(2*RTX)*QRXL/QL*(XA1RX.*XTXA1)./(XTXA1+XA1RX+1).^2;                         % PDL for the 3-coil link as a function of the additional resonator position, DTXA1

figure(1)%PTE%
h=plot(DTXA1,100*PTE_3coil);
set(h,'color', plots_colors(2,:), 'LineStyle', linestyle{2})

figure(2)%PDL%
h=plot(DTXA1,1e3*PDL_3coil);
set(h,'color', plots_colors(2,:), 'LineStyle', linestyle{2})
hold on

%% CALCULUS and PLOT 4-coil, Figure 2.25 and 2.26%%

DA2RX_vector=[10 20];
for DA2RX=DA2RX_vector                                                                        	% For each DA2RX, PTE and PDL is calculated as a function of DTXA1
    DTXA1=(0:.1:(DTXRX-DA2RX));                                                                 % Tx to first additional resonator distance (swept)
    kTXA1=(radiusA1^2*radiusTX^2)./(sqrt(radiusA1*radiusTX)*(DTXA1.^2+radiusTX^2).^(3/2));     	% Tx to first additional resonator coupling coefficient
    XTXA1=kTXA1.^2*QTX*QA1;                                                                     % Parameter used to calculate efficiency in the 4-coil link
    DA1A2=DTXRX-DTXA1-DA2RX;                                                                    % First additional resonator to second additional resonator distance
    kA1A2=(radiusA2^2*radiusA1^2)./(sqrt(radiusA2*radiusA1)*(DA1A2.^2+radiusA1^2).^(3/2));    	% First additional resonator to second additional resonator coupling coefficient
    XA1A2=kA1A2.^2*QA1*QA2;                                                                     % Parameter used to calculate efficiency in the 4-coil link
    kA2RX=(radiusRX^2*radiusA2^2)./(sqrt(radiusRX*radiusA2)*(DA2RX.^2+radiusA2^2).^(3/2));    	% Second additional resonator to Rx coupling coefficient
    XA2RX=kA2RX.^2*QA2*QRXL;                                                                    % Parameter used to calculate efficiency in the 4-coil link
    PTE_4coil=(QRXL/QL)*(XTXA1.*XA1A2.*XA2RX)./((1+XA2RX+XA1A2).*(XA1A2+(1+XTXA1).*(1+XA2RX))); % PTE for the 4-coil link as a function of the first additional resonator position, DTXA1
    PDL_4coil=VS^2/(2*RTX)*QRXL/QL*(XTXA1.*XA1A2.*XA2RX)./(XA1A2+(1+XTXA1).*(1+XA2RX)).^2;      % PDL for the 4-coil link as a function of the first additional resonator position, DTXA1
    
    color_for_plot=plots_colors(3,:)*(0.5*(DA2RX==DA2RX_vector(1))+1.5*(DA2RX==DA2RX_vector(2)));   % Colors for the PTE plot in 4-coil link
    
    figure(1)%PTE%
    h=plot(DTXA1,100*PTE_4coil);
    set(h, 'color', color_for_plot,'LineStyle', linestyle{3})
    figure(2)%PDL%
    h=plot(DTXA1,1e3*PDL_4coil);
    set(h, 'color', color_for_plot, 'LineStyle', linestyle{3})
end

%% PLOT STYLE, Figure 2.25 and 2.26%%

figure(1)
legend('2-coil link','3-coil link','4-coil link D_{A2-Rx}=10 cm','4-coil link D_{A2-Rx}=20 cm')
grid on
xlabel('D_{Tx-A1} (cm)')
ylabel('\eta_{Link} (%)')

figure(2)
legend('2-coil link','3-coil link','4-coil link D_{A2-Rx}=10 cm','4-coil link D_{A2-Rx}=20 cm')
grid on
xlabel('D_{Tx-A1} (cm)')
ylabel('P_{MN} (mW)')

%% CALCULUS, Figure 2.27 and 2.28%%

DTXRX=(1:.1:100);                                                                           % Tx to Rx distance in cm
DTXA_opt=[];                                                                                % Tx to additional coil optimum distance
for D=DTXRX                                                                                 % This 'for' sentence calculates DTXA_opt
    DTXA=(0:.1:D);                                                                          % Tx to additional coil distance (swept)
    kTXA=(radiusA1^2*radiusTX.^2)./(sqrt(radiusA1*radiusTX).*(DTXA.^2+radiusTX.^2).^(3/2)); % Tx to additional coil coupling coefficient
    DARX=max(DTXA)-DTXA;                                                                    % Additional coil to Rx distance (swept)
    kARX=(radiusRX^2*radiusA1.^2)./(sqrt(radiusRX*radiusA1).*(DARX.^2+radiusA1.^2).^(3/2)); % Additional coil to Rx quality factor
    XTXA=kTXA.^2*QTX*QA1;
    XARX=kARX.^2*QA1*QRXL;
    eta3coil= QRXL/QL*(XARX./(XARX+1)).*(XTXA./(XTXA+XARX+1));                              % Efficiency of the 3-coil link as a function of the additional coil position for a DTXRX=D
    [Y, I]=max(eta3coil);                                                                   % Get index of optimum additional coil position 'I'
    DTXA_opt=[DTXA_opt DTXA(I)];                                                            % Save additional coil position for that Tx to Rx distance
end
kTXRX=(radiusRX^2*radiusTX.^2)./(sqrt(radiusRX*radiusTX).*(DTXRX.^2+radiusTX.^2).^(3/2));   % Tx to Rx coil coupling coefficient
kTXA=(radiusA1^2*radiusTX.^2)./(sqrt(radiusA1*radiusTX).*(DTXA_opt.^2+radiusTX.^2).^(3/2)); % Tx to additional coil coupling coefficient
DTXA=DTXRX-DTXA_opt;
kARX=(radiusRX^2*radiusA1.^2)./(sqrt(radiusRX*radiusA1).*(DTXA.^2+radiusA1.^2).^(3/2));
XTXRX=kTXRX.^2*QTX*QRXL;                                                                 	% Parameter used to calculate efficiency in the 2-coil link
XTXA=kTXA.^2*QTX*QA1;                                                                    	% Parameter used to calculate efficiency in the 3-coil link
XARX=kARX.^2*QA1*QRXL;                                                                      % Parameter used to calculate efficiency in the 3-coil link
eta2coil= QRXL/QL*((XTXRX)./(1+XTXRX));                                                     % 2-coil link efficiency 
eta3coil= QRXL/QL*(XARX./(XARX+1)).*(XTXA./(XTXA+XARX+1));                                  % 3-coil link efficiency

%% PLOTS %%

figure(3)
%2-coil%
h=plot(DTXRX,100*eta2coil);
set(h, 'color', plots_colors(1,:),'LineStyle', linestyle{1})
hold on
%3-coil%
h=plot(DTXRX,100*eta3coil);
set(h, 'color', plots_colors(2,:),'LineStyle', linestyle{2})
%Set the style%
legend('2-coil link','3-coil link')
ylim([0 90])
xlim([min(DTXRX) max(DTXRX)])
grid on
xlabel('D_{Tx-Rx} (cm)')
ylabel('\eta_{Link} (%)')

figure(4)
h=plot(DTXRX,DTXA_opt);
set(h, 'color', plots_colors(1,:),'LineStyle', linestyle{1})
grid on
xlabel('D_{Tx-Rx} (cm)')
ylabel('D_{Tx-A_{opt}}')


