%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 3, SECTION 3.1.1 %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%% Square-shaped Printed Spiral Coil %%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc

figure_config                       % Set figures style

%% CONSTANTS %%
mu0=4*pi*10^(-7);                   % Free space magnetic permeability
mu=1.00000037*mu0;                  % Air permeability
muc=0.99999*mu0;                    % Cooper permeability
epsilon0=8.854187817e-12;           % Free space electric permittivity
epsilonFR4=4;                       % Relative electric permittivity of FR4 material

%% PARAMETERS %%
%Electrical%
ro=16.8e-9;                         % Cooper resistivity
f=13.56e6;                          % Carrier frequency (Hz)
%Geometric%
n=5;                                % Number of turns
w=1e-3;                             % Conductor width (m)
thickness=35e-6;                    % Conductor thickness (m)
s=3e-3;                             % Conductor spacing (m)
din=5e-3;                           % Inner diameter (m)
dout=din+2*n*w+2*(n-1)*s;           % Outer diameter (m)
DTXRX=0.01;                         % Tx to Rx distance (m)
FR4_thickness=1.5e-3;               % PCB, FR4, thickness (m)

%% Self-Inductance %%
phi= (dout-din)/(dout+din);
davg= 0.5*(dout+din);
L=(1.27*mu*n^2*davg/2)*(log(2.07/phi)+0.18*phi+0.13*phi^2)                  % Self-inductance

%% Equivalent Series Resistance (ESR) %%
%DC ESR%
length= 4*n*dout-4*n*w-(2*n+1)^2*(s+w);                                     % Conductor length
gap_length= 4*(dout-w*n)*(n-1)-4*s*n*(n+1);                                 % Gap length
Area= thickness*w;                                                          % Track area
RDC=ro*length/Area;                                                         % DC resistance
%AC ESR%
delta= sqrt((2*ro)/(2*pi*f*muc));                                           % Skin depth
RAC=(RDC*thickness)/(delta*(1-exp(-thickness/delta))*(1+thickness/w))       % AC ESR resistance

Q=2*pi*f*L/RAC                                                              % Coil quality factor

%% Parasitic Capacitance %%
k0= s/(s+2*w);
k0_prime=sqrt(1-k0^2);
k1=tanh(pi*s/(4*FR4_thickness))/tanh(pi*(s+2*w)/(4*FR4_thickness));
k1_prime=sqrt(1-k1^2);
epsilon_eff=1+(epsilonFR4-1)*(0.5)*ellipke(k1_prime)*ellipke(k0)/(ellipke(k1)*ellipke(k0_prime));
Cpar=epsilon0*epsilon_eff*(ellipke(k0_prime)/ellipke(k0))*length            % Parasitic capacitance

fself=1/(2*pi*sqrt(L*Cpar))                                                 % Coil self-resonance

%% Mutual Inductance %%
ni=[1:1:n];
a_i=ones(n,1)*(dout/2-(ni-1)*(w+s)-w/2);
a_j=(dout/2-(ni-1)*(w+s)-w/2)'*ones(1,n);
gamma_ij= 2*a_i.*a_j./(a_i.^2+a_j.^2+DTXRX^2);
M_ij=(mu0*pi*a_i.^2.*a_j.^2./(2*(a_i.^2+a_j.^2+DTXRX^2).^(3/2))).*(1+(15/32)*gamma_ij.^2+(315/1024)*gamma_ij.^4);
M=(4/pi)^2*sum(sum(M_ij))
ktxrx=M/L