%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 5, SECTION 5.1 %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% Achieving the Optimum Operating Point (OOP) %%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc

figure_config                       % Set figures style

%% PARAMETERS %%

QTX=200;                            % Tx quality factor
QRX=200;                            % Rx quality factor
RTX=5;                              % Tx coil series parasitic resistance, in ohms
RRX=5;                              % Rx coil series parasitic resistance, in ohms
kTXRX=0.01;                         % Tx-Rx coupling coefficient
w=13.56e6*2*pi;                     % Carrier signal frequency
LRX=QRX*RRX/w;                      % Rx selfinductance
LTX=QTX*RTX/w;                      % Tx selfinductance

REZmn_range=[1:2:50];                                           % Real part of ZMN
ImZmn_range= [-50:2:50];                                        % Imaginary part of ZMN
ImZmn_range= ImZmn_range - w*LRX*ones(1,length(ImZmn_range));   % Imaginary part of ZMN centered at the resonance value 

VS=1;                               % Tx voltage peak amplitude (when voltage source is used in the Tx), in volts

%% CALCULATIONS %%
PMN_voltage_matrix=[];  % Auxiliary matrix where the results are going to be loaded
eta_link_matrix=[];     % Auxiliary matrix where the results are going to be loaded

for REZmn=REZmn_range
    PMN_voltage_vector=[];
    eta_link_vector=[];
    for ImZmn=ImZmn_range
        etaRX=REZmn/(REZmn+RRX);                                                % Rx efficiency
        Zref=(kTXRX^2*w^2*LTX*LRX)/(RRX+j*w*LRX+REZmn+j*ImZmn);                 % Reflected impedance in the Tx
        etaTX=real(Zref)/(RTX+real(Zref));                                      % Tx efficiency
        eta_link=etaRX*etaTX;                                                   % Power Transfer Efficiency (PTE)
        Zs=RTX+Zref;                                                            % Tx driver load impedance 
        PTX_voltage=0.5*(VS/abs(Zs))^2*(real(Zs));                              % Voltage driver output power
        PMN_voltage=PTX_voltage*eta_link;                                       % Power Delivered to the Load (PDL) with a Voltage Tx driver 
        PMN_voltage_vector=[PMN_voltage_vector PMN_voltage];
        eta_link_vector=[eta_link_vector eta_link];
    end
    PMN_voltage_matrix=[PMN_voltage_matrix; PMN_voltage_vector];
    eta_link_matrix=[eta_link_matrix; eta_link_vector];
end

%% PLOTS %%

figure(1)%PTE%
h=surf(ImZmn_range,REZmn_range,eta_link_matrix*100);
hold on
xlabel('Im\{Z_{MN}\} (\Omega)')
ylabel('Re\{Z_{MN}\} (\Omega)')
zlabel('\eta_{Link} (%)')

figure(2)%PDL%
h=surf(ImZmn_range,REZmn_range,PMN_voltage_matrix*1000);
hold on
xlabel('Im\{Z_{MN}\} (\Omega)')
ylabel('Re\{Z_{MN}\} (\Omega)')
zlabel('P_{MN} (mW)')

%% Highlight selected points %%

%DISCLAIMER: Although this script is cited at the beginning of chapter 5, 
%in the following, it uses equations that are deduced later in the chapter.

%%%%MEP%%%%%
ImZmn_mep=-w*LRX;                                                                                  
ReZmn_mep=RRX*sqrt(kTXRX^2*QRX*QTX+1);
eta_max=(kTXRX^2*QRX*QTX)/(sqrt(kTXRX^2*QRX*QTX+1)+1)^2;
figure(1)
h=plot3(ImZmn_mep,ReZmn_mep,eta_max*100,'o','markersize',20);
set(h,'MarkerFaceColor','red','MarkerEdgeColor','red')
h=text(ImZmn_mep,ReZmn_mep,eta_max*100,'MEP');
set(h, 'fontweight','bold','fontsize',30,'color', [1 0 0])
 
%%%%MPP%%%%%
ImZmn_mpp=-w*LRX;                                                                                  
ReZmn_mpp=RRX*(kTXRX^2*QRX*QTX+1);
PMN_voltage_max=(VS^2)/(8*RTX)*(kTXRX^2*QRX*QTX)/(kTXRX^2*QRX*QTX+1);
figure(2)
h=plot3(ImZmn_mpp,ReZmn_mpp,PMN_voltage_max*1000,'o','markersize',20);
set(h,'MarkerFaceColor','red','MarkerEdgeColor','red');
h=text(ImZmn_mep,ReZmn_mep,eta_max*100,'MPP');
set(h, 'fontweight','bold','fontsize',30,'color', [1 0 0])