%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 5, SECTION 5.2 %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%% Maximum Efficiency Point (MEP) in 2-coil links %%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc

figure_config                       % Set figures style

%% PARAMETERS %%

QTX=200;                            % Tx quality factor
QRX=QTX;                            % Rx quality factor
kTXRX=0.01;                         % Tx-Rx coupling coefficient

VS=1;                               % Tx voltage peak amplitude (when voltage source is used in the Tx), in volts
RTX=5;                              % Tx coil series parasitic resistance, in ohms
RRX=5;                              % Rx coil series parasitic resistance, in ohms

RL=[1:1:100];                       % Load resistance, in this case is equal to Re{ZMN}

%% CALCULATIONS %%
QL=QRX*RRX./RL;                                                             % Load quality factor QL=wLRX/Re{ZMN}
QRXL= QRX*QL./(QRX+QL);
eta_RX=(QRXL./QL)*100;                                                      % Rx efficiency
eta_TX=(kTXRX^2*QTX.*QRXL)./(kTXRX^2*QTX*QRXL+1)*100;                       % Tx efficiency
PTE=(1/100)*eta_RX.*eta_TX;                                                 % PTE
PDL=VS^2/(2*RTX)*(QRXL./QL).*(kTXRX^2*QTX.*QRXL)./(kTXRX^2*QTX*QRXL+1).^2;  % PDL
RLopt=RRX*sqrt(kTXRX^2*QTX*QRX+1)                                           % Optimum RL to maximize PTE

%% PLOTS %% 
figure(1)%PTE%
h=plot(RL,eta_RX);
set(h, 'color', plots_colors(3,:), 'linestyle', linestyle{3})
hold on
h=plot(RL,eta_TX);
set(h, 'color', plots_colors(2,:), 'linestyle', linestyle{2})
h=plot(RL,PTE);
set(h, 'color', plots_colors(1,:), 'linestyle', linestyle{1})

xlabel('Re\{Z_{MN}\} (\Omega)')
xlim([min(RL) max(RL)])
grid on
set(gca,'xtick',[round(RLopt,2) 40 60 80 100])
ylabel('Efficiency (%)')
legend('\eta_{L_{Rx}}', '\eta_{L_{Tx}}', '\eta_{Link}=\eta_{L_{Tx}}\times\eta_{L_{Rx}}')
