%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 5, SECTION 5.4 %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%% Choosing between MEP and MPP %%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc

figure_config                       % Set figures style

%% PARAMETERS %%

QTX=200;                            % Tx quality factor
QRX=QTX;                            % Rx quality factor
kTXRX=0.05;                         % Tx-Rx coupling coefficient

RTX=5;                              % Tx coil series parasitic resistance, in ohms
RRX=5;                              % Rx coil series parasitic resistance, in ohms

PMN_desired=500e-3;                 % Desired PMN

%% MEP %%
disp('-------------Using a voltage source Tx-------------')
disp('-------------MEP-------------')
Re_ZMN= RRX*sqrt(kTXRX^2*QTX*QRX+1)                                                 % Optimum real part of ZMN that maximizes PTE (MEP)
QL= QRX/sqrt(kTXRX^2*QTX*QRX+1)                                                     % Load quality factor (at the MEP)
QRXL= QRX*QL./(QRX+QL);
PTE=100*QRXL/QL*kTXRX^2.*QTX.*QRXL./(kTXRX^2*QTX.*QRXL+1)                           % Power Transfer Efficiency (PTE)
VS=sqrt(RTX*PMN_desired*2/(QRXL/QL*kTXRX^2.*QTX.*QRXL./(kTXRX^2*QTX.*QRXL+1).^2))   % Required VS to deliver the desired PMN

Rtx_rx= RTX*kTXRX^2*QTX*QRXL                                                        % Reflected resistance in the Tx from the Rx

%IF VS=5%
VS=5
PMN_voltage=0.5*VS^2/RTX*QRXL/QL*kTXRX^2.*QTX.*QRXL./(kTXRX^2*QTX.*QRXL+1).^2       % Power Delivered to the Load (PDL) with a voltage Tx source, if VS=5
PTx_voltage=VS^2/(2*(RTX+Rtx_rx))                                                   % Tx power
%PTx_voltage=PMN_voltage/(PTE/100)                                                   % Other way to calculate the Tx power

%% MPP %%
disp('-------------Using a voltage source Tx-------------')
disp('-------------MPP-------------')
Re_ZMN= RRX*(kTXRX^2*QTX*QRX+1)                                                     % Optimum real part of ZMN that maximizes PDL (MPP) (with a voltage source Tx)
QL= QRX/(kTXRX^2*QTX*QRX+1)                                                         % Load quality factor (in the MPP) (with a voltage source Tx)
QRXL= QRX*QL./(QRX+QL);
PTE=100*QRXL/QL*kTXRX^2.*QTX.*QRXL./(kTXRX^2*QTX.*QRXL+1)                           % Power Transfer Efficiency (PTE)
VS=sqrt(RTX*PMN_desired*2/(QRXL/QL*kTXRX^2.*QTX.*QRXL./(kTXRX^2*QTX.*QRXL+1).^2))   % Required VS to deliver the desired PMN

Rtx_rx= RTX*kTXRX^2*QTX*QRXL                                                        % Reflected resistance in the Tx from the Rx

%IF VS=5%
VS=5
PMN_voltage=0.5*VS^2/RTX*QRXL/QL*kTXRX^2.*QTX.*QRXL./(kTXRX^2*QTX.*QRXL+1).^2       % Power Delivered to the Load (PDL) with a voltage Tx source, if VS=5
PTx_voltage=VS^2/(2*(RTX+Rtx_rx))                                                   % Tx power
%PTx_voltage=PMN_voltage/(PTE/100)                                                   % Other way to calculate the Tx power


%% MEP %%
disp('-------------Using a current source Tx-------------')
disp('-------------MEP-------------')
Re_ZMN= RRX*sqrt(kTXRX^2*QTX*QRX+1)                                                 % Optimum real part of ZMN that maximizes PTE (MEP)
QL= QRX/sqrt(kTXRX^2*QTX*QRX+1)                                                     % Load quality factor (in the MEP)
QRXL= QRX*QL./(QRX+QL);
PTE=100*QRXL/QL*kTXRX^2.*QTX.*QRXL./(kTXRX^2*QTX.*QRXL+1)                           % Power Transfer Efficiency (PTE)
IS=sqrt(PMN_desired/(0.5*RTX*QRXL/QL*kTXRX^2.*QTX.*QRXL))                           % Required IS to deliver the desired PMN

Rtx_rx= RTX*kTXRX^2*QTX*QRXL                                                        % Reflected resistance in the Tx from the Rx

%IF IS=100mA%
IS=0.1
PMN_current=0.5*IS^2*RTX*QRXL/QL*kTXRX^2.*QTX.*QRXL                                 % Power Delivered to the Load (PDL) with a current Tx source, if IS=100mA
PTx_current=IS^2*(RTX+Rtx_rx)/2                                                     % Tx power
%PTx_current=PMN_current/(PTE/100)                                                   % Other way to calculate the Tx power

%% MPP %%
disp('-------------Using a current source Tx-------------')
disp('-------------MPP-------------')
Re_ZMN= RRX                                                                         % Optimum real part of ZMN that maximizes PDL (MPP) (with a current source Tx)
QL= QRX                                                                             % Load quality factor (in the MPP) (with a current source Tx)
QRXL= QRX*QL./(QRX+QL);
PTE=100*QRXL/QL*kTXRX^2.*QTX.*QRXL./(kTXRX^2*QTX.*QRXL+1)                           % Power Transfer Efficiency (PTE)
IS=sqrt(PMN_desired/(0.5*RTX*QRXL/QL*kTXRX^2.*QTX.*QRXL))                           % Required IS to deliver the desired PMN

Rtx_rx= RTX*kTXRX^2*QTX*QRXL                                                        % Reflected resistance in the Tx from the Rx

%IF VS=5%
IS=0.1
PMN_current=0.5*IS^2*RTX*QRXL/QL*kTXRX^2.*QTX.*QRXL                                 % Power Delivered to the Load (PDL) with a current Tx source, if IS=100mA
PTx_current=IS^2*(RTX+Rtx_rx)/2                                                     % Tx power
%PTx_current=PMN_current/(PTE/100)                                                   % Other way to calculate the Tx power




