%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 5, SECTION 5.6 %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% Using matching networks to achieve the OOP %%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc

figure_config                       % Set figures style

%% PARAMETERS %%

QTX=200;                            % Tx quality factor
QRX=QTX;                            % Rx quality factor
kTXRX=0.01;                         % Tx-Rx coupling coefficient

RTX=5;                              % Tx coil series parasitic resistance, in ohms
RRX=5;                              % Rx coil series parasitic resistance, in ohms

%% CALCULATIONS %% 
Re_ZMN_opt_eta=RRX*sqrt(kTXRX^2*QTX*QRX+1)                                  % Optimum real part of ZMN that maximizes PTE (MEP)
eta_max=100*(kTXRX^2*QTX*QRX)/(sqrt(kTXRX^2*QTX*QRX+1)+1)^2                 % PTE at MEP
Re_ZMN_opt_PMN=RRX*(kTXRX^2*QTX*QRX+1)                                      % Optimum real part of ZMN that maximizes PDL (MPP)
VS=0.5
PMN_max=VS^2/(8*RTX)*(kTXRX^2*QTX*QRX)/(kTXRX^2*QTX*QRX+1)                  % PDL at MPP (VS=500mV)
VS=50
PMN_max=VS^2/(8*RTX)*(kTXRX^2*QTX*QRX)/(kTXRX^2*QTX*QRX+1)                  % PDL at MPP (VS=50V)

disp('----------HIGH POWER EXAMPLE----------')
RL=200;
VS=50;
Re_ZMN_serie=RL
QL_serie=(QRX*RRX)/Re_ZMN_serie;
QRXL_serie= QRX*QL_serie./(QRX+QL_serie);
PTE_serie=100*(QRXL_serie./QL_serie).*(kTXRX^2*QTX.*QRXL_serie)./(kTXRX^2*QTX*QRXL_serie+1)                            % PTE, calculated for the series resonator case
PDL_serie=VS^2/(2*RTX)*(QRXL_serie./QL_serie).*(kTXRX^2*QTX.*QRXL_serie)./(kTXRX^2*QTX*QRXL_serie+1).^2                % PDL, calculated for the series resonator case

Re_ZMN_parallel=QRX^2*RRX^2/RL
QL_parallel=(QRX*RRX)/Re_ZMN_parallel;
QRXL_parallel= QRX*QL_parallel./(QRX+QL_parallel);
PTE_parallel=100*(QRXL_parallel./QL_parallel).*(kTXRX^2*QTX*QRXL_parallel)./(kTXRX^2*QTX*QRXL_parallel+1)              % PTE, calculated for the parallel resonator case
PDL_parallel=VS^2/(2*RTX)*(QRXL_parallel./QL_parallel).*(kTXRX^2*QTX*QRXL_parallel)./(kTXRX^2*QTX*QRXL_parallel+1).^2  % PDL, calculated for the parallel resonator case

disp('----------LOW POWER EXAMPLE----------')
RL=3000;
VS=0.5;
Re_ZMN_serie=RL
QL_serie=(QRX*RRX)/Re_ZMN_serie;
QRXL_serie= QRX*QL_serie./(QRX+QL_serie);
PTE_serie=100*(QRXL_serie./QL_serie).*(kTXRX^2*QTX.*QRXL_serie)./(kTXRX^2*QTX*QRXL_serie+1)                            % PTE, calculated for the series resonator case
PDL_serie=VS^2/(2*RTX)*(QRXL_serie./QL_serie).*(kTXRX^2*QTX.*QRXL_serie)./(kTXRX^2*QTX*QRXL_serie+1).^2                % PDL, calculated for the series resonator case

Re_ZMN_parallel=QRX^2*RRX^2/RL
QL_parallel=(QRX*RRX)/Re_ZMN_parallel;
QRXL_parallel= QRX*QL_parallel./(QRX+QL_parallel);
PTE_parallel=100*(QRXL_parallel./QL_parallel).*(kTXRX^2*QTX*QRXL_parallel)./(kTXRX^2*QTX*QRXL_parallel+1)              % PTE, calculated for the parallel resonator case
PDL_parallel=VS^2/(2*RTX)*(QRXL_parallel./QL_parallel).*(kTXRX^2*QTX*QRXL_parallel)./(kTXRX^2*QTX*QRXL_parallel+1).^2  % PDL, calculated for the parallel resonator case


