%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 5, SECTION 5.7 %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% Comparing 2-coil and 3-coil links at the MEP %%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc

figure_config                   % Set figures style

%% PARAMETERS %%

QTX=200;                        % Tx quality factor
QRX=QTX;                        % Rx quality factor

radioTX=10;                     % Tx coil radius
radioA1=radioTX;                % Resonator radius
radioRX=radioTX;                % Rx coil radius

DTXRX=60;                       % Tx to Rx distance


%% Example 1, 2-coil%%

kTXRX=(radioRX^2*radioTX.^2)./(sqrt(radioRX*radioTX).*(DTXRX.^2+radioTX.^2).^(3/2));	% Tx to Rx coupling coefficient

alpha2=kTXRX^2*QTX*QRX                                                                  % Alpha_2 defined in (5.33)    
QLopt_eta=QRX/(kTXRX^2*QTX*QRX+1)                                                       % Optimum QL that maximizes PTE (MEP) (in a 2-coil link)
A2=sqrt(1+alpha2);                                                                      % A2 defined in (5.32)
eta=100*(A2^2-1)/(A2+1)^2                                                               % PTE at MEP (5.31)

%% Example 2, 3-coil, QA=5%%

QA1=5;                                                                                                      % Additional coil 1 (resonator) quality factor

%CALCULATIONS%
DTXA1=(0:.01:DTXRX);                                                                                        % Tx to resonator distance
kTXA1=(radioA1^2*radioTX^2)./(sqrt(radioA1*radioTX)*(DTXA1.^2+radioTX^2).^(3/2));                           % Tx to resonator coupling coefficient
DA1RX=DTXRX-DTXA1;                                                                                          % Resonator to Rx distance (swept)
kA1RX=(radioRX^2*radioA1^2)./(sqrt(radioRX*radioA1)*(DA1RX.^2+radioA1^2).^(3/2));                           % Resonator to Rx coupling coefficient

alpha3=kTXA1.^2*QTX*QA1.*kA1RX.^2*QA1*QRX./(kTXA1.^2*QTX*QA1+kA1RX.^2*QA1*QRX+1);                           % Alpha_3 defined in (5.33)    
QLopt_eta=QRX*sqrt((kTXA1.^2*QTX*QA1+1)./((kA1RX.^2*QA1*QRX+1).*(kTXA1.^2*QTX*QA1+kA1RX.^2*QA1*QRX+1)));    % Optimum QL that maximizes PTE (MEP) (in a 3-coil link)
A3=sqrt(1+alpha3);                                                                                          % A3 defined in (5.32)
eta=100*(A3.^2-1)./(A3+1).^2;                                                                               % PTE at MEP (5.31)

%PLOTS%
figure()
h=plot(DTXA1/DTXRX,alpha3);
grid on
xlabel('D_{Tx-A1}/D_{Tx-Rx}')
ylabel('\alpha_3')
set(h, 'color', [0 0 0])
set(gca, 'XTick', [0 0.5 1]);
xlim([0, 1]);
set(gca, 'YTick', [0.79 10 20]);
ylim([0, 20]);

figure()
h=plot(DTXA1/DTXRX,QLopt_eta);
grid on
xlabel('D_{Tx-A1}/D_{Tx-Rx}')
ylabel('Q_{L_{opt-\eta}}')
set(h, 'color', [0 0 0])
set(gca, 'XTick', [0 0.5 1]);
xlim([0, 1]);
set(gca, 'YTick', [0 100 200]);
ylim([0, 200]);

figure()
h=plot(DTXA1/DTXRX,eta);
grid on
xlabel('D_{Tx-A1}/D_{Tx-Rx}')
ylabel('\eta_{Link_{max}} (%)')
set(h, 'color', [0 0 0])
set(gca, 'XTick', [0 0.5 1]);
xlim([0, 1]);
set(gca, 'YTick', [14.5 35 70]);
ylim([0, 70]);

%% Example 2, 3-coil, QA=50%%

QA1=50;                                                                                                     % Additional coil 1 (resonator) quality factor

%CALCULATIONS%
DTXA1=(0:.01:DTXRX);                                                                                        % Tx to resonator distance
kTXA1=(radioA1^2*radioTX^2)./(sqrt(radioA1*radioTX)*(DTXA1.^2+radioTX^2).^(3/2));                           % Tx to resonator coupling coefficient
DA1RX=DTXRX-DTXA1;                                                                                          % Resonator to Rx distance (swept)
kA1RX=(radioRX^2*radioA1^2)./(sqrt(radioRX*radioA1)*(DA1RX.^2+radioA1^2).^(3/2));                           % Resonator to Rx coupling coefficient

alpha3=kTXA1.^2*QTX*QA1.*kA1RX.^2*QA1*QRX./(kTXA1.^2*QTX*QA1+kA1RX.^2*QA1*QRX+1);                           % Alpha_3 defined in (5.33)    
QLopt_eta=QRX*sqrt((kTXA1.^2*QTX*QA1+1)./((kA1RX.^2*QA1*QRX+1).*(kTXA1.^2*QTX*QA1+kA1RX.^2*QA1*QRX+1)));    % Optimum QL that maximizes PTE (MEP) (in a 3-coil link)
A3=sqrt(1+alpha3);                                                                                          % A3 defined in (5.32)
eta=100*(A3.^2-1)./(A3+1).^2;                                                                               % PTE at MEP (5.31)

%PLOTS%
figure()
h=plot(DTXA1/DTXRX,alpha3);
grid on
xlabel('D_{Tx-A1}/D_{Tx-Rx}')
ylabel('\alpha_3')
set(h, 'color', [0 0 0])
set(gca, 'XTick', [0 0.5 1]);
xlim([0, 1]);
set(gca, 'YTick', [0.79 10 20]);
ylim([0, 20]);

figure()
h=plot(DTXA1/DTXRX,QLopt_eta);
grid on
xlabel('D_{Tx-A1}/D_{Tx-Rx}')
ylabel('Q_{L_{opt-\eta}}')
set(h, 'color', [0 0 0])
set(gca, 'XTick', [0 0.5 1]);
xlim([0, 1]);
set(gca, 'YTick', [0 100 200]);
ylim([0, 200]);

figure()
h=plot(DTXA1/DTXRX,eta);
grid on
xlabel('D_{Tx-A1}/D_{Tx-Rx}')
ylabel('\eta_{Link_{max}} (%)')
set(h, 'color', [0 0 0])
set(gca, 'XTick', [0 0.5 1]);
xlim([0, 1]);
set(gca, 'YTick', [14.5 35 70]);
ylim([0, 70]);

%% Example 3, 3-coil, QA=200%%

QA1=200;                                                                                                    % Additional coil 1 (resonator) quality factor

%CALCULATIONS%
DTXA1=(0:.01:DTXRX);                                                                                        % Tx to resonator distance
kTXA1=(radioA1^2*radioTX^2)./(sqrt(radioA1*radioTX)*(DTXA1.^2+radioTX^2).^(3/2));                           % Tx to resonator coupling coefficient
DA1RX=DTXRX-DTXA1;                                                                                          % Resonator to Rx distance (swept)
kA1RX=(radioRX^2*radioA1^2)./(sqrt(radioRX*radioA1)*(DA1RX.^2+radioA1^2).^(3/2));                           % Resonator to Rx coupling coefficient

alpha3=kTXA1.^2*QTX*QA1.*kA1RX.^2*QA1*QRX./(kTXA1.^2*QTX*QA1+kA1RX.^2*QA1*QRX+1);                           % Alpha_3 defined in (5.33)    
QLopt_eta=QRX*sqrt((kTXA1.^2*QTX*QA1+1)./((kA1RX.^2*QA1*QRX+1).*(kTXA1.^2*QTX*QA1+kA1RX.^2*QA1*QRX+1)));    % Optimum QL that maximizes PTE (MEP) (in a 3-coil link)
A3=sqrt(1+alpha3);                                                                                          % A3 defined in (5.32)
eta=100*(A3.^2-1)./(A3+1).^2;                                                                               % PTE at MEP (5.31)

%PLOTS%
figure()
h=plot(DTXA1/DTXRX,alpha3);
grid on
xlabel('D_{Tx-A1}/D_{Tx-Rx}')
ylabel('\alpha_3')
set(h, 'color', [0 0 0])
set(gca, 'XTick', [0 0.5 1]);
xlim([0, 1]);
set(gca, 'YTick', [0.79 10 20]);
ylim([0, 20]);

figure()
h=plot(DTXA1/DTXRX,QLopt_eta);
grid on
xlabel('D_{Tx-A1}/D_{Tx-Rx}')
ylabel('Q_{L_{opt-\eta}}')
set(h, 'color', [0 0 0])
set(gca, 'XTick', [0 0.5 1]);
xlim([0, 1]);
set(gca, 'YTick', [0 100 200]);
ylim([0, 200]);

figure()
h=plot(DTXA1/DTXRX,eta);
grid on
xlabel('D_{Tx-A1}/D_{Tx-Rx}')
ylabel('\eta_{Link_{max}} (%)')
set(h, 'color', [0 0 0])
set(gca, 'XTick', [0 0.5 1]);
xlim([0, 1]);
set(gca, 'YTick', [14.5 35 70]);
ylim([0, 70]);
