%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 5, SECTION 5.8 %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% Design of a 3-coil link to work at the MEP %%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc

figure_config                   % Set figures style

%% PARAMETERS %%

QTX=200;                        % Tx quality factor
QA1=QTX;                        % Additional coil (resonator) quality factor
QRX=QTX;                        % Rx quality factor
radioTX=10;                     % Tx coil radius
radioA1=radioTX;                % Resonator radius
radioRX=radioTX;                % Rx coil radius

DTXRX=60;                       % Tx to Rx distance
DTXA1=(0:.1:DTXRX);             % Tx to first resonator distace

VS=1;                           % Tx voltage source
RTX=5;                          % Tx coil series parasitic resistance


%% CALCULUS and PLOT 3-coil %%

QL_vector=[5, 50];                                                                      % Load quality factor QL=wLRX/Re{ZMN}

kTXA1=(radioA1^2*radioTX^2)./(sqrt(radioA1*radioTX)*(DTXA1.^2+radioTX^2).^(3/2));       % Tx to additional coil coupling coefficient
DA1RX=DTXRX-DTXA1;                                                                      % Additional resonator to Rx distance (swept)
kA1RX=(radioRX^2*radioA1^2)./(sqrt(radioRX*radioA1)*(DA1RX.^2+radioA1^2).^(3/2));       % Additional resonator to Rx coupling coefficient

index_color=1;                                                                          % Index used to select the plot color
for QL=QL_vector                                                                        % For each QL
    %CALCULATIONS%
    QRXL= QRX*QL./(QRX+QL);
    XTXA1=kTXA1.^2*QTX*QA1;                                                             % Parameter used to calculate efficiency in the 3-coil link
    XA1RXL=kA1RX.^2*QA1*QRXL;                                                           % Parameter used to calculate efficiency in the 3-coil link
    PTE_3coil= QRXL/QL*(XA1RXL./(XA1RXL+1)).*(XTXA1./(XTXA1+XA1RXL+1));                 % PTE for the 3-coil link as a function of the additional resonator position, DTXA1
    PDL_3coil= VS^2/(2*RTX)*QRXL/QL*(XA1RXL.*XTXA1)./(XTXA1+XA1RXL+1).^2;               % PDL for the 3-coil link as a function of the additional resonator position, DTXA1

    %PLOTS%
    figure(1)%PTE%
    h=plot(DTXA1/DTXRX,100*PTE_3coil);
    set(h, 'color', plots_colors(index_color,:), 'linestyle', linestyle{index_color})
    hold on
    
    figure(2)%PDL%
    h=plot(DTXA1/DTXRX,1e3*PDL_3coil);
    set(h, 'color', plots_colors(index_color,:), 'linestyle', linestyle{index_color})
    hold on
    index_color=index_color+1;
end

%% PLOT STYLE %%

figure(1)
legend('Q_L=5','Q_L=50')
grid on
xlabel('D_{Tx-A}/D_{Tx-Rx}')
ylabel('\eta_{Link} (%)')

figure(2)
legend('Q_L=5','Q_L=50')
grid on
xlabel('D_{Tx-A}/D_{Tx-Rx}')
ylabel('P_{MN} (mW)')

%% MEP and MPP %%

%CALCULATIONS%
XA1RX=kA1RX.^2*QA1*QRX;
A=sqrt(1+XTXA1.*XA1RX./(XTXA1+XA1RX+1));                                            % A3 defined in (5.32)
PTE_max_3coil=(A.^2-1)./(A+1).^2;                                                   % PTE at MEP (5.31)
[alpha beta]=max(PTE_max_3coil);
QL_opt= QRX*sqrt((XTXA1(beta)+1)/((XA1RX(beta)+1)*(XA1RX(beta)+XTXA1(beta)+1)))     % Optimum QL that maximizes PTE (MEP) (in a 3-coil link)

%PLOTS%
figure(3)
h=plot(DTXA1/DTXRX,100*PTE_max_3coil);
set(h, 'color', plots_colors(1,:), 'linestyle', linestyle{1})
grid on
xlabel('D_{Tx-A}/D_{Tx-Rx}')
ylabel('\eta_{Link_{max}} (%)')
fprintf('kTXA1= %d \n', kTXA1(beta))
fprintf('kA1RX= %d \n', kA1RX(beta))


