%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 8, SECTION 8.1.2 %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%% 2-coil RFID link Charging phase %%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc
%format long eng
figure_config                       % Set figures style

%% PARAMETERS %%
% Presented in Table 8.1 %
f=134.2e3;                          % Carrier frequency
w=2*pi*f;                           % Carrier angular frequency

% Reader %
LTX=443e-6;                         % Reader (Tx) self-inductance (H)
RTX=15.9;                           % Reader (Tx) Equivalent Series Resistance (ESR) (ohms)
RoutR=11.5;                         % Driver output impedance (TMS3705 Transponder Base Station IC) (ohms)
radiusTX=6;                         % Reader (Tx) radius (cm) 
CTX=1/(w^2*LTX);                    % Reader (Tx) resonance capacitor (F)
QTX=(w*LTX)/RTX;                    % Reader (Tx) quality factor
RQTX=5e3;                           % Resistance added to reduce equivalent QTX and avoid ISI. To consider it uncomment lines 47 and 53

% Tag %
LRX=2.49e-3;                        % Tag (Rx) self-inductance (H)
RRX=44.59;                          % Tag (Rx) Equivalent Series Resistance (ESR) (ohms)
RL=2.2e6;                           % Load resistance (ohms)
radiusRX=1;                         % Tag (Rx) average radius (cm) (outer radius + inner radius)/2
CRX=1/(w^2*LRX);                    % Tag (Rx) resonance capacitor (F)
QRX=(w*LRX)/RRX;                    % Tag (Rx) quality factor

DTXRX=10;                           % Reader (Tx) to Tag (Rx) distance (cm)
%% CALCULATIONS %%
% PTE %
% Explained in Table 8.2 %
% The calculations here are presented from the bottom of the table (last raw) to the top.
Rrect=RL/2                                                                                  % Rectifier input resistance
Re_ZMN=1/(Rrect*(w*CRX)^2)                                                                  % Real part of matching network input impedance
QL=(w*LRX)/Re_ZMN                                                                           % Load quality factor
QRXL=(QRX*QL)/(QRX+QL)                                                                      % Rx equivalent quality factor
kTXRX=(radiusRX^2*radiusTX^2)/(sqrt(radiusRX*radiusTX)*(DTXRX^2+radiusTX^2)^(3/2))          % Reader (Tx) to tag (Rx) coupling coefficient
QTX=(w*LTX)/(RTX+RoutR)                                                                     % Tx quality factor, overwritten to include driver output impedance
%QTX=(w*LTX)/(RTX+RoutR+(w*LTX)^2/RQTX)                                                      % Tx quality factor, overwritten to include driver output impedance and RQTX added to reduce QTX and avoid ISI
PTE=100*QRXL/QL*kTXRX^2*QTX*QRXL/(kTXRX^2*QTX*QRXL+1)                                       % Inductive link efficiency

% PDL %
VS=6.37;
EqRTX=RTX+RoutR;                                                                            % Equivalent RTX, considering driver output impedance RoutR
%EqRTX=RTX+RoutR+(w*LTX)^2/RQTX;                                                             % Equivalent RTX, considering driver output impedance RoutR, and RQTX
PMN=0.5*VS^2/(EqRTX)*QRXL/QL*kTXRX^2*QTX*QRXL/(kTXRX^2*QTX*QRXL+1)^2                        % Power Delivered to the Load (PDL) with a voltage Tx source
VL=sqrt(PMN*RL)