%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 8, SECTION 8.1.2 %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%% 2-coil RFID link Reading phase %%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc
%format long eng
figure_config                       % Set figures style

%% PARAMETERS %%
% Presented in Table 8.1 %
% Note that during the reading phase, the TX is the tag while the RX is the reader %

f_carrier=134.2e3;                  % Power carrier frequency
w_carrier=2*pi*f_carrier;           % Power carrier angular frequency

f_low=134.2e3;                      % Low bit frequency
w_low=2*pi*f_low;                   % Low bit angular frequency

f_high=123.2e3;                     % Low bit frequency
w_high=2*pi*f_high;                 % Low bit angular frequency

% Reader %
LRX=443e-6;                         % Reader (Rx) self-inductance (H)
RRX_low=15.9;                       % Reader (Rx) Equivalent Series Resistance (ESR) at the low bit frequency (ohms)
RRX_high=15.1;                      % Reader (Rx) Equivalent Series Resistance (ESR) at the high bit frequency (ohms)
radiusRX=6;                         % Reader (Rx) radius (cm) 
CRX=1/(w_carrier^2*LRX);            % Reader (Rx) resonance capacitor (F)
QRX_low=(w_low*LRX)/RRX_low;        % Reader (Rx) quality factor at the low bit frequency
QRX_high=(w_high*LRX)/RRX_high;     % Reader (Rx) quality factor at the high bit frequency
RQRX=5e3;                           % Resistance added to reduce equivalent reader quality factor and avoid ISI. To consider it uncomment line 28
RL=47e3;                            % Load resistance (ohms)
%RL=47e3*RQRX/(47e3+RQRX);           % Load resistance if RQRX is included (ohms)

% Tag %
LTX=2.49e-3;                        % Tag (Tx) self-inductance (H)
RTX_low=44.59;                      % Tag (Tx) Equivalent Series Resistance (ESR) at the low bit frequency (ohms)
RTX_high=42.75;                     % Tag (Tx) Equivalent Series Resistance (ESR) at the high bit frequency (ohms)
radiusTX=1;                         % Tag (Tx) average radius (cm) (outer radius + inner radius)/2
QTX_low=(w_low*LTX)/RTX_low;        % Tag (Tx) quality factor at the low bit frequency
QTX_high=(w_high*LTX)/RTX_high;     % Tag (Tx) quality factor at the high bit frequency

DTXRX=10;                           % Reader (Tx) to Tag (Rx) distance (cm)

%% PTE CALCULATIONS %%
disp('-----------------PTE-------------------')
kTXRX=(radiusRX^2*radiusTX^2)/(sqrt(radiusRX*radiusTX)*(DTXRX^2+radiusRX^2)^(3/2)); % Reader (Tx) to tag (Rx) coupling coefficient
disp('-----------Low bit 134.2 kHz-----------')
Re_ZMN=1/(RL*(w_low*CRX)^2);                                                        % Real part of matching network input impedance
QL_low=(w_low*LRX)/Re_ZMN;                                                          % Load quality factor
QRXL_low=(QRX_low*QL_low)/(QRX_low+QL_low);                                         % Rx equivalent quality factor
PTE_low=100*QRXL_low/QL_low*kTXRX^2*QTX_low*QRXL_low/(kTXRX^2*QTX_low*QRXL_low+1)   % Power Transfer Efficiency (PTE)
ZRXTX_ref_low=w_low^2*kTXRX^2*LTX*LRX/(RRX_low+Re_ZMN);                             % Reflected impedance from reader (Rx) in tag (Tx)

disp('-----------High bit 123.2 kHz-----------')
ZMN=(RL*1/(j*w_high*CRX))/(RL+1/(j*w_high*CRX));                                    % The ZMN is the parallel of RL and CRX
QL_high=(w_high*LRX)/real(ZMN);                                                     % Load quality factor
ZRXTX_ref_high=w_high^2*kTXRX^2*LTX*LRX/(RRX_high+j*w_high*LRX+ZMN);                % Reflected impedance from reader (Rx) in tag (Tx)
eta_RX=QRX_high/(QRX_high+QL_high);                                                 % Reader (Rx) coil efficiency
eta_TX=real(ZRXTX_ref_high)/(real(ZRXTX_ref_high)+RTX_high);                        % Tag (Tx) coil efficiency
PTE_high=100*eta_RX*eta_TX

%% PDL CALCULATIONS %%
disp('-----------------PDL-------------------')
VT=9;
disp('-----------Low bit 134.2 kHz-----------')
EqZTX_low=RTX_low+j*w_low*LTX+ZRXTX_ref_low;	% Tag (Tx) driver load impedance
ITX_low=VT/abs(EqZTX_low);                      % Tag (Tx) current
PT_low=(ITX_low)^2*real(EqZTX_low)/2;           % Tag (Tx) driver output power
PMN_low=PT_low*PTE_low/100;                     % Reader (Rx) received power
VRS_low=sqrt(PMN_low*RL*2)                      % Voltage at the sense node (voltage to be decoded)
disp('-----------High bit 123.2 kHz-----------')
EqZTX_high=RTX_high+j*w_high*LTX+ZRXTX_ref_high;% Tag (Tx) driver load impedance
ITX_high=VT/abs(EqZTX_high);                    % Tag (Tx) current
PT_high=(ITX_high)^2*real(EqZTX_high)/2;        % Tag (Tx) driver output power
PMN_high=PT_high*PTE_high/100;                  % Reader (Rx) received power
VRS_high=sqrt(PMN_high*RL*2)                    % Voltage at the sense node (voltage to be decoded)
