%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 8, SECTION 8.1.3 %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 3-coil RFID link %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc
%format long eng
figure_config                       % Set figures style

%% PARAMETERS %%
% Presented in Tables 8.1 and 8.6%
f=134.2e3;                          % Carrier frequency
w=2*pi*f;                           % Carrier angular frequency

% Reader %
LTX=443e-6;                         % Reader (Tx) self-inductance (H)
RTX=15.9;                           % Reader (Tx) Equivalent Series Resistance (ESR) (ohms)
RoutR=11.5;                         % Driver output impedance (TMS3705 Transponder Base Station IC) (ohms)
radiusTX=6;                         % Reader (Tx) radius (cm) 
CTX=1/(w^2*LTX);                    % Reader (Tx) resonance capacitor (F)
CTX_extra=390e-12;                  % Reader (Tx) extra capacitor used to detune the (Tx) and avoid ISI (F). To consider it uncomment line 66
QTX=(w*LTX)/RTX;                    % Reader (Tx) quality factor
RQTX=5e3;                           % Resistance added to reduce equivalent QTX and avoid ISI. To consider it uncomment lines 58 and 65

% Additional coil %
LA=648e-6;                          % Additional coil self-inductance (H)
RA=13.3;                            % Additional coil Equivalent Series Resistance (ESR) (ohms)
RQA=53e3;                           % Resistance added to reduce equivalent QA and avoid ISI. To consider it uncomment line 36
radiusA=13;                         % Additional coil radius (cm)
CA=1/(w^2*LA);                      % Additional coil resonance capacitor (F)
QA=w*LA/RA;                         % Additional coil quality factor
%QA=w*LA/(RA+(w*LA)^2/RQA);         % Additional coil quality factor including RQA

% Tag %
LRX=2.49e-3;                        % Tag (Rx) self-inductance (H)
RRX=44.59;                          % Tag (Rx) Equivalent Series Resistance (ESR) (ohms)
RL=2.2e6;                           % Load resistance (ohms)
radiusRX=1;                         % Tag (Rx) average radius (cm) (outer radius + inner radius)/2
CRX=1/(w^2*LRX);                    % Tag (Rx) resonance capacitor (F)
QRX=(w*LRX)/RRX;                    % Tag (Rx) quality factor

DTXA=30;                            % Reader (Tx) to additional coil distance (cm)
DARx=5;                             % Additional coil to tag (Rx) distance (cm)

%% CALCULATIONS %%
% PTE %
Rrect=RL/2;                                                                                                 % Rectifier input resistance
Re_ZMN=1/(Rrect*(w*CRX)^2);                                                                                 % Real part of matching network input impedance
QL=(w*LRX)/Re_ZMN;                                                                                          % Load quality factor
QRXL=(QRX*QL)/(QRX+QL);                                                                                     % Rx equivalent quality factor
kTXA=(radiusA^2*radiusTX^2)/(sqrt(radiusA*radiusTX)*(DTXA^2+radiusA^2)^(3/2));                              % Reader (Tx) to additional coil coupling coefficient
kARX=(radiusRX^2*radiusA^2)/(sqrt(radiusRX*radiusA)*(DARx^2+radiusA^2)^(3/2));                              % Additional coil to tag (Rx) coupling coefficient
QTX=(w*LTX)/(RTX+RoutR);                                                                                    % Tx quality factor, overwritten to include driver output impedance
%QTX=(w*LTX)/(RTX+RoutR+(w*LTX)^2/RQTX);                                                                     % Tx quality factor, overwritten to include driver output impedance and RQTX added to reduce QTX and avoid ISI
PTE= 100*QRXL/QL*(kARX^2*QA*QRXL/(kARX^2*QA*QRXL+1))*(kTXA^2*QTX*QA/(kTXA^2*QTX*QA+kARX^2*QA*QRXL+1))       % PTE for the 3-coil link

% PDL %
VS=6.37;
RATXref=kTXA^2*QTX*QA*(RTX+RoutR)/(kARX^2*QA*QRXL+1);       % Reflected resistance in the reader (Tx) coil, see equation (2.30)
EqZTX=RTX+RoutR+RATXref;                                    % Equivalent RTX, considering driver output impedance RoutR
%EqZTX=RTX+RoutR+RATXref+(w*LTX)^2/RQTX;                    % Equivalent RTX, considering driver output impedance RoutR, and RQTX
%EqZTX=RTX+RoutR+RATXref+1/(j*w*(CTX+CTX_extra))+j*w*LTX;	% Equivalent RTX, considering driver output impedance RoutR, and CTX_extra
ITX=VS/abs(EqZTX);
PS=ITX^2*real(EqZTX)/2;
PDL=PS*PTE/100
VL=sqrt(PDL*RL)

%If the reader is resonating (without CTX_extra) the previously calculated PDL is equal to:
%PDL= VS^2/(2*(RTX+RoutR))*QRXL/QL*(kARX^2*QA*QRXL*kTXA^2*QTX*QA)/(kTXA^2*QTX*QA+kARX^2*QA*QRXL+1)^2         %PDL for the 3-coil link
%VL=sqrt(PDL*RL)
