%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 8, SECTION 8.2.2 %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%% Rx matching network design, series vs parallel %%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc
%format long eng
figure_config                       % Set figures style

%% PARAMETERS %%
% Presented in Table 8.8 %
f=13.56e6;                          % Carrier frequency
w=2*pi*f;                           % Carrier angular frequency
% Presented in Table 8.9 %
% Tx %
LTX=120e-9;                         % Tx self-inductance (H)
RsTX=0.06;                          % Tx Equivalent Series Resistance (ESR) (ohms)
RpTX=2.36e3;                        % Tx Parasitic Paralel Resistance (ohms)
% Rx %
LRX=340e-9;                         % Rx self-inductance (H)
RsRX=0.72;                          % Rx Equivalent Series Resistance (ESR) (ohms)
RpRX=1.68e3;                        % Rx Equivalent Series Resistance (ESR) (ohms)
% Tx-Rx %
kTXRX=0.0301;                       % Reader (Tx) to Tag (Rx) coupling coefficient
% Presented in Table 8.10 %
% Tx %
RTX=(RsTX+(w*LTX)^2/RpTX);
QTX=(w*LTX)/RTX;                    % Tx quality factor
% Rx %
RRX=(RsRX+(w*LRX)^2/RpRX);
QRX=(w*LRX)/RRX;                    % Tx quality factor
% Estimated in Section 8.2.1
RL=500;                             % Load 50 mW @ 5 V

Grect=1;                            % Rectfier Gain. It is =1 in section 8.2.2 and =2 in section 8.2.3

%% CALCULATIONS %%
% Equation (8.5) %
Re_ZMN_opt_eta=RRX*sqrt(kTXRX^2*QTX*QRX+1);
Re_ZMN_opt_PMN=RRX*(kTXRX^2*QTX*QRX+1);
% Presented in Table 8.11 %
Rrect=RL/(2*Grect^2);               % Rectifier input resistance
CRX=1/(w^2*LRX);                    % Rx resonance capacitor (F)
% Series %
ZMN_series= Rrect+1/(j*w*CRX);
% Parallel %
ZMN_parallel= 1/(Rrect*(w*CRX)^2)+1/(j*w*CRX);
% Presented in Table 8.12 %
% Series %
QL_series=(w*LRX)/real(ZMN_series);                                                                 % Load quality factor
QRXL_series=(QRX*QL_series)/(QRX+QL_series);                                                        % Rx equivalent quality factor
PTE_series=100*QRXL_series/QL_series*kTXRX^2*QTX*QRXL_series/(kTXRX^2*QTX*QRXL_series+1)            % Power Transfer Efficiency (PTE)
% Parallel %
QL_parallel=(w*LRX)/real(ZMN_parallel);                                                             % Load quality factor
QRXL_parallel=(QRX*QL_parallel)/(QRX+QL_parallel);                                                  % Rx equivalent quality factor
PTE_parallel=100*QRXL_parallel/QL_parallel*kTXRX^2*QTX*QRXL_parallel/(kTXRX^2*QTX*QRXL_parallel+1)  % Power Transfer Efficiency (PTE)

