%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 8, SECTION 8.3 %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% Wireless power transfer for Smartphones %%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc
%format long eng
figure_config                       % Set figures style

%% PARAMETERS %%

f=125e3;                            % Carrier frequency
w=2*pi*f;                           % Carrier angular frequency

% Tx %
LTX=10e-6;                          % Tx self-inductance (H)
QTX=130;
RTX=w*LTX/QTX;                      % Tx Equivalent Series Resistance (ESR) (ohms)
% Rx %
LRX=12e-6;                          % Rx self-inductance (H)
QRX=33;                             % Tx quality factor
RRX=w*LRX/QRX;                      % Tx Equivalent Series Resistance (ESR) (ohms)
CRX=1/(w^2*LRX);
% Tx-Rx %
kTXRX=0.2;                          % Reader (Tx) to Tag (Rx) coupling coefficient

RL=5;                               % Load 5W @ 5 V
PL=5;
VL=5;

Grect=1;                            % Full-wave rectifier
eta_rect=0.9;                       % Approximation, it depends on Vrect
eta_dcdc=0.9;                       % Approximation, it depends on Vrect

%% CALCULATIONS %%

%Optimum point %
Re_ZMN_opt_eta=RRX*sqrt(kTXRX^2*QTX*QRX+1)
Re_ZMN_opt_PMN=RRX*(kTXRX^2*QTX*QRX+1)

% Maximum eta %
A=kTXRX^2*QTX*QRX;
eta_link_max=(A)/(sqrt(A+1)+1)^2

CTX=192e-9;                         % detuned case
XS=-1/(w*CTX)+w*LTX;
Re_ZMN_opt_PMN_withX=RRX*sqrt(((kTXRX^2*QTX*QRX+1)^2+(XS/RTX)^2)/((XS/RTX)^2+1))

%% Plots %%
%TUNED%
Vs_tuned=(6.3:0.2:7.7);
PTE_tuned=[72.2415 72.1771 72.0655 71.7365 71.2036 70.8147 70.3736 69.8847]; % From LTspice simulation
figure()
h=plot(Vs_tuned, PTE_tuned);
set(h,'color',[0 0 0])
xlabel('V_S (V)')
ylabel('PTE (%)')
xlim([6.2 7.7])
grid on
%DETUNED%
Vs_detuned=[1.715 1.725 1.75 1.8 1.9 2 2.1 2.2];
PTE_detuned=[41.9617 37.9629 34.0487 29.3511 23.9495 20.3917 17.753 15.6783]; % From LTspice simulation
figure()
h=plot(Vs_detuned, PTE_detuned);
set(h,'color',[0 0 0])
xlabel('V_S (V)')
xlim([1.7 2.2])
grid on
ylabel('PTE (%)')
