%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%Inductive Links for Wireless Power Transfer%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%Pablo Pérez-Nicoli, Fernando Silveira and Maysam Ghovanloo%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% CHAPTER 8, SECTION 8.4 %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% Wireless power transfer for Electric vehicles %%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all 
clear all
clc
%format long eng
figure_config                       % Set figures style

%% PARAMETERS %%
f=20e3;                             % Carrier frequency
w=2*pi*f;                           % Carrier angular frequency

% Tx %
LTX=603e-6;                         % Tx self-inductance (H)
RTX=81e-3+80e-3;                    % Tx Equivalent Series Resistance (ESR) (ohms)
QTX=(w*LTX)/RTX;                    % Tx quality factor

% Rx %
LRX=635e-6;                         % Rx self-inductance (H)
CRX=1/(w^2*LRX);
RRX=105e-3+21e-3;                   % Rx Equivalent Series Resistance (ESR) (ohms)
RL=22.5;                            % Load resistance (ohms)
QRX=(w*LRX)/RRX;                    % Rx quality factor

kTXRX=0.1468;
%% CALCULATIONS %%
Rrect=RL/2                                              % Rectifier input resistance
Re_ZMN=Rrect                                            % Real part of matching network input impedance
QL=(w*LRX)/Re_ZMN                                       % Load quality factor
QRXL=(QRX*QL)/(QRX+QL)                                  % Rx equivalent quality factor

PTE=100*QRXL/QL*kTXRX^2*QTX*QRXL/(kTXRX^2*QTX*QRXL+1)   % Power Transfer Efficiency (PTE)
