************************************************************************************************************************
* PROJECT: 		Die Nationalratswahl 2017 unter besonderer Berücksichtigung der Silberstein-Affäre
* OBJECTIVE: 	AUTNES Online Panel Study - Annotated Do-File
* AUTHOR:		Nicolai Berk, Julia Partheymüller & Jakob-Moritz Eberl
* DATE:			2019-01-02
* DATA DOI:		10.11587/I7QIYJ
************************************************************************************************************************

* Definiere Pfade (MAIN anpassen)
global MAIN "~/Dropbox/Blauer Band 2017/NEW"
global DATA "$MAIN/data"
global GRAPHS "$MAIN/graphs"
global TABLES "$MAIN/tables"

* Datensatz laden
use "$DATA/10017_da_de_v1_0.dta", clear

set more off
set scheme s1mono

************************************************************************************************************************
* Rekodieren
************************************************************************************************************************


* AUFMERKSAMKEIT WAHLKAMPF ALLGEMEIN
***********************************
recode w2_q1 (4=0 "gar nicht aufmerksam") (3=1 " wenig aufmerksam ") (2=2 "ziemlich aufmerksam") (1=3 "sehr aufmerksam") (99=.), gen(w2_campint)
recode w3_q1 (4=0 "gar nicht aufmerksam") (3=1 " wenig aufmerksam ") (2=2 "ziemlich aufmerksam") (1=3 "sehr aufmerksam") (99=.), gen(w3_campint)
recode w4_q2 (4=0 "gar nicht aufmerksam") (3=1 " wenig aufmerksam ") (2=2 "ziemlich aufmerksam") (1=3 "sehr aufmerksam") (99=.), gen(w4_campint)
recode w5_q1 (4=0 "gar nicht aufmerksam") (3=1 " wenig aufmerksam ") (2=2 "ziemlich aufmerksam") (1=3 "sehr aufmerksam") (99=.), gen(w5_campint)

** Auf [0,1] reskalieren
lab def zerone_campint  0 "gar nicht aufmerksam" 1 "sehr aufmerksam"
foreach num of numlist 2/5 {
	replace w`num'_campint = w`num'_campint/3
	lab val w`num'_campint zerone_campint
}


* WAHLWAHRSCHEINLICHKEIT
***********************************
recode w1_q14 (0=0 "nehme sicher nicht teil") (10=10 "nehme ganz sicher teil") (77/99=.), gen(w1_turnout)
recode w2_q12 (0=0 "nehme sicher nicht teil") (10=10 "nehme ganz sicher teil") (77/99=.), gen(w2_turnout)
recode w3_q13 (0=0 "nehme sicher nicht teil") (10=10 "nehme ganz sicher teil") (77/99=.), gen(w3_turnout)
recode w4_q15 (0=0 "nehme sicher nicht teil") (10=10 "nehme ganz sicher teil") (77/99=.), gen(w4_turnout)
recode w5_q9 (1/3=0 "Wahlteilnahme: Nein") (4=10 "Wahlteilnahme: Ja") (99=.), gen(w5_turnout)

** Auf [0,1] reskalieren
lab def zerone_vote5 0 "Habe nicht gewählt" 1 "Habe gewählt"
lab def zerone_vote  0 "Nehme sicher nicht teil" 1 "nehme ganz sicher teil"
foreach num of numlist 1/4 {
	replace w`num'_turnout = w`num'_turnout/10
	lab val w`num'_turnout zerone_vote
}
lab val w5_turnout zerone_vote5


* WAHLWAHRSCHEINLICHKEIT SPÖ
***********************************
recode w1_q12x1 (0=0  "sehr unwahrscheinlich") (10=10 "sehr wahrscheinlich") (77/99=.), gen(w1_ptvspoe)
recode w2_q5x1 (0=0  "sehr unwahrscheinlich") (10=10 "sehr wahrscheinlich") (77/99=.), gen(w2_ptvspoe)
recode w3_q8x1 (0=0  "sehr unwahrscheinlich") (10=10 "sehr wahrscheinlich") (77/99=.), gen(w3_ptvspoe)
recode w4_q10x1 (0=0  "sehr unwahrscheinlich") (10=10 "sehr wahrscheinlich") (77/99=.), gen(w4_ptvspoe)

* WAHLWAHRSCHEINLICHKEIT: LIST SEBASTIAN KURZ - THE NEW PEOPLE'S PARTY
***********************************
fre w1_q12x2 w2_q5x2 w3_q8x2 w4_q10x2
recode w1_q12x2 (0=0  "sehr unwahrscheinlich") (10=10 "sehr wahrscheinlich") (77/99=.), gen(w1_ptvoevp)
recode w2_q5x2 (0=0  "sehr unwahrscheinlich") (10=10 "sehr wahrscheinlich") (77/99=.), gen(w2_ptvoevp)
recode w3_q8x2 (0=0  "sehr unwahrscheinlich") (10=10 "sehr wahrscheinlich") (77/99=.), gen(w3_ptvoevp)
recode w4_q10x2 (0=0  "sehr unwahrscheinlich") (10=10 "sehr wahrscheinlich") (77/99=.), gen(w4_ptvoevp)

* Auf [0,1] reskalieren
lab def zerone_ptv 0 "sehr unwahrscheinlich" 1 "sehr wahrscheinlich"
foreach num of numlist 1/4 {
	replace w`num'_ptvspoe = w`num'_ptvspoe/10
	lab val w`num'_ptvspoe zerone_ptv
}

foreach num of numlist 1/4 {
	replace w`num'_ptvoevp = w`num'_ptvoevp/10
	lab val w`num'_ptvoevp zerone_ptv
}

* SYMPATHIE: CHRISTIAN KERN
***********************************
recode w1_q13x1 	(0=0 "gar nicht sympathisch") (10=10 "sehr sympathisch") (77/99=.), gen(w1_scalokern) copy
recode w2_q6x1 		(0=0 "gar nicht sympathisch") (10=10 "sehr sympathisch") (77/99=.), gen(w2_scalokern) copy
recode w3_q9x1 		(0=0 "gar nicht sympathisch") (10=10 "sehr sympathisch") (77/99=.), gen(w3_scalokern) copy
recode w4_q11x1		(0=0 "gar nicht sympathisch") (10=10 "sehr sympathisch") (77/99=.), gen(w4_scalokern) copy
recode w5_q8x1 		(0=0 "gar nicht sympathisch") (10=10 "sehr sympathisch") (77/99=.), gen(w5_scalokern) copy

* SYMPATHIE: SEBASTIAN KURZ
************************************
fre w1_q13x2 w2_q6x2 w3_q9x2 w4_q11x2 w5_q8x2
recode w1_q13x2 	(0=0 "gar nicht sympathisch") (10=10 "sehr sympathisch") (77/99=.), gen(w1_scalokurz) copy
recode w2_q6x2 		(0=0 "gar nicht sympathisch") (10=10 "sehr sympathisch") (77/99=.), gen(w2_scalokurz) copy
recode w3_q9x2 		(0=0 "gar nicht sympathisch") (10=10 "sehr sympathisch") (77/99=.), gen(w3_scalokurz) copy
recode w4_q11x2		(0=0 "gar nicht sympathisch") (10=10 "sehr sympathisch") (77/99=.), gen(w4_scalokurz) copy
recode w5_q8x2 		(0=0 "gar nicht sympathisch") (10=10 "sehr sympathisch") (77/99=.), gen(w5_scalokurz) copy

* Auf [0,1] reskalieren
lab def zerone_symp 0 "gar nicht sympathisch" 1 "sehr sympathisch"
foreach num of numlist 1/5 {
	replace w`num'_scalokern =  w`num'_scalokern/10
	lab val w`num'_scalokern zerone_symp
}

foreach num of numlist 1/5 {
	replace w`num'_scalokurz =  w`num'_scalokurz/10
	lab val w`num'_scalokurz zerone_symp
}

* PARTEI-IDENTIFIKATION
***********************************

* "Im Allgemeinen einer politischen Partei nahe"
recode w1_q17 (1=0) (2=1) (99=.), gen(w1_nopid)
recode w4f_q24 (1=0) (2=1) (99=.), gen(w4f_nopid)
recode w6f_q14 (1=0) (2=1) (99=.), gen(w6f_nopid)

* "Näher zu einer Partei als zu anderen"
recode w1_q18 (1=0) (2=1) (99=.), gen(w1_nolean)
recode w4f_q25 (1=0) (2=1) (99=.), gen(w4f_nolean)
recode w6f_q15 (1=0) (2=1) (99=.), gen(w6f_nolean)

gen nolean = w1_nolean
replace nolean = w4f_nolean if w1_nolean ==.
replace nolean = w6f_nolean if w1_nolean ==. & w4f_nolean==.

gen nopid = w1_nopid
replace nopid = w4f_nopid if w1_nopid ==.
replace nopid = w6f_nopid if w1_nopid ==. & w4f_nopid==.

gen indep = .
replace indep = 0 if nolean== 0 | nopid==0
replace indep = 1 if nolean==1 & nopid==1

* Parteiidentifikation
recode w1_q19 (1=1 "SPOE") (2=2 "OEVP") (3=3 "FPOE") (4=4 "Gruene") (5=5 "NEOS") (6=7 "Andere Partei") 	(99=.), gen(w1_pid)
recode w4f_q26 (1=1 "SPOE") (2=2 "OEVP") (3=3 "FPOE") (4=4 "Gruene") (5=5 "NEOS") (6=6 "PILZ") (7=7 "Andere Partei") (99=.), gen(w4f_pid)
recode w6f_q16 (1=1 "SPOE") (2=2 "OEVP") (3=3 "FPOE") (4=4 "Gruene") (5=5 "NEOS") (6=6 "PILZ") (7=7 "Andere Partei") (99=.), gen(w6f_pid)

gen pid = w1_pid
replace pid = w4f_pid if w1_pid ==.
replace pid = w6f_pid if w1_pid ==. & w4f_pid==.
replace pid = 8 if indep==1
lab def pid_lb 1 "SPOE" 2 "OEVP" 3 "FPOE" 4 "GRUENE" 5 "NEOS" 6 "PILZ" 7 "Andere Partei" 8 "Keine Partei"
lab val pid pid_lb

gen pid_str = pid
replace pid_str = . if w1_q17  != 1 & w4f_q24 != 1 & w6f_q14 != 1
lab val pid_str pid_lb

* PID: Fünf Kategorien
recode pid (1=1) (2=2) (3=3) (4/7=4) (8=5), gen(pid_5cat)
label def pid_5cat_lb 1 "SPÖ" 2 "ÖVP" 3"FPÖ" 4"Andere" 5 "Keine"
label val pid_5cat pid_5cat_lb

recode pid_str (1=1) (2=2) (3=3) (4/7=4) (.=5), gen(pid_5cat_str)
label val pid_5cat_str pid_5cat_lb

* SILBERSTEIN BATTERIE
***********************************

* Aufmerksamkeit Silberstein Skandal
recode w5_q17 (4=0 "gar nicht aufmerksam") (3=1 "wenig aufmerksam") (2=2 "ziemlich aufmerksam") (1=3 "sehr aufmerksam") (99=.), gen(att_silberstein)

** Recodierung [0,1]
replace att_silberstein = att_silberstein/3
lab def att_silberstein_lb			///
		0 	"gar nicht aufmerksam" 	///
		1/3 "wenig aufmerksam"		///
		2/3 "ziemlich aufmerksam"	///
		1 	"sehr aufmerksam"

* EINFLUSS AUF WAHLENTSCHEIDUNG: SILBERSTEIN SKANDAL (TABLE 2)
***********************************************
recode w5_q19 (88=.), gen(influence) copy
lab var influence "Einfluss auf das Wahlverhalten (Selbsteinschätzung)"
tab influence pid_5cat [aweight = w5_weightd], col nof 

* KAMPAGNENWAHRNEHMUNG (GRAPH 1)
***********************************************

* Kampagne: fair
recode w5_q48x1 (4=0  "gar nicht") (3=1  "wenig") (2=2  "ziemlich") (1=3 "sehr") (88=.), gen(campfair)
label var campfair "Fair"

gen campunfair = 3-campfair
label var campunfair "Unfair"

* Kampagne: aggressiv
recode w5_q48x2 (4=0  "gar nicht") (3=1  "wenig") (2=2  "ziemlich") (1=3 "sehr") (88=.), gen(campaggr)
label var campaggr "Aggressiv"

* Kampagne: langweilig
fre w5_q48x3
recode w5_q48x3 (4=0  "gar nicht") (3=1  "wenig") (2=2  "ziemlich") (1=3 "sehr") (88=.), gen(campdull)
fre campdull
label var campdull "Langweilig"
*checked

* Kampagne: unterhaltsam
recode w5_q48x4 (4=0  "gar nicht") (3=1  "wenig") (2=2  "ziemlich") (1=3 "sehr") (88=.), gen(campfun)
label var campfun "Unterhaltsam"

foreach var of varlist campfair campunfair campaggr campdull campfun {
	gen `var'_01 = `var'/3 
}

* Graph
graph bar campunfair_01 campaggr_01 campdull_01 campfun_01 [pweight = w5_weightd], 									///
	legend(lab(1 "Unfair") lab(2 "Aggressiv") lab(3 "Langweilig") lab(4 "Unterhaltsam") region(lwidth(none))) 		///
	ylabel(0 "0" 0.125 " " 0.25 "0.25" 0.375 " " 0.5 "0.5" 0.625 " " 0.75 "0.75", angle(0)) bargap (50) 			///
	ytitle(Mittelwert (Skala: 0-1)) over(att_silberstein, 															///
											relabel(1 "gar nicht aufmerksam" 					///
													2 "wenig aufmerksam" 						///
													3 "ziemlich aufmerksam" 					///
													4 "sehr aufmerksam")						///
											gap(*2) label(labsize(vsmall))) 					///
	caption("Daten: AUTNES Online Panel Study, Welle 5" "Beobachtungen demographisch gewichtet", size(small)) 
graph export "$GRAPHS/campaign_perceptions.png", replace

				

*********************************************************************************************************
* Datensatz für Analyse vorbereiten
*********************************************************************************************************

* Variablen für Analyse umbenennen
foreach stub in turnout campint scalokern scalokurz ptvspoe ptvoevp {
	rename w2_`stub' `stub'_w2
	rename w3_`stub' `stub'_w3
	rename w4_`stub' `stub'_w4	
}

* Respondenten auswählen
keep if w1_panelist==1 & w2_panelist==1 & w3_panelist==1 & w4_panelist==1 & w5_panelist==1

* Variablen auswählen
keep id pid_5cat pid_5cat_str att_silberstein					///
	 turnout_w2 turnout_w3 turnout_w4							///
	 campint_w2 campint_w3 campint_w4 							///
	 scalokern_w2 scalokern_w3 scalokern_w4						///
	 scalokurz_w2 scalokurz_w3 scalokurz_w4						///
	 ptvspoe_w2 ptvspoe_w3 ptvspoe_w4							///
	 ptvoevp_w2 ptvoevp_w3 ptvoevp_w4

********************************************************************************
*  Datensatz für Panelanalyse vorbereiten
********************************************************************************

* Langes Datendesign
reshape long turnout_w campint_w scalokern_w scalokurz_w ptvspoe_w ///
		ptvoevp_w, i(id) j(wave)


* Panelstruktur definieren
xtset id wave

* Periodeneffekte
gen wave1 = (wave == 1)
gen wave2 = (wave == 2)
gen wave3 = (wave == 3)
gen wave4 = (wave == 4)

*********************************************************************************************************
* Analyse: Drei-Wege-Interaktion
*********************************************************************************************************

* Wahlbeteiligung
xtreg turnout_w 		wave3 wave4 											///
						c.wave3#c.att_silberstein c.wave4#c.att_silberstein 	///
						c.wave3#b1.pid_5cat c.wave4#b1.pid_5cat					///
						c.wave3#c.att_silberstein#b1.pid_5cat c.wave4#c.att_silberstein#b1.pid_5cat, fe
estimates store m1
margins, dydx(att_silberstein) at(wave4=1 wave3=0 pid=(1 2 3 4 5))
marginsplot, 	title("Wahlbeteiligung") xtitle("Parteiidentifikation") 		///
				ytitle("Marginaler Effekt: Aufmerksamkeit Silberstein") yline(0) ///
				ylabel(#6, grid) plotregion(lstyle(none))
graph export "$GRAPHS/results_turnout.png", replace

* Wahlkampfinteresse
xtreg campint_w 		wave3 wave4 											///
						c.wave3#c.att_silberstein c.wave4#c.att_silberstein 	///
						c.wave3#b1.pid_5cat c.wave4#b1.pid_5cat					///
						c.wave3#c.att_silberstein#b1.pid_5cat c.wave4#c.att_silberstein#b1.pid_5cat, fe
estimates store m2
margins, dydx(att_silberstein) at(wave4=1 wave3=0 pid=(1 2 3 4 5))
marginsplot, 	title("Interesse am Wahlkampf") xtitle("Parteiidentifikation") ///
				ytitle("Marginaler Effekt: Aufmerksamkeit Silberstein") yline(0) ///
				ylabel(#6, grid) plotregion(lstyle(none))
graph export "$GRAPHS/results_campint.png", replace

* Sympathie Kern
xtreg scalokern_w 		wave3 wave4 											///
						c.wave3#c.att_silberstein c.wave4#c.att_silberstein 	///
						c.wave3#b1.pid_5cat c.wave4#b1.pid_5cat					///
						c.wave3#c.att_silberstein#b1.pid_5cat c.wave4#c.att_silberstein#b1.pid_5cat, fe
estimates store m3
margins, dydx(att_silberstein) at(wave4=1 wave3=0 pid=(1 2 3 4 5))
marginsplot, 	title("Sympathie Kern") xtitle("Parteiidentifikation") 			///
				ytitle("Marginaler Effekt: Aufmerksamkeit Silberstein") yline(0) ///
				ylabel(#6, grid) plotregion(lstyle(none))
				
graph export "$GRAPHS/results_scalokern.png", replace

* Wahlwahrscheinlichkeit SPÖ
xtreg ptvspoe_w 		wave3 wave4 											///
						c.wave3#c.att_silberstein c.wave4#c.att_silberstein 	///
						c.wave3#b1.pid_5cat c.wave4#b1.pid_5cat					///
						c.wave3#c.att_silberstein#b1.pid_5cat c.wave4#c.att_silberstein#b1.pid_5cat, fe
estimates store m4
margins, dydx(att_silberstein) at(wave4=1 wave3=0 pid=(1 2 3 4 5))
marginsplot, 	title("Wahlwahrscheinlichkeit SPOE") xtitle("Parteiidentifikation") ///
				ytitle("Marginaler Effekt: Aufmerksamkeit Silberstein") yline(0) ///
				ylabel(#6, grid) plotregion(lstyle(none))
graph export "$GRAPHS/results_ptvspoe.png", replace

* Sympathie Kurz
xtreg scalokurz_w 		wave3 wave4 											///
						c.wave3#c.att_silberstein c.wave4#c.att_silberstein 	///
						c.wave3#b1.pid_5cat c.wave4#b1.pid_5cat					///
						c.wave3#c.att_silberstein#b1.pid_5cat c.wave4#c.att_silberstein#b1.pid_5cat, fe
estimates store m5
margins, dydx(att_silberstein) at(wave4=1 wave3=0 pid=(1 2 3 4 5))
marginsplot, 	title("Sympathie Kurz") xtitle("Parteiidentifikation") 			///
				ytitle("Marginaler Effekt: Aufmerksamkeit Silberstein") yline(0) ///
				ylabel(#6, grid) plotregion(lstyle(none))
graph export "$GRAPHS/results_scalokurz.png", replace

* Wahlwahrscheinlichkeit ÖVP
xtreg ptvoevp_w 		wave3 wave4 											///
						c.wave3#c.att_silberstein c.wave4#c.att_silberstein 	///
						c.wave3#b1.pid_5cat c.wave4#b1.pid_5cat					///
						c.wave3#c.att_silberstein#b1.pid_5cat c.wave4#c.att_silberstein#b1.pid_5cat, fe
estimates store m6
margins, dydx(att_silberstein) at(wave4=1 wave3=0 pid=(1 2 3 4 5))
marginsplot, 	title("Wahlwahrscheinlichkeit OEVP") xtitle("Parteiidentifikation") ///
				ytitle("Marginaler Effekt: Aufmerksamkeit Silberstein") yline(0) ///
				ylabel(#6, grid) plotregion(lstyle(none))
graph export "$GRAPHS/results_ptvoevp.png", replace



* Tabelle
esttab m1 m2 m3 m4 m5 m6 using "$TABLES/table_results.rtf",  b(3) se(4) wide replace 		///
	nonumbers mtitles("Wahlbeteiligung" "Wahlkampfinteresse" "Sympathie: Kern" 				///
						"Sympathie: Kurz" "PTV: SPÖ" "PTV: ÖVP")							///
	stats(N N_g r2)

********************************************************************************
* Graph der abhängigen Variablen über Zeit
********************************************************************************
* Durchschnitte für Parteien und Wellen errechnen
collapse (mean) turnout_w campint_w scalokern_w ///
				scalokurz_w ptvspoe_w ptvoevp_w, by(wave pid_5cat)

* Wahlbeteiligung
graph twoway line turnout_w wave if pid_5cat == 2,							///
										name(graph0, replace)				///
										ylabel(.8 "0.8".85 		///
										"0.85".9 "0.9" .95 "0.95" 1 "1", 	///
										grid gmin gmax angle(0))			///
										title("Wahlbeteiligung")			///
										ytitle("")							///
										xtitle("")							///
										xlabel(, nolabels noticks)			///
										scale(1.5)							///
										col("black")						///
										legend(order(5 "SPÖ" 1 "ÖVP"		///
										2 "FPÖ" 3 "Andere"					///
										4 "Keine"))							///
	|| line turnout_w wave if pid_5cat == 3, col("blue") lp("- -")			///
	|| line turnout_w wave if pid_5cat == 4, col("gray") lp("._")			///
	|| line turnout_w wave if pid_5cat == 5, col("gray") lp("_")			///
	|| line turnout_w wave if pid_5cat == 1, col("red")						///
	|| dot  turnout_w wave if pid_5cat == 1, mcol("red") msymbol(o) dcol("white")
										

* Wahlkampfinteresse
graph twoway line campint_w wave if pid_5cat == 2,							///
										name(graph1, replace)				///
										ylabel(0 "0" .25 "0.25" .5 "0.5" 	///
										.75 "0.75" 1 "1", 					///
										grid gmin gmax angle(0))			///
										title("Wahlkampfinteresse")			///
										ytitle("")							///
										xtitle("")							///
										xlabel(, nolabels noticks)			///
										scale(1.5)							///
										col("black")						///
										legend(off)							///
	|| line campint_w wave if pid_5cat == 3, col("blue") lp("- -")			///
	|| line campint_w wave if pid_5cat == 4, col("gray") lp("._")			///
	|| line campint_w wave if pid_5cat == 5,  	col("gray") lp("_")			///
	|| line campint_w wave if pid_5cat == 1, col("red")						///
	|| dot  campint_w wave if pid_5cat == 1, mcol("red") msymbol(o) dcol("white")

* Sympathie: Kern
graph twoway line scalokern_w wave if pid_5cat == 2,						///
										name(graph2, replace)				///
										ylabel(0 "0" .25 "0.25" .5 "0.5" 	///
										.75 "0.75" 1 "1", 					///
										grid gmin gmax angle(0))			///
										title("Sympathie: Kern")			///
										xlabel(, nolabels)					///
										ytitle("")							///
										xtitle("")							///
										xlabel(, nolabels noticks)			///
										scale(1.5)							///
										col("black")						///
										legend(off)							///
	|| line scalokern_w wave if pid_5cat == 3, col("blue") lp("- -")		///
	|| line scalokern_w wave if pid_5cat == 4, col("gray") lp("._")			///
	|| line scalokern_w wave if pid_5cat == 5, 	col("gray") lp("_")			///
	|| line scalokern_w wave if pid_5cat == 1, col("red")					///
	|| dot  scalokern_w wave if pid_5cat == 1, mcol("red") msymbol(o) dcol("white")

* Sympathie: Kurz
graph twoway line scalokurz_w wave if pid_5cat == 2,						///
										name(graph3, replace)				///
										ylabel(0 "0" .25 "0.25" .5 "0.5" 	///
										.75 "0.75" 1 "1", 					///
										grid gmin gmax angle(0))			///
										title("Sympathie: Kurz")			///
										ytitle("")							///
										xtitle("")							///
										xlabel(, nolabels noticks)			///
										scale(1.5)							///
										col("black")						///
										legend(off)							///
	|| line scalokurz_w wave if pid_5cat == 3, col("blue") lp("- -")		///
	|| line scalokurz_w wave if pid_5cat == 4, col("gray") lp("._")			///
	|| line scalokurz_w wave if pid_5cat == 5, 	col("gray") lp("_")		///
	|| line scalokurz_w wave if pid_5cat == 1, col("red")					///
	|| dot  scalokurz_w wave if pid_5cat == 1, mcol("red") msymbol(o) dcol("white")

* Wahlwahrscheinlichkeit: SPÖ
graph twoway line ptvspoe_w wave if pid_5cat == 2,							///
										name(graph4, replace)				///
										ylabel(0 "0" .25 "0.25" .5 "0.5" 	///
										.75 "0.75" 1 "1", grid gmin gmax	///
										 angle(0))							///
										title("PTV: SPÖ")					///
										ytitle("")							///
										xtitle("")							///
										xlabel(, nolabels noticks)			///
										scale(1.5)							///
										col("black")						///
										legend(off)							///
	|| line ptvspoe_w wave if pid_5cat == 3, col("blue") lp("- -")			///
	|| line ptvspoe_w wave if pid_5cat == 4, col("gray") lp("._")			///
	|| line ptvspoe_w wave if pid_5cat == 5, 	col("gray") lp("_")			/// 
	|| line ptvspoe_w wave if pid_5cat == 1, col("red")						///
	|| dot  ptvspoe_w wave if pid_5cat == 1, mcol("red") msymbol(o) dcol("white")

* Wahlwahrscheinlichkeit: ÖVP
graph twoway line ptvoevp_w wave if pid_5cat == 2,							///
										name(graph5, replace)				///
										ylabel(0 "0" .25 "0.25" .5 "0.5" 	///
										.75 "0.75" 1 "1", grid gmin gmax	///
										 angle(0))							///
										title("PTV: ÖVP")					///
										ytitle("")							///
										xtitle("")							///
										xlabel(, nolabels noticks)			///
										scale(1.5)							///
										col("black")						///
										legend(off)							///
	|| line ptvoevp_w wave if pid_5cat == 3, col("blue") lp("- -")			///
	|| line ptvoevp_w wave if pid_5cat == 4, col("gray") lp("._")			///
	|| line ptvoevp_w wave if pid_5cat == 5, col("gray") lp("_")			///
	|| line ptvoevp_w wave if pid_5cat == 1, col("red")						///
	|| dot  ptvoevp_w wave if pid_5cat == 1, mcol("red") msymbol(o) dcol("white")

* Zusammenführung
grc1leg graph0 graph1 graph2 graph3 graph4 graph5, 	///
		title("Mittelwerte der abhängigen Variablen"		/// 
				"im Verlauf der Befragungswellen", size("vlarge")) ///
		subtitle("nach Parteiidentifikation")scale(.8)
graph export "$GRAPHS/dep_waves.png", replace width(2550)

