###############################################################################
## Set-up
###############################################################################

## On Windows: Copy path to "~/btw", then:
# setwd(gsub("\\\\", "/", readClipboard()))

## Load packages
## Save package names as a vector of strings
pkgs <- c("abind", "parallel", "plyr", "nnet", "MASS", "foreign")

## Install uninstalled packages
lapply(pkgs[!(pkgs %in% installed.packages())], install.packages,
       repos = 'https://cran.uni-muenster.de/')

## Load all packages to library and adjust options
lapply(pkgs, library, character.only = TRUE)

###############################################################################
## Source Functions
###############################################################################

source("fun/invlogit.R")
source("fun/softmax.R")
source("fun/pred_mnl.R")
source("fun/mediate_mnl.R")

###############################################################################
## Data
###############################################################################

## Load pre-processed GLES Data
load("data/gles.RData")


###############################################################################
## Description
###############################################################################

## Risk and Subjective Fears
m0.sim.1 <- m0.sim.0 <- NULL
m0.x.1 <-
  cbind(1, log(seq(0, 38, 2) + 1), 1, log(seq(0, 38, 2) + 1))
m0.x.0 <- cbind(1, log(seq(0, 38, 2) + 1), 0, 0)
for (i in seq_along(gles.imp)) {
  m <- glm(
    subj_loss ~ risk + unemp00 + risk:unemp00,
    data = gles.act[[i]],
    weights = weight,
    family = binomial(link = "logit")
  )
  m0.sim.0 <- rbind(m0.sim.0,
                    invlogit(mvrnorm(1000L, coef(m), vcov(m)) %*% t(m0.x.0)))
  m0.sim.1 <- rbind(m0.sim.1,
                    invlogit(mvrnorm(1000L, coef(m), vcov(m)) %*% t(m0.x.1)))
}
m0.0 <- apply(m0.sim.0, 2, quantile, c(.5, .025, .975))
m0.1 <- apply(m0.sim.1, 2, quantile, c(.5, .025, .975))
rm(m0.sim.0, m0.sim.1, m)
save(m0.0, m0.1, file = "est/m0.RData")

## Voting by labor market status
m2 <- pred_mnl(
  vote2017 ~ 1 + lm_part + glescomp,
  data = gles.imp[[1]],
  weights = "weight",
  imp = FALSE,
  S = 200L,
  x.name = "lm_part",
  x.steps = NULL,
  ey_stack = TRUE,
  dydx = FALSE,
  rdydx = FALSE
)
save(m2, file = "est/m2.RData")

## Voting by labor market risks
m3 <- pred_mnl(
  formula = vote2017 ~ 1 + risk + glescomp,
  data = gles.act,
  weights = "weight",
  imp = TRUE,
  S = 200L,
  seed = 20190331,
  x.name = "risk",
  x.shift = "unit",
  x.steps = log(seq(0, 38, 2) + 1),
  ey_stack = TRUE,
  dydx = TRUE
)
save(m3, file = "est/m3.RData")


###############################################################################
## Mediation of Risk
###############################################################################

risk.ed <- mediate_mnl(
  formula.y = vote2017 ~ risk +
    unemp00 + log_hinc_eq +
    imm_self + se_self + stf_dem +
    age + fem + east + union + relig +
    edu5 +
    glescomp,
  formula.m1 = imm_self ~ risk +
    unemp00 + log_hinc_eq +
    age + fem + east +
    edu5 +
    glescomp,
  formula.m2 = se_self ~ risk +
    unemp00 + log_hinc_eq +
    age + fem + east +
    edu5 +
    glescomp,
  formula.m3 = stf_dem ~ risk +
    unemp00 + log_hinc_eq +
    age + fem + east +
    edu5 +
    glescomp,
  type.m1 = "continuous",
  type.m2 = "continuous",
  type.m3 = "continuous",
  data = gles.act,
  weights = "weight",
  imp = TRUE,
  S = 200L,
  seed = 19890213,
  type.t = "continuous",
  t.name = "risk",
  t.shift = "unit"
)

## Save
save(risk.ed, file = "est/med_risk.RData")


###############################################################################
## Mediation of Unemployment
###############################################################################

unemp.ed <- mediate_mnl(
  formula.y = vote2017 ~ risk +
    unemp00 + log_hinc_eq +
    imm_self + se_self + stf_dem +
    age + fem + east + union + relig +
    edu5 +
    glescomp,
  formula.m1 = imm_self ~ risk +
    unemp00 + log_hinc_eq +
    age + fem + east +
    edu5 +
    glescomp,
  formula.m2 = se_self ~ risk +
    unemp00 + log_hinc_eq +
    age + fem + east +
    edu5 +
    glescomp,
  formula.m3 = stf_dem ~ risk +
    unemp00 + log_hinc_eq +
    age + fem + east +
    edu5 +
    glescomp,
  type.m1 = "continuous",
  type.m2 = "continuous",
  type.m3 = "continuous",
  data = gles.act,
  weights = "weight",
  imp = TRUE,
  S = 200L,
  seed = 19890213,
  type.t = "binary",
  t.name = "unemp00"
)

## Save
save(unemp.ed, file = "est/med_unemp.RData")