* Analyse Uncertainty für Blauen Band
* update 4 Apr 2021 tb


clear
* use "K:\BTW2009_13_17_GLES\ZA6800_2017\gles_2017_bam2.dta"

cd /home/tb/Dropbox/Pappi_DFG_Projekt/Uncertainty
use gles_2017_bam2.dta




* Wahlabsicht
gen vote=q11ba
recode vote (1=1)(4=2)(5=3)(6=4)(7=5)(322=6)(else=.)


* Parteipositionen und Selbsteinstufung
gen lire1=q52a-6
gen lire2=q52b-6
gen lire3=q52c-6
gen lire4=q52f-6
gen lire5=q52e-6
gen lire6=q52d-6
gen lire7=q52g-6

gen ego_lire=q54-6

gen soz1=q56a-6
gen soz2=q56b-6
gen soz3=q56c-6
gen soz4=q56f-6
gen soz5=q56e-6
gen soz6=q56d-6
gen soz7=q56g-6

gen ego_soz=q59-6
gen sal_soz=q62

gen mig1=q57a-6
gen mig2=q57b-6
gen mig3=q57c-6
gen mig4=q57f-6
gen mig5=q57e-6
gen mig6=q57d-6
gen mig7=q57g-6

gen ego_mig=q60-6
gen sal_mig=q63

gen klima1=q58a-6
gen klima2=q58b-6
gen klima3=q58c-6
gen klima4=q58f-6
gen klima5=q58e-6
gen klima6=q58d-6
gen klima7=q58g-6

gen ego_klima=q61-6
gen sal_klima=q64


* Befragte mit vollständige Angaben
egen lirem=rowmiss (lire1 lire2 lire3 lire4 lire5 lire6 lire7)
gen liregl=1 if (lire1==lire2 & lire2==lire3 & lire3==lire4 & lire4==lire5 & lire5==lire6 & lire6==lire7) & lirem==0
egen sozm=rowmiss(soz1 soz2 soz3 soz4 soz5 soz6 soz7)
gen sozgl=1 if (soz1==soz2 & soz2==soz3 & soz3==soz4 & soz4==soz5 & soz5==soz6 & soz6==soz7) & sozm==0
egen migm=rowmiss(mig1 mig2 mig3 mig4 mig5 mig6 mig7)
gen miggl=1 if (mig1==mig2 & mig2==mig3 & mig3==mig4 & mig4==mig5 & mig5==mig6 & mig6==mig7) & migm==0
egen klimam=rowmiss(klima1 klima2 klima3 klima4 klima5 klima6 klima7)
gen klimagl=1 if (klima1==klima2 & klima2==klima3 & klima3==klima4 & klima4==klima5 & klima5==klima6 & klima6==klima7) & klimam==0
recode liregl sozgl miggl klimagl (.=0)
tab1 lirem liregl sozm sozgl migm miggl klimam klimagl   // S. 9 


*links-rechts 
by intnr, sort: gen meanr_lire=(lire1+lire2+lire3+lire4+lire5+lire6+lire7)/7
*** alt: im Folgenden werden AM-Skalen benutzt
*gen r_lire=(((lire1 - meanr_lire)*cdu_lire_am)+((lire2 - meanr_lire)*csu_lire_am)+((lire3 - meanr_lire)*spd_lire_am)+((lire4 - meanr_lire)*fdp_lire_am)+((lire5 - meanr_lire)*gru_lire_am)+((lire6 - meanr_lire)*lin_lire_am)+((lire7 - meanr_lire)*afd_lire_am))
gen std_lire= sqrt((lire1 - meanr_lire)^2 + (lire2 - meanr_lire)^2 + (lire3 - meanr_lire)^2 + (lire4 - meanr_lire)^2 + (lire5 - meanr_lire)^2 + (lire6 - meanr_lire)^2 + (lire7 - meanr_lire)^2)
*gen corr_lire= r_lire/std_lire 

gen zlire1=(lire1-meanr_lire)/(std_lire/sqrt(7)) 
gen zlire2=(lire2-meanr_lire)/(std_lire/sqrt(7)) 
gen zlire3=(lire3-meanr_lire)/(std_lire/sqrt(7)) 
gen zlire4=(lire4-meanr_lire)/(std_lire/sqrt(7)) 
gen zlire5=(lire5-meanr_lire)/(std_lire/sqrt(7)) 
gen zlire6=(lire6-meanr_lire)/(std_lire/sqrt(7)) 
gen zlire7=(lire7-meanr_lire)/(std_lire/sqrt(7)) 

gen zego_lire=(ego_lire-meanr_lire)/(std_lire/(sqrt(7)))

egen lire_zm1=mean(zlire1) if lirem==0 & liregl~=1
egen lire_zm2=mean(zlire2) if lirem==0 & liregl~=1 
egen lire_zm3=mean(zlire3) if lirem==0 & liregl~=1
egen lire_zm4=mean(zlire4) if lirem==0 & liregl~=1
egen lire_zm5=mean(zlire5) if lirem==0 & liregl~=1
egen lire_zm6=mean(zlire6) if lirem==0 & liregl~=1
egen lire_zm7=mean(zlire7) if lirem==0 & liregl~=1

gen stdzm_lire=sqrt(lire_zm1^2+lire_zm2^2+lire_zm2^2+lire_zm3^2+lire_zm4^2+lire_zm5^2+lire_zm6^2+lire_zm7^2)

* ICC auf individueller Ebene
gen rzm_lire=(((lire1 - meanr_lire)*lire_zm1)+((lire2 - meanr_lire)*lire_zm2)+((lire3 - meanr_lire)*lire_zm3)+((lire4 - meanr_lire)*lire_zm4)+((lire5 - meanr_lire)*lire_zm5)+((lire6 - meanr_lire)*lire_zm6)+((lire7 - meanr_lire)*lire_zm7))
gen corrzm_lire=rzm_lire/(std_lire*stdzm_lire)


* alt: benutzt AM-Daten
*gen lrdam1=(self_lire_am-cdu_lire_am)^2 if q52a~=.
*replace lrdam1=(self_lire_am-csu_lire_am)^2 if q52b~=. & bula==9
*gen lrdam2=(self_lire_am-spd_lire_am)^2 if q52c~=.
*gen lrdam3=(self_lire_am-fdp_lire_am)^2 if q52f~=.
*gen lrdam4=(self_lire_am-gru_lire_am)^2 if q52e~=.
*gen lrdam5=(self_lire_am-lin_lire_am)^2 if q52d~=.
*gen lrdam6=(self_lire_am-afd_lire_am)^2 if q52g~=.

gen lrdo1=(ego_lire-lire1)^2
replace lrdo1=(ego_lire-lire2)^2 if bula==9
gen lrdo2=(ego_lire-lire3)^2
gen lrdo3=(ego_lire-lire4)^2
gen lrdo4=(ego_lire-lire5)^2
gen lrdo5=(ego_lire-lire6)^2
gen lrdo6=(ego_lire-lire7)^2

gen lrdz1=(zego_lire-zlire1)^2
replace lrdz1=(zego_lire-zlire2)^2 if bula==9
gen lrdz2=(zego_lire-zlire3)^2
gen lrdz3=(zego_lire-zlire4)^2
gen lrd4=(zego_lire-zlire5)^2
gen lrdz5=(zego_lire-zlire6)^2
gen lrdz6=(zego_lire-zlire7)^2

gen lrdzm1=(zego_lire-lire_zm1)^2
replace lrdzm1=(zego_lire-lire_zm2)^2 if bula==9
gen lrdzm2=(zego_lire-lire_zm3)^2
gen lrdzm3=(zego_lire-lire_zm4)^2
gen lrdzm4=(zego_lire-lire_zm5)^2
gen lrdzm5=(zego_lire-lire_zm6)^2
gen lrdzm6=(zego_lire-lire_zm7)^2

* alt: benutzt AM-Daten
*gen corr_liret=3 if corr_lire>=.9 & corr_lire~=.
*replace corr_liret=2 if corr_lire<.9 & corr_lire > .3
*replace corr_liret=1 if corr_lire<=.3
*by corr_liret, sort : summarize zlire*



* sozio-ökon.

by intnr, sort: gen meanr_soz=(soz1+soz2+soz3+soz4+soz5+soz6+soz7)/7
*gen r_soz=(((soz1 - meanr_soz)*cdu_soz_am)+((soz2 - meanr_soz)*csu_soz_am)+((soz3 - meanr_soz)*spd_soz_am)+((soz4 - meanr_soz)*fdp_soz_am)+((soz5 - meanr_soz)*gru_soz_am)+((soz6 - meanr_soz)*lin_soz_am)+((soz7 - meanr_soz)*afd_soz_am))
gen std_soz= sqrt((soz1 - meanr_soz)^2 + (soz2 - meanr_soz)^2 + (soz3 - meanr_soz)^2 + (soz4 - meanr_soz)^2 + (soz5 - meanr_soz)^2 + (soz6 - meanr_soz)^2 + (soz7 - meanr_soz)^2)
*gen corr_soz= r_soz/std_soz

gen zsoz1=(soz1-meanr_soz)/(std_soz/sqrt(7)) 
gen zsoz2=(soz2-meanr_soz)/(std_soz/sqrt(7)) 
gen zsoz3=(soz3-meanr_soz)/(std_soz/sqrt(7)) 
gen zsoz4=(soz4-meanr_soz)/(std_soz/sqrt(7)) 
gen zsoz5=(soz5-meanr_soz)/(std_soz/sqrt(7)) 
gen zsoz6=(soz6-meanr_soz)/(std_soz/sqrt(7)) 
gen zsoz7=(soz7-meanr_soz)/(std_soz/sqrt(7)) 

gen zego_soz=(ego_soz-meanr_soz)/(std_soz/(sqrt(7)))

egen soz_zm1=mean(zsoz1) if sozm==0 & sozgl~=1
egen soz_zm2=mean(zsoz2) if sozm==0 & sozgl~=1 
egen soz_zm3=mean(zsoz3) if sozm==0 & sozgl~=1
egen soz_zm4=mean(zsoz4) if sozm==0 & sozgl~=1
egen soz_zm5=mean(zsoz5) if sozm==0 & sozgl~=1
egen soz_zm6=mean(zsoz6) if sozm==0 & sozgl~=1
egen soz_zm7=mean(zsoz7) if sozm==0 & sozgl~=1

gen stdzm_soz=sqrt(soz_zm1^2+soz_zm2^2+soz_zm2^2+soz_zm3^2+soz_zm4^2+soz_zm5^2+soz_zm6^2+soz_zm7^2)

gen rzm_soz=(((soz1 - meanr_soz)*soz_zm1)+((soz2 - meanr_soz)*soz_zm2)+((soz3 - meanr_soz)*soz_zm3)+((soz4 - meanr_soz)*soz_zm4)+((soz5 - meanr_soz)*soz_zm5)+((soz6 - meanr_soz)*soz_zm6)+((soz7 - meanr_soz)*soz_zm7))
gen corrzm_soz=rzm_soz/(std_soz*stdzm_soz)

/*
gen sozdam1=(self_soz_am-cdu_soz_am)^2 if q56a~=.
replace sozdam1=(self_soz_am-csu_soz_am)^2 if q56b~=. & bula==9
gen sozdam2=(self_soz_am-spd_soz_am)^2 if q56c~=.
gen sozdam3=(self_soz_am-fdp_soz_am)^2 if q56f~=.
gen sozdam4=(self_soz_am-gru_soz_am)^2 if q56e~=.
gen sozdam5=(self_soz_am-lin_soz_am)^2 if q56d~=.
gen sozdam6=(self_soz_am-afd_soz_am)^2 if q56g~=.
*/

gen sozdo1=(ego_soz-soz1)^2
replace sozdo1=(ego_soz-soz2)^2 if bula==9
gen sozdo2=(ego_soz-soz3)^2
gen sozdo3=(ego_soz-soz4)^2
gen sozdo4=(ego_soz-soz5)^2
gen sozdo5=(ego_soz-soz6)^2
gen sozdo6=(ego_soz-soz7)^2

gen sozdz1=(zego_soz-zsoz1)^2
replace sozdz1=(zego_soz-zsoz2)^2 if bula==9
gen sozdz2=(zego_soz-zsoz3)^2
gen sozdz3=(zego_soz-zsoz4)^2
gen sozd4=(zego_soz-zsoz5)^2
gen sozdz5=(zego_soz-zsoz6)^2
gen sozdz6=(zego_soz-zsoz7)^2

gen sozdzm1=(zego_soz-soz_zm1)^2
replace sozdzm1=(zego_soz-soz_zm2)^2 if bula==9
gen sozdzm2=(zego_soz-soz_zm3)^2
gen sozdzm3=(zego_soz-soz_zm4)^2
gen sozdzm4=(zego_soz-soz_zm5)^2
gen sozdzm5=(zego_soz-soz_zm6)^2
gen sozdzm6=(zego_soz-soz_zm7)^2

* alt
/*
gen corr_sozt=3 if corr_soz<=-0.9 
replace corr_sozt=2 if corr_soz>-0.9 & corr_soz <-0.3
replace corr_sozt=1 if corr_soz>=-0.3 & corr_soz~=.
by corr_sozt, sort : summarize zsoz*
*/



* klima

by intnr, sort: gen meanr_klima=(klima1+klima2+klima3+klima4+klima5+klima6+klima7)/7
*gen r_klima=(((klima1 - meanr_klima)*cdu_klima_am)+((klima2 - meanr_klima)*csu_klima_am)+((klima3 - meanr_klima)*spd_klima_am)+((klima4 - meanr_klima)*fdp_klima_am)+((klima5 - meanr_klima)*gru_klima_am)+((klima6 - meanr_klima)*lin_klima_am)+((klima7 - meanr_klima)*afd_klima_am))
gen std_klima= sqrt((klima1 - meanr_klima)^2 + (klima2 - meanr_klima)^2 + (klima3 - meanr_klima)^2 + (klima4 - meanr_klima)^2 + (klima5 - meanr_klima)^2 + (klima6 - meanr_klima)^2 + (klima7 - meanr_klima)^2)
*gen corr_klima= r_klima/std_klima

gen zklima1=(klima1-meanr_klima)/(std_klima/sqrt(7)) 
gen zklima2=(klima2-meanr_klima)/(std_klima/sqrt(7)) 
gen zklima3=(klima3-meanr_klima)/(std_klima/sqrt(7)) 
gen zklima4=(klima4-meanr_klima)/(std_klima/sqrt(7)) 
gen zklima5=(klima5-meanr_klima)/(std_klima/sqrt(7)) 
gen zklima6=(klima6-meanr_klima)/(std_klima/sqrt(7)) 
gen zklima7=(klima7-meanr_klima)/(std_klima/sqrt(7)) 

gen zego_klima=(ego_klima-meanr_klima)/(std_klima/(sqrt(7)))

egen klima_zm1=mean(zklima1) if klimam==0 & klimagl~=1
egen klima_zm2=mean(zklima2) if klimam==0 & klimagl~=1 
egen klima_zm3=mean(zklima3) if klimam==0 & klimagl~=1
egen klima_zm4=mean(zklima4) if klimam==0 & klimagl~=1
egen klima_zm5=mean(zklima5) if klimam==0 & klimagl~=1
egen klima_zm6=mean(zklima6) if klimam==0 & klimagl~=1
egen klima_zm7=mean(zklima7) if klimam==0 & klimagl~=1

gen stdzm_klima=sqrt(klima_zm1^2+klima_zm2^2+klima_zm2^2+klima_zm3^2+klima_zm4^2+klima_zm5^2+klima_zm6^2+klima_zm7^2)

gen rzm_klima=(((klima1 - meanr_klima)*klima_zm1)+((klima2 - meanr_klima)*klima_zm2)+((klima3 - meanr_klima)*klima_zm3)+((klima4 - meanr_klima)*klima_zm4)+((klima5 - meanr_klima)*klima_zm5)+((klima6 - meanr_klima)*klima_zm6)+((klima7 - meanr_klima)*klima_zm7))
gen corrzm_klima=rzm_klima/(std_klima*stdzm_klima)

// gen klimadam1=(self_klima_am-cdu_klima_am)^2 if q58a~=.
// replace klimadam1=(self_klima_am-csu_klima_am)^2 if q58b~=. & bula==9
// gen klimadam2=(self_klima_am-spd_klima_am)^2 if q58c~=.
// gen klimadam3=(self_klima_am-fdp_klima_am)^2 if q58f~=.
// gen klimadam4=(self_klima_am-gru_klima_am)^2 if q58e~=.
// gen klimadam5=(self_klima_am-lin_klima_am)^2 if q58d~=.
// gen klimadam6=(self_klima_am-afd_klima_am)^2 if q58g~=.

gen klimado1=(ego_klima-klima1)^2
replace klimado1=(ego_klima-klima2)^2 if bula==9
gen klimado2=(ego_klima-klima3)^2
gen klimado3=(ego_klima-klima4)^2
gen klimado4=(ego_klima-klima5)^2
gen klimado5=(ego_klima-klima6)^2
gen klimado6=(ego_klima-klima7)^2

gen klimadz1=(zego_klima-zklima1)^2
replace klimadz1=(zego_klima-zklima2)^2 if bula==9
gen klimadz2=(zego_klima-zklima3)^2
gen klimadz3=(zego_klima-zklima4)^2
gen klimad4=(zego_klima-zklima5)^2
gen klimadz5=(zego_klima-zklima6)^2
gen klimadz6=(zego_klima-zklima7)^2

gen klimadzm1=(zego_klima-klima_zm1)^2
replace klimadzm1=(zego_klima-klima_zm2)^2 if bula==9
gen klimadzm2=(zego_klima-klima_zm3)^2
gen klimadzm3=(zego_klima-klima_zm4)^2
gen klimadzm4=(zego_klima-klima_zm5)^2
gen klimadzm5=(zego_klima-klima_zm6)^2
gen klimadzm6=(zego_klima-klima_zm7)^2


// gen corr_klimat=3 if corr_klima>=.9 & corr_klima~=.
// replace corr_klimat=2 if corr_klima<.9 & corr_klima > .3
// replace corr_klimat=1 if corr_klima<=.3
// by corr_klimat, sort : summarize zklima*



* migration

by intnr, sort: gen meanr_mig=(mig1+mig2+mig3+mig4+mig5+mig6+mig7)/7
*gen r_mig=(((mig1 - meanr_mig)*cdu_mig_am)+((mig2 - meanr_mig)*csu_mig_am)+((mig3 - meanr_mig)*spd_mig_am)+((mig4 - meanr_mig)*fdp_mig_am)+((mig5 - meanr_mig)*gru_mig_am)+((mig6 - meanr_mig)*lin_mig_am)+((mig7 - meanr_mig)*afd_mig_am))
gen std_mig= sqrt((mig1 - meanr_mig)^2 + (mig2 - meanr_mig)^2 + (mig3 - meanr_mig)^2 + (mig4 - meanr_mig)^2 + (mig5 - meanr_mig)^2 + (mig6 - meanr_mig)^2 + (mig7 - meanr_mig)^2)
*gen corr_mig= r_mig/std_mig


gen zmig1=(mig1-meanr_mig)/(std_mig/sqrt(7)) 
gen zmig2=(mig2-meanr_mig)/(std_mig/sqrt(7)) 
gen zmig3=(mig3-meanr_mig)/(std_mig/sqrt(7)) 
gen zmig4=(mig4-meanr_mig)/(std_mig/sqrt(7)) 
gen zmig5=(mig5-meanr_mig)/(std_mig/sqrt(7)) 
gen zmig6=(mig6-meanr_mig)/(std_mig/sqrt(7)) 
gen zmig7=(mig7-meanr_mig)/(std_mig/sqrt(7)) 

gen zego_mig=(ego_mig-meanr_mig)/(std_mig/(sqrt(7)))


egen mig_zm1=mean(zmig1) if migm==0 & miggl~=1
egen mig_zm2=mean(zmig2) if migm==0 & miggl~=1 
egen mig_zm3=mean(zmig3) if migm==0 & miggl~=1
egen mig_zm4=mean(zmig4) if migm==0 & miggl~=1
egen mig_zm5=mean(zmig5) if migm==0 & miggl~=1
egen mig_zm6=mean(zmig6) if migm==0 & miggl~=1
egen mig_zm7=mean(zmig7) if migm==0 & miggl~=1

gen stdzm_mig=sqrt(mig_zm1^2+mig_zm2^2+mig_zm2^2+mig_zm3^2+mig_zm4^2+mig_zm5^2+mig_zm6^2+mig_zm7^2)

gen rzm_mig=(((mig1 - meanr_mig)*mig_zm1)+((mig2 - meanr_mig)*mig_zm2)+((mig3 - meanr_mig)*mig_zm3)+((mig4 - meanr_mig)*mig_zm4)+((mig5 - meanr_mig)*mig_zm5)+((mig6 - meanr_mig)*mig_zm6)+((mig7 - meanr_mig)*mig_zm7))
gen corrzm_mig=rzm_mig/(std_mig*stdzm_mig)


// gen migdam1=(self_mig_am-cdu_mig_am)^2 if q58a~=.
// replace migdam1=(self_mig_am-csu_mig_am)^2 if q58b~=. & bula==9
// gen migdam2=(self_mig_am-spd_mig_am)^2 if q58c~=.
// gen migdam3=(self_mig_am-fdp_mig_am)^2 if q58f~=.
// gen migdam4=(self_mig_am-gru_mig_am)^2 if q58e~=.
// gen migdam5=(self_mig_am-lin_mig_am)^2 if q58d~=.
// gen migdam6=(self_mig_am-afd_mig_am)^2 if q58g~=.

gen migdo1=(ego_mig-mig1)^2
replace migdo1=(ego_mig-mig2)^2 if bula==9
gen migdo2=(ego_mig-mig3)^2
gen migdo3=(ego_mig-mig4)^2
gen migdo4=(ego_mig-mig5)^2
gen migdo5=(ego_mig-mig6)^2
gen migdo6=(ego_mig-mig7)^2

gen migdz1=(zego_mig-zmig1)^2
replace migdz1=(zego_mig-zmig2)^2 if bula==9
gen migdz2=(zego_mig-zmig3)^2
gen migdz3=(zego_mig-zmig4)^2
gen migd4=(zego_mig-zmig5)^2
gen migdz5=(zego_mig-zmig6)^2
gen migdz6=(zego_mig-zmig7)^2

gen migdzm1=(zego_mig-mig_zm1)^2
replace migdzm1=(zego_mig-mig_zm2)^2 if bula==9
gen migdzm2=(zego_mig-mig_zm3)^2
gen migdzm3=(zego_mig-mig_zm4)^2
gen migdzm4=(zego_mig-mig_zm5)^2
gen migdzm5=(zego_mig-mig_zm6)^2
gen migdzm6=(zego_mig-mig_zm7)^2

// gen corr_migt=3 if corr_mig>=.9 & corr_mig~=.
// replace corr_migt=2 if corr_mig<.9 & corr_mig > .3
// replace corr_migt=1 if corr_mig<=.3
// by corr_migt, sort : summarize zmig*

/*
gen polint=(5-q3)/4
gen polwiss_5pr=0
replace polwiss_5pr=1 if q14==5
gen polwiss_pol=0
replace polwiss_pol=1 if q127a==4 & q127b==6 & q127c==5
gen polwiss_inh=0
replace polwiss_inh=1 if q128==1 & q129==1
gen p_kontakt=0
replace p_kontakt=1 if q39a==1 | q39c==1 | q39d==1 | q39f==1
recode q92 q93 q94* q96 (5 6 7=1)(else=0)
gen info_tv=0
gen info_zeitg=0
gen info_net=0
replace info_tv=1 if q92==1 | q93==1
replace info_zeitg=1 if q94a==1 | q94b==1 | q94c==1 | q94d==1 | q94e==1 | q94f==1 | q94g==1 | q94h==1 | q94i==1
replace info_net=1 if q96==1
*/




********************** neu 4.5.2021 

* neu: individuelle ICC in drei Klassen, das ergibt korrekte Fallzahlen in Abb. 1

foreach i in lire soz klima mig {
	gen corrzm_`i't = 3 if corrzm_`i' >= .9 & corrzm_`i' ~=.
	replace corrzm_`i't = 2 if corrzm_`i' < .9 & corrzm_`i' > .3
	replace corrzm_`i't = 1 if corrzm_`i' <= .3
}


foreach i in lire soz klima mig {
	by corrzm_`i't, sort : summarize z`i'?
}

save tmp, replace


* Datensatz für Abbildung 1

foreach i in lire soz klima mig {
	use tmp, clear
	collapse (mean) z1 = z`i'1 (mean) z2 = z`i'2 (mean) z3 = z`i'3  ///
	(mean) z4 = z`i'4 (mean) z5 = z`i'5 (mean) z6 = z`i'6  ///
	(mean) z7 = z`i'7 (count) n = z`i'1, by(corrzm_`i't)
	rename corrzm_`i't level
	save tmp1, replace
	use tmp, clear
	collapse (mean) z1 = z`i'1 (mean) z2 = z`i'2 (mean) z3 = z`i'3  ///
	(mean) z4 = z`i'4 (mean) z5 = z`i'5 (mean) z6 = z`i'6  ///
	(mean) z7 = z`i'7 (count) n = z`i'1
	gen level = 4
	order level 
	append using tmp1
	drop if level == .
	gen issue = "`i'"
	sort issue level 
	save tmp_`i', replace
}

use tmp_lire, clear
foreach i in soz klima mig {
	append using tmp_`i'
	erase "tmp_`i'.dta"
}
erase "tmp_lire.dta"
erase "tmp1.dta"

saveold Abbildung1_data, version(13) replace



******************** Abbildung 2 ????

use tmp, replace
keep intnr vote lrdzm? sozdzm? klimadzm? migdzm? corrzm_lire* corrzm_soz* corrzm_klima* corrzm_mig*
reshape long lrdzm sozdzm klimadzm migdzm, i(intnr) j(party6)
replace vote = (vote == party)


* clogit ???? unklar 

clogit vote i.corrzm_liret#c.lrdzm i.party6 c.corrzm_lire, group(intnr)
clogit vote i.corrzm_liret#c.lrdzm i.party6#c.corrzm_lire, group(intnr)





*erase "tmp.dta"


 
