*********************************************************************************
* Titel: 	Politbarometer														*
* Aufsatz: 	CDU und CSU, dissonante Bürgerurteile und Wahlverhalten				*
* Autoren: 	H. Schoen u. M. Pesthy												*
*********************************************************************************




*********************************************************************************
* Datenkorrektur Politbarometer Parteienskalometer 2009/2010					*
*********************************************************************************

/*
In der Gesamtkumulation ZA5100_v1-0-0.dta des Politbarometers (1977-2016) liegt
bei den Parteienskalometern CDU, CSU und SPD in den Jahren 2009 und 2010 ein
Fehler vor. Die Art des Fehlers kann überprüft werden, indem die Skalometer im 
Jahr 2009 mit den Daten 2009 Ost (ZA5431) und 2009 West (ZA5432) verglichen werden. 
In den Ost-West-Kumulationen 2009 wurde der Fehler behoben. 2010 liegt der gleiche 
Fehler vor.
Folgendes ist passiert: in der Gesamtkumulation wurde in den Jahren 2009/10 
das CDU-Skalometer mit dem CSU Skalometer befüllt; das SPD-Skalometer mit dem 
CDU-Skalometer; das CSU-Skalometer mit dem SPD-Skalometer.
*/

* Data
	use ZA5100_v1-0-0.dta, clear

* copy variables unchanged
	gen vd12 = Vd12 
	gen vd13 = Vd13
	gen vd14 = Vd14

* make corrections
	replace Vd12 = vd14 if V6 ==  2009	// SPD
	replace Vd12 = vd14 if V6 ==  2010	// SPD

	replace Vd14 = vd13 if V6 ==  2009	// CSU
	replace Vd14 = vd13 if V6 ==  2010	// CSU

	replace Vd13 = vd12 if V6 ==  2009 	// CDU
	replace Vd13 = vd12 if V6 ==  2010	// CDU

* drop copied variables
	drop vd12 vd13 vd14

* save modified dataset
	save ZA5100_v1-1-0.dta, replace

	
*********************************************************************************
* Vorbereitung Politbarometer 2017												*
*********************************************************************************
	
	use "ZA6988_v1-2-0.dta", clear

	rename _all, lower

	rename v1 V1
	rename v2 V2
	rename v3 V3
	rename v4 V5
	rename v5 V4
	drop v6
	gen v6 = 2017
	rename v7 V8
	rename v8 V7
	rename v9 V10
	rename v10 Vf98
	rename v11 vf99
	rename v12 V12
	rename v13 V13
	rename v14 V15
	rename v15 V14
	rename v16 V16
	rename v17 Vb2
	rename v18 Vb1
	rename v19 Vb5
	rename v20 Vb4
	rename v21 Vb3
	rename v25 Vc2
	rename v27 Vc8
	rename v28 Vc19
	rename v29 Vc18
	rename v30 Vc23
	rename v31 Vc21
	rename v32 Vc22
	rename v34 Vc24
	rename v35 Vc25
	rename v36 Vc29
	rename v37 Vk26
	rename v38 Vk25
	rename v39 Vk27
	rename v40 Vk31
	rename v41 Vk30
	rename v49 Vd13
	rename v50 Vd14
	rename v51 Vd12
	rename v52 Vd18
	rename v53 Vd16
	rename v54 Vd15
	rename v56 Vf10
	rename v57 Vf11
	rename v58 Vf12
	rename v61 Vd19
	rename v62 Vd20
	rename v63 Vd21
	rename v64 Vi139
	rename v66 Vi118
	rename v69 Vi25
	rename v70 Vi131
	rename v72 Vi132
	rename v73 Vi30
	rename v75 Vi40
	rename v76 Vi133
	rename v77 Vi134
	rename v80 Vi135
	rename v82 Vi54
	rename v84 Vi137
	rename v85 Vi120
	rename v89 Vi68
	rename v90 Vi72
	rename v93 Vi82
	rename v95 Vi90
	rename v96 Vi106
	rename v99 Vi87
	rename v100 Vj97
	rename v101 Vj32
	rename v103 Vj49
	rename v107 Vj51
	rename v110 Vj65
	rename v112 Vj73
	rename v113 Vj78
	rename v116 Vf79
	rename v117 Vf77
	rename v118 Vk54
	rename v119 Vk55
	rename v120 Vk53
	rename v121 Vf81
	rename v126 Vq12
	rename v140 Vo30
	rename v146 Vk49
	rename v165 Vk34
	rename v170 Vh2
	rename v180 Vv63
	rename v181 Vt19
	rename v182 Vv65
	rename v209 Vl44
	rename v210 Vl16
	rename v217 Vo10
	rename v219 Vo11
	rename v241 Vd62
	rename v247 Vc41
	rename v250 Vd9
	rename v263 Vc4
	rename v272 Vc6
	rename v273 Vc7
	rename v276 Vm20
	rename v290 Vk48
	rename v306 Vf84
	rename v307 Vd27
	rename v308 Vd28
	rename v309 Vd29
	rename v310 Vd31
	rename v311 Vd30
	rename v317 Vx5
	rename v318 Vx7
	rename v319 Vx10
	rename v320 Vx11
	rename v321 Vx31
	rename v322 Vx37
	rename v323 Vx35
	rename v324 Vx33
	rename v326 Vx43
	rename v328 Vx47
	rename v329 Vx48
	rename v330 Vx330
	rename v332 Vx4
	rename v334 Vx54
	rename v336 Vx58


	rename _all, upper

	save ZA6988_prep.dta, replace


*********************************************************************************
* Append Politbarometer 2017													*
*********************************************************************************

	use "ZA5100_v1-1-0.dta", clear
	rename _all, upper

	append using "ZA6988_prep.dta"

		
*********************************************************************************
* Grafik-Erstellung																*
*********************************************************************************

	rename _all, lower

*** Variablen ***
	
	* Monate
		gen m = (v6-1977)*12 + v5 -1
		lab var m "Monat"
		levelsof m
	
	* Label
		lab def pos 0"negativ" 1"positiv"
		lab def be 0"kein Unterschied" 1"maximaler Unterschied"
		
	* Skalometer CDU
		gen skal_cdu = (vd13 -1)/10 
		lab var skal_cdu "Skalometer CDU"
		lab val skal_cdu pos, nofix

	* Skalometer CSU
		gen skal_csu = (vd14 -1)/10 
		lab var skal_csu "Skalometer CSU"
		lab val skal_csu pos, nofix

	
	* (Betrag) Skalometer-Differenz CDU/CSU
		gen diff_skal = round(skal_cdu-skal_csu, .1)
		gen absdiff_skal = abs(round(skal_cdu-skal_csu, .1))
		label var diff_skal "Diff CDU/CSU"
		lab var absdiff_skal "Betrag Differenz CDU/CSU"
		lab val absdiff_skal be, nofix		
		sum diff_skal absdiff_skal
	
		sum *skal*
	
	* Spitzenpolitiker CDU/CSU
		
		fre vj51	// Merkel
		gen kohl=(vj42-1)/10
		gen merkel=(vj51-1)/10
		gen seehofer=(vj73-1)/10
		gen stoiber=(vj79-1)/10
		gen waigel=(vj91-1)/10
		gen beckstein=(vj7-1)/10
		gen schäuble=(vj65-1)/10
		gen strauß=(vj82-1)/10
		fre merkel
		
			
		gen cdupol=kohl if v6<1998 | (v6==1998 & m < 262)											// bis 10/1998
		replace cdupol=schäuble if (v6==1998 & v5>= 262) | v6==1999 | v6==2000 & m <= 278			// 11/1998 - 03/2000
		replace cdupol=merkel if (v6==2000 & m > 278) | (v6>2000 & v6<2020)							// seit 04/2000
		
		gen csupol=strauß if v6<1988 | (v6==1988 & m <= 141) 										// bis 10/1988
		replace csupol=waigel if (v6==1988 & m > 141) | (v6>1988 & v6<1999) | (v6==1999 & m==264)	// 11/1988 - 01/1999
		replace csupol=stoiber if (v6==1999 & m > 264) | (v6>1999 & v6<2007) | (v6==2007 & m<368)	// 02/1999 - 08/2007
		replace csupol=beckstein if (v6==2007 & m>367) | (v6==2008 & m<381)							// 09/2007 - 09/2008
		replace csupol=seehofer if (v6==2008 & m>380) | (v6>2008 & v6<2020)							// seit 10/2008		
		

		gen cdsupold=abs(round(cdupol-csupol, .1))	
	
	
	* Bundesland (Bayern)
		gen bayern = v8 == 9
		label var bayern "Bundesland (Bayern)"
		
	* fix East/West distinction in years 1996-1998
		recode v7 (3 = 2) if inlist(v8, 1,2,3,4,5,6,7,8,9,10,11)
		recode v7 (3 = 1) if inlist(v8, 12,13,14,15,16,17)
		recode v7 (3 = .) if v8 == .k

*********************************************************************************
* Abbildung 3																	*
*********************************************************************************

	set scheme s1mono
	
	
	* Bewertungsdifferenz Spitzenpolitiker Ost/West/Bayern
	
		gen absdiff_pol = abs(round(cdupol - csupol, .1))
		egen absmeandiff_polO = mean(absdiff_pol) if v7 == 1, by(m)
		egen absmeandiff_polW = mean(absdiff_pol) if v7 == 2, by(m)
		egen absmeandiff_polWoB = mean(absdiff_pol) if v7 == 2 & v8 != 9, by(m)
		egen absmeandiff_polB = mean(absdiff_pol) if v8 == 9, by(m)
		
		sort m
		
	
	* Grafik Ost/West/Bayern
		line absmeandiff_polO m [aw=vx56], clcolor(gs2) ///
		|| line absmeandiff_polWoB m [aw=vx56], clcolor(gs8) /// 
		|| line absmeandiff_polB m [aw=vx56], clcolor(gs12) ///
		xlabel(36"1980" 100"1985" 156 "1990 "216"1995" 276"2000" 336"2005" 400"2010" 456"2015") ///
		xtitle("Jahr") ///
		ytitle("Betrag Bewertungsdifferenz Spitzenpolitiker") ///
		ylabel(0 (0.2) 1) ///	
		legend(lab(1 "Ost") lab(2 "West") lab(3 "Bayern") cols(3) size(small)) 
		 
		graph export "Abbildung3.eps", replace
		
*********************************************************************************
* Abbildung 3																	*
*********************************************************************************
	
	* Bewertungsdifferenz CDU/CSU Ost/West/Bayern	

		egen absmeandiff_cdsuO = mean(absdiff_skal) if v7 == 1, by(m)				// Ost
		egen absmeandiff_cdsuW = mean(absdiff_skal) if v7 == 2, by(m) 				// West
		egen absmeandiff_cdsuWnB = mean(absdiff_skal) if v7 == 2 & v8 != 9, by(m) 	//West ohne Bayern
		egen absmeandiff_cdsuB = mean(absdiff_skal) if v8 == 9, by(m)				// Bayern

		sort m

	
	* Grafik Ost/West/Bayern
		line absmeandiff_cdsuO m [aw=vx56], clcolor(gs2) ///
		|| line absmeandiff_cdsuWnB m [aw=vx56], clcolor(gs8) /// 
		|| line absmeandiff_cdsuB m [aw=vx56], clcolor(gs12) ///
		xlabel(36"1980" 100"1985" 156 "1990 "216"1995" 276"2000" 336"2005" 400"2010" 456"2015") ///
		xtitle("Jahr") ///
		ytitle("Betrag Bewertungsdifferenz CDU/CSU") ///
		ylabel(0 (0.2) 1) ///	
		legend(lab(1 "Ost") lab(2 "West") lab(3 "Bayern") cols(3) size(small)) 
		
		graph export "Abbildung4.eps", replace
	




