*********************************************************************************
* Titel: 	Vor- und Nachwahl-Querschnitt 2017									*
* Aufsatz: 	CDU und CSU, dissonante Bürgerurteile und Wahlverhalten				*
* Autoren: 	H. Schoen u. M. Pesthy												*
*********************************************************************************


* Daten
	use ZA6802_v3-0-0.dta, clear	



* Missings definieren
	mvdecode _all, mv(-99=.a \ -98=.b \  -97=.c \ -94=.f \ -93=.g \ -83=.l \ -71=.p)
	
*********************************************************************************
* Variablen erstellen															*
*********************************************************************************

	
	* Value Label
		lab def be 0"kein Unterschied" 1"maximaler Unterschied"
		lab define interest 0 "überhaupt nicht" 1 "sehr stark"
		lab define skal_partei 0 "halte ueberhaupt nichts von dieser Partei" ///
								1 "halte sehr viel von dieser Partei"
		lab define b_politiker 	0 "halte ueberhaupt nichts von diesem Politiker" ///
									1 "halte sehr viel von diesem Politiker"
		lab def wahl 0"nein" 1"ja"
		lab def str 0"sehr schwach" 1"sehr stark"
		label define edu 0"niedrig" 1"mittel" 2"hoch"
		label define age 	0 "18-29" ///
							1 "30-39" ///
							2 "40-49" ///
							3 "50-59" ///
							4 "60+"
	
	* Politisches Interesse
		gen interest = (vn3-5)/-4
		lab var interest "Political Interest"
		lab value interest interest

	* Skalometer Parteien 
		gen skal_cdu = (vn20a -1)/10
		lab var skal_cdu "Bewertung CDU"

		gen skal_csu = (vn20b -1)/10
		lab var skal_csu "Bewertung CSU"

		gen skal_spd = (vn20c -1)/10
		lab var skal_spd "Bewertung SPD"

		gen skal_lin = (vn20d -1)/10
		lab var skal_lin "Bewertung Linke"

		gen skal_gru = (vn20e -1)/10
		lab var skal_gru "Bewertung Gruene"

		gen skal_fdp = (vn20f -1)/10
		lab var skal_fdp "Bewertung FDP"

		gen skal_afd = (vn20g -1)/10
		lab var skal_afd "Bewertung AfD"

		lab value skal_* skal_partei
		sum skal_*
		
	* (Betrag) Skalometer-Differenz CDU/CSU
		gen diff_skal = round(skal_cdu-skal_csu, .1)
		gen absdiff_skal = abs(round(skal_cdu-skal_csu, .1))
		gen absdiff_skal2 = abs(round(vn20a-vn20b))

		label var diff_skal "Diff CDU/CSU"
		lab var absdiff_skal "Betrag Differenz CDU/CSU"
		lab val absdiff_skal be, nofix		
		sum diff_skal absdiff_skal	

	* Skalenstreuung auf Individualebene
		egen meanp=rowmean(skal_cdu skal_csu skal_spd skal_fdp skal_gru ///
		skal_lin skal_afd)
		lab var meanp "Parteienskalometer-Durchschnitt"
		egen sdp=rowsd(skal_cdu skal_csu skal_spd skal_fdp ///
		skal_gru skal_lin skal_afd)
		lab var sdp "SD Parteienskalometer-Durchschnitt"
		gen ambp=meanp-2*sdp
		lab var ambp "Durchschnitt minus 2*SD"

		
		
	* Skalometer Politiker
		gen merkel = (vn21a -1)/10
		lab var merkel "Bewertung Merkel"

		gen schulz = (vn21b -1)/10
		lab var schulz "Bewertung Schulz"
		
		gen seeh = (vn21g -1)/10
		lab var seeh "Bewertung Seehofer"

		gen wagenk = (vn21c -1)/10
		lab var wagenk "Bewertung Wagenknecht"

		gen oezdem = (vn21d -1)/10
		lab var oezdem "Bewertung Oezdemir"

		gen lindner = (vn21e -1)/10
		lab var lindner "Bewertung Lindner"

		gen petry = (vn21f -1)/10
		lab var petry "Bewertung Petry" 

		lab value merkel seeh  schulz wagenk oezdem lindner petry  b_politiker
		sum merkel schulz seeh wagenk oezdem lindner petry 
		
	* (Betrag) Skalometer-Differenz Merkel/Seehofer
		gen diff_ms = round(merkel-seeh, .1)
		gen absdiff_ms = abs(round(merkel-seeh, .1))
		label var diff_ms "Diff Merkel/Seehofer"
		lab var absdiff_ms "Betrag Differenz Merkel/Seehofer"
		lab val absdiff_ms be, nofix	
		sum diff_ms absdiff_ms	
			
		
	* Parteiidentifikation 
		gen unionpid=0 if !missing(vn99a)
		replace unionpid=1 if vn99a==1 | vn99a==2 | vn99a==3
		gen cdsupid=0 if !missing(vn99a)
		replace unionpid=1 if vn99a==1
		gen cdupid=0 if !missing(vn99a)
		replace cdupid=1 if vn99a==2
		gen csupid=0 if !missing(vn99a)
		replace csupid=1 if vn99a==3
		gen spdpid=0 if !missing(vn99a)
		replace spdpid=1 if vn99a==4
		gen fdppid=0 if !missing(vn99a)
		replace fdppid=1 if vn99a==5
		gen grupid=0 if !missing(vn99a)
		replace grupid=1 if vn99a==6
		gen linpid=0 if !missing(vn99a)
		replace linpid=1 if vn99a==7
		gen afdpid=0 if !missing(vn99a)
		replace afdpid=1 if vn99a==322
		
		foreach var in union cdu csu spd fdp gru lin afd {
			label var `var'pid "PID `Var'"
		}
		
		label var unionpid "PID Union"
		label var cdupid "PID CDU"
		label var csupid "PID CSU"
		label var spdpid "PID SPD"
		label var fdppid "PID FDP"
		label var grupid "PID GRUENE"
		label var linpid "PID LINKE"
		label var afdpid "PID AfD"
		
		
		
		gen strength = (vn100-5)/-4 
		lab var strength "PID Staerke"
		lab val strength str
		
		gen pid = 1 if vn99a < 802
		replace pid = 0 if vn99a == 808
		lab var pid "Existenz einer PID"
		
	
		
	* Beabsichtigte Stimmabgabe: Zweitstimme
		clonevar wabs2 = v11ba
		gen unionwabs2 = 0 if !missing(wabs2)
		replace unionwabs2 = 1 if wabs2==1
		gen spdwabs2 = 0 if !missing(wabs2)
		replace spdwabs2 = 1 if wabs2 == 4
		gen fdpwabs2 = 0 if !missing(wabs2)
		replace fdpwabs2 = 1 if wabs2 == 5
		gen gruwabs2 = 0 if !missing(wabs2)
		replace gruwabs2 = 1 if wabs2 == 6
		gen linwabs2 = 0 if !missing(wabs2)
		replace linwabs2 = 1 if wabs2 == 7
		gen afdwabs2 = 0 if !missing(wabs2)
		replace afdwabs2 = 1 if wabs2 == 322	
		
		foreach var in union spd fdp gru lin afd {
			label var `var'wabs2 "Wahlabsicht Zweitstimme `var'"
		}


	* Wahlbeteiligung
		recode v10 (1 2 3 6=1) (4 5=0), gen(wbtg)
		recode n10 (2=0), gen(wahlbtg)
		lab var wahlbtg "Wahlbeteiligung"
		lab val wahlbtg wahl
		
	
	* Wahlentscheidung: Zweitstimme 
		
		gen vote=v11ba if survey1==0
		replace vote=n11ba if survey1==1
		fre vote
		
		gen unionwahl2=0 if !missing(n11ba)
		replace unionwahl2=1 if n11ba==1
		gen spdwahl2=0 if !missing(n11ba)
		replace spdwahl2=1 if n11ba==4
		gen fdpwahl2=0 if !missing(n11ba)
		replace fdpwahl2=1 if n11ba==5
		gen gruwahl2=0 if !missing(n11ba)
		replace gruwahl2=1 if n11ba==6
		gen linwahl2=0 if !missing(n11ba)
		replace linwahl2=1 if n11ba==7
		gen afdwahl2=0 if !missing(n11ba)
		replace afdwahl2=1 if n11ba==322
		
		foreach var in union spd fdp gru lin afd {
			label var `var'wahl2 "Zweitstimme `var'"
		}
	
		clonevar wahl2 = n11ba
		
		
		
	* Zeitpunkt der Wahlentscheidung
		clonevar zeit_wahl = n207
		
	* Kumulierte Variable Unionwahl
		gen unionwahl = .
		replace unionwahl = 1 if unionwabs2 == 1 | unionwahl2 == 1
		replace unionwahl = 0 if unionwabs2 == 0 | unionwahl2 == 0
		replace unionwahl=0 if wbtg==0 | wahlbtg==0
		lab var unionwahl "Wahlabsicht/Wahlentscheidung Union"
		lab def un 1"Union-Wahl" 0"keine Unionwahl"
		lab val unionwahl un
		
		clonevar wahlzweit = wabs2
		replace wahlzweit = wahl2 if wahlzweit == .f & wahl2 != .f
	

	* Bildung (Schulabschluss)
		gen edu = 0 if vn136 < 3
		replace edu = 1 if vn136 == 3
		replace edu = 2 if inlist(vn136,4,5)
		* Schüler & anderer Abschluss = .
		label var edu "Bildung (Schulabschluss)"
		label value edu edu
	
	* Alter
		gen ageyears = 2017 - vn2c	// es geht um Alter zum Auskunfszeitpunkt, daher 2017
		label var ageyears "Alter in Jahren"
		gen age = 0 	if ageyears > 17 & ageyears < 30
		replace age = 1 if ageyears > 29 & ageyears < 40
		replace age = 2 if ageyears > 39 & ageyears < 50 
		replace age = 3 if ageyears > 49 & ageyears < 60
		replace age = 4 if ageyears > 59
		label var age "Alter gruppiert"
			
		label values age age
		fre ageyears if age == . // passt
		
	* Geschlecht

		gen female = vn1 == 1
		label var female "Geschlecht (weiblich)"

	* Bayern vs. Nicht-Bayern ***
		gen bayern = bula == 9
		label var bayern "Bundesland (Bayern)"
		
		
	* Kompetenzzuschreibung Parteien	
		fre vn24a vn25a 
		gen komspd1=0 if vn24a>0 & vn24a<811
		replace komspd1=1 if vn24a==4
		gen komfdp1=0 if vn24a>0 & vn24a<811
		replace komfdp1=1 if vn24a==5
		gen komgru1=0 if vn24a>0 & vn24a<811
		replace komgru1=1 if vn24a==6
		gen komlin1=0 if vn24a>0 & vn24a<811
		replace komlin1=1 if vn24a==7
		gen komafd1=0 if vn24a>0 & vn24a<811
		replace komafd1=1 if vn24a==322
		gen komcdsu1=0 if vn24a>0 & vn24a<811
		replace komcdsu1=1 if vn24a==1
		gen komcdu1=0 if vn24a>0 & vn24a<811
		replace komcdu1=1 if vn24a==2
		gen komcsu1=0 if vn24a>0 & vn24a<811
		replace komcsu1=1 if vn24a==3
		gen komunion1=0 if vn24a>0 & vn24a<811
		replace komunion1=1 if vn24a>0 & vn24a<4
		gen komspd2=0 if vn25a>0 & vn25a<811
		replace komspd2=1 if vn25a==4
		gen komfdp2=0 if vn25a>0 & vn25a<811
		replace komfdp2=1 if vn25a==5
		gen komgru2=0 if vn25a>0 & vn25a<811
		replace komgru2=1 if vn25a==6
		gen komlin2=0 if vn25a>0 & vn25a<811
		replace komlin2=1 if vn25a==7
		gen komafd2=0 if vn25a>0 & vn25a<811
		replace komafd2=1 if vn25a==322
		gen komcdsu2=0 if vn25a>0 & vn25a<811
		replace komcdsu2=1 if vn25a==1
		gen komcdu2=0 if vn25a>0 & vn25a<811
		replace komcdu2=1 if vn25a==2
		gen komcsu2=0 if vn25a>0 & vn25a<811
		replace komcsu2=1 if vn25a==3
		gen komunion2=0 if vn25a>0 & vn25a<811
		replace komunion2=1 if vn25a>0 & vn25a<4
		gen komind1=0 if vn24a>0 & vn24a<811
		replace komind1=1 if vn24a==808 | vn24a==809
		gen komind2=0 if vn25a>0 & vn25a<811
		replace komind2=1 if vn25a==808 | vn25a==809

		gen komspd3=(komspd1+komspd2)/2
		gen komfdp3=(komfdp1+komfdp2)/2
		gen komgru3=(komgru1+komgru2)/2
		gen komlin3=(komlin1+komlin2)/2
		gen komafd3=(komafd1+komafd2)/2
		gen komunion3=(komunion1+komunion2)/2
		gen komcdsu3=(komcdsu1+komcdsu2)/2
		gen komcdu3=(komcdu1+komcdu2)/2
		gen komcsu3=(komcsu1+komcsu2)/2
		gen komind3=(komind1+komind2)/2
		
		fre kom*3
	
	* Kanzlerpräferenz
		fre v33 n33
		gen prefmerk=0 if (v33>0 & v33<4) | (n33>0 & n33<4)
		replace prefmerk=1 if v33==1 | n33==1
		fre prefmerk
		lab var prefmerk "Kanzlerpraeferenz Merkel"

*********************************************************************************
* Abbildung 1																	*
*********************************************************************************
	
	set scheme lean2

	* Histogramme
	fre diff_skal diff_ms
	
	twoway 		(histogram diff_skal if bayern == 1, discrete percent col(gray) lcolor(black)) ///
			|| 	(histogram diff_skal if bayern == 0, discrete percent fcolor(none)), ///
				legend(lab (1 "Bayern") lab(2 "Deutschland""ohne Bayern")) ///
				xtitle("Bewertungsunterschied CDU/CSU") ytitle("Anteil Befragte (%)") ///
				xlabel( ,nogrid) ylabel( ,nogrid)
				
	graph export "Abbildung1.eps", replace
	
	bysort bayern: count if diff_skal == .
	
*********************************************************************************
* Abbildung 2																	*
*********************************************************************************

	twoway 		(histogram diff_ms if bayern == 1, discrete percent col(gray)lcolor(black)) ///
			|| 	(histogram diff_ms if bayern == 0, discrete percent fcolor(none)), ///
				legend(lab (1 "Bayern") lab(2 "Deutschland""ohne Bayern")) ///
				xtitle("Bewertungsunterschied Merkel/Seehofer") ytitle("Anteil Befragte (%)") ///
				xlabel( ,nogrid) ylabel(0(10)50, nogrid)
				
	graph export "Abbildung2.eps", replace
	
	bysort bayern: count if diff_ms == .
	
		
*********************************************************************************
* Abbildung 5.a)																*
*********************************************************************************		

	* AV: Unionswahl
	
		* Finales Modell
		eststo m1a:  quietly logit 	unionwahl absdiff_skal  absdiff_ms komunion3 strength prefmerk ///
									c.(ageyears interest) female i.edu if bayern==0 & unionpid==1 [pw=w_ipfges]
		eststo marg1a: margins, at(absdiff_skal=(0(.1)1)) post	
		estimates restore m1a
		eststo marg1b: margins, at(absdiff_ms=(0(.1)1)) post
						
		eststo m2a: quietly logit 	unionwahl absdiff_skal  absdiff_ms komunion3 strength prefmerk  ///
									c.(ageyears interest) female i.edu if bayern==1 & unionpid==1 [pw=w_ipfges]
		eststo marg2a: margins, at(absdiff_skal=(0(.1)1)) post
		estimates restore m2a
		eststo marg2b: margins, at(absdiff_ms=(0(.1)1)) post
					
		* Different estimation procedure for graph production
		separate unionwahl, by(bayern)
		eststo m3: logit 	unionwahl c.absdiff_skal##i.bayern  c.absdiff_ms##i.bayern  c.komunion3##i.bayern  c.strength##i.bayern  i.prefmerk##i.bayern  ///
							c.ageyears##i.bayern  c.interest##i.bayern  i.female##i.bayern  i.edu##i.bayern  if unionpid==1 [pw=w_ipfges]
		
		margins, at(absdiff_skal=(0(.1)1)) over(bayern)
	
		marginsplot, plot1opts(msymbol(O) mcolor(black)) plot2opts(msymbol(O) mcolor(gray) ) ci2opts(lcolor(gray))xlabel(,format(%9.1f) angle(45)) name(overlay1, replace) ///
		addplot((histogram absdiff_skal if unionpid == 1 & bayern == 0, discrete fraction fcolor(gs0) lcolor(black)) ///
				||(histogram absdiff_skal if unionpid == 1 & bayern == 1, discrete fraction color(gray) lcolor(black) barwidth(.09)), ///
				legend(off)) ///
				title("Bewertungsunterschied CDU/CSU") ytitle("") ///
				xtitle("") xlabel( ,nogrid) ylabel( ,nogrid) ///
				text(0.93 0.2 "Bayern", size(small) color(gray)) ///
				text(0.6 0.3 "Deutschland ohne Bayern", size(small) color(gs0))

		estimates restore m3
		
		margins, at(absdiff_ms=(0(.1)1)) over(bayern)
		
		marginsplot, plot1opts(msymbol(O) mcolor(black)) plot2opts(msymbol(O) mcolor(gray) ) ci2opts(lcolor(gray))xlabel(,format(%9.1f) angle(45)) name(overlay2, replace) ///
		addplot((histogram absdiff_ms if unionpid == 1 & bayern == 0, discrete fraction color(gs0) lcolor(black)) ///
				||(histogram absdiff_ms if unionpid == 1 & bayern == 1, discrete fraction color(gray)  lcolor(black) barwidth(.09)), ///
				legend(off)) xlabel( ,nogrid) ylabel( ,nogrid) ///
				title("Bewertungsunterschied Merkel/Seehofer") ytitle("") ///
				xtitle("")
				
		graph combine overlay1 overlay2, ycommon 
		graph export "Abbildung5a.eps", replace			
		
		
		esttab 	m1a m2a using "Tabelle_5a.rtf", replace nogaps compress label ///
				nobaselevels  ///
				b(2) se(2) ///
				nonumbers mtitles("Deutschland ohne Bayern" "Bayern") ///
				coeflabels(	c.absdiff_skal "Differenz CDU/CSU" ///
							c.absdiff_ms "Differenz Merkel/Seehofer" ///
							komunion3 "Kompetenz Union" ///
							strength "Staerke PID" ///
							prefmerk "Kanzlerpraeferenz Merkel" ///
							_cons "Konstante") ///
				stats(N r2_p, label("N" "Pseudo R-Quadrat")) ///
				addnotes(	"Angegeben sind logistische Regressionskoeffizienten mit Standardfehlern in Klammern;" ///
							"Daten: Kumulierter Querschnitt 2017; Signifikanzniveaus: * p < 0.05, ** p < 0.01, *** p < 0.001.")




*********************************************************************************
* Robustheitsprüfung															*
*********************************************************************************

	
		* Finales Modell
		eststo m1a:  quietly logit 	unionwahl absdiff_skal  absdiff_ms komunion3 strength prefmerk ///
									skal_cdu skal_csu merkel seeh ///
									c.(ageyears interest) female i.edu if bayern==0 & unionpid==1 [pw=w_ipfges]
		eststo marg1a: margins, at(absdiff_skal=(0(.1)1)) post	
		estimates restore m1a
		eststo marg1b: margins, at(absdiff_ms=(0(.1)1)) post
						
		eststo m2a: quietly logit 	unionwahl absdiff_skal  absdiff_ms komunion3 strength prefmerk  ///
									skal_cdu skal_csu merkel seeh ///
									c.(ageyears interest) female i.edu if bayern==1 & unionpid==1 [pw=w_ipfges]
		eststo marg2a: margins, at(absdiff_skal=(0(.1)1)) post
		estimates restore m2a
		eststo marg2b: margins, at(absdiff_ms=(0(.1)1)) post
					
		* Different estimation procedure for graph production
		/* separate unionwahl, by(bayern) */
		eststo m3: logit 	unionwahl (c.absdiff_skal  c.absdiff_ms  c.komunion3  c.strength  i.prefmerk  ///
							c.skal_cdu c.skal_csu c.merkel c.seeh ///
							c.ageyears  c.interest  i.female  i.edu)##i.bayern  if unionpid==1 [pw=w_ipfges]
		
		margins, at(absdiff_skal=(0(.1)1)) over(bayern)

		marginsplot, plot1opts(msymbol(O) mcolor(black)) plot2opts(msymbol(O) mcolor(gray) ) ci2opts(lcolor(gray))xlabel(,format(%9.1f) angle(45)) name(overlay1, replace) ///
		addplot((histogram absdiff_skal if unionpid == 1 & bayern == 0, discrete fraction fcolor(gs0)) ///
				||(histogram absdiff_skal if unionpid == 1 & bayern == 1, discrete fraction color(gray) barwidth(.09)), ///
				legend(off)) ///
				title("Bewertungsunterschied CDU/CSU") ytitle("") ///
				xtitle("") xlabel( ,nogrid) ylabel( ,nogrid) ///
				text(0.93 0.2 "Bayern", size(small) color(gray)) ///
				text(0.45 0.3 "Deutschland ohne", size(small) color(gs0)) ///
				text(0.4 0.3 "Bayern", size(small) color(gs0))

		estimates restore m3
		
		margins, at(absdiff_ms=(0(.1)1)) over(bayern)
		
		marginsplot, plot1opts(msymbol(O) mcolor(black)) plot2opts(msymbol(O) mcolor(gray) ) ci2opts(lcolor(gray))xlabel(,format(%9.1f) angle(45)) name(overlay2, replace) ///
		addplot((histogram absdiff_ms if unionpid == 1 & bayern == 0, discrete fraction color(gs0)) ///
				||(histogram absdiff_ms if unionpid == 1 & bayern == 1, discrete fraction color(gray) barwidth(.09)), ///
				legend(off)) xlabel( ,nogrid) ylabel( ,nogrid) ///
				title("Bewertungsunterschied Merkel/Seehofer") ytitle("") ///
				xtitle("")
				
		graph combine overlay1 overlay2, ycommon 
		graph export "Abbildung5a_Robust.eps", replace			
		
		
		esttab 	m1a m2a using "Tabelle_5a_Robust.rtf", replace nogaps compress  ///
				nobaselevels ///
				b(2) se(2) ///
				nonumbers mtitles("Deutschland ohne Bayern" "Bayern") ///
				coeflabels(	absdiff_skal "Differenz CDU/CSU" ///
							absdiff_ms "Differenz Merkel/Seehofer" ///
							komunion3 "Kompetenz Union" ///
							strength "Staerke PID" ///
							prefmerk "Kanzlerpraeferenz Merkel" ///
							skal_cdu "Skalometer CDU" ///
							skal_csu "Skalometer CSU" ///
							merkel "Skalometer Merkel" ///
							seeh "Skalometer Seehofer" ///
							ageyears "Alter (in Jahren)" ///
							interest "Politisches Interesse" ///
							female "Geschlecht (weiblich)" ///
							1.edu "Schulische Bildung: mittleres Niveau" ///
							2.edu "Schulische Bildung: hohes Niveau" ///
							_cons "Konstante") ///
				stats(N r2_p, label("N" "Pseudo R-Quadrat")) ///
				addnotes(	"Angegeben sind logistische Regressionskoeffizienten mit Standardfehlern in Klammern;" ///
							"Daten: Kumulierter Querschnitt 2017; Signifikanzniveaus: * p < 0.05, ** p < 0.01, *** p < 0.001.")
							
						
						
						

	

	
	
	
	
	
	
	
	
	
	
	
		
