*********************************************************************************
* Titel: 	WKP 2017															*
* Aufsatz: 	CDU und CSU, dissonante Bürgerurteile und Wahlverhalten				*
* Autoren: 	H. Schoen u. M. Pesthy												*
*********************************************************************************

* Daten
/*	use "ZA6804_v6-0-0.dta", clear */
	
*SPSS Missings in STATA Format umbennenen (Numerisch)

foreach var of varlist _all {
	capture confirm numeric var `var'
	if !_rc {
		mvdecode `var', mv(-71=.p \-72=.o \-81=.n \-82=.m \-83=.l ///
				 \-84=.k \-85=.j \-86=.i \-92=.h \-93=.g ///
				 \-94=.f \-95=.e \-96=.d \-97=.c \-98=.b ///
				 \-99=.a)
		local lab: value label `var'
		if "`lab'"!="" {
			label define `lab' ///
			.a"keine Angabe" ///
			.b"weiss nicht" ///
			.c"trifft nicht zu" ///
			.d"Split" ///
			.e"nicht teilgenommen" ///
			.f"nicht in Auswahlgesamtheit" ///
			.g"Interview abgebrochen" ///
			.h"Fehler in Daten" ///
			.i"nicht wahlberechtigt" ///
			.j"nicht waehlen" ///
			.k"keine Erst-/Zweitstimme abgegeben" ///
			.l"ungueltig waehlen" ///
			.m"keine andere Partei waehlen" ///
			.n"noch nicht entschieden" ///
			.o"nicht einzuschaetzen/nicht-eindeutige Zuordnung PLZ" ///
			.p"nicht bekannt/unbekannte PLZ", modify
			}
		}
}


*** Variablen

	* Label für Beträge von Differenzen
		lab def be 0"kein Unterschied" 1"maximaler Unterschied"
	
	* Gender
		gen female = kpx_2280 == 2
		lab var female "Female"

	* age
		gen ageyears = 2017 - kpx_2290
		lab var ageyears "Alter in Jahren"
		
		gen age = 0 if ageyears <= 29
		replace age = 1 if ageyears >= 30 & ageyears <=44
		replace age = 2 if ageyears >= 45 & ageyears <=59
		replace age = 3 if ageyears >= 60
		
		label define age 	0"18-29" ///
							1"30-44" ///
							2"45-59" ///
							3"60+"
		lab var age "Alter gruppiert"					
		label values age age
	
	* Schulabschluss
		gen edu = .
		replace edu = 0 if inlist(kp1_2320, 1,2)
		replace edu = 1 if kp1_2320 == 3
		replace edu = 2 if inlist(kp1_2320, 4,5)
		
		label define edu 0"low" 1"middle" 2"high"
		label values edu edu
		lab var edu "Schulische Ausbildung"
		
	* Politisches Interesse
		foreach n of numlist 1/8 {
			gen interest`n' = 1-(kp`n'_010 -1)/4
			lab var interest`n' "Politisches Interesse Welle `n'"
		}
	
	* Bundesland
		gen bayern = kp1_2601 == 9
		lab var bayern "Bayern"
	
	* Wahl
		* Zweitstimme Wahlentscheidung
			clonevar wahl8_2 = kp8_200ba
			
			foreach n of numlist 5/7 {
				replace wahl8_2 = kp`n'_191ba if kp`n'_170 == 6
			}
			
			replace wahl8_2 = kp8_191ba if kp8_180 == 6
			lab var wahl8_2 "Wahlentscheidung Zweitstimme 2017"
	
		* Unionwahl
			gen unionwahl8 = 0 if !missing(wahl8_2)
			replace unionwahl8 = 1 if wahl8_2 == 1
			replace unionwahl8 = 0 if kp8_180 == 2		// Nichtwähler
			lab var unionwahl8 "Unionwahl Dummy Welle 8"
		
	* PID
		foreach n of numlist 1/8{
			gen unionpid`n' 	= 0 if !missing(kp`n'_2090a)
			replace unionpid`n' = 1 if kp`n'_2090a == 1
			gen spdpid`n'		= 0 if !missing(kp`n'_2090a)
			replace spdpid`n'	= 1 if kp`n'_2090a==4
			gen fdppid`n'		= 0 if !missing(kp`n'_2090a)
			replace fdppid`n'	= 1 if kp`n'_2090a==5
			gen grupid`n'		= 0 if !missing(kp`n'_2090a)
			replace grupid`n'	= 1 if kp`n'_2090a==6
			gen linpid`n'		= 0 if !missing(kp`n'_2090a)
			replace linpid`n'	= 1 if kp`n'_2090a==7
			gen afdpid`n'		= 0 if !missing(kp`n'_2090a)
			replace afdpid`n'	= 1 if kp`n'_2090a==322
		}
	
	* Stärke PID

		foreach n of numlist 1/8{
			gen pidstr`n'=(5-kp`n'_2100)/4 if !missing(kp`n'_2100)
		}

		
	* Skalometer Parteien
		foreach n of numlist 1/8{
			gen skal_cdu`n' = (kp`n'_430a -1)/10
			lab var skal_cdu`n' "Bewertung CDU Welle `n'"
			gen skal_csu`n' = (kp`n'_430b -1)/10
			lab var skal_csu`n' "Bewertung CSU Welle `n'"
			gen skal_spd`n' = (kp`n'_430c -1)/10
			lab var skal_spd`n' "Bewertung SPD Welle `n'"
			gen skal_fdp`n' = (kp`n'_430d -1)/10
			lab var skal_fdp`n' "Bewertung FDP Welle `n'"
			gen skal_gru`n' = (kp`n'_430e -1)/10
			lab var skal_gru`n' "Bewertung GRUENE Welle `n'"
			gen skal_lin`n' = (kp`n'_430f -1)/10
			lab var skal_lin`n' "Bewertung DIE LINKE Welle `n'"
			gen skal_afd`n' = (kp`n'_430i -1)/10
			lab var skal_afd`n' "Bewertung AfD Welle `n'"
			
			gen absdiff_cdsu`n' = abs(round(skal_cdu`n'-skal_csu`n', .1))
			lab var absdiff_cdsu`n' "Betrag Bewertungsdifferenz CDU/CSU Welle `n'"
			lab val absdiff_cdsu`n' be, nofix
		}	
		
	* Bewertungsstreuung Parteibewertungen
		foreach n of numlist 1/8 {
			egen meanp`n'=rowmean(	skal_cdu`n' skal_csu`n' skal_spd`n' skal_fdp`n' skal_gru`n' ///
									skal_lin`n' skal_afd`n')
			lab var meanp`n' "Rowmean Skalometer alle Parteien"
			egen sdp`n'=rowsd(	skal_cdu`n' skal_csu`n' skal_spd`n' skal_fdp`n' ///
								skal_gru`n'	skal_lin`n' skal_afd`n')
			lab var sdp`n' "Rowsd Skalometer alle Parteien"
			gen ambp`n'=meanp`n'-2*sdp`n'
			lab var ambp`n' "Rowmean Parteiskalometer minus 2* Rowsd Parteiskalometer"
			egen meanpb`n'=rowmean(	skal_spd`n' skal_fdp`n' skal_gru`n' ///
									skal_lin`n' skal_afd`n')
			lab var meanpb`n' "Rowmean Skalometer Parteien ohne CDU/CSU"
			egen sdpb`n'=rowsd(	skal_spd`n' skal_fdp`n' ///
								skal_gru`n'	skal_lin`n' skal_afd`n')
			lab var sdpb`n' "Rowsd Skalometer Parteien ohne CDU/CSU"
			gen ambpb`n'=meanpb`n'-2*sdpb`n'
			lab var ambpb`n' "Rowmean Parteiskalometer minus 2* Rowsd Parteiskalometer ohne CDU/CSU"
			egen pmax`n'=rowmax(skal_cdu`n' skal_csu`n' skal_spd`n' skal_fdp`n' skal_gru`n' ///
								skal_lin`n' skal_afd`n')
			lab var pmax`n' "Rowmax Parteiskalometer"
			egen pmin`n'=rowmin(skal_cdu`n' skal_csu`n' skal_spd`n' skal_fdp`n' skal_gru`n' ///
								skal_lin`n' skal_afd`n')
			lab var pmin`n' "Rowmin Parteiskalometer"
			gen pspread`n'=abs(pmax`n'-pmin`n')
			lab var pspread`n' "Skalometer-Bewertungsrange"
			gen absdiff_cdsus`n'=round(absdiff_cdsu`n'/pspread`n')
			lab var absdiff_cdsus`n' "Bewertungsdifferenz / Bewertungsrange"
		}

	* Skalometer Politiker
		foreach n of numlist 1/8{
			gen merkel`n' = (kp`n'_650a -1)/10
			lab var merkel`n' "Bewertung Merkel"
			gen seeh`n' = (kp`n'_650c -1)/10
			lab var seeh`n' "Bewertung Seehofer"
			
			gen absdiff_ms`n' = abs(round(merkel`n'-seeh`n', .1))
			lab var absdiff_ms`n' "Betrag Bewertungsdifferenz Merkel/Seehofer Welle `n'"
			lab val absdiff_ms`n' be, nofix
		}
	
		gen spdpol1 = kp1_650t				//Gabriel
		foreach n of numlist 2/8 {
			gen spdpol`n' = kp`n'_650z1		// Schulz
		}
	
		foreach n of numlist 1/8 {
			gen fdppol`n' = kp`n'_650s		//Lindner
		}
		
		foreach n of numlist 1/8 {
			gen grupol`n' = kp`n'_650w		// Goering-Eckhardt
		}
		
		gen linpol1 = kp1_650v1				// Kipping
		foreach n of numlist 2/8 {
			gen linpol`n' = kp`n'_650y		// Wagenknecht
		}
	
		foreach n of numlist 1/7 {
			gen afdpol`n' = kp`n'_650p		// Petry
		}
		gen afdpol8 = kp8_650j1				// Gauland
	
	
		foreach n of numlist 1/8 {
			egen polmin`n' = rowmin(merkel`n' seeh`n' spdpol`n' fdppol`n' grupol`n' ///
									linpol`n' afdpol`n')
			egen polmax`n' = rowmax(merkel`n' seeh`n' spdpol`n' fdppol`n' grupol`n' ///
									linpol`n' afdpol`n')
			gen polspread`n'=abs(polmax`n'-polmin`n')
			gen absdiff_mss`n'=round(absdiff_ms`n'/polspread`n')
			lab var absdiff_mss`n' "Bewertungsdifferenz / Bewertungsrange"
		}
	
	
	* Kanzlerpräferenz Merkel
		foreach n of numlist 2/8 {
			gen kpraef_m`n'=0 if kp`n'_671>0 & kp`n'_671<4
			replace kpraef_m`n'=1 if kp`n'_671==1
		}	
		
	* Indifferenz Lösungskompetenz *
		foreach n of numlist 1/8 {
			gen indkoma`n'=0 if !missing(kp`n'_850a)
			replace indkoma`n'=1 if kp`n'_850a==808 | kp`n'_850a==809
			gen indkomb`n'=0 if !missing(kp`n'_870a)
			replace indkomb`n'=1 if kp`n'_870a==808 | kp`n'_870a==809
			gen indkomc`n'=(indkoma`n'+indkomb`n')/2
			gen indkomoa`n'=0 if !missing(kp`n'_850a)
			replace indkomoa`n'=1 if kp`n'_850a==808
			gen indkomob`n'=0 if !missing(kp`n'_870a)
			replace indkomob`n'=1 if kp`n'_870a==808 
			gen indkomoc`n'=(indkomoa`n'+indkomob`n')/2
		}

	* Parteiendifferenz 
		lab def unt 0"ueberhaupt keine Unterschiede" 1"sehr grosse Unterschiede"

		foreach n of numlist 1 5 7 8 {
			gen partdiff`n'=(kp`n'_5021-1)/4
			lab var partdiff`n' "Unterschied Parteien"
			lab val partdiff`n' unt, nofix
		}
	
	* Kompetenzzuschreibung
	
		foreach n of numlist 1/8 {
		
			gen kp`n'_komspd1=0 if kp`n'_850a>0 & kp1_850a<811
			replace kp`n'_komspd1=1 if kp`n'_850a==4
			gen kp`n'_komfdp1=0 if kp`n'_850a>0 & kp`n'_850a<811
			replace kp`n'_komfdp1=1 if kp`n'_850a==5
			gen kp`n'_komgru1=0 if kp`n'_850a>0 & kp`n'_850a<811
			replace kp`n'_komgru1=1 if kp`n'_850a==6
			gen kp`n'_komlin1=0 if kp`n'_850a>0 & kp`n'_850a<811
			replace kp`n'_komlin1=1 if kp`n'_850a==7
			gen kp`n'_komafd1=0 if kp`n'_850a>0 & kp`n'_850a<811
			replace kp`n'_komafd1=1 if kp`n'_850a==322
			gen kp`n'_komcdsu1=0 if kp`n'_850a>0 & kp`n'_850a<811
			replace kp`n'_komcdsu1=1 if kp`n'_850a==1
			
			gen kp`n'_komcdu1=0 if kp`n'_850b>0 & kp`n'_850b<811
			replace kp`n'_komcdu1=1 if kp`n'_850b==2
			gen kp`n'_komcsu1=0 if kp`n'_850b>0 & kp`n'_850b<811
			replace kp`n'_komcsu1=1 if kp`n'_850b==3
			gen kp`n'_komunion1=0 if kp`n'_850b>0 & kp`n'_850b<811
			replace kp`n'_komunion1=1 if kp`n'_850b>0 & kp`n'_850b<4
			
			gen kp`n'_komspd2=0 if kp`n'_870a>0 & kp1_870a<811
			replace kp`n'_komspd2=1 if kp`n'_870a==4
			gen kp`n'_komfdp2=0 if kp`n'_870a>0 & kp`n'_870a<811
			replace kp`n'_komfdp2=1 if kp`n'_870a==5
			gen kp`n'_komgru2=0 if kp`n'_870a>0 & kp`n'_870a<811
			replace kp`n'_komgru2=1 if kp`n'_870a==6
			gen kp`n'_komlin2=0 if kp`n'_870a>0 & kp`n'_870a<811
			replace kp`n'_komlin2=1 if kp`n'_870a==7
			gen kp`n'_komafd2=0 if kp`n'_870a>0 & kp`n'_870a<811
			replace kp`n'_komafd2=1 if kp`n'_870a==322
			gen kp`n'_komcdsu2=0 if kp`n'_870a>0 & kp`n'_870a<811
			replace kp`n'_komcdsu2=1 if kp`n'_870a==1
			
			gen kp`n'_komcdu2=0 if kp`n'_870b>0 & kp`n'_870b<811
			replace kp`n'_komcdu2=1 if kp`n'_870b==2
			gen kp`n'_komcsu2=0 if kp`n'_870b>0 & kp`n'_870b<811
			replace kp`n'_komcsu2=1 if kp`n'_870b==3
			gen kp`n'_komunion2=0 if kp`n'_870b>0 & kp`n'_870b<811
			replace kp`n'_komunion2=1 if kp`n'_870b>0 & kp`n'_850b<4
		}
		
		foreach n of numlist 1/8 {
			gen kp`n'_komspd3 = (kp`n'_komspd1 + kp`n'_komspd2)/2
			gen kp`n'_komfdp3 = (kp`n'_komfdp1 + kp`n'_komfdp2)/2
			gen kp`n'_komgru3 = (kp`n'_komgru1 + kp`n'_komgru2)/2
			gen kp`n'_komlin3 = (kp`n'_komlin1 + kp`n'_komlin2)/2
			gen kp`n'_komafd3 = (kp`n'_komafd1 + kp`n'_komafd2)/2
			gen kp`n'_komcdsu3 = (kp`n'_komcdsu1 + kp`n'_komcdsu2)/2
			gen kp`n'_komcdu3 = (kp`n'_komcdu1 + kp`n'_komcdu2)/2
			gen kp`n'_komcsu3 = (kp`n'_komcsu1 + kp`n'_komcsu2)/2
			gen kp`n'_komunion3 = (kp`n'_komunion1 + kp`n'_komunion2)/2
		}
	
	
	foreach n of numlist 1/8 {
		lab var kp`n'_komspd1 "Loesungskompetenz wichtigstes Problem"
		lab var kp`n'_komfdp1 "Loesungskompetenz wichtigstes Problem"
		lab var kp`n'_komgru1 "Loesungskompetenz wichtigstes Problem"
		lab var kp`n'_komlin1 "Loesungskompetenz wichtigstes Problem"
		lab var kp`n'_komafd1 "Loesungskompetenz wichtigstes Problem"
		lab var kp`n'_komcdsu1 "Loesungskompetenz wichtigstes Problem"
		lab var kp`n'_komcdu1 "Loesungskompetenz wichtigstes Problem"
		lab var kp`n'_komcsu1 "Loesungskompetenz wichtigstes Problem"
		lab var kp`n'_komunion1 "Loesungskompetenz wichtigstes Problem"
		lab var kp`n'_komspd2 "Loesungskompetenz zweitwichtigstes Problem"
		lab var kp`n'_komfdp2 "Loesungskompetenz zweitwichtigstes Problem"
		lab var kp`n'_komgru2 "Loesungskompetenz zweitwichtigstes Problem"
		lab var kp`n'_komlin2 "Loesungskompetenz zweitwichtigstes Problem"
		lab var kp`n'_komafd2 "Loesungskompetenz zweitwichtigstes Problem"
		lab var kp`n'_komcdsu2 "Loesungskompetenz zweitwichtigstes Problem"
		lab var kp`n'_komcdu2 "Loesungskompetenz zweitwichtigstes Problem"
		lab var kp`n'_komcsu2 "Loesungskompetenz zweitwichtigstes Problem"
		lab var kp`n'_komunion2 "Loesungskompetenz zweitwichtigstes Problem"
		lab var kp`n'_komspd3 "Loesungskompetenz beide Probleme"
		lab var kp`n'_komfdp3 "Loesungskompetenz beide Probleme"
		lab var kp`n'_komgru3 "Loesungskompetenz beide Probleme"
		lab var kp`n'_komlin3 "Loesungskompetenz beide Probleme"
		lab var kp`n'_komafd3 "Loesungskompetenz beide Probleme"
		lab var kp`n'_komcdsu3 "Loesungskompetenz beide Probleme"
		lab var kp`n'_komcdu3 "Loesungskompetenz beide Probleme"
		lab var kp`n'_komcsu3 "Loesungskompetenz beide Probleme"
		lab var kp`n'_komunion3 "Loesungskompetenz beide Probleme"
	}
	

	
	* Zeitpunkt der Wahlentscheidung (kp17_320)
		foreach n of numlist 8 {
			clonevar zeit_wahl`n' = kp`n'_320
			recode zeit_wahl`n' (1=1) (2=3) (3=4) (4=5) (5=6) (6=2)
			clonevar zeit_wahlb`n' = zeit_wahl`n'
			recode zeit_wahlb`n' (1 2=1) (3=2) (4=3) (5=4) (6=5)
		}
	
	* Schwierigkeit der Wahlentscheidung
		lab define schwer 0"ueberhaupt nicht schwer" 1"sehr schwer"
		
		foreach n of numlist 5/8 {
			gen schwer_wahl`n' = 1-(kp`n'_330 -1)/4
			lab var schwer_wahl`n' "Schwierigkeit der Wahlentscheidung"
			lab val schwer_wahl`n' schwer
		}	

	
	* Werte Briefwähler in UVs W8 ersetzen
		replace unionpid8 = unionpid5 if kp5_170 == 6 
		replace unionpid8 = unionpid6 if kp6_170 == 6
		replace unionpid8 = unionpid7 if kp7_170 == 6
		
		replace absdiff_cdsu8 = absdiff_cdsu5 if kp5_170 == 6
		replace absdiff_cdsu8 = absdiff_cdsu6 if kp6_170 == 6
		replace absdiff_cdsu8 = absdiff_cdsu7 if kp7_170 == 6
		
		replace absdiff_ms8 = absdiff_ms5 if kp5_170 == 6
		replace absdiff_ms8 = absdiff_ms6 if kp6_170 == 6
		replace absdiff_ms8 = absdiff_ms7 if kp7_170 == 6
		
		replace kp8_komunion3 = kp5_komunion3 if kp5_170 == 6
		replace kp8_komunion3 = kp6_komunion3 if kp6_170 == 6
		replace kp8_komunion3 = kp7_komunion3 if kp7_170 == 6
		
		replace partdiff8 = partdiff5 if kp5_170 == 6
		replace partdiff8 = partdiff5 if kp6_170 == 6
		replace partdiff8 = partdiff7 if kp7_170 == 6
		
		replace pidstr8 = pidstr5 if kp5_170 == 6
		replace pidstr8 = pidstr6 if kp6_170 == 6
		replace pidstr8 = pidstr7 if kp7_170 == 6

		replace indkomc8 = indkomc5 if kp5_170 == 6
		replace indkomc8 = indkomc6 if kp6_170 == 6
		replace indkomc8 = indkomc7 if kp7_170 == 6
		
		replace ambp8 = ambp5 if kp5_170 == 6
		replace ambp8 = ambp6 if kp6_170 == 6
		replace ambp8 = ambp7 if kp7_170 == 6
		
		replace kpraef_m8 = kpraef_m5 if kp5_170 == 6
		replace kpraef_m8 = kpraef_m6 if kp6_170 == 6
		replace kpraef_m8 = kpraef_m7 if kp7_170 == 6
		
		
		foreach n of numlist 5/7 {
			foreach var in spd fdp gru lin afd {
				replace `var'pid8 = `var'pid`n' if kp`n'_170 == 6
				replace interest8 = interest`n' if kp`n'_170 == 6	
			}	
		}
		
		* alternative Operationalisierung
			replace absdiff_cdsu7 = absdiff_cdsu5 if kp5_170 == 6
			replace absdiff_cdsu7 = absdiff_cdsu6 if kp6_170 == 6
				
			replace absdiff_ms7 = absdiff_ms5 if kp5_170 == 6
			replace absdiff_ms7 = absdiff_ms6 if kp6_170 == 6
			
			foreach n of numlist 5/6 {
				foreach var in union spd fdp gru lin afd {
					replace `var'pid7 = `var'pid`n' if kp`n'_170 == 6
					replace interest7 = interest`n' if kp`n'_170 == 6	
				}
			}		
		

		
		
		
*********************************************************************************
* Abbildung 5.b: Unionwahl		  												*
*********************************************************************************
	set scheme lean2
			
	* Standard Modell
		eststo m1a: quietly logit 	unionwahl8 absdiff_cdsu8 absdiff_ms8 pidstr8 kp8_komunion3 kpraef_m8 ///
									c.(ageyears interest8) female i.edu if bayern==0 & unionpid8==1
							
		eststo m2a: quietly logit 	unionwahl8 absdiff_cdsu8 absdiff_ms8 pidstr8 kp8_komunion3 kpraef_m8 ///
									c.(ageyears interest8) female i.edu if bayern==1 & unionpid8==1 
		
		
	* Andere Schätzung zur Grafik-Erstellung Abbildung 5b
		separate unionwahl8, by(bayern)
		eststo m3: logit 	unionwahl8 c.absdiff_cdsu8##i.bayern  c.absdiff_ms8##i.bayern ///
							c.kp8_komunion3##i.bayern  c.pidstr8##i.bayern  i.kpraef_m8##i.bayern  ///
							c.ageyears##i.bayern  c.interest8##i.bayern  i.female##i.bayern  i.edu##i.bayern  if unionpid8==1
			
		margins, at(absdiff_cdsu8=(0(.1)1)) over(bayern)

		marginsplot, plot1opts(msymbol(O) mcolor(black)) plot2opts(msymbol(O) mcolor(gray) ) ci2opts(lcolor(gray))xlabel(,format(%9.1f) angle(45)) name(overlay1, replace) ///
		addplot((histogram absdiff_cdsu8 if unionpid8 == 1 & bayern == 0, discrete fraction fcolor(gs0)) ///
				||(histogram absdiff_cdsu8 if unionpid8 == 1 & bayern == 1, discrete fraction color(gs10) barwidth(.09)), ///
				legend(off)) ///
				title("Bewertungsunterschied CDU/CSU") ytitle("") ///
				xlabel(,nogrid) ylabel(0 0.2 0.4 0.6 0.8 1, nogrid) ///
				xtitle("") ///
				text(0.5 0.2 "Bayern", size(small) color(gray)) ///
				text(0.8 0.3 "Deutschland ohne Bayern", size(small) color(gs0))

		estimates restore m3
			
		margins, at(absdiff_ms=(0(.1)1)) over(bayern)
			
		marginsplot, plot1opts(msymbol(O) mcolor(black)) plot2opts(msymbol(O) mcolor(gray) ) ci2opts(lcolor(gray))xlabel(,format(%9.1f) angle(45)) name(overlay2, replace) ///
		addplot((histogram absdiff_ms8 if unionpid8 == 1 & bayern == 0, discrete fraction color(gs0)) ///
				||(histogram absdiff_ms8 if unionpid8 == 1 & bayern == 1, discrete fraction color(gs10) barwidth(.09)), ///
				legend(off)) ///
				title("Bewertungsunterschied Merkel/Seehofer") ytitle("") ///
				xlabel(,nogrid) ylabel(0 0.2 0.4 0.6 0.8 1, nogrid) ///
				xtitle("")
					
		graph combine overlay1 overlay2, ycommon 

		graph export "Abbildung5b.eps", replace

	* Tabelle (Appendix)
		esttab 	m1a m2a using "Tabelle_5b.rtf", replace nogaps compress label ///
				nobaselevels ///
				b(2) se(2) ///
				nonumbers mtitles("Deutschland ohne Bayern" "Bayern") ///
				coeflabels(	absdiff_cdsu8 "Differenz CDU/CSU" ///
							absdiff_ms8 "Differenz Merkel/Seehofer" ///
							kp8_komunion3 "Kompetenz Union" ///
							pidstr8 "Staerke PID" ///
							kpraef_m8 "Kanzlerpraeferenz Merkel" ///
							_cons "Konstante") ///
				stats(N r2_p, label("N" "Pseudo R-Quadrat")) ///
				addnotes(	"Daten: Wahlkampfpanel 2017 Welle 8")
						
		
*********************************************************************************
* Abbildung 6: Schwierigkeit der Wahlentscheidung								*
*********************************************************************************		
		
		estimates clear

		eststo m1a: quietly ologit	schwer_wahl8 absdiff_cdsu8 absdiff_ms8 ///
									partdiff8 ambp8 kp8_komunion3 pidstr8 ///
									i.edu ageyears female interest8 if bayern == 0 & unionpid8==1 & unionwahl8 == 1
								
		eststo marg1a: margins, at(absdiff_cdsu8=(0(.1)1)) pr(outcome(0)) post	
		estimates restore m1a
		eststo marg1b: margins, at(absdiff_ms8=(0(.1)1)) pr(outcome(0)) post
		
		eststo m1b: quietly ologit	schwer_wahl8 absdiff_cdsu8 absdiff_ms8 ///
									partdiff8 ambp8 kp8_komunion3 pidstr8 ///
									i.edu ageyears female interest8 if bayern == 1 & unionpid8==1 & unionwahl8 == 1
		
		eststo marg2a: margins, at(absdiff_cdsu8=(0(.1)1)) pr(outcome(0)) post	
		estimates restore m1b
		eststo marg2b: margins, at(absdiff_ms8=(0(.1)1)) pr(outcome(0)) post
		
	* Die Grafik beschreibt den Effekt auf Outcome schwer_wahl == 0, aka "überhaupt nicht schwer"
		coefplot 	(marg1a, recast(connected) label("Deutschland ohne Bayern") msymbol(Oh)) ///
					(marg2a,recast(connected) label(Bayern) msymbol(Sh) mcolor(gray) lcolor(gray)), bylabel("Bewertungsunterschied CDU/CSU") ///
					||(marg1b, recast(connected)) (marg2b,recast(connected)),bylabel("Bewertungsunterschied Merkel/Seehofer") ///
					vertical ///
					xlabel(1"0" 2"0.1" 3"0.2" 4"0.3" 5"0.4" 6"0.5" 7"0.6" 8"0.7" 9"0.8" 10"0.9" 11"1", nogrid) ///
					ylabel(0(0.2)1, nogrid) 
					
		graph export "Abbildung6.eps", replace	
	
		
	* Tabelle (Appendix)
		esttab 	m1a m1b using "Tabelle_6.rtf", replace compress nogaps nonumbers b(2) se(2) ///
				mtitles("Deutschland ohne Bayern" "Bayern") label nobaselevels noconstant ///
				coeflabels(	absdiff_cdsu8 "Diff. CDU/CSU" ///
							partdiff8 "Unterschied Parteien" ///
							kp8_komunion3 "Kompetenz Union" ///
							ambp8 "Ambivalenz Parteien" ///
							pidstr8 "Staerke PID" ///
							absdiff_ms8 "Diff. Merkel/Seehofer") ///
							stats(N r2_p, label("N" "Pseudo R-Quadrat")) ///
				addnotes(	"Daten: Wahlkampfpanel 2017 (Praediktor-Variablen aus Welle, in welcher die Wahlentscheidung fiel)") 
					
*********************************************************************************
* Abbildung 7: Zeitpunkt der Wahlentscheidung									*
*********************************************************************************				
		
	* Finales Modell (5-stufige AV)
		estimates clear
		eststo m1a: quietly ologit	zeit_wahlb8 absdiff_cdsu8 absdiff_ms8 ///
									partdiff8 ambp8 kp8_komunion3 pidstr8 ///
									i.edu ageyears female interest8 if bayern == 0 & unionpid8==1 & unionwahl8 == 1
								
		eststo m1b: quietly ologit	zeit_wahlb8 absdiff_cdsu8 absdiff_ms8 ///
									partdiff8 ambp8 kp8_komunion3 pidstr8 ///
									i.edu ageyears female interest8 if bayern == 1 & unionpid8==1 & unionwahl8 == 1
									
	* Grafik mit Zusammenfassung der Ausprägungen 3,4,5
		fre zeit_wahlb8
		clonevar zeit_wahlc8 = zeit_wahlb8
		recode zeit_wahlc8 (4 5 = 3)
		fre zeit_wahlc8
		
		eststo m2a: quietly ologit	zeit_wahlc8 absdiff_cdsu8 absdiff_ms8 ///
									partdiff8 ambp8 kp8_komunion3 pidstr8 ///
									i.edu ageyears female interest8 if bayern == 0 & unionpid8==1 & unionwahl8 == 1
									
		eststo marg2a1: margins, at(absdiff_cdsu8=(0(.1)1)) pr(outcome(3)) post	
		
		estimates restore m2a
		eststo marg2a2: margins, at(absdiff_ms8=(0(.1)1)) pr(outcome(3)) post
									
		eststo m2b: quietly ologit	zeit_wahlc8 absdiff_cdsu8 absdiff_ms8 ///
									partdiff8 ambp8 kp8_komunion3 pidstr8 ///
									i.edu ageyears female interest8 if bayern == 1 & unionpid8==1 & unionwahl8 == 1 
									
		eststo marg2b1: margins, at(absdiff_cdsu8=(0(.1)1)) pr(outcome(3)) post
		
		estimates restore m2b
		eststo marg2b2: margins, at(absdiff_ms8=(0(.1)1)) pr(outcome(3)) post
		
		
		coefplot 	(marg2a1, recast(connected) label(Deutschland ohne Bayern) msymbol(Oh)) (marg2b1,recast(connected) label(Bayern)msymbol(Sh) mcolor(gray) lcolor(gray)), bylabel("Bewertungsunterschied CDU/CSU") ///
 					||(marg2a2, recast(connected)) (marg2b2,recast(connected)),bylabel("Bewertungsunterschied Merkel/Seehofer") ///
 					vertical ///
 					xlabel(1"0" 2"0.1" 3"0.2" 4"0.3" 5"0.4" 6"0.5" 7"0.6" 8"0.7" 9"0.8" 10"0.9" 11"1", nogrid) ///
 					ylabel(0(0.2)1, nogrid) 
		
		graph export "Abbildung7.eps", replace	
		
		
	* Tabelle (Appendix)
	esttab 	m1a m1b using "Tabelle_7.rtf", replace b(2) se(2) nogaps compress ///
			nobaselevels nonumbers noconstant label ///
			mtitles("Deutschland ohne Bayern" "Bayern") ///
			coeflabels(	absdiff_cdsu8 "Diff. CDU/CSU" ///
						partdiff8 "Unterschied Parteien" ///
						kp8_komunion3 "Kompetenz Union" ///
						ambp8 "Ambivalenz Parteien" ///
						pidstr8 "Staerke PID" ///
						absdiff_ms8 "Diff. Merkel/Seehofer") ///
						stats(N r2_p, label("N" "Pseudo R-Quadrat")) ///
			addnotes(	"Daten: Wahlkampfpanel 2017 (Praediktor-Variablen aus Welle, in welcher die Wahlentscheidung fiel)")
										
		
*********************************************************************************
* Robustheitsprüfung															*
*********************************************************************************
	estimates clear
	
*** Wahlentscheidung zugunsten der Union

	eststo m1a: quietly logit 	unionwahl8 absdiff_cdsu8 absdiff_ms8 pidstr8 kp8_komunion3 kpraef_m8 ///
								skal_cdu8 skal_csu8 merkel8 seeh8 ///
								c.(ageyears interest8) female i.edu if bayern==0 & unionpid8==1
							
	eststo m2a: quietly logit 	unionwahl8 absdiff_cdsu8 absdiff_ms8 pidstr8 kp8_komunion3 kpraef_m8 ///
								skal_cdu8 skal_csu8 merkel8 seeh8 ///
								c.(ageyears interest8) female i.edu if bayern==1 & unionpid8==1 


	* Tabelle 
		esttab 	m1a m2a using "Tabelle_5b_Robust.rtf", replace nogaps compress label ///
				nobaselevels b(2) se(2) modelwidth(8) varwidth(25) ///
				nonumbers mtitles("Deutschland ohne Bayern" "Bayern") ///
				coeflabels(	absdiff_cdsu8 "Differenz CDU/CSU" ///
							absdiff_ms8 "Differenz Merkel/Seehofer" ///
							skal_cdu8 "Skalometer CDU" ///
							skal_csu8 "Skalometer CSU" ///
							merkel8  "Skalometer Merkel" ///
							seeh8 "Skalometer Seehofer" ///
							kp8_komunion3 "Kompetenz Union" ///
							pidstr8 "Staerke PID" ///
							kpraef_m8 "Kanzlerpraeferenz Merkel" ///
							interest8 "Politisches Interesse" ///
							female "Geschlecht (Weiblich)" ///
							1.edu "Schulische Bildung: mittleres Niveau" ///
							2.edu "Schulische Bildung: hohes Niveau" ///
							_cons "Konstante") ///
				stats(N r2_p, label("N" "Pseudo R-Quadrat")) ///
				addnotes(	"Daten: Wahlkampfpanel 2017 Welle 8")
		
	* Grafik
	/* separate unionwahl8, by(bayern) */
					
	eststo m3: logit 	unionwahl8 (c.absdiff_cdsu8  c.absdiff_ms8 ///
						c.skal_cdu8 c.skal_csu8 c.merkel8 c.seeh8 ///
						c.kp8_komunion3  c.pidstr8  i.kpraef_m8  ///
						c.ageyears  c.interest8 i.female  i.edu)##i.bayern  if unionpid8==1
			
	margins, at(absdiff_cdsu8=(0(.1)1)) over(bayern)

	marginsplot, xlabel(,format(%9.1f) angle(45)) name(overlay1, replace) ///
	addplot((histogram absdiff_cdsu8 if unionpid8 == 1 & bayern == 0, discrete fraction fcolor(gs0)) ///
			||(histogram absdiff_cdsu8 if unionpid8 == 1 & bayern == 1, discrete fraction color(gs10) barwidth(.09)), ///
			legend(off)) ///
			title("Bewertungsunterschied CDU/CSU") ytitle("") ///
			xlabel(,nogrid) ylabel(0 0.2 0.4 0.6 0.8 1, nogrid) ///
			xtitle("") ///
			text(0.5 0.2 "Bayern", size(small) color(gs10)) ///
			text(0.8 0.3 "Deutschland ohne Bayern", size(small) color(gs0))

	estimates restore m3
			
	margins, at(absdiff_ms=(0(.1)1)) over(bayern)
			
	marginsplot, xlabel(,format(%9.1f) angle(45)) name(overlay2, replace) ///
	addplot((histogram absdiff_ms8 if unionpid8 == 1 & bayern == 0, discrete fraction color(gs0)) ///
			||(histogram absdiff_ms8 if unionpid8 == 1 & bayern == 1, discrete fraction color(gs10) barwidth(.09)), ///
			legend(off)) ///
			title("Bewertungsunterschied Merkel/Seehofer") ytitle("") ///
			xlabel(,nogrid) ylabel(0 0.2 0.4 0.6 0.8 1, nogrid) ///
			xtitle("")
					
	graph combine overlay1 overlay2, ycommon 

	graph export "Abbildung5b_Robust.tif", replace



*** Schwierigkeit der Wahlentscheidung								
		
	estimates clear

	eststo m1a: quietly ologit	schwer_wahl8 absdiff_cdsu8 absdiff_ms8 ///
								skal_cdu8 skal_csu8 merkel8 seeh8 ///
								partdiff8 ambp8 kp8_komunion3 pidstr8 ///
								i.edu ageyears female interest8 if bayern == 0 & unionpid8==1 & unionwahl8 == 1
								
	eststo marg1a: margins, at(absdiff_cdsu8=(0(.1)1)) pr(outcome(0)) post	
	estimates restore m1a
	eststo marg1b: margins, at(absdiff_ms8=(0(.1)1)) pr(outcome(0)) post
		
	eststo m1b: quietly ologit	schwer_wahl8 absdiff_cdsu8 absdiff_ms8 ///
								skal_cdu8 skal_csu8 merkel8 seeh8 ///
								partdiff8 ambp8 kp8_komunion3 pidstr8 ///
								i.edu ageyears female interest8 if bayern == 1 & unionpid8==1 & unionwahl8 == 1
								
	eststo marg2a: margins, at(absdiff_cdsu8=(0(.1)1)) pr(outcome(0)) post	
	estimates restore m1b
	eststo marg2b: margins, at(absdiff_ms8=(0(.1)1)) pr(outcome(0)) post
		
	* Die Grafik beschreibt den Effekt auf Outcome schwer_wahl == 0, aka "überhaupt nicht schwer"
	coefplot 	(marg1a, recast(connected) label("Deutschland ohne Bayern")) ///
				(marg2a,recast(connected) label(Bayern)), bylabel("Bewertungsunterschied CDU/CSU") ///
				||(marg1b, recast(connected)) (marg2b,recast(connected)),bylabel("Bewertungsunterschied Merkel/Seehofer") ///
				vertical ///
				xlabel(1"0" 2"0.1" 3"0.2" 4"0.3" 5"0.4" 6"0.5" 7"0.6" 8"0.7" 9"0.8" 10"0.9" 11"1", nogrid) ///
				ylabel(0(0.2)1, nogrid) 
					
	graph export "Abbildung6_Robust.tif", replace	
	
	
	
	* Tabelle 
	esttab 	m1a m1b using "Tabelle_6_Robust.rtf", replace compress nogaps nonumbers b(2) se(2) ///
			nobaselevels noconstant modelwidth(8) varwidth(25) ///
			mtitles("Deutschland ohne Bayern" "Bayern") ///
			coeflabels(	absdiff_cdsu8 "Differenz CDU/CSU" ///
						absdiff_ms8 "Differenz Merkel/Seehofer" ///
						skal_cdu8 "Skalometer CDU" ///
						skal_csu8 "Skalometer CSU" ///
						merkel8  "Skalometer Merkel" ///
						seeh8 "Skalometer Seehofer" ///
						kp8_komunion3 "Kompetenz Union" ///
						pidstr8 "Staerke PID" ///
						partdiff8 "Unterschied Parteien" ///
						interest8 "Politisches Interesse" ///
						ambp8 "Ambivalenz Parteien" ///
						female "Geschlecht (Weiblich)" ///
						1.edu "Schulische Bildung: mittleres Niveau" ///
						2.edu "Schulische Bildung: hohes Niveau" ///
						ageyears "Alter (in Jahren)" ///
						_cons "Konstante") ///
						stats(N r2_p, label("N" "Pseudo R-Quadrat")) ///
			addnotes(	"Daten: Wahlkampfpanel 2017 (Praediktor-Variablen aus Welle, in welcher die Wahlentscheidung fiel)") 


*** Zeitpunkt der Wahlentscheidung

	estimates clear
	eststo m1a: quietly ologit	zeit_wahlb8 absdiff_cdsu8 absdiff_ms8 ///
								skal_cdu8 skal_csu8 merkel8 seeh8 ///
								partdiff8 ambp8 kp8_komunion3 pidstr8 ///
								i.edu ageyears female interest8 if bayern == 0 & unionpid8==1 & unionwahl8 == 1
								
	eststo m1b: quietly ologit	zeit_wahlb8 absdiff_cdsu8 absdiff_ms8 ///
								skal_cdu8 skal_csu8 merkel8 seeh8 ///
								partdiff8 ambp8 kp8_komunion3 pidstr8 ///
								i.edu ageyears female interest8 if bayern == 1 & unionpid8==1 & unionwahl8 == 1	

	* Tabelle
	esttab 	m1a m1b using "Tabelle_7_Robust.rtf", replace b(2) se(2) nogaps compress ///
			nobaselevels nonumbers noconstant modelwidth(8) varwidth(25) ///
			mtitles("Deutschland ohne Bayern" "Bayern") ///
			coeflabels(	absdiff_cdsu8 "Differenz CDU/CSU" ///
						absdiff_ms8 "Differenz Merkel/Seehofer" ///
						skal_cdu8 "Skalometer CDU" ///
						skal_csu8 "Skalometer CSU" ///
						merkel8  "Skalometer Merkel" ///
						seeh8 "Skalometer Seehofer" ///
						kp8_komunion3 "Kompetenz Union" ///
						pidstr8 "Staerke PID" ///
						partdiff8 "Unterschied Parteien" ///
						interest8 "Politisches Interesse" ///
						ambp8 "Ambivalenz Parteien" ///
						female "Geschlecht (Weiblich)" ///
						1.edu "Schulische Bildung: mittleres Niveau" ///
						2.edu "Schulische Bildung: hohes Niveau" ///
						ageyears "Alter (in Jahren)" ///
						_cons "Konstante") ///
						stats(N r2_p, label("N" "Pseudo R-Quadrat")) ///
			addnotes(	"Daten: Wahlkampfpanel 2017 (Praediktor-Variablen aus Welle, in welcher die Wahlentscheidung fiel)")

	* Grafik mit Zusammenfassung der Ausprägungen 3,4,5
				
		eststo m2a: quietly ologit	zeit_wahlc8 absdiff_cdsu8 absdiff_ms8 ///
									skal_cdu8 skal_csu8 merkel8 seeh8 ///
									partdiff8 ambp8 kp8_komunion3 pidstr8 ///
									i.edu ageyears female interest8 if bayern == 0 & unionpid8==1 & unionwahl8 == 1
									
		eststo marg2a1: margins, at(absdiff_cdsu8=(0(.1)1)) pr(outcome(3)) post	
		
		estimates restore m2a
		eststo marg2a2: margins, at(absdiff_ms8=(0(.1)1)) pr(outcome(3)) post
									
		eststo m2b: quietly ologit	zeit_wahlc8 absdiff_cdsu8 absdiff_ms8 ///
									skal_cdu8 skal_csu8 merkel8 seeh8 ///
									partdiff8 ambp8 kp8_komunion3 pidstr8 ///
									i.edu ageyears female interest8 if bayern == 1 & unionpid8==1 & unionwahl8 == 1 
									
		eststo marg2b1: margins, at(absdiff_cdsu8=(0(.1)1)) pr(outcome(3)) post
		
		estimates restore m2b
		eststo marg2b2: margins, at(absdiff_ms8=(0(.1)1)) pr(outcome(3)) post
		
		
		coefplot 	(marg2a1, recast(connected) label(Deutschland ohne Bayern)) (marg2b1,recast(connected) label(Bayern)), bylabel("Bewertungsunterschied CDU/CSU") ///
 					||(marg2a2, recast(connected)) (marg2b2,recast(connected)),bylabel("Bewertungsunterschied Merkel/Seehofer") ///
 					vertical ///
 					xlabel(1"0" 2"0.1" 3"0.2" 4"0.3" 5"0.4" 6"0.5" 7"0.6" 8"0.7" 9"0.8" 10"0.9" 11"1", nogrid) ///
 					ylabel(0(0.2)1, nogrid) 
		
		graph export "Abbildung7_Robust.tif", replace	

	
*********************************************************************************
*********************************************************************************
* Alternative Operationalisierungen												*
*********************************************************************************
*********************************************************************************	
		
* 1. Um Skalennutzung bereinigte Differenzvariablen als Prädiktoren	(Fußnote 2 S. 6)	

	*****************
	* AV: Unionwahl *
	*****************
		estimates clear
	* Standard Modell
		eststo m1a: quietly logit 	unionwahl8 absdiff_cdsus8 absdiff_mss8 pidstr8 kp8_komunion3 kpraef_m8 ///
									c.(ageyears interest8) female i.edu if bayern==0 & unionpid8==1
							
		eststo m2a: quietly logit 	unionwahl8 absdiff_cdsus8 absdiff_mss8 pidstr8 kp8_komunion3 kpraef_m8 ///
									c.(ageyears interest8) female i.edu if bayern==1 & unionpid8==1 
		
		
	* Andere Schätzung zur Grafik-Erstellung Abbildung 5b

		eststo m3: logit 	unionwahl8 c.absdiff_cdsus8##i.bayern  c.absdiff_mss8##i.bayern ///
							c.kp8_komunion3##i.bayern  c.pidstr8##i.bayern  i.kpraef_m8##i.bayern  ///
							c.ageyears##i.bayern  c.interest8##i.bayern  i.female##i.bayern  i.edu##i.bayern  if unionpid8==1
			
		margins, at(absdiff_cdsus8=(0(.1)1)) over(bayern)

		marginsplot, xlabel(,format(%9.1f) angle(45)) name(overlay1, replace) ///
		addplot((histogram absdiff_cdsu8 if unionpid8 == 1 & bayern == 0, discrete fraction fcolor(gs0)) ///
				||(histogram absdiff_cdsu8 if unionpid8 == 1 & bayern == 1, discrete fraction color(gs10) barwidth(.09)), ///
				legend(off)) ///
				title("Bewertungsdifferenz CDU/CSU") ytitle("") ///
				ylabel(0 0.2 0.4 0.6 0.8 1) ///
				xtitle("") ///
				text(0.5 0.2 "Bayern", size(small) color(gs10)) ///
				text(0.8 0.3 "Deutschland ohne Bayern", size(small) color(gs0))

		estimates restore m3
			
		margins, at(absdiff_mss=(0(.1)1)) over(bayern)
			
		marginsplot, xlabel(,format(%9.1f) angle(45)) name(overlay2, replace) ///
		addplot((histogram absdiff_ms8 if unionpid8 == 1 & bayern == 0, discrete fraction color(gs0)) ///
				||(histogram absdiff_ms8 if unionpid8 == 1 & bayern == 1, discrete fraction color(gs10) barwidth(.09)), ///
				legend(off)) ///
				title("Bewertungsdifferenz Merkel/Seehofer") ytitle("") ///
				ylabel(0 0.2 0.4 0.6 0.8 1) ///
				xtitle("")
					
		graph combine overlay1 overlay2, ycommon 


	* Tabelle
		esttab 	m1a m2a, replace nogaps compress label ///
				nobaselevels drop(ageyears interest8 female 1.edu 2.edu) ///
				b(2) se(2) ///
				nonumbers mtitles("Deutschland ohne Bayern" "Bayern") ///
				coeflabels(	absdiff_cdsus8 "Differenz CDU/CSU" ///
							absdiff_mss8 "Differenz Merkel/Seehofer" ///
							kp8_komunion3 "Kompetenz Union" ///
							pidstr8 "Staerke PID" ///
							kpraef_m8 "Kanzlerpraeferenz Merkel" ///
							_cons "Konstante") ///
				stats(N r2_p, label("N" "Pseudo R-Quadrat")) ///
				addnotes(	"Daten: Wahlkampfpanel 2017 Welle 8;" ///
							"nicht berichtete Variablen: politisches Interesse, Geschlecht, Alter, Bildung")
							
							
	******************************************						
	* AV: Schwierigkeit der Wahlentscheidung *
	******************************************
	estimates clear

		eststo m1a: quietly ologit	schwer_wahl8 absdiff_cdsus8 absdiff_mss8 ///
									partdiff8 ambp8 kp8_komunion3 pidstr8 ///
									i.edu ageyears female interest8 if bayern == 0 & unionpid8==1
								
		eststo marg1a: margins, at(absdiff_cdsus8=(0(.1)1)) pr(outcome(0)) post	
		estimates restore m1a
		eststo marg1b: margins, at(absdiff_mss8=(0(.1)1)) pr(outcome(0)) post
		
		eststo m1b: quietly ologit	schwer_wahl8 absdiff_cdsus8 absdiff_mss8 ///
									partdiff8 ambp8 kp8_komunion3 pidstr8 ///
									i.edu ageyears female interest8 if bayern == 1 & unionpid8==1
		
		eststo marg2a: margins, at(absdiff_cdsus8=(0(.1)1)) pr(outcome(0)) post	
		estimates restore m1b
		eststo marg2b: margins, at(absdiff_mss8=(0(.1)1)) pr(outcome(0)) post
		
	* Die Grafik beschreibt den Effekt auf Outcome schwer_wahl == 0, aka "überhaupt nicht schwer"
		coefplot 	(marg1a, recast(connected) label("Deutschland ohne Bayern")) ///
					(marg2a,recast(connected) label(Bayern)), bylabel("Parteienbewertungen") ///
					||(marg1b, recast(connected)) (marg2b,recast(connected)),bylabel("Politikerbewertungen") ///
					vertical ///
					xlabel(1"0" 2"0.1" 3"0.2" 4"0.3" 5"0.4" 6"0.5" 7"0.6" 8"0.7" 9"0.8" 10"0.9" 11"1") ///
					ylabel(0(0.1)0.6) 
					
		
	* Tabelle
		esttab 	m1a m1b, replace compress nogaps nonumbers b(2) se(2) ///
				drop(0.edu 1.edu 2.edu female ageyears interest8 _cons) ///
				mtitles("Deutschland ohne Bayern" "Bayern") ///
				coeflabels(	absdiff_cdsus8 "Diff. CDU/CSU" ///
							partdiff8 "Unterschied Parteien" ///
							kp8_komunion3 "Kompetenz Union" ///
							ambp8 "Ambivalenz Parteien" ///
							pidstr8 "Staerke PID" ///
							absdiff_mss8 "Diff. Merkel/Seehofer") ///
							stats(N r2_p, label("N" "Pseudo R-Quadrat")) ///
				addnotes(	"Daten: Wahlkampfpanel 2017 (Praediktor-Variablen aus Welle, in der die Wahlentscheidung fiel);" ///
							"nicht berichtete Variablen: politisches Interesse, Geschlecht, Alter, Bildung")	
		
		
	**************************************
	* AV: Zeitpunkt der Wahlentscheidung *
	**************************************			
		
	* Finales Modell (5-stufige AV)
		estimates clear
		eststo m1a: quietly ologit	zeit_wahlb8 absdiff_cdsus8 absdiff_mss8 ///
									partdiff8 ambp8 kp8_komunion3 pidstr8 ///
									i.edu ageyears female interest8 if bayern == 0 & unionpid8==1
								
		eststo m1b: quietly ologit	zeit_wahlb8 absdiff_cdsus8 absdiff_mss8 ///
									partdiff8 ambp8 kp8_komunion3 pidstr8 ///
									i.edu ageyears female interest8 if bayern == 1 & unionpid8==1
									
	* Grafik mit Zusammenfassung der Ausprägungen 3,4,5
	
		eststo m2a: quietly ologit	zeit_wahlc8 absdiff_cdsus8 absdiff_mss8 ///
									partdiff8 ambp8 kp8_komunion3 pidstr8 ///
									i.edu ageyears female interest8 if bayern == 0 & unionpid8==1
									
		eststo marg2a1: margins, at(absdiff_cdsus8=(0(.1)1)) pr(outcome(3)) post	
		
		estimates restore m2a
		eststo marg2a2: margins, at(absdiff_mss8=(0(.1)1)) pr(outcome(3)) post
									
		eststo m2b: quietly ologit	zeit_wahlc8 absdiff_cdsus8 absdiff_mss8 ///
									partdiff8 ambp8 kp8_komunion3 pidstr8 ///
									i.edu ageyears female interest8 if bayern == 1 & unionpid8==1
									
		eststo marg2b1: margins, at(absdiff_cdsus8=(0(.1)1)) pr(outcome(3)) post
		
		estimates restore m2b
		eststo marg2b2: margins, at(absdiff_mss8=(0(.1)1)) pr(outcome(3)) post
		
		
		coefplot 	(marg2a1, recast(connected) label(Deutschland ohne Bayern) noci) (marg2b1,recast(connected) label(Bayern) noci), bylabel("Parteienbewertungen") ///
 					||(marg2a2, recast(connected) noci) (marg2b2,recast(connected) noci),bylabel("Politikerbewertungen") ///
 					vertical ///
 					xlabel(1"0" 2"0.1" 3"0.2" 4"0.3" 5"0.4" 6"0.5" 7"0.6" 8"0.7" 9"0.8" 10"0.9" 11"1") ///
 					ylabel(0(0.2)1) 
			
		
	* Tabelle 
	esttab 	m1a m1b, replace b(2) se(2) nogaps compress ///
			nobaselevels nonumbers ///
			drop(1.edu 2.edu female ageyears interest8 _cons) ///
			mtitles("Deutschland ohne Bayern" "Bayern") ///
			coeflabels(	absdiff_cdsu8 "Diff. CDU/CSU" ///
						partdiff8 "Unterschied Parteien" ///
						kp8_komunion3 "Kompetenz Union" ///
						ambp8 "Ambivalenz Parteien" ///
						pidstr8 "Staerke PID" ///
						absdiff_ms8 "Diff. Merkel/Seehofer") ///
						stats(N r2_p, label("N" "Pseudo R-Quadrat")) ///
			addnotes(	"Daten: Wahlkampfpanel 2017 (Praediktor-Variablen aus Welle, in der die Wahlentscheidung fiel);" ///
						"nicht berichtete Variablen: politisches Interesse, Geschlecht, Alter, Bildung")
										
			
		
* 2. Prädiktoren für Unionwahl aus Vorwahlwelle (Fußnote 8 S. 15)
		
		estimates clear
		
		eststo m1a: quietly logit 	unionwahl8 absdiff_cdsu7 absdiff_ms7 pidstr7 kp7_komunion3 kpraef_m7 ///
									c.(ageyears interest7) female i.edu if bayern==0 & unionpid7==1
									
		eststo marg1a: margins, at(absdiff_cdsu7=(0(.1)1)) post	
		estimates restore m1a
		eststo marg1b: margins, at(absdiff_ms7=(0(.1)1)) post
						
		eststo m2a: quietly logit 	unionwahl8 absdiff_cdsu7 absdiff_ms7 pidstr7 kp7_komunion3 kpraef_m7 ///
									c.(ageyears interest7) female i.edu if bayern==1 & unionpid7==1 
		
		eststo marg2a: margins, at(absdiff_cdsu7=(0(.1)1)) post
		estimates restore m2a
		eststo marg2b: margins, at(absdiff_ms7=(0(.1)1)) post

		
		coefplot 	(marg1a, recast(connected) label(außerhalb Bayerns)) (marg2a,recast(connected) label(Bayern)), bylabel("Parteienbewertung") ///
					||(marg1b, recast(connected)) (marg2b,recast(connected)),bylabel("Politikerbewertung") ///
					vertical ///
					xlabel(1"0" 2"0.1" 3"0.2" 4"0.3" 5"0.4" 6"0.5" 7"0.6" 8"0.7" 9"0.8" 10"0.9" 11"1") ///
					ylabel(0(0.2)1) 
					
		
		
