setwd(dirname(rstudioapi::getActiveDocumentContext()$path))
library(glmmADMB)
library(openxlsx)
library(magrittr)
library(texreg)
library(MASS)
library(tidyverse)
select <- dplyr::select

# Load candidate file ----
candidates <- read_rds("Data/candidates.rds")

# Add social media activity ----
##NOTE: Raw social media data cannot be shared.
##Here, we 1) document the analysis and 2) share aggregated count data per candidate

#* Twitter data ----
# load("../Data_SM/candidate_tweets.Rda")
# twitter_activity <- candidate_tweets %>%
#   filter(createdAt > "2017-08-13 00:00:00" & createdAt < "2017-09-24 23:59:59") %>% #108k tweets
#   group_by(user.id) %>%
#   summarise(n_tweets = n())
# write_rds(twitter_activity, file = "Data/twitter_activity.rds")

# Join
candidates <- left_join(candidates, read_rds(file = "Data/twitter_activity.rds"), 
                        by = c("twitter_id" = "user.id"))

#* Facebook data ----
# load("../Data_SM/13august_to_24september_facebookposts_pols.Rda")
# facebook_activity <- facebookposts_pols %>%
#   filter(createdTime > "2017-08-13 00:00:00" &
#            createdTime < "2017-09-24 23:59:59") %>%
#   group_by(unique_id) %>%
#   summarise(n_facebookposts = n())
# write_rds(facebook_activity, file = "Data/facebook_activity.rds")

# Join
candidates <- left_join(candidates, read_rds(file = "Data/facebook_activity.rds"), 
                        by = "unique_id")

