############################################################################
# Die Nutzung sozialer Medien durch Kandidaten im Bundestagswahlkampf 2017 #
# Sebastian Stier, Jürgen Maier & Corinna Oschatz ##########################
############################################################################

setwd(dirname(rstudioapi::getActiveDocumentContext()$path))

# Preprocess data and load packages
source("1_preprocessing.R")

# Regression models ----

#* Table 1: Presence of candidates on social media ----

#Facebook Use
fb_use_model1 <- glm(fb_use ~ party + renewed_candidacy + 
                       mode + leadingcandTOP1 + east +
                       sex + age, data = candidates, family = "binomial")

#Twitter Use
tw_use_model1 <- glm(tw_use ~ party + renewed_candidacy + 
                       mode + leadingcandTOP1 + east +
                       sex + age, data = candidates, family = "binomial")

#Print
htmlreg(list(fb_use_model1, tw_use_model1),
        custom.model.names = c("Facebook Adoption", 
                               "Twitter Adoption"),
        doctype = TRUE,
        file = "Output/Tabelle1.doc",
        single.row = TRUE,
        digits = 2,
        caption = "",
        custom.note = "Logistische Regressionsmodelle, unstandardisierte Koeffizienten. AfD ist Referenzkategorie für Koeffizienten der Parteien.\n ***p < 0.001, **p < 0.01, *p < 0.05",
        include.adjrs = TRUE, 
        include.rsquared = TRUE,
        include.deviance = FALSE,
        include.nobs = TRUE,
        include.bic = FALSE,
        include.dispersion = FALSE,
        custom.gof.names = c(NA, NA, "N"),
        custom.coef.names = c("Konstante",
                              "CDU",
                              "CSU",
                              "FDP", 
                              "Grüne", 
                              "Linke", 
                              "SPD",
                              "Amtsinhaber",
                              "Listenplatz und Direktkandidat",
                              "Nur Listenplatz", 
                              "Spitzenkandidat Parteiliste",
                              "Ostdeutschland",
                              "Geschlecht (1=männlich)",
                              "Alter")) 

#* Table 2: Intensity of social media use ----

#Facebook activity
fb_act_model2 <- glm.nb(n_facebookposts ~ party + renewed_candidacy + 
                          mode + leadingcandTOP1 + east +
                          sex + age, data = candidates)

#Twitter activity
tw_act_model2 <- glm.nb(n_tweets ~ party + renewed_candidacy + 
                          mode + leadingcandTOP1 + east +
                          sex + age, data = candidates)

#Print
htmlreg(list(fb_act_model2, tw_act_model2),
        custom.model.names = c("Facebook Nutzungsintensität", 
                               "Twitter Nutzungsintensität"),
        doctype = TRUE,
        file = "Output/Tabelle2.doc",
        single.row = TRUE,
        digits = 2,
        caption = "",
        custom.note = "Negativ-binomiale Regressionsmodelle, unstandardisierte Koeffizienten. AfD ist Referenzkategorie für Koeffizienten der Parteien.\n ***p < 0.001, **p < 0.01, *p < 0.05",
        include.adjrs = TRUE, 
        include.rsquared = TRUE,
        include.deviance = FALSE,
        include.nobs = TRUE,
        include.bic = FALSE,
        include.dispersion = FALSE,
        custom.gof.names = c(NA, NA, "N"),
        custom.coef.names = c("Konstante",
                            "CDU",
                            "CSU",
                            "FDP", 
                            "Grüne", 
                            "Linke", 
                            "SPD",
                            "Amtsinhaber",
                            "Listenplatz und Direktkandidat",
                            "Nur Listenplatz", 
                            "Spitzenkandidat Parteiliste",
                            "Ostdeutschland",
                            "Geschlecht (1=männlich)",
                            "Alter")) 


# Candidate surveys ----
##NOTE: The candidate data cannot be shared but accessed at GESIS:
#GESIS Datenarchiv, Köln. ZA6814 Datenfile Version 3.0.0, https://doi.org/10.4232/1.13089

#* Figure 1: Importance of Facebook and Twitter ----
read.xlsx("Data/figure1.xlsx") %>% 
  gather(key = "key", value = "value", -X1) %>% 
  mutate(party = recode_factor(X1, "Alle" = "Alle",
                               "AfD" = "AfD",
                               "CDU" = "CDU",
                               "CSU" = "CSU",
                               "FDP" = "FDP",
                               "Grüne" = "Grüne",
                               "Linke" = "Linke",
                               "SPD" = "SPD")) %>% 
  ggplot(aes(x = party, y = value, group = key, fill = key)) +
  geom_col(position = "dodge") + 
  theme_minimal() +
  theme(legend.position = "bottom",
        legend.title = element_blank(),
        axis.title.x = element_blank(),
        axis.text = element_text(color = "black")) + 
  labs(x = "Partei", y = "Wichtigkeit") +
  coord_cartesian(ylim = c(1, 4)) +
  scale_fill_grey()
ggsave(file = "Plots/figure1.pdf", width = 7, height = 6)

#* Figure 2: Facebook usage motives ----
read.xlsx("Data/figure2.xlsx") %>% 
  gather(key = "key", value = "value", -X1) %>% 
  mutate(party = recode_factor(key, "Alle" = "Alle",
                               "AfD" = "AfD",
                               "CDU" = "CDU",
                               "CSU" = "CSU",
                               "FDP" = "FDP",
                               "Grüne" = "Grüne",
                               "Linke" = "Linke",
                               "SPD" = "SPD")) %>% 
  rename(dimension = X1) %>% 
  ggplot(aes(x = party, y = value, fill = party)) +
  facet_wrap(~dimension, nrow = 3) +
  geom_col(position = "dodge") + 
  theme_minimal() +
  theme(legend.position = "none",
        legend.title = element_blank(),
        axis.title.x = element_blank(),
        axis.text = element_text(color = "black"),
        axis.text.x = element_text(angle = 45, hjust = 1, vjust = 1.25)) +
  labs(x = "Partei", y = "Stärke des Einsatzes für...") +
  ylim(c(0, 4)) +
  scale_fill_grey()
ggsave(file = "Plots/figure2.pdf", width = 5)

#* Figure 3: Twitter usage motives ----
read.xlsx("Data/figure3.xlsx") %>% 
  gather(key = "key", value = "value", -X1) %>% 
  mutate(party = recode_factor(key, "Alle" = "Alle",
                               "AfD" = "AfD",
                               "CDU" = "CDU",
                               "CSU" = "CSU",
                               "FDP" = "FDP",
                               "Grüne" = "Grüne",
                               "Linke" = "Linke",
                               "SPD" = "SPD")) %>% 
  rename(dimension = X1) %>% 
  mutate(key = NULL) %>% 
  ggplot(aes(x = party, y = value, fill = party)) +
  facet_wrap(~dimension, nrow = 3) +
  geom_col(position = "dodge") + 
  theme_minimal() +
  theme(legend.position = "none",
        legend.title = element_blank(),
        axis.title.x = element_blank(),
        axis.text = element_text(color = "black"),
        axis.text.x = element_text(angle = 45, hjust = 1, vjust = 1.25)) +
  labs(x = "Partei", y = "Stärke des Einsatzes für...") +
  ylim(c(0, 4)) +
  scale_fill_grey()
ggsave(file = "Plots/figure3.pdf", width = 5)
