*Populismus ohne host ideology?
clear all
global path "...." // insert path (data & graphs)
use "$path\ZA6801_v1-0-0.dta", clear //  GLES Post-election cross-section 2017, version 1.0.0
set more off
set scheme plotplain
do "$path\ZA6801_missing.do"
gen gew=w_ipfges
svyset [pw=gew]
do "$path\variables.do"

*reshape
gen persnr=_n
reshape long lrdist lrdist_lin ptv sozoekdist libautdist klimadist sal_sozoekdist sal_libautdist sal_klimadist pi leader mip econ wahl , i(persnr) j(partei)

lab var lrdist "Sq. Dist. Left-Right"
lab var sozoekdist "Sq. Dist. Socio-Economic"
lab var libautdist "Sq. Dist. Cultural"
lab var klimadist "Sq. Dist. Climate Change"
lab var pi "Party Identification"
lab var leader "Leader Evaluation"
lab var mip "Solving MIP"
lab var econ "Economy"
lab var ptv "Party Utility (PTV)"
lab var Populism "Populist Attitudes"
lab var pol_int "Political Interest"

replace lrdist = lrdist/10
replace sozoekdist = sozoekdist/10
replace libautdist = libautdist/10
replace klimadist = klimadist/10
**************************************
*AV= PTV
**************************************
*LR:
xtmixed ptv c.lrdist##c.Populism pi leader mip econ [pw=gew]  || persnr: lrdist, var
xtmixed ptv c.lrdist##c.Populism pi leader mip econ pol_int [pw=gew]  || persnr: lrdist

interflex ptv lrdist Populism pi leader mip econ, type(linear) 

interflex ptv lrdist Populism pi leader mip econ, vce(r) ylab(Parteinutzen) dlab(Links-Rechts-Distanz) xlab(Populistische Einstellungen)

interflex ptv lrdist Populism pi leader mip econ, vce(r) n(3) ti(Marginal Effect) xr(-3.5 2.5) yr(-.10 0) ylab(Party Utility) dlab(Left Right) xlab(Populismus)

*interflex ptv lrdist Populism pi leader mip econ, type(kernel)
xtmixed ptv c.lrdist##c.Populism pi leader mip econ [pw=gew]  || persnr: lrdist
esttab using leftright.rtf, label brackets se b(%8.3f) replace
/*
estout using test.txt, keep(ptv:) eqlab("" "L2 RI" "L1 error", none) cell("b se") style(fixed) replace
estout using test.txt, drop(ptv:) eqlab("" "L2 RI" "L1 error", none) cell("b se") style(fixed) eform mlab(,none) collab(,none) stats(r2 bic N) append
*/
margins, at(lrdist=(0(1)5) Populism=(-2 2)) vsquish
marginsplot,  level(95) ///
 recast(line) recastci(rarea) ciopts(color(gs12%50) fintensity(100)) ///
 plot1opts(lcolor(black)) plot2opts(lcolor(black) lp(dash)) ///
 ytitle("PTV") xtitle("Distance Ego-Party") title("Left-Right") ///
 legend(off) saving(lr_ml, replace)
graph export "$path\lr_pop_ml.emf", replace

interflex ptv lrdist Populism pi leader mip econ, vce(r) n(3) title("Marginaler Effekt: Links-rechts") xr(-3.5 2.5) yr(-.10 0) ylab(" ") dlab(Left Right) xlab("Populismus")
graph export "$path\abb_a2_links_oben.tif", replace width(3000)

*Issues
interflex ptv sozoekdist Populism libautdist klimadist  pi leader mip econ, vce(r) n(3) ti(Marginaler Effekt: Steuern/Abgaben) xr(-3.5 2.5) yr(-.10 0) ylab(" ") dlab(soziooec.) xlab(Populismus) 
graph export "$path\interflex_se.emf", replace
graph export "$path\abb_a2_rechts_oben.tif", replace width(3000) 

interflex ptv libautdist Populism sozoekdist klimadist  pi leader mip econ, vce(r) n(3) ti(Marginaler Effekt: Zuzug) xr(-3.5 2.5) yr(-.10 0) ylab(" ") dlab(soziocult.) xlab(Populismus)
graph export "$path\interflex_sc.emf", replace
graph export "$path\abb_a2_links_unten.tif", replace width(3000)

interflex ptv klimadist  Populism libautdist sozoekdist pi leader mip econ, vce(r) n(3) ti(Marginaler Effekt: Klimawandel) xr(-3.5 2.5) yr(-.10 0) ylab(" ") dlab(climate) xlab(Populismus)
graph export "$path\interflex_cl.emf", replace
graph export "$path\abb_a2_rechts_unten.tif", replace width(3000)


*interflex ptv sozoekdist Populism libautdist klimadist  pi leader mip econ, type(kernel)
*interflex ptv libautdist Populism sozoekdist klimadist  pi leader mip econ, type(kernel)
*interflex ptv klimadist  Populism libautdist sozoekdist pi leader mip econ, type(kernel)

xtmixed ptv c.sozoekdist##c.Populism c.libautdist##c.Populism c.klimadist##c.Populism pi leader mip econ [pw=gew] || persnr: sozoekdist libautdist klimadist
esttab using issues.rtf, label brackets se b(%8.3f) replace

margins, at(sozoekdist=(0(1)5) Populism=(-2 2)) vsquish
marginsplot,  level(95) ///
 recast(line) recastci(rarea) ciopts(color(gs12%50) fintensity(100)) ///
 plot1opts(lcolor(black)) plot2opts(lcolor(black) lp(dash)) ///
 ytitle("PTV") xtitle("Distance Ego-Party") title("Socio-Economic Issue Dimension") ///
 legend(off) saving(so, replace) 
graph export "$path\sozoek_pop_ml.emf", replace
 
margins, at(libautdist=(0(1)5) Populism=(-2 2)) vsquish
marginsplot,  level(95) ///
 recast(line) recastci(rarea) ciopts(color(gs12%50) fintensity(100)) ///
 plot1opts(lcolor(black)) plot2opts(lcolor(black) lp(dash)) ///
 ytitle("PTV") xtitle("Distance Ego-Party") title("Cultural Issue Dimension") ///
 legend(off) saving(la, replace)
graph export "$path\libaut_pop_ml.emf", replace

margins, at(klimadist=(0(1)5) Populism=(-2 2)) vsquish
marginsplot,  level(95) ///
 recast(line) recastci(rarea) ciopts(color(gs12%50) fintensity(100)) ///
 plot1opts(lcolor(black)) plot2opts(lcolor(black) lp(dash)) ///
 ytitle("PTV") xtitle("Distance Ego-Party") title("Climate Change Issue Dimension") ///
 legend(off) saving(cl, replace)
graph export "$path\climate_pop_ml.emf", replace

graph combine "so.gph" "la.gph" "cl.gph", ycommon row(3) xsize(3) ysize(4)
graph export "$path\3issues_pop_ml.emf", replace

graph combine "lr_ml.gph" "so.gph" "la.gph" "cl.gph",  row(2) 
graph export "$path\4MargEff_pop_ml.emf", replace
 
preserve
replace Populism=Populism-2
xtmixed ptv c.lrdist##c.Populism pi leader mip econ [pw=gew]  || persnr: lrdist
xtmixed ptv c.sozoekdist##c.Populism c.libautdist##c.Populism c.klimadist##c.Populism pi leader mip econ [pw=gew] || persnr: sozoekdist libautdist klimadist
restore

*Robust
*1) Einzelmodelle a) Afd, b) U+S+F+G
*a)
xtmixed ptv c.sozoekdist##c.Populism c.libautdist##c.Populism c.klimadist##c.Populism pi leader mip econ [pw=gew] if partei==6 || persnr: 
 	
margins, at(sozoekdist=(0(1)5) Populism=(-2 2)) vsquish
marginsplot,  level(95) ///
 recast(line) recastci(rarea) ciopts(color(gs12%50) fintensity(100)) ///
 plot1opts(lcolor(black)) plot2opts(lcolor(black) lp(dash)) ///
 ytitle("PTV") xtitle("Distance Ego-Party: socio-economic issue dimension") title("AfD") ///
 legend(off) saving(so_afd_ml, replace)
graph export "$path\sozoek_pop_afd_ml.emf", replace
 
margins, at(libautdist=(0(1)5) Populism=(-2 2)) vsquish
marginsplot,  level(95) ///
 recast(line) recastci(rarea) ciopts(color(gs12%50) fintensity(100)) ///
 plot1opts(lcolor(black)) plot2opts(lcolor(black) lp(dash)) ///
 ytitle("PTV") xtitle("Distance Ego-Party: socio-cultural issue dimension") title("AfD") ///
 legend(off) saving(la_afd_ml, replace)
graph export "$path\libaut_pop_afd_ml.emf", replace

margins, at(klimadist=(0(1)5) Populism=(-2 2)) vsquish
marginsplot,  level(95) ///
 recast(line) recastci(rarea) ciopts(color(gs12%50) fintensity(100)) ///
 plot1opts(lcolor(black)) plot2opts(lcolor(black) lp(dash)) ///
 ytitle("PTV") xtitle("Distance Ego-Party: climate change issue") title("AfD") ///
 legend(off) saving(cl_afd_ml, replace)
graph export "$path\climate_pop_afd_ml.emf", replace

graph combine "so_afd_ml.gph" "la_afd_ml.gph" "cl_afd_ml.gph", ycommon row(3) xsize(3) ysize(4)
graph export "$path\3issues_pop_afd_ml.emf", replace

*b)
gen etabliert=1 if partei==1 | partei==2 | partei==4 | partei==5
xtmixed ptv c.sozoekdist##c.Populism c.libautdist##c.Populism c.klimadist##c.Populism pi leader mip econ [pw=gew] if etabliert==1 || persnr: 
margins, at(sozoekdist=(0(1)5) Populism=(-2 2)) vsquish
marginsplot,  level(95) ///
 recast(line) recastci(rarea) ciopts(color(gs12%50) fintensity(100)) ///
 plot1opts(lcolor(black)) plot2opts(lcolor(black) lp(dash)) ///
 ytitle("PTV") xtitle("Distance Ego-Party: socio-economic issue dimension") title("Established Parties") ///
 legend(off) saving(so_USFG_ml, replace)
 
margins, at(libautdist=(0(1)5) Populism=(-2 2)) vsquish
marginsplot,  level(95) ///
 recast(line) recastci(rarea) ciopts(color(gs12%50) fintensity(100)) ///
 plot1opts(lcolor(black)) plot2opts(lcolor(black) lp(dash)) ///
 ytitle("PTV") xtitle("Distance Ego-Party: socio-cultural issue dimension") title("Established Parties") ///
 legend(off) saving(la_USFG_ml, replace)

margins, at(klimadist=(0(1)5) Populism=(-2 2)) vsquish
marginsplot,  level(95) ///
 recast(line) recastci(rarea) ciopts(color(gs12%50) fintensity(100)) ///
 plot1opts(lcolor(black)) plot2opts(lcolor(black) lp(dash)) ///
 ytitle("PTV") xtitle("Distance Ego-Party: climate change issue") title("Established Parties") ///
 legend(off) saving(cl_USFG_ml, replace)

graph combine "so_USFG_ml.gph" "la_USFG_ml.gph" "cl_USFG_ml.gph", ycommon row(3) xsize(3) ysize(4)
graph export "$path\3issues_pop_USFG_ml.emf", replace

*LR:
xtmixed ptv c.lrdist##c.Populism pi leader mip econ [pw=gew] if etabliert==1 || persnr: ,var
margins, at(lrdist=(0(10)50) Populism=(-2 2)) vsquish
marginsplot,  level(95) ///
 recast(line) recastci(rarea) ciopts(color(gs12%50) fintensity(100)) ///
 plot1opts(lcolor(black)) plot2opts(lcolor(black) lp(dash)) ///
 ytitle("PTV") xtitle("Distance Ego-Party: left-right") title("Established Parties") ///
 legend(off) saving(lr_USFG_ml, replace)

