***************************
*Populism
***************************
svy: gsem (Populism -> q85a q85b q85c q85d q85e q85f ), oprobit
predict Populism, latent(Populism)
replace Populism=Populism*-1
alpha q85a q85b q85c q85d q85e q85f
sum Populism
local mini=r(min)
local maxi=r(max)
local mittel=r(mean)
hist Populism, xtitle("Populistische Einstellungen", size(large)) percent xlab(`mini' "    schwach"  `maxi' "stark    ", labsize(medlarge) nogrid) ylab(, nogrid) ytitle("Prozent", size(large))
*graph export "$path\abb_a1.tif", replace width(3000)

************************************
*PTVs
************************************
gen ptv1=(q106a-1)/10 //cdu/csu
replace ptv1=(q106b-1)/10 if bula==9
gen ptv2=(q106c-1)/10 //spd
gen ptv3=(q106d-1)/10 //lin
gen ptv4=(q106e-1)/10 //gru
gen ptv5=(q106f-1)/10 //fdp
gen ptv6=(q106g-1)/10 //afd

************************************
*vote choice
************************************
forvalues q=1(1)6 {
gen wahl`q'=0
}
replace wahl1=1 if q19ba==1 //cdu/csu
replace wahl2=1 if q19ba==4 //spd
replace wahl3=1 if q19ba==7 //lin
replace wahl4=1 if q19ba==6 //gru
replace wahl5=1 if q19ba==5 //fdp
replace wahl6=1 if q19ba==322 //afd
************************************
*political interest
************************************
recode q60 (1/2=1) (3=0) (4/5=-1), gen(pol_int)


************************************
*PID - any PID at least medium strength
************************************
recode q126 (1/3=1) (else=0), gen(pid)

************************************
*PID - which party
************************************
forvalues q=1(1)6 {
gen pi`q'=0
}
replace pi1=1 if q125a<4
replace pi2=1 if q125a==4
replace pi3=1 if q125a==7
replace pi4=1 if q125a==6
replace pi5=1 if q125a==5
replace pi6=1 if q125a==322

**********************************
*LR-Distances
**********************************
*squared
gen lrdist1=(q32-q31a)^2
replace lrdist1=(q32-q31b)^2 if bula==9
gen lrdist2=(q32-q31c)^2
gen lrdist3=(q32-q31d)^2
gen lrdist4=(q32-q31e)^2
gen lrdist5=(q32-q31f)^2
gen lrdist6=(q32-q31g)^2
*linear
gen lrdist_lin1=abs(q32-q31a)
replace lrdist_lin1=abs(q32-q31b) if bula==9
gen lrdist_lin2=abs(q32-q31c)
gen lrdist_lin3=abs(q32-q31d)
gen lrdist_lin4=abs(q32-q31e)
gen lrdist_lin5=abs(q32-q31f)
gen lrdist_lin6=abs(q32-q31g)
**********************************
*issue distances
**********************************
gen ego_so=q78
*squared socio-economic
gen sozoekdist1=(q78-q75a)^2
replace sozoekdist1=(q78-q75b)^2 if bula==9
gen sozoekdist2=(q78-q75c)^2
gen sozoekdist3=(q78-q75d)^2
gen sozoekdist4=(q78-q75e)^2
gen sozoekdist5=(q78-q75f)^2
gen sozoekdist6=(q78-q75g)^2
*squared immigration
gen ego_la=q79
gen libautdist1=(q79-q76a)^2
replace libautdist1=(q79-q76b)^2 if bula==9
gen libautdist2=(q79-q76c)^2
gen libautdist3=(q79-q76d)^2
gen libautdist4=(q79-q76e)^2
gen libautdist5=(q79-q76f)^2
gen libautdist6=(q79-q76g)^2
*squared climate
gen ego_cl=q80
gen klimadist1=(q80-q77a)^2
replace klimadist1=(q80-q77b)^2 if bula==9
gen klimadist2=(q80-q77c)^2
gen klimadist3=(q80-q77d)^2
gen klimadist4=(q80-q77e)^2
gen klimadist5=(q80-q77f)^2
gen klimadist6=(q80-q77g)^2

**********************************
*issue saliency
**********************************
gen sal_se = 5-(q81)
gen sal_la = 5-(q83)
gen sal_cl = 5-(q84)

**********************************
*issue saliency X squared distances
**********************************
*se
gen sal_sozoekdist1=sal_se*sozoekdist1
gen sal_sozoekdist2=sal_se*sozoekdist2
gen sal_sozoekdist3=sal_se*sozoekdist3
gen sal_sozoekdist4=sal_se*sozoekdist4
gen sal_sozoekdist5=sal_se*sozoekdist5
gen sal_sozoekdist6=sal_se*sozoekdist6
*la
gen sal_libautdist1=sal_la*libautdist1
gen sal_libautdist2=sal_la*libautdist2
gen sal_libautdist3=sal_la*libautdist3
gen sal_libautdist4=sal_la*libautdist4
gen sal_libautdist5=sal_la*libautdist5
gen sal_libautdist6=sal_la*libautdist6
*cl
gen sal_klimadist1=sal_cl*klimadist1
gen sal_klimadist2=sal_cl*klimadist2
gen sal_klimadist3=sal_cl*klimadist3
gen sal_klimadist4=sal_cl*klimadist4
gen sal_klimadist5=sal_cl*klimadist5
gen sal_klimadist6=sal_cl*klimadist6

**********************************
*leader evaluations
**********************************
gen leader1=q29a
replace leader1=q29g if bula==9
egen leader2=rowmean(q29b q29h)
egen leader3=rowmean(q29c q29i)
egen leader4=rowmean(q29d q29j)
egen leader5=rowmean(q29e q29k)
egen leader6=rowmean(q29f q29l)

**********************************
*competence (to solve mip)
**********************************
forvalues q=1(1)6 {
gen mip`q'=0
}
replace mip1=1 if q5a<4
replace mip2=1 if q5a==4
replace mip3=1 if q5a==7
replace mip4=1 if q5a==6
replace mip5=1 if q5a==5
replace mip6=1 if q5a==322

**********************************
*economic evaluation (last 12 month)
**********************************
recode q14 (1=2) (5=4)
gen econ1=-1*q14 // hihger values = better for govt parties
gen econ2=-1*q14 // hihger values = better for govt parties
gen econ3=q14 // hihger values = worse for opposition parties
gen econ4=q14
gen econ5=q14
gen econ6=q14

