{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{       UNIT zur Umwandlung von Zahlen in Hexadezimaldarstellung u.v.m.     }
{                                                                           }
{***************************************************************************}

                              UNIT CODES;

                              INTERFACE

procedure UpCaseStr(var s:string);
procedure DnCaseStr(var s:string);

function HexByte(x:Byte):String;
         { wandelt ein Byte in Hex-Darstellung um }
function HexWord(x:Word):String;
         { wandelt Word in Hexdarstellung um }
function HexDWord(l:Longint):String;
         { wandelt DWord in Hexdarstellung um }
function HexShort(x:shortInt):string;
         { wandelt ein ShortInt in Hex-Darstellung um, Format ZZ }
function HexInt(x:Integer):string;
         { wandelt ein Integer in Hex-Darstellung um, Format ZZ }
function HexLong(l:Longint):String;
         { wandelt Longint in Hexdarstellung um }
function HexPtr(a:pointer):string;
         { ermittelt Stringdarstellung in der Form Hex(SEG):Hex(OFS) }

function ByteHex(s:String):Byte;
         { wandelt eine Hexdarstellung fr Byte in Wert um }
function WordHex(s:String):Word;
         { wandelt Hexdarstellung in Word um }
function DWordHex(s:String):Longint;
	 { wandelt Hexdarstellung in Dword bzw. Longint um }
function ShortHex(s:String):Shortint;
function IntHex(s:String):Integer;
function LongHex(s:String):Longint;

function Bin2BCD(n:Byte):Byte;
	 { ermittelt Binr-Wert von Byte n in gepackter BCD-Darstellung }

function BCD2Bin(n:Byte):Byte;
	 { ermittelt BCD-Wert von Byte n }

{ *********************** } IMPLEMENTATION { ************************** }

const { Tabelle zur Umrechnung von Binrdaten in Hexadezimalstrings }
      Hex:Array[0..15] of Char='0123456789ABCDEF';

      { Tabelle zur Umrechnung von Hexadezimalstrings in Binrdaten }
      Bin:Array[0..22] of Byte=(0,1,2,3,4,5,6,7,8,9,
				$FF,$FF,$FF,$FF,$FF,$FF,$FF,
				10,11,12,13,14,15);

procedure UpCaseStr(var s:string); assembler;
 asm
    cld
    les   di,s
    mov   si,di
    seges lodsb
    mov   cl,al
    xor   ch,ch
    inc   di
@@1:seges lodsb
    cmp   al,'a'
    jb    @@L
    cmp   al,'z'
    ja    @@X
    sub   al,32
    jmp   @@L
@@X: cmp   al,''
     jne   @@X1
     mov   al,''
     jmp   @@L
@@X1:cmp   al,''
     jne   @@X2
     mov   al,''
     jmp   @@L
@@X2:cmp   al,''
     jne   @@L
     mov   al,''
@@L:stosb
    loop  @@1
 end;

procedure DnCaseStr(var s:string); assembler;
 asm
    cld
    les   di,s
    mov   si,di
    seges lodsb
    mov   cl,al
    xor   ch,ch
    inc   di
@@1:seges lodsb
    cmp   al,'A'
    jb    @@L
    cmp   al,'Z'
    ja    @@X
    add   al,32
    jmp   @@L
@@X: cmp   al,''
     jne   @@X1
     mov   al,''
     jmp   @@L
@@X1:cmp   al,''
     jne   @@X2
     mov   al,''
     jmp   @@L
@@X2:cmp   al,''
     jne   @@L
     mov   al,''
@@L:stosb
    loop  @@1
 end;

{ Hilfsprozedur fr Hexbyte/Hexword/Hexdword/HexShort/  }
{                   HexInt/HexLong                      }
{ Input:                                                }
{ ES:DI = Zeiger auf @Result                            }
{ CX   : Anzahl der Nibbles, die auszuwerten sind       }
{ DX:AX: Wert, der zu konvertieren ist.                 }
procedure _Buildhexstr_; near; assembler;
 asm
     std
     add  di,cx
     push cx
     lea  bx,hex
     mov  si,ax
@@1: mov  ax,si
     and  ax,$0F
     xlat
     stosb
     push cx
     mov  cx,4
@@2: shr  dx,1
     rcr  si,1
     loop @@2
     pop  cx
     loop @@1
     pop  cx
     mov  al,cl
     stosb
 end;

function HexByte(x:Byte):String; assembler;
 asm
  les  di,@result
  mov  cx,2
  xor  dx,dx
  mov  al,x
  xor  ah,ah
  call _buildhexstr_
 end;

function HexDWord(l:longint):String; assembler;
 asm
  les  di,@result
  mov  cx,8
  mov  ax,l.word[0]
  mov  dx,l.word[2]
  call _buildhexstr_
 end;

function HexWord(x:Word):String; assembler;
 asm
  les  di,@result
  mov  cx,4
  xor  dx,dx
  mov  ax,x
  call _buildhexstr_
 end;

function HexShort(x:shortInt):string; assembler;
 asm
     les di,@result
     xor dx,dx
     mov cx,2
     xor ah,ah
     mov al,x
     or  al,al
     pushf
     jns @@1
     neg al
     inc di
@@1: call _buildhexstr_
     popf
     jns @@2
     mov al,'-'
     mov es:[di+1],al
     mov al,3
     stosb
@@2:
 end;

function HexInt(x:Integer):string; assembler;
 asm
     les di,@result
     xor dx,dx
     mov cx,4
     mov ax,x
     or  ax,ax
     pushf
     jns @@1
     neg ax
     inc di
@@1: call _buildhexstr_
     popf
     jns @@2
     mov al,'-'
     mov es:[di+1],al
     mov al,5
     stosb
@@2:
 end;

function HexLong(l:longint):String; assembler;
 asm
     les di,@result
     mov ax,l.word[0]
     mov dx,l.word[2]
     mov cx,8
     or  dx,dx
     pushf
     jns @@1
     not ax
     not dx
     add ax,1
     adc dx,0
     inc di
@@1: call _buildhexstr_
     popf
     jns @@2
     mov al,'-'
     mov es:[di+1],al
     mov al,9
     stosb
@@2:
 end;

function HexPtr(a:pointer):string;
 var s:string[9];
 begin
  s:=HexDWord(longint(a));
  insert(':',s,5);
  HexPtr:=s;
 end;

{ Hilfsprozedur fr ByteHex/WordHex/DWordHex }
procedure _GetHex; near; assembler;
 asm
     cld
     xor   ch,ch
     xor   dx,dx
     xor   di,di
     lea   bx,bin
     les   si,[bp+6]
     seges lodsb
     mov   cl,al
     jcxz  @@error
     cmp   cl,8
     ja    @@error
     seges lodsb
     cmp   al,'-'
     pushf
     jne   @@1
     seges lodsb
     dec   cx
@@1: sub   al,'0'
     js    @@error
     cmp   al,22
     ja    @@error
     xlat
     push  cx
     mov   cx,4
     shl   al,cl
@@2: shl   al,1
     rcl   di,1
     rcl   dx,1
     loop  @@2
     pop   cx
     seges lodsb
     loop  @@1
     popf
     jne   @@3
     not   di
     not   dx
     add   di,1
     adc   dx,0
     jmp   @@3
@@error:
     popf
     xor   di,di
     xor   dx,dx
@@3: mov   ax,di
 end;

function ByteHex(s:String):Byte; assembler;
asm
 call _gethex
end;

function WordHex(s:String):Word; assembler;
asm
 call _gethex
end;

function DWordHex(s:String):Longint; assembler;
asm
 call _gethex
end;

function ShortHex(s:String):Shortint; assembler;
asm
 call _gethex
end;

function IntHex(s:String):Integer; assembler;
asm
 call _gethex
end;

function LongHex(s:String):Longint; assembler;
asm
 call _gethex
end;

function Bin2BCD(n:Byte):Byte; assembler;
 asm
  mov  ah,10
  mov  al,n
  div  ah
  mov  cl,4
  shl  al,cl
  or   al,ah
 end;

function BCD2Bin(n:Byte):Byte; assembler;
 asm
  mov cl,4
  mov al,n
  shr al,cl
  mov ah,10
  mul ah
  mov ah,n
  and ah,$0F
  add al,ah
 end;

end.