;******************************************************************;
;                                                                  ;
;    Copyright (c) 1993 by CHRISTIAN BAUMGARTEN 1993               ;
;                                                                  ;
;******************************************************************;

        TITLE CPU

        LOCALS

_len          EQU  WORD PTR [BP+10]
_array        EQU DWORD PTR [BP+6]
_idx          EQU DWORD PTR [BP+12]
_what         EQU  WORD PTR [BP+12]

DATA	SEGMENT	BYTE PUBLIC

	EXTRN	Test8086:BYTE

DATA	ENDS

CODE	SEGMENT	BYTE PUBLIC

	ASSUME	CS:CODE,DS:DATA

        PUBLIC  _MOVE
        PUBLIC  FILLB,FILLW,FILLD
        PUBLIC  SCANSB,SCANSW,SCANSD
        PUBLIC  NSCANSB,NSCANSW,NSCANSD
        PUBLIC  COMPS
        PUBLIC  _INSB_,_INSW_,_OUTSB_,_OUTSW_

_Move          PROC    FAR          ; _Move(var source,dest;count:word);
                mov  bx,sp
                push ds
                cld
                cmp  Test8086,2
                pushf
                mov  cx,ss:[bx+4]
                jcxz @@ende
                mov  dx,cx
                les  di,dword ptr ss:[bx+6]
                lds  si,dword ptr ss:[bx+10]
                cmp  si,di
                ja   @@Upper
                add  si,cx
                add  di,cx
                popf
                jb   @@86low
                .386
                std
                and  cx,3
                jcxz @@2
                dec  si
                dec  di
                rep  movsb
                inc  si
                inc  di
@@2:            sub  si,4
                sub  di,4
                mov  cx,dx
                shr  cx,2
                rep  movsd
                .8086
                jmp  @@ende
@@86low:        std
                shr  cx,1
                jnc  @@3
                dec  si
                dec  di
                movsb
                inc  si
                inc  di
@@3:            sub  si,2
                sub  di,2
                jmp  @@1
@@Upper:        popf
                jb   @@86
                .386
                shr  cx,1
                jnc  @@5
                movsb
@@5:            shr  cx,1
                jnc  @@6
                movsw
@@6:            rep  movsd
                .8086
                jmp  @@ende
@@86:           shr  cx,1
                jnc  @@1
                movsb
@@1:            rep  movsw
@@ende:         pop  ds
                RET     10
_Move          ENDP

_STOSW386:      .386
                SHR  CX,1
                JNC  Short @@1
                STOSW
@@1:            PUSH AX
                PUSH AX
                POP  EAX
                REP  STOSD
                .8086
                RETF 8

FillB          PROC  FAR ; Procedure FillB(Var Buff;Count:word;what:byte);
                MOV  BX,SP
                CLD
                LES  DI,DWORD PTR SS:[BX+8]
                MOV  CX,WORD PTR SS:[BX+6]
                JCXZ @@EXIT
                MOV  AX,WORD PTR SS:[BX+4]
                MOV  AH,AL
                SHR  CX,1
                JNC  @@1
                STOSB
@@1:            CMP  TEST8086,2
                JB   @@2
                JMP  _STOSW386
@@2:            REP  STOSW
@@EXIT:         RET  8
FillB          ENDP

FillW          PROC  FAR ; Procedure FillW(Var Buff;Count:word;what:Word);
                MOV  BX,SP
                CLD
                LES  DI,DWORD PTR SS:[BX+8]
                MOV  CX,WORD PTR SS:[BX+6]
                JCXZ @@EXIT
                MOV  AX,WORD PTR SS:[BX+4]
                CMP  TEST8086,2
                JB   @@86
                JMP  _STOSW386
@@86:           REP  STOSW
@@EXIT:         RET  8
FillW          ENDP

FillD          PROC  FAR ; Procedure FillW(Var Buff;Count:word;what:Longint);
                MOV  BX,SP
                CLD
                LES  DI,DWORD PTR SS:[BX+10]
                MOV  CX,WORD PTR SS:[BX+8]
                JCXZ @@EXIT
                CMP  TEST8086,2
                JB   @@86
                .386
                MOV  EAX,DWORD PTR SS:[BX+4]
                REP  STOSD
                .8086
                RET  8
@@86:           SHL  CX,1
                MOV  AX,WORD PTR SS:[BX+4]
                MOV  DX,WORD PTR SS:[BX+6]
@@1:            STOSW
                XCHG AX,DX
                LOOP @@1
@@EXIT:         RET  8
FillD          ENDP

SCANSB         PROC   FAR  ; Function Scansb(var buff;Count:word;What:Byte):Word;
                CLD
                MOV   BX,SP
                MOV   DX,0FFFFH
                LES   DI,DWORD PTR SS:[BX+8]
                MOV   CX,WORD PTR SS:[BX+6]
                JCXZ  @@EXIT
                MOV   AL,BYTE PTR SS:[BX+4]
                REPNE SCASB
                JNE   @@EXIT
                MOV   DX,WORD PTR SS:[BX+6]
                SUB   DX,CX
                DEC   DX
@@EXIT:         MOV   AX,DX
               RET   8
SCANSB         ENDP

NSCANSB        PROC   FAR  ; Function NScansb(var buff;Count:word;What:Byte):Word;
                CLD
                MOV   BX,SP
                MOV   DX,0FFFFH
                LES   DI,DWORD PTR SS:[BX+8]
                MOV   CX,WORD PTR SS:[BX+6]
                JCXZ  @@EXIT
                MOV   AL,BYTE PTR SS:[BX+4]
                REPE  SCASB
                JE    @@EXIT
                MOV   DX,WORD PTR SS:[BX+6]
                SUB   DX,CX
                DEC   DX
@@EXIT:         MOV   AX,DX
               RET   8
NSCANSB        ENDP

SCANSW         PROC   FAR  ; Function Scansw(var buff;Count:word;What:Word):Word;
                CLD
                MOV   BX,SP
                MOV   DX,0FFFFH
                LES   DI,DWORD PTR SS:[BX+8]
                MOV   CX,WORD PTR SS:[BX+6]
                JCXZ  @@EXIT
                MOV   AX,word PTR SS:[BX+4]
                REPNE SCASW
                JNE   @@EXIT
                MOV   DX,WORD PTR SS:[BX+6]
                SUB   DX,CX
                DEC   DX
@@EXIT:         MOV   AX,DX
               RET   8
SCANSW         ENDP

NSCANSW        PROC   FAR  ; Function NScansw(var buff;Count:word;What:Word):Word;
                CLD
                MOV   BX,SP
                MOV   DX,0FFFFH
                LES   DI,DWORD PTR SS:[BX+8]
                MOV   CX,WORD PTR SS:[BX+6]
                JCXZ  @@EXIT
                MOV   AX,word PTR SS:[BX+4]
                REPE  SCASW
                JE    @@EXIT
                MOV   DX,WORD PTR SS:[BX+6]
                SUB   DX,CX
                DEC   DX
@@EXIT:         MOV   AX,DX
               RET   8
NSCANSW        ENDP

SCANSD         PROC   FAR  ; Function ScansD(var buff;Count:word;What:Longint):Word;
                CLD
                MOV   BX,SP
                MOV   DX,0FFFFH
                LES   DI,DWORD PTR SS:[BX+10]
                MOV   CX,WORD PTR SS:[BX+8]
                JCXZ  @@EXIT
                CMP   TEST8086,2
                JB    @@86
                .386
                MOV   EAX,dword PTR SS:[BX+4]
                REPNE SCASD
                .8086
                JE    @@OK
                JMP   @@EXIT
@@86:           MOV   AX,word PTR SS:[BX+4]
                MOV   SI,word PTR SS:[BX+6]
                JMP   @@1a
@@1:            ADD   DI,2
@@1a:           SCASW
                LOOPNE @@1
                XCHG  AX,SI
                SCASW
                XCHG  AX,SI
                LOOPNE @@1a
                JNE   @@EXIT
@@OK:           MOV   DX,WORD PTR SS:[BX+8]
                SUB   DX,CX
                DEC   DX
@@EXIT:         MOV   AX,DX
               RET   10
SCANSD         ENDP

NSCANSD        PROC   FAR  ; Function NScansD(var buff;Count:word;What:Longint):Word;
                CLD
                MOV   BX,SP
                MOV   DX,0FFFFH
                LES   DI,DWORD PTR SS:[BX+10]
                MOV   CX,WORD PTR SS:[BX+8]
                JCXZ  @@EXIT
                CMP   TEST8086,2
                JB    @@86
                .386
                MOV   EAX,dword PTR SS:[BX+4]
                REPE  SCASD
                .8086
                JNE   @@OK
                JMP   @@EXIT
@@86:           MOV   AX,word PTR SS:[BX+4]
                MOV   SI,word PTR SS:[BX+6]
@@1:            SCASW
                JNE   @@OK
                XCHG  AX,SI
                SCASW
                XCHG  AX,SI
                LOOPE @@1
                JE    @@EXIT
@@OK:           MOV   DX,WORD PTR SS:[BX+8]
                SUB   DX,CX
                DEC   DX
@@EXIT:         MOV   AX,DX
               RET   10
NSCANSD       ENDP

COMPS      PROC    FAR ; Function COMPS(var source,Dest;Count:Word):boolean;
              MOV    BX,SP
              CLD
              PUSH   DS
              MOV    CX,WORD PTR SS:[BX+4]
              JCXZ   @@OK
              LES    DI,DWORD PTR SS:[BX+6]
              LDS    SI,DWORD PTR SS:[BX+10]
              SHR    CX,1
              JNC    @@1
              CMPSB
              JNE    @@NO
              JCXZ   @@OK
@@1:          REPE   CMPSW
              JNE    @@NO
@@OK:         MOV    AL,1
              JMP    @@EXIT
@@NO:         XOR    AL,AL
@@EXIT:       POP    DS
              RET    10
COMPS      ENDP

_INSB_     PROC   FAR ; Procedure _Insb_(Var Buff;Count:Word;PortNo:Word);
             CLD
             MOV    BX,SP
             MOV    CX,WORD PTR SS:[BX+6]
             JCXZ   @@EXIT
             LES    DI,DWORD PTR SS:[BX+8]
             MOV    DX,WORD PTR SS:[BX+4]
             CMP    Test8086,0
             JA     @@286
@@1:         IN     AL,DX
             STOSB
             LOOP   @@1
             JMP    @@EXIT
@@286:       .286
             REP    INSB
             .8086
@@EXIT:      RET    8
_INSB_     ENDP

_INSW_     PROC   FAR ; Procedure _Insw_(Var Buff;Count:Word;PortNo:Word);
             CLD
             MOV    BX,SP
             MOV    CX,WORD PTR SS:[BX+6]
             JCXZ   @@EXIT
             LES    DI,DWORD PTR SS:[BX+8]
             MOV    DX,WORD PTR SS:[BX+4]
             CMP    Test8086,0
             JA     @@286
@@1:         IN     AX,DX
             STOSW
             LOOP   @@1
             JMP    @@EXIT
@@286:       .286
             REP    INSW
             .8086
@@EXIT:      RET    8
_INSW_     ENDP

_OUTSB_    PROC   FAR ; Procedure _Outsb_(Var Buff;Count:Word;PortNo:Word);
             CLD
             MOV    BX,SP
             MOV    CX,WORD PTR SS:[BX+6]
             JCXZ   @@EXIT
             LES    SI,DWORD PTR SS:[BX+8]
             MOV    DX,WORD PTR SS:[BX+4]
             CMP    Test8086,0
             JA     @@286
@@1:         SEGES  LODSB
             OUT    DX,AL
             LOOP   @@1
             JMP    @@EXIT
@@286:       .286
             REP    SEGES OUTSB
             .8086
@@EXIT:      RET    8
_OUTSB_    ENDP

_OUTSW_    PROC   FAR ; Procedure _Outsw_(Var Buff;Count:Word;PortNo:Word);
             CLD
             MOV    BX,SP
             MOV    CX,WORD PTR SS:[BX+6]
             JCXZ   @@EXIT
             LES    SI,DWORD PTR SS:[BX+8]
             MOV    DX,WORD PTR SS:[BX+4]
             CMP    Test8086,0
             JA     @@286
@@1:         SEGES  LODSW
             OUT    DX,AX
             LOOP   @@1
             JMP    @@EXIT
@@286:       .286
             REP    SEGES OUTSW
             .8086
@@EXIT:      RET    8
_OUTSW_    ENDP


CODE	ENDS
	END
