{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{***************************************************************************}
UNIT DISK_OBJ;
INTERFACE
{$IFDEF MSDOS}
 USES OBJECTS,DOS,DISK_REC;
{$ELSE}
 USES OBJECTS,DOS,DISK_REC,WINAPI;
{$ENDIF}

Const
{--- Drive-Flag-Konstanten: ------------------------}

     df_Bootable   = $0001;
     df_Primary    = $0002;
     df_fat12      = $0004;
     df_BigPart    = $0008;
     df_Changeable = $0010;
     df_NotAvail   = $1000;

{--- Drive-Status-Konstanten: ----------------------}

     ds_OK       = 0;
     ds_Error    = 1;
     ds_NotAvail = 2;
     ds_NotReady = 3;

Type
      tDoubleRec = Record
       Case Byte Of
       0:(Selector,Segment:word;);
       1:(L:Longint;);
      end;

     pDrive = ^tDrive;
     tDrive = object(tObject)
      Flags    :Word;
      State    :Integer;
       ByteSec  :Word;
       SecClust :Word;
       {**** Ab hier direkte Daten des "Bootrecords" aus Sektor 0 ****}
       ResSec   :Word;
       FATs     :Byte;
       RootNo   :Word;
       SecNo    :Word;    { = 0, wenn Festplatte > 33 MB }
       MediaType:Byte;
       SecFat   :Word;
       SecTrack :Word;
       Heads    :Word;
       HidSek   :longint; { = word bis DOS 3.3 }
      {------------ Exestiert nur ,falls SekNo=0 und DosVersion>=4.0 ------}
       TotalSek :longint;
       BiosDrive:byte;    { Diskette : 0/1, Festplatte : $80/$81 }
       fill_    :byte;
       extsign  :byte;    { 29h: Extended Boot Record     }
       Serial   :longint; { Seriennummer des Datentrgers }
       VolLabel :DosName;
       FATSTR   :DosPreName;
      {--------------------------------------------------------------------}
      {**** Ab hier selbstinitialisierte Daten ****}
        SecCyl   :Word;
        ClustNo  :Word;
        FreeClust:Word;
        FatStart :Array[1..4] of word;
        Rootstart:Word;
        Datastart:Word;
        Size     :Longint;
        FreeSize :Longint;
        Drive    :Char;
        ByteClust:word;
        D_E_F,E_O_F:word;
      Constructor Init(aDrive:Char);
        Procedure Reset; Virtual;
        Procedure ReadSector(Start:Longint;Count:Word;var Buff);
        Procedure WriteSector(Start:Longint;Count:Word;var Buff);
        Procedure ReadCluster(Start,Count:Word;Var Buff);
        Procedure WriteCluster(Start,Count:Word;Var Buff);
        Procedure ReadAbsSector(Start:Longint;Count:Word;Var Buff);
        Procedure WriteAbsSector(Start:Longint;Count:Word;Var Buff);
       Destructor Done; Virtual;
      Private
        Procedure DosInt_IO(Mode:Word;Start:Longint;Count:Word;Var Buff);
        Procedure DosIOCtrl_IO(Mode:Word;Start:Longint;Count:Word;Var Buff);
{$IFNDEF MSDOS}
      Private
       DosBuffer : tDoubleRec;
       InProcAddr,OutProcAddr:Pointer;
{$ENDIF}
     end;

IMPLEMENTATION

{$IFNDEF MSDOS}

USES _DPMI;

Var  TRegs:TCallStructure;

{$ENDIF}

Const dm_Read  = $0001;
      dm_Write = $0002;

 Constructor tDrive.Init(aDrive:Char);
  begin
   aDrive:=UpCase(aDrive);
   FillChar(Flags,SizeOf(tDrive) - 2,0);
   Drive:=aDrive;
   asm
    mov  ax,$4408    { DOS INT 21H, Funktion 4408h: "Is Drive Changeable" }
    mov  bl,aDrive   { BL = Drive; 0 = Default, 1 = 'A' etc.              }
    sub  bl,64
    push ds
    int  21H
    pop  ds
    jnc  @@10        { Carryflag gesetzt: Fehler ! (AX = 15 entspr. LW n.vh.) }
    cmp  ax,15
    je   @@22        { Laufwerk exestiert nicht ! }
(*  cmp  ax,1
    je   @@3         { Abfrage wird nicht untersttzt }
*)
@@10:cmp  ax,1       { AX = 1 bedeutet, da das Laufwerk fest ist }
    je   @@3
    les  di,self
    or   es:[di].flags,df_changeable
@@3:mov  ah,36h      { DOS INT 21H, Funktion 36H: "Get Free Disk Space" }
    mov  dl,adrive   { DL = Drive; 0 = Default, 1 = 'A' etc.            }
    sub  dl,64
    push ds
    int  21h
    pop  ds
    cmp  ax,$FFFF    { Falls Fehler auftrat, enthlt AX den Wert $FFFF  }
    je   @@1
    les  di,self
    mov  es:[di].SecClust,AX
    mov  es:[di].FreeClust,BX
    mov  es:[di].ByteSec,CX
    mov  es:[di].ClustNo,DX
    mov  si,dx  { DX vor der Multiplikation sichern                       }
    mul  CX     { AX * CX = Sektoren/Cluster * Byte/Sektor = Byte/Cluster }
    mov  dx,si  { DX restaurieren                                         }
    mov  es:[di].ByteClust,AX
    mov  si,ax  { AX vor Multiplikation sichern                           }
    mul  dx     { AX * DX = Byte/Cluster * Anz.d.Cluster = Bytes insgesamt}
    mov  es:[di].Size.Word[0],AX
    mov  es:[di].Size.Word[2],DX
    mov  ax,si  { AX restaurieren                                         }
    mul  bx     { AX * BX = Byte/Cluster * Freie Cluster = Freier Platz   }
    mov  es:[di].FreeSize.Word[0],AX
    mov  es:[di].FreeSize.Word[2],DX
    mov  ax,ds_OK
    jmp  @@2
@@1:mov  ax,ds_notready
    jmp  @@2
@@22:mov  ax,ds_notavail
@@2:les  di,self
    mov  es:[di].state,ax
   end;
   if state<>ds_OK then exit;
{$IFNDEF MSDOS}
   DosBuffer.L:=GlobalDosAlloc(SizeOf(tIoCtrlParams)+ByteClust);
   GetRealMIntVec($25,InProcAddr);    { Adresse Int 25h erfahren }
   GetRealMIntVec($26,OutProcAddr);   { Adresse Int 26h erfahren }
{$ENDIF}
   Reset;
  end;

 Procedure tDrive.Reset;
  var DRV,i:Byte;
      P:pSectorBuff;
  begin
   DRV:=Ord(Drive)-64;
   asm
    mov   ah,1CH   { INT 21H, Funktion 1CH: "Get Drive Data" }
    mov   dl,DRV   { DL = Drive; 0 = Default, 1 = 'A' etc.   }
    push  ds
    int   21h
    mov   bl,[bx] { Rckgabewert in DS:BX enthlt Zeiger auf Media Deskriptor }
                  { Weitere Rckgabewerte werden ignoriert, da schon bekannt. }
    pop   ds
    les   di,self
    cmp   al,$FF  { AL = $FF bedeutet, da ein Fehler auftrat }
    je    @@2     { Laufwerk exestiert nicht/nicht bereit !   }
    mov   es:[di].MediaType,bl
    mov   ax,ds_OK
    jmp   @@3
@@2:mov   ax,ds_NotReady
@@3:mov   es:[di].state,AX
   end;
   if State = ds_OK then
   begin
    asm
     les  di,self      { Gesamtzahl der Cluster > $FFF0 ? => Groe Partition }
     mov  ax,es:[di].ClustNo
     mul  es:[di].SecClust
     or   dx,dx
     jnz  @@Big
     cmp  ax,$FFF0
     jb   @@Small
@@Big:or  es:[di].flags,df_BigPart
@@Small:
    end;
{$IFDEF MSDOS}
    GetMem(P,sizeof(tDos_IOParams)+ByteSec);
{$ELSE}
    P:=Ptr(DosBuffer.Selector,0); { DOS-Speicherplatz reservieren   }
{$ENDIF}
    ReadSector(0,1,P^.Data);      { BootRecord im 0.ten Sektor lesen }
    Move(P^.BootRec.ResSek,Self.ResSec,22 + 26);
    if (Lo(DosVersion)< 4) OR (ExtSign<>$29) then
    begin
     HidSek:=HidSek and $FFFF;
     TotalSek:=SecNo;
     Fillchar(BiosDrive,26,0);
    end;
       {  Berechnungen zur Platten-/Diskettenstruktur durchfhren: }
    FatStart[1] := ResSec;
    For i:=2 to FATs do FatStart[i]:=FatStart[i-1] + SecFat;
    Rootstart:= FatStart[1] + FATs * SecFat;
    Datastart:= RootStart   + (RootNo * 32) div ByteSec;
       { FAT - Signaturen fr defekte Cluster bzw. letzten Dateicluster: }
    if clustNo>=$FF0 then
    begin
     D_E_F:=$FFF0;        { 16-Bit-FAT }
     E_O_F:=$FFF8;
    end else
    begin
     D_E_F:=$FF0;         { 12-Bit-FAT }
     E_O_F:=$FF8;
     Flags:=Flags or df_FAT12;
    end;
    SecCyl:=SecTrack * Heads;
    if SecNo <> 0 then TotalSek:=SecNo;
{$IFDEF MSDOS}
    FreeMem(P,sizeof(tIoCtrlParams)+ByteSec);
{$ENDIF}
   end;
  end;

{$IFDEF MSDOS}
 Procedure tDrive.DosInt_IO(Mode:Word;Start:Longint;Count:Word;Var Buff);
  var Params:tDos_IOParams;
  begin
   if Flags and df_BigPart = 0 then
   asm           { Kleine Partition:                            }
     mov  cx,4   { Max. Anzahl der Wiederholungen im Fehlerfall }
@@1: push cx
     push ds     { DS sichern ! }
     xor  ah,ah
     les  di,self
     mov  al,es:[di].Drive
     sub  al,65               { AL = Drive                     }
     mov  cx,count            { CX = Anz. der Sektoren         }
     mov  dx,start.word[0]    { DX = StartSektor               }
     lds  bx,buff             { DS:BX = Zeiger auf Datenpuffer }
     cmp  mode,dm_Write
     je   @@10                { Schreiben oder Lesen ?         }
     int  25h
     jmp  @@11
@@10:int  26h
@@11:pop  bx       { Flags vom Stack holen (!)                          }
     pop  ds       { DS restaurieren                                    }
     pop  cx       { Wiederholungszhler laden                          }
     jnc  @@OK     { Kein Carryflag: Alles OK                           }
     loop @@1      { Fehler aufgetreten: Falls CX>0 Versuch wiederholen }
     xor  ah,ah    { AL = Fehlercode, AH lschen                        }
     jmp  @@2
@@OK:mov  ax,ds_OK
@@2: les  di,self
     mov  es:[di].state,ax
   end else
   begin                                { Groe Partition ( >32MB ) : }
    Params.StartSec:=Start;
    Params.Count:=Count;
    Params.Dta_Addr:=@Buff;
    asm
     mov  cx,4
@@1: push cx
     push ds      { Datensegment auf dem Stack sichern                     }
     xor  ah,ah
     les  di,self
     mov  al,es:[di].Drive    { AL = Drive                                 }
     sub  al,65
     mov  cx,-1               { CX = -1 : Zugriff auf erweiterte Partition }
     push ss
     pop  ds
     lea  bx,Params           { DS:BX = Zeiger auf tDOS_IOParams - Record  }
     cmp  Mode,dm_Write       { Lesen oder Schreiben ?                     }
     je   @@10
     int  25h
     jmp  @@11
@@10:int  26h
@@11:pop  bx      { Flags vom Stack holen (!)                              }
     pop  ds      { DS restaurieren                                        }
     pop  cx      { Zhlerwert restaurieren                                }
     jnc  @@2     { Carryflag gesetzt: Fehler und evtl. Versuch wiederholen}
     loop @@1
     xor  ah,ah
     jmp  @@3
@@2: xor  ax,ax
@@3: les  di,self
     mov  es:[di].state,ax
    end;
   end;
  end;

{$ELSE}

 Procedure tDrive.DosInt_IO(Mode:Word;Start:Longint;Count:Word;Var Buff);
  Var P:pSectorBuff;
      BuffPtr:Pointer;
      ACount:word;

   Procedure IO_Sectors;
    var Regs:tCallStructure;
        I:Byte;
    begin
      I:=0;
      repeat
       Regs:=TRegs;
       CallRealMProc(Regs);
       INC(I);
      until (Regs._Flags and 1=0) or (I=4);
      TRegs:=Regs;
    end;

  begin
   P:=Ptr(DosBuffer.Selector,0);
   BuffPtr:=@Buff;
   Repeat
     if Count>SecClust then aCount:=SecClust else aCount:=Count;
     PrepareTCallStruct(TRegs);
     With TRegs do
     begin
      { CALL - Adresse in den TCALLSTRUCT eintragen: }
      if Mode = dm_Write then
      begin
       _CS := PtrRec(OutProcAddr).Seg;
       _IP := PtrRec(OutProcAddr).Ofs;
      end else
      begin
       _CS := PtrRec(InProcAddr).Seg;
       _IP := PtrRec(InProcAddr).Ofs;
      end;          { AL = Drive eintragen                         }
      _EAX:= Ord(Drive) - 65;
                   { DS:BX = Zeiger auf Puffer (EBX wird von der  }
                   { Prozedur PrepareTCallStruct auf Null gesetzt)}
      _DS := DosBuffer.Segment;
      if Flags and df_BigPart = 0 then
      begin         { Kleine Partition ( < 32 MB ):                }
       _ECX:=aCount;
       _EDX:=Start;
       _EBX:=SizeOf(tDos_IOParams);
      end else
      begin         { Groe Partition ( > 32 MB )                 }
       _ECX := - 1;
       tDOS_IOParams(P^.Params).Count   :=aCount;
       tDOS_IOParams(P^.Params).StartSec:=Start;
       tDOS_IOParams(P^.Params).DTA_Addr:=
                 Ptr(DosBuffer.Segment,SizeOf(TDOS_IOParams));
      end;
      if Mode=dm_Write then Move(BuffPtr^,P^.Data,ByteSec * aCount);
      IO_Sectors;
      IF TRegs._Flags and 1=0 then
      begin
        State:=ds_OK;
        if Mode = dm_Read then Move(P^.Data,BuffPtr^,ByteSec * aCount);
      end else
      begin
       State:=TRegs._EAX and $FF;
       exit;
      end;
      asm
        les di,self
        mov ax,aCount
        sub Count,ax
        mul es:[di].ByteSec
        add BuffPtr.word[0],ax
        adc dx,0
        mov ax,dx
        mul selectorinc
        add BuffPtr.word[2],ax
      end;
     end;
    until (Count<=0);
  end;

{$ENDIF}

 Procedure tDrive.ReadSector(Start:Longint;Count:Word;var Buff);
  begin
   DosInt_IO(dm_read,Start,Count,Buff);
  end;

 Procedure tDrive.WriteSector(Start:Longint;Count:Word;var Buff);
  begin
   DosInt_IO(dm_write,Start,Count,Buff);
  end;

 Procedure tDrive.ReadCluster(Start,Count:Word;Var Buff);
  begin
   DosInt_IO(dm_read,DataStart + (Start - 2) * SecClust,SecClust * Count,Buff);
  end;

 Procedure tDrive.WriteCluster(Start,Count:Word;Var Buff);
  begin
   DosInt_IO(dm_write,DataStart + (Start - 2) * SecClust,SecClust * Count,Buff);
  end;

{$IFDEF MSDOS}

 Procedure tDrive.DosIOCtrl_IO(Mode:Word;Start:Longint;Count:Word;Var Buff); assembler;
  Var Params:tIOCtrlParams;
  asm
     push ds
     push ss
     pop  ds
     lea  bx,Params
     les  di,self
     mov  ax,Start.Word[0]
     mov  dx,Start.word[2]
     div  es:[di].SecCyl
     mov  [bx].tIOCtrlParams.head,ax
     mov  ax,dx
     xor  dx,dx
     div  es:[di].SecTrack
     mov  [bx].tIOCtrlParams.cyl,ax
     mov  [bx].tIOCtrlParams.StartSec,dx
     mov  ax,count
     mov  [bx].tIOCtrlParams.Sectors,ax
     xor  ax,ax
     mov  [bx].tIOCtrlParams.BitField,al
     mov  ax,buff.word[0]
     mov  dx,buff.word[2]
     mov  [bx].tIOCtrlParams.dta_addr.word[0],ax
     mov  [bx].tIOCtrlParams.dta_addr.word[2],dx
     mov  cx,4
@@1: push cx
     les  di,self
     mov  ax,$440D
     mov  bl,es:[di].Drive
     sub  bl,64
     mov  ch,8
     cmp  mode,dm_write
     je   @@10
     mov  cl,$61
     jmp  @@11
@@10:mov  cl,$41
@@11:push ds
     lea  dx,params
     Int  21h
     pop  ds
     pop  cx
     jnc  @@2
     loop @@1
     mov  ax,$00FF
     jmp  @@3
@@2: xor  ax,ax
@@3: les  di,self
     mov  es:[di].state,ax
     pop  ds
  end;

{$ELSE}

 Procedure tDrive.DosIOCtrl_IO(Mode:Word;Start:Longint;Count:Word;Var Buff);
  Var P : PSectorBuff;
      BuffPtr:Pointer;
      ACount:Word;

   Procedure IO_Sectors;
    var Regs:tCallStructure;
        I:Byte;
    begin
      I:=0;
      repeat
       Regs:=TRegs;
       CallRealMIntr($21,Regs);
       INC(I);
      until (Regs._Flags and 1=0) or (I=4);
      TRegs:=Regs;
    end;

  begin
   P:=Ptr(DosBuffer.Selector,0);
   BuffPtr:=@Buff;
   Repeat
    if Count>SecClust then aCount:=SecClust else aCount:=Count;
    asm
     push ds
     lds  bx,P
     les  di,self
     mov  ax,Start.Word[0]
     mov  dx,Start.word[2]
     div  es:[di].SecCyl
     mov  [bx].tIOCtrlParams.head,ax
     mov  ax,dx
     xor  dx,dx
     div  es:[di].SecTrack
     mov  [bx].tIOCtrlParams.cyl,ax
     mov  [bx].tIOCtrlParams.StartSec,dx
     mov  ax,count
     mov  [bx].tIOCtrlParams.Sectors,ax
     xor  ax,ax
     mov  [bx].tIOCtrlParams.BitField,al
     pop  ds
    end;
    PrepareTCallStruct(TRegs);
    with TRegs do
    begin
     _EAX:=$440D;
     _EBX:=Ord(Drive)-64;
     if Mode = dm_write then _ECX:=$0841 else _ECX:=$0861;
     _DS:=DosBuffer.Segment;
     { _EDX:=0; implizit }
    end;
    P^.Params.DTA_Addr:=Ptr(DosBuffer.Segment,SizeOf(tIOCtrlParams));
    if Mode = dm_Write then Move(BuffPtr^,P^.Data,aCount * ByteSec);

    IO_Sectors;

    IF TRegs._Flags and 1 = 0 then
    begin
      State:=ds_OK;
      if Mode = dm_Read then Move(P^.Data,BuffPtr^,aCount * ByteSec);
    end else
    begin
      State:=TRegs._EAX and $FF;
      exit;
    end;
    asm
       les di,self
       mov ax,aCount
       sub Count,ax
       mul es:[di].ByteSec
       add BuffPtr.word[0],ax
       adc dx,0
       mov ax,dx
       mul selectorinc
       add BuffPtr.word[2],ax
    end;
   until (Count=0);
  end;

{$ENDIF}

 Procedure tDrive.ReadAbsSector(Start:Longint;Count:Word;Var Buff);
  begin
   DosIoCtrl_IO(dm_read,Start,Count,Buff);
  end;

 Procedure tDrive.WriteAbsSector(Start:Longint;Count:Word;Var Buff);
  begin
   DosIoCtrl_IO(dm_write,Start,Count,Buff);
  end;

 Destructor tDrive.Done;
  begin
{$IFNDEF MSDOS}
   if DosBuffer.L<>0 then GlobalDosFree(DosBuffer.Selector);
{$ENDIF}
  end;


end.