{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{***************************************************************************}
UNIT DISK_REC;
INTERFACE

Type  DosPreName = Array[1..8] of char;
      DosName    = Array[1..11] of Char;
      DosExt     = Array[1..3] of Char;

      DosDiskRec=Record
       SekClust:word;
       FreeClust:word;
       ByteSek:word;
       ClustNo:word;
       Media:byte;
      end;

    pPartition = ^tPartition;
    tPartition = Record { 16 Byte }
     Bootind:byte;        { $80: bootable, $00: nicht bootable }
     Shead:byte;          { Erster Kopf der Partition          }
     SSekCyl:word; { Bit: 7......0 15......8                                  }
                   {                   = StartSektor(6 Bit: <=63        }
                   {      ........ = StartZylinder (10 Bit: <= 1023 }
                   { SSek=SSekCyl and $3F                                     }
                   { SCyl=Hi(SSekcyl) + (SSekCyl and $C0) shl 2               }
     SysInd:byte;         { Sysind=1: primary Dos Area, 12-Bit-FAT }
                          { Sysind=4: primary Dos Area, 16-Bit-FAT }
                          { Sysind=5: extended Dos Area            }
     EHead:byte;          { Letzter Kopf der Partition             }
     ESekCyl:word;        { Endsektor & Endzylinder wie oben       }
     PreSek:longint;      { Vorsektoren                            }
     TotalSek:longint;    { Gesamtzahl der Sektoren in der Part.   }
    end;

    pBootRecord = ^tBootRecord;
    tBootRecord = record
     JUMP:array[1..3] of byte;
     USER:DosPreName;
     ByteSek:word;
     SekClust:byte;
    {****  22 Byte: }
     ResSek:word;
     FATs:byte;
     RootNo:word;
     SekNo:word;     { = 0: Platte>32 MB }
     Media:byte;
     SekFat:word;
     SekTrack:word;
     Heads:word;
     {------------ Ab hier DOS-Versionsabhngig -----------}
     HidSek:longint;   { Bis Dos 3.3 vom Typ Word                        }
     TotalSek:longint; { Exestiert nur ,falls SekNo=0 und DosVersion>3.3 }
    {****}
     Drive:byte;
     fill1:byte;
     extsign:byte;   { 29h: Extended Boot Record, ab DOS 4.0     }
     Serial:longint; { Seriennummer des Datentrgers, ab DOS 4.0 }
     VolLabel:DosName;
     FATSTR:DosPreName;
    end;

    tIOCTRLParams=record
      { Fr INTR $21 Fkt $44 (Generic IoCtrl Request) }
      Bitfield:byte;
      head    :word;
      cyl     :word;
      StartSec:word;
      Sectors :word;
      DTA_Addr:Pointer;
     end;

    tDOS_IOParams = Record
     { Fr erweiterte DosPartitionen (>33 MB) und die Interrupts 25h/26h }
     StartSec : Longint;
     Count    : Word;
     DTA_Addr : Pointer;
     Fill     : Array[1..3] of Byte;
     { Fill ist nur dazu da, den Record auf die gleiche Grsse wie
       tIOCtrlParams zu bringen }
    end;

    pBootSector = ^tBootSector;
    tBootSector = Record
     fill:array[1..$1BE] of byte;
     Partition:array[1..4] of tPartition;
     Sign:word;  { Die Signatur mu den Wert $AA55 haben ! }
    end;

    pSectorBuff = ^tSectorBuff;
    tSectorBuff = Record
     Params:tIoCtrlParams;
     case byte of
     0:(BootSec:tBootSector);
     1:(BootRec:tBootrecord;);
     2:(data:array[1..4096] of byte);
    end;

    pDirEntry = ^tDirEntry;
    tDirEntry = record { 32 Bytes: Entspricht einem Verzeichniseintrag     }
     Name:DosName;
                        { Name[1]=$00           : unbenutzter Eintrag   }
                        { Name[1]=$05/$E5  ='' : gelschter  Eintrag   }
                        { Name[1]=$2E      ='.' : SELF                  }
                        { Name[1..2]=$2E2E ='..': UPDIR                 }
     Attr:byte;         { __ADVSHR =Archive,Dir,Vol_ID,Sys,Hid,ReadOnly }
     Fill:Array[1..10] of Byte;
     Time:word;         { HHHH HMMM MMMS SSSS ,Hour:Minute:Second }
     Date:word;         { YYYY YYYM MMMD DDDD ,Year:Month:Day     }
     Startclust:word;   { Erster Datencluster des Files           }
     Size:longint;
    end;

Var DiskError : Word;

  function SekCylVal(sektor:byte;Cyl:word):word;
  function SektorNo(SekCyl:word):byte;
  function CylNo(SekCyl:word):word;

 procedure ResetDisk;
 procedure ParkDisk(Drv:byte);
 procedure GetDriveRec(LW:byte;var DriveRec:DosDiskRec);
 function CurrentDrive:Char;

IMPLEMENTATION

 function CurrentDrive:Char; assembler;
  asm
   mov  ah,$19
   push ds
   Int  $21
   pop  ds
   add  al,'A'
  end;

 procedure GetDriveRec(LW:byte;var DriveRec:DosDiskRec); assembler;
  asm
   mov  ah,$36
   mov  dl,LW
   PUSH DS
   Int  $21
   POP  DS
   CLD
   LES  DI,DriveRec
   STOSW
   MOV  AX,BX
   STOSW
   MOV  AX,CX
   STOSW
   MOV  AX,DX
   STOSW
   mov  ah,$1C
   mov  dl,LW
   push es
   push di
   push ds
   Int  $21
   mov  al,[bx]
   pop  ds
   pop  di
   pop  es
   stosb
 end;

 { Bios-Konvention:                                    }
 { Bit: 7......0 15......8                             }
 {                   = Sektor(6 Bit: <=63        }
 {      ........ = Zylinder (10 Bit: <= 1023 }
function SekCylVal(sektor:byte;Cyl:word):word;
 begin
  SekCylVal:=(sektor and $3F) or ((Cyl and $300) shr 2) or (Cyl shl 8);
 end;

function SektorNo(SekCyl:word):byte;
 begin
  SektorNo:=SekCyl and 63;
 end;

function CylNo(SekCyl:word):word;
 begin
  CylNo:=(SekCyl shr 8) or ((SekCyl and $C0) shl 2);
 end;

procedure ResetDisk; assembler;
 asm
  mov  ah,$0D
  push ds
  Int  $21
  pop  ds
 end;

procedure ParkDisk(Drv:byte); assembler;
 asm
    mov  ah,$19
    mov  dl,drv
    int  13h
    xor  al,al
    jc   @@1
    xor  ah,ah
@@1:lea  di,DiskError
    xchg al,ah
    mov  [di],ax
 end;

end.