{***************************************************************************}
{                                                                           }
{          Copyright (C) Christian Baumgarten, Hamburg 1993.                }
{                                                                           }
{         UNIT zur Bearbeitung von vorzeichenlosen 32-Bit-Zahlen            }
{                                                                           }
{***************************************************************************}

unit dwords;

interface

type dword=longint;

function dstr(a:dword):string;
{ Doppelwort in String konvertieren }

function dval(s:string;var a:dword):integer;
{ String mit Integerwert in Doppelwort konvertieren }


function dmul(a,b:dword):dword;
{ Zwei Doppelworte multiplizieren }

procedure dDivMod(a,b:dword;var d,m:dword);
{ Quotienten und Rest der Division von A durch B errechnen }
{ D = A DIV B; M = A MOD B                                 }

function D_GGT(a,b:dword):dword;
{ Grten gemeinsamen Teiler zweier Doppelworte berechnen }

Function D_KGV(a,b:dword):dword;
{ Kleinstes Gemeinsames Vielfaches zweier Doppelworte berechnen }

function DSqrt(D:DWORD):WORD;
{ Der Eigabeparameter D muss <= $FFFE0000 sein, da das  }
{ Ergebnis sonst nicht mehr als Wort darstellbar ist !  }

implementation

function  dmul(a,b:dword):dword;                 external;
procedure dDivMod(a,b:dword;var d,m:dword);      external;
{$L DWORDS.OBJ}

function DSqrt(D:DWORD):WORD; assembler;
 asm
    mov cx,d.word[2]
    cmp cx,$FFFE
    ja  @@error
    je  @@max
    mov si,d.word[0]
    or  cx,cx
    jnz @@start         { D < $10000 ? }
    cmp si,8            { D <= 8 ? }
    je  @@Is2
    jb  @@small
@@start:
    mov bx,$A5A5
@@1:mov dx,cx
    mov ax,si
    div bx
    add ax,bx
    shr ax,1
    cmp ax,bx
    je  @@2
    inc ax
    cmp ax,bx
    je  @@2
    mov bx,ax
    jmp @@1
@@max:
    mov ax,-1 { = $FFFF }
    jmp @@exit
@@error:
    xor ax,ax
    jmp @@exit
@@small:
    cmp si,4
    jae @@Is2
    mov ax,1
    or  si,si
    jnz @@exit
    dec ax
    jmp @@exit
@@Is2:
    mov ax,2
    jmp @@exit
@@2:
    mov ax,bx
    mul ax
    cmp dx,cx
    jne @@3
    cmp ax,si
@@3:jbe @@4
    dec bx
    jmp @@2
@@4:mov ax,bx
@@exit:
 end;

function D_GGT(a,b:dword):dword;
{ Anwendung des "Euklidischen Algorithmus": }
{ A : B = D , Rest M   ; Falls M>0 dann:    }
{ B : M = D1, Rest M1    usw., bis M = 0.   }
 var d,m:dword;
 begin
  repeat
   ddivmod(a,b,d,m);
   a:=b;
   b:=m;
  until (m=0);
  D_GGT:=a;
 end;

Function D_KGV(a,b:dword):dword;
 { Kleinstes gemeinsames Vielfaches zweier Zahlen A und B ist    }
 { (A * B)/GGT(A,B) ; z.B. KGV(6,15) = 6 * 15 / 3 = 2 * 15 = 30  }
 var c,m:dword;
 begin
  ddivmod(a,d_ggt(a,b),c,m);
  D_KGV:=DMUL(C,B);
 end;

function dstr(a:dword):string;
 var s:string;
     i:byte;
     d,m:dword;
 begin
  s[0]:=#0;
  while (a<>0) do
  begin
   ddivmod(a,10,d,m);
   s:=chr(m+48)+s;
   a:=d;
  end;
  if s[0]=#0 then dstr:='0' else dstr:=s;
 end;

function dval(s:string;var a:dword):integer;
 var i:byte;
 begin
  dval:=0;
  a:=0;
  i:=1;
  while (i<=ord(s[0])) and (s[i] in [' ','+']) do inc(i);
  while i<=length(s) do
  begin
   if s[i] in ['0'..'9'] then
   begin
    a:=dmul(a,10);
    a:=a+ord(s[i])-48;
   end else
   begin
    dval:=i;
    exit;
   end;
   inc(i);
  end;
 end;

end.