{***************************************************************************}
{        FLIESSKOMMAEMULATION FR 8068er UND 80386er Prozessoren.           }
{                Geschrieben von Christian Baumgarten 1993                  }
{                     Copyright (C) Hamburg 1993                            }
{***************************************************************************}

UNIT EMULX87;

INTERFACE
Type tfloat = record
      w1,w2,w3,w4:word;
      se:word;
     end;

 {----------------------------------------------------------}
 { Format einer extended-Zahl:                              }
 { Bit : 79 .......                                       0 }
 {        s eeeeeee eeeeeeee 1mmmmmmm mmmmmmmm ... mmmmmmmm }
 {                                                          }
 { s = 1 : Vorzeichen negativ                               }
 { Der Exponent ist eine vorzeichenlose 15-Bit Zahl.        }
 { Den tatschlichen Wert erhlt man durch Subtraktion von  }
 { 16383 vom codierten Wert !!                              }
 { d.h. das hchste Bit der Mantisse ist immer gesetzt !    }
 { Null wird durch einen Nullexponenten dargestellt und NaN }
 {  = "Not a Number" durch den Exponenten 7FFFH             }
 { Die "Null" kann ein negatives Vorzeichen haben !         }
 {----------------------------------------------------------}

FUNCTION FMUL(a,b:Extended):Extended;
FUNCTION FADD(a,b:Extended):Extended;
FUNCTION FSUB(a,b:Extended):Extended;
FUNCTION FDIV(a,b:Extended):Extended;
FUNCTION FSQR(a:Extended):Extended;
FUNCTION FSQRT(a:Extended):Extended;
FUNCTION FYLOG2(a:Extended):Extended;
{ Berechnet den Logarithmus zur Basis 2    }
{ einer Extended-Zahl im Intervall  ]1..2[ }

IMPLEMENTATION

TYPE TEXTENDED = RECORD
      Mantisse:array[1..4] of word;
      Exponent:Integer;
     end;

PROCEDURE FMUL86; near;  external;
PROCEDURE FADD86; near;  external;
PROCEDURE FSUB86; near;  external;
PROCEDURE FDIV86; near;  external;
PROCEDURE FQDIV86;near;  external;
PROCEDURE FSQR86; near;  external;
PROCEDURE FSQRT86;near; external;
PROCEDURE FLOG2_86;near;  external;
{$L FLOAT86.OBJ }

PROCEDURE FMUL386; near;  external;
PROCEDURE FADD386; near;  external;
PROCEDURE FSUB386; near;  external;
PROCEDURE FDIV386; near;  external;
PROCEDURE FQDIV386;near;  external;
PROCEDURE FSQR386; near;  external;
PROCEDURE FSQRT386;near;  external;
PROCEDURE FLOG2386;near;  external;
{$L FLOAT386.OBJ}

var _fmul,_fdiv,_fadd,_fsub,_fsqr,_fsqrt,_flog2:word;

FUNCTION FMUL(a,b:Extended):Extended;
 begin
  asm
   call word ptr _FMUL;
  end;
 end;

FUNCTION FADD(a,b:Extended):Extended;
 begin
  asm
   call word ptr _Fadd;
  end;
 end;

FUNCTION FSUB(a,b:Extended):Extended;
 begin
  asm
   call word ptr _FSub;
  end;
 end;

FUNCTION FDIV(a,b:Extended):Extended;
 begin
  asm
   call word ptr _FDiv;
  end;
 end;

FUNCTION FSQR(a:Extended):Extended;
 begin
  asm
   call word ptr _FSqr;
  end;
 end;

FUNCTION FSQRT(a:Extended):Extended;
 begin
  asm
   call word ptr _FSqrt;
  end;
 end;

FUNCTION FYLOG2(a:Extended):Extended;
 begin
  asm
   call word ptr _FLog2;
  end;
 end;

BEGIN
 if Test8086 < 2 then
 begin
  _fmul:=ofs(fmul86);
  _fdiv:=ofs(fqdiv86);
  _fadd:=ofs(fadd86);
  _fsub:=ofs(fsub86);
  _fsqr:=ofs(fsqr86);
  _fsqrt:=ofs(fsqrt86);
  _Flog2:=Ofs(flog2_86);
 end else
 begin
  _fmul:=ofs(fmul386);
  _fdiv:=ofs(fqdiv386);
  _fadd:=ofs(fadd386);
  _fsub:=ofs(fsub386);
  _fsqr:=ofs(fsqr386);
  _fsqrt:=ofs(fsqrt386);
  _Flog2:=Ofs(flog2386);
 end;
END.