;******************************************************************;
;                                                                  ;
;    Copyright (c) 1993 by CHRISTIAN BAUMGARTEN 1993               ;
;                                                                  ;
;    FLOATING POINT EMULATOR FR 8086/80386er Prozessoren und      ;
;            144 Bit-Fliekommaformat (Expanded)                   ;
;                                                                  ;
;******************************************************************;

        TITLE EXPANDED

        LOCALS

C_E     EQU   WORD PTR [BP-2]
C_4     EQU   WORD PTR [BP-4]
C4      EQU  DWORD PTR [BP-6]
C3      EQU  DWORD PTR [BP-10]
C2      EQU  DWORD PTR [BP-14]
C1      EQU  DWORD PTR [BP-18]

A_E     EQU   WORD PTR [BP-20]
A_4     EQU   WORD PTR [BP-22]
A4      EQU  DWORD PTR [BP-24]
A3      EQU  DWORD PTR [BP-28]
A2      EQU  DWORD PTR [BP-32]
A1      EQU  DWORD PTR [BP-36]

B_E     EQU   WORD PTR [BP-38]
B_4     EQU   WORD PTR [BP-40]
B4      EQU  DWORD PTR [BP-42]
B3      EQU  DWORD PTR [BP-46]
B2      EQU  DWORD PTR [BP-50]
B1      EQU  DWORD PTR [BP-54]

F_BIAS  EQU 16383
F_WORDS EQU 8
F_SIZE  EQU 16

.386P

DATA	SEGMENT	BYTE PUBLIC USE16

DATA	ENDS

CODE	SEGMENT	BYTE PUBLIC USE16

	ASSUME	CS:CODE,DS:DATA

;***************************************************************************;
;                       Alle Routinen sind near !!                          ;
; Multiplikationen und Additive Operationen werden sehr schnell bearbeitet, ;
; die Division hingegen bentigt etwas mehr Zeit.                           ;
;***************************************************************************;

     PUBLIC  _EMUL386,_EADD386,_ESUB386,_EDIV386,_EQDIV386
     PUBLIC  _ESQR386,_ESQRT386,_ELOG2_386
     PUBLIC  _ECMP386

; Hilfsroutine, die Vorzeichen & Exponenten multipliziert

MUL_SIGNS  PROC      NEAR
            mov  ax,a_e
            mov  bx,ax
            and  ax,07fffh
            mov  cx,b_e
            mov  dx,cx
            and  cx,07fffh
            sub  cx,f_bias
            sub  ax,f_bias
            add  ax,cx
            add  ax,f_bias
            xor  bx,dx
            and  bx,08000h
           RET
MUL_SIGNS  ENDP

; Hilfsroutine, die die Vorzeichen liefert:
; A negativ == Bit 1 in CX gesetzt
; B negativ == Bit 0 in CX gesetzt
; Out: AX = Exponent von A - Bias
;      BX = Exponent von B - Bias
GETSIGNS    PROC      NEAR
             XOR  CX,CX
             MOV  AX,A_E
             MOV  BX,B_E
             SHL  AX,1
             RCL  CX,1
             SHL  BX,1
             RCL  CX,1
             SHR  AX,1
             SHR  BX,1
             SUB  AX,F_BIAS
             SUB  BX,F_BIAS
            RET
GETSIGNS    ENDP

;  Hilfsroutine, die das Ergebnis von A nach C schiebt:
;  A = tExpanded Ptr [bp-36]
;  C = tExpanded Ptr [bp-18]
MOV_C_A     PROC     NEAR
             MOV   EAX,A1
             MOV   C1,EAX
             MOV   EAX,A2
             MOV   C2,EAX
             MOV   EAX,A3
             MOV   C3,EAX
             MOV   EAX,A4
             MOV   C4,EAX
             MOV   AX,A_E
             MOV   C_E,AX
             RET
MOV_C_A     ENDP

; Hilfsroutine, die B mit CL nach rechts rotiert (Fr Addition/Subtraktion)

ROTR_B       PROC     NEAR
              PUSH EAX
@@1:          CMP  CL,31
              JBE  short @@2
              xor  eax,eax
              xchg eax,b4
              xchg eax,b3
              xchg eax,b2
              xchg eax,b1
              sub  cl,32
              JMP  @@1
@@2:          mov  eax,B2
              shrd b1,eax,cl
              mov  eax,B3
              shrd b2,eax,cl
              mov  eax,B4
              shrd B3,eax,cl
              shr  B4,cl
              POP  EAX
              RET
ROTR_B       ENDP

; Hilfsroutine, die die Eingabewerte austauscht

XCHG_A_B     PROC   NEAR
              MOV  EDX,A1
              XCHG EDX,B1
              MOV  A1,EDX
              MOV  EDX,A2
              XCHG EDX,B2
              MOV  A2,EDX
              MOV  EDX,A3
              XCHG EDX,B3
              MOV  A3,EDX
              MOV  EDX,A4
              XCHG EDX,B4
              MOV  A4,EDX
              MOV  DX,A_E
              XCHG DX,B_E
              MOV  A_E,DX
             RET
XCHG_A_B     ENDP

; Hilfsroutine, die die Mantisse von B zu A addiert

ADD_A_B      PROC  NEAR
              SUB  AX,BX
              JNS  short @@1
              CALL XCHG_A_B
              NEG  AX
@@1:          CMP  AX , F_WORDS * 16
              JB   short @@11
              RET
@@11:         OR   AX,AX
              JZ   short @@2
              MOV  CX,AX
              CALL ROTR_B
@@2:          mov  eax,b1
              add  a1,eax
              mov  eax,b2
              adc  a2,eax
              mov  eax,b3
              adc  a3,eax
              mov  eax,b4
              adc  a4,eax
              jnc  @@OK
              rcr  a4,1
              rcr  a3,1
              rcr  a2,1
              rcr  a1,1
              inc  a_E
@@OK:         RET
ADD_A_B      ENDP

; Hilfsroutine, die die Eingabemantisse vergleicht

MCMP386       PROC   NEAR
              PUSH  EAX
              MOV   EAX,A4
              CMP   EAX,B4
              JNE   short @@EXIT
              MOV   EAX,A3
              CMP   EAX,B3
              JNE   short @@EXIT
              MOV   EAX,A2
              CMP   EAX,B2
              JNE   short @@EXIT
              MOV   EAX,A1
              CMP   EAX,B1
@@EXIT:       POP   EAX
              RET
MCMP386       ENDP

; Hilfsroutine, die die Mantisse von B von A abzieht
; Input: AX = Exponent von A-Bias
;        BX = Exponent von B-Bias
SUB_A_B      PROC   NEAR
                CMP  AX,BX
                JG   short @@1  ; A > B ?
                JL   short @@X  ; B > A ?
                CALL MCMP386    ; Exponenten identisch => Mantissen vergleichen
                JA   short @@1
                JB   short @@X
                JMP  @@Z        ; Mantissen identisch => Ergebnis = Null
@@X:            CALL XCHG_A_B   ; B > A => Operanden tauschen...
                XCHG AX,BX
                CALL @@1 ;SUB_A_B
                XOR  A_E,08000H ; ... und Ergebnis negieren
                RET
@@1:            SUB  AX,BX      ; Exponenten subtrahieren...
                JZ   short @@2
                CMP  AX, F_WORDS * 16
                JB   short @@11 ; Zweiter zu klein, um am ersten etwas zu ndern ?
                RET
@@11:           MOV  CX,AX      ; ... und Mantissen angleichen
                CALL ROTR_B
@@2:            mov  eax,b1     ; Mantissen subtrahieren:
                sub  a1,eax
                mov  eax,b2
                sbb  a2,eax
                mov  eax,b3
                sbb  a3,eax
                mov  eax,b4
                sbb  a4,eax
                TEST a_4,08000H
                jnz  short @@4
                mov  cx,F_WORDS * 16
@@3:            shl  a1,1        ; Mantisse renormieren:
                rcl  a2,1
                rcl  a3,1
                rcl  a4,1
                dec  a_e
                test a_4,08000H
                loopz  @@3
                jnz  short @@4
                and  a_e,08000H
@@4:            RET
@@Z:            XOR  AX,AX       ; Ergebnis = Null !
                PUSH SS
                POP  ES
                CLD
                LEA  DI,A1
                MOV  CX,F_Words+1
                REP  STOSW
                RET
SUB_A_B      ENDP

_ECMP386       PROC      NEAR
                CALL GETSIGNS
                XOR  DX,DX
                CMP  CX,1          ; A>0, B<0 ?
                JE   short @@MORE  ; Wenn ja, denn A > B
                CMP  CX,2          ; A<0, B>0 ?
                JE   short @@LESS  ; Wenn ja, dann B > A
                CMP  CX,3          ; A<0, B<0 ?
                PUSHF
                CMP  AX,BX         ; Vergleich der Exponenten:
                JL   short @@LESS1
                JG   short @@MORE1
                CALL MCMP386       ; Vergleich der Mantissen
                JA   short @@MORE1
                JB   short @@LESS1
                POP  AX
                JMP  short @@EQUAL ; A = B
@@LESS1:        POPF
                JE   short @@MORE
@@LESS:         MOV  AX,-1
                RET
@@MORE1:        POPF
                JE   short @@LESS
@@MORE:         MOV  AX,1
                RET
@@EQUAL:        XOR  AX,AX
                RET
_ECMP386       ENDP


_EADD386       PROC      NEAR
                CALL  GETSIGNS
                CMP   CX,1         ; A > 0, B < 0 ?
                JNE   short @@1
                XOR   B_E,08000H   ; Ja: Ergebnis = |A| - |B|
                CALL  SUB_A_B
                JMP   @@ENDE
@@1:            CMP   CX,2         ; A < 0, B > 0 ?
                JNE   short @@2
                XOR   A_E,08000H   ; Ja: Ergebnis = |B| - |A|
                CALL  XCHG_A_B
                XCHG  AX,BX
                CALL  SUB_A_B
                JMP   @@ENDE
@@2:            CMP   CX,3         ; Beide negativ ?
                PUSHF
                JNE   short @@3
                XOR   A_E,08000H   ; Ja: Ergebnis = - (|A| + |B|)
                XOR   B_E,08000H
@@3:            CALL  ADD_A_B
                POPF
                JNE   short @@ENDE
                XOR   a_E,08000H
@@ENDE:         CALL  MOV_C_A      ; Ergebnis nach C schreiben.
                RET
_EADD386        ENDP

_ESUB386       PROC      NEAR
                CALL  GETSIGNS
                CMP   CX,2         ; A < 0, B > 0 ?
                JNE   short @@1
                XOR   A_E,08000H   ; Ja: Ergebnis = - (|A|+|B|)
                CALL  ADD_A_B
                XOR   A_E,08000H
                JMP   @@ENDE
@@1:            CMP   CX,1         ; A > 0, B < 0 ?
                JNE   short @@2
                XOR   B_E,08000H   ; Ja: Ergebnis = |A|+|B|
                CALL  ADD_A_B
                JMP   @@ENDE
@@2:            CMP   CX,3         ; Beide negativ ?
                JNE   short @@3
                XOR   A_E,08000H   ; Ja: Ergebnis = |B| - |A|
                XOR   B_E,08000H
                CALL  XCHG_A_B
                XCHG  AX,BX
@@3:            CALL  SUB_A_B      ; A > 0, B > 0: Ergebnis = A - B
@@ENDE:         CALL  MOV_C_A
                RET
_ESUB386        ENDP

; Hilfsroutine, die Null oder NaN zurckliefert:

FILL_C     PROC      NEAR
            MOV     C1,EAX
            MOV     C2,EAX
            MOV     C3,EAX
            MOV     C4,EAX
            MOV     C_E,AX
           RET
FILL_C     ENDP


_EMUL386    PROC      NEAR
             mov  ax,a_e
             or   ax,ax         ; A = 0 ?
             jne  short @@_1
             jmp  Zero386       ; Ja: Ergebnis = 0
@@_1:        cmp  ax,0FFFFH     ; A = NaN ?
             jne  short @@_2
             jmp  NaN386        ; Ja: Ergebnis = NaN
@@_2:        mov  ax,b_e
             or   ax,ax         ; B = 0 ?
             jne  short @@_3
             jmp  Zero386
@@_3:        cmp  ax,0FFFFH     ; B = NaN ?
             jne  short @@_4
             jmp  NaN386
@@_4:        mov  eax,a4        ; Mantissen multiplizieren:
             mul  b4
             mov  c3,eax        ; C3 = Lo(A4*B4)
             mov  c4,edx        ; C4 = Hi(A4*B4)
                                ; u.s.w.u.s.f.
             mov  eax,a4
             mul  b3
             mov  c2,eax
             add  c3,edx
             adc  c4,0

             mov  eax,a3
             mul  b4
             add  c2,eax
             adc  c3,edx
             adc  c4,0

             mov  eax,a3
             mul  b3
             mov  c1,eax
             add  c2,edx
             adc  c3,0
             adc  c4,0

             mov  eax,a4
             mul  b2
             add  c1,eax
             adc  c2,edx
             adc  c3,0
             adc  c4,0

             mov  eax,a2
             mul  b4
             add  c1,eax
             adc  c2,edx
             adc  c3,0
             adc  c4,0

             mov  eax,a1
             mul  b4
             mov  ecx,eax
             add  c1,edx
             adc  c2,0
             adc  c3,0
             adc  c4,0

             mov  eax,a4
             mul  b1
             add  ecx,eax
             adc  c1,edx
             adc  c2,0
             adc  c3,0
             adc  c4,0

             mov  eax,a2
             mul  b3
             add  ecx,eax
             adc  c1,edx
             adc  c2,0
             adc  c3,0
             adc  c4,0

             mov  eax,a3
             mul  b2
             add  ecx,eax
             adc  c1,edx
             adc  c2,0
             adc  c3,0
             adc  c4,0

             CALL MUL_SIGNS      ; Vorzeichen & Exponenten ermitteln

             test c_4,08000h     ; Mantisse normiert ?
             jnz  short @@1
             shl  c1,1           ; Nein: Mantisse renormieren
             rcl  c2,1
             rcl  c3,1
             rcl  c4,1
             jmp  @@2
@@1:         inc  ax
@@2:         or   ax,bx
             mov  C_E,ax
            RET
_EMUL386   ENDP

NaN386:      MOV   EAX,0FFFFFFFFH
            JMP   FILL_C
Zero386:     XOR   EAX,EAX
            JMP   FILL_C

_EDIV386        PROC      NEAR
                mov  ax,a_e
                or   ax,ax
                je    Zero386
                cmp  ax,0FFFFH
                je    NaN386

                mov  ax,b_e
                or   ax,ax
                je    NaN386
                cmp  ax,0FFFFH
                je    Zero386

                XOR  EAX,EAX
                MOV  C1,EAX
                MOV  C2,EAX
                MOV  C3,EAX
                MOV  C4,EAX
                MOV  C_E,AX
                mov  ax,A_E
                mov  bx,ax
                and  ax,07fffh
                mov  cx,B_E
                mov  dx,cx
                and  cx,07fffh
                add  ax,f_bias
                sub  ax,cx
                xor  bx,dx
                and  bx,08000H
                call MCMP386
                ja   short @@1
                shr  b4,1
                rcr  b3,1
                rcr  b2,1
                rcr  b1,1
                dec  ax
@@1:            or   ax,bx    ; Start der eigentlichen Berechnung:
                mov  c_e,ax
                jmp  short @@4
@@3:            shr  b4,1
                rcr  b3,1
                rcr  b2,1
                rcr  b1,1
@@4:            mov  eax,a1
                mov  ebx,a2
                mov  ecx,a3
                mov  edx,a4
                sub  eax,b1
                sbb  ebx,b2
                sbb  ecx,b3
                sbb  edx,b4
                jc   short @@2
                mov  a1,eax
                mov  a2,ebx
                mov  a3,ecx
                mov  a4,edx
@@2:            cmc
                rcl  c1,1
                rcl  c2,1
                rcl  c3,1
                rcl  c4,1
                test c_4,08000H
                jz   @@3
                RET
_EDIV386       ENDP

QDIV           PROC  NEAR
               XOR   CX,CX
@@_1:          OR    EDI,EDI
               JE    short @@1
               SHR   EDI,1
               RCR   EDX,1
               RCR   EAX,1
               INC   CX
               JMP   @@_1
@@1:           TEST  EDX,0C0000000H
               JE    short @@2
               SHR   EDX,1
               RCR   EAX,1
               INC   CX
               JMP   @@1
@@2:           DIV   EBX
               XOR   EDX,EDX
               JCXZ  short @@4
               SHLD  EDX,EAX,CL
               SHL   EAX,CL
@@4:           RET
QDIV           ENDP

_EQDIV386     PROC  NEAR
                mov  ax,a_e
                or   ax,ax
                je   Zero386
                cmp  ax,0FFFFH
                je   NaN386
                mov  ax,b_e
                or   ax,ax
                je   NaN386
                cmp  ax,0FFFFH
                je   Zero386
                mov  ax,A_E       ; Exponentenberechnung:
                mov  bx,ax        ;
                and  ax,07fffh    ; AX = Exponent(A)
                mov  cx,B_E
                mov  dx,cx
                and  cx,07fffh    ; CX = Exponent(B)
                add  ax,f_bias
                sub  ax,cx
                xor  bx,dx
                and  bx,08000H    ; BX = SIGN(A/B)
                shr  A4,1
                rcr  A3,1
                rcr  A2,1
                rcr  A1,1
                or   ax,bx
                mov  c_e,ax       ; C_E = Exponent(A) - Exponent(B)
                xor  edi,edi
                mov  edx,A4
                mov  eax,A3
                mov  ebx,B4
                call qDiv
                MOV  C4,eax
@@1:             PUSH A4
                 PUSH A3
                 PUSH A2
                 PUSH A1
                MOV  ESI,EAX
                MUL  EBX      ; C4 * B4
                SUB  A3,EAX
                SBB  A4,EDX
                JC   @@2
                MOV  EAX,B3
                MUL  ESI      ; C4 * B3
                SUB  A2,EAX
                SBB  A3,EDX
                SBB  A4,0
                JC   short @@2
                MOV  EAX,ESI
                MUL  B2      ; C4 * B2
                SUB  A1,EAX
                SBB  A2,EDX
                SBB  A3,0
                SBB  A4,0
                JC   @@2
                MOV  EAX,ESI   ; C4 * B1
                MUL  B1
                SUB  A1,EDX
                SBB  A2,0
                SBB  A3,0
                SBB  A4,0
                JNC  @@21
@@2:            POP  A1
                POP  A2
                POP  A3
                POP  A4
                DEC  C4
                MOV  EAX,C4
                JMP  @@1
@@21:           ADD  SP,16
                MOV  EDI,A4
                MOV  EDX,A3
                MOV  EAX,A2
                CALL QDIV
                MOV  C3,EAX
                MOV  ESI,EAX
                OR   EDX,EDX
                JE   @@3
                ADD  C4,EDX
@@31:           SUB  A3,EBX
                SBB  A4,0
                MOV  EAX,B3
                SUB  A2,EAX
                SBB  A3,0
                SBB  A4,0
                MOV  EAX,B2
                SUB  A1,EAX
                SBB  A2,0
                SBB  A3,0
                SBB  A4,0
                DEC  EDX
                JNZ  @@31
@@3:            PUSH A4
                PUSH A3
                PUSH A2
                PUSH A1
                MOV  EAX,ESI
                MUL  B3    ; C3 * B3
                SUB  A1,EAX
                SBB  A2,EDX
                SBB  A3,0
                SBB  A4,0
                JC   @@4
                MOV  EAX,ESI
                MUL  B2
                SUB  A1,EDX ; C3 * B2
                SBB  A2,0
                SBB  A3,0
                SBB  A4,0
                JC   @@4
                MOV  EAX,ESI ; C3 * B4
                MUL  EBX
                SUB  A2,EAX
                SBB  A3,EDX
                SBB  A4,0
                JNC  @@5
@@4:            POP  A1
                POP  A2
                POP  A3
                POP  A4
                DEC  C3
                MOV  ESI,C3
                JMP  @@3
@@5:            ADD  SP,16
                MOV  EDI,A3
                MOV  EDX,A2
                MOV  EAX,A1
                CALL QDIV
                MOV  C2,EAX
                MOV  ESI,EAX
                OR   EDX,EDX
                JE   @@51
                ADD  C3,EDX
                ADC  C4,0
@@50:           SUB  A2,EBX
                SBB  A3,0
                SBB  A4,0
                MOV  EAX,B3
                SUB  A1,EAX
                SBB  A2,0
                SBB  A3,0
                SBB  A4,0
                DEC  EDX
                JNZ  @@50
@@51:           PUSH A1
                PUSH A3
                PUSH A2
                PUSH A1
                MOV  EAX,ESI
                MUL  EBX     ; C2 * B4
                SUB  A1,EAX
                SBB  A2,EDX
                SBB  A3,0
                SBB  A4,0
                JC   @@6
                MOV  EAX,ESI
                MUL  B3      ; C2 * B3
                SUB  A1,EDX
                SBB  A2,0
                SBB  A3,0
                SBB  A4,0
                JNC  @@61
@@6:            POP  A1
                POP  A2
                POP  A3
                POP  A4
                DEC  C2
                MOV  ESI,C2
                JMP  @@51
@@61:           ADD  SP,16
                MOV  EDI,A2
                MOV  EDX,A1
                XOR  EAX,EAX
                CALL QDIV
                MOV  C1,EAX
                ADD  C2,EDX
                ADC  C3,0
                ADC  C4,0
@@E:            TEST C_4,08000H
                JNE  short @@X
                SHL  C1,1
                RCL  C2,1
                RCL  C3,1
                RCL  C4,1
                DEC  C_E
                JMP  @@E
@@X:           RET
_EQDIV386     ENDP



SQR_SIGN      PROC   NEAR
               mov  ax,a_E
               and  ax,07FFFH
               jz   Zero386
               sub  ax,f_bias
               shl  ax,1
               add  ax,f_bias
               or   ax,ax
              RET
SQR_SIGN      ENDP

_ESQR386    PROC      NEAR
             mov  ax,a_e
             or   ax,ax
             jz   Zero386
             cmp  ax,0FFFFH
             je   NaN386
             mov  edi,a4
             mov  esi,a3
             mov  ebx,a2

             mov  eax,edi
             mul  edi
             mov  c3,eax
             mov  c4,edx

             mov  eax,edi
             mul  esi
             mov  c2,eax
             add  c3,edx
             adc  c4,0

             add  c2,eax
             adc  c3,edx
             adc  c4,0

             mov  eax,esi
             mul  esi
             mov  c1,eax
             add  c2,edx
             adc  c3,0
             adc  c4,0

             mov  eax,edi
             mul  ebx
             shl  eax,1
             rcl  edx,1
             add  c1,eax
             adc  c2,edx
             adc  c3,0
             adc  c4,0

             mov  eax,a1
             mul  edi
             shl  eax,1
             rcl  edx,1
             mov  ecx,eax
             add  c1,edx
             adc  c2,0
             adc  c3,0
             adc  c4,0

             mov  eax,ebx
             mul  esi
             shl  eax,1
             rcl  edx,1
             add  ecx,eax
             adc  c1,edx
             adc  c2,0
             adc  c3,0
             adc  c4,0

             CALL SQR_SIGN
             js   NaN386
             test c_4,08000h
             jnz  short @@1
             shl  c1,1
             rcl  c2,1
             rcl  c3,1
             rcl  c4,1
             jmp  @@2
@@1:         inc  ax
@@2:         mov  C_E,ax
            RET
_ESQR386   ENDP

;  Hilfsroutine fr _ESQRT386:

DoDiv       Proc  Near
             push  cx
             xor   cx,cx
             xor   ebx,ebx
@@1:         shr   edx,1
             rcr   eax,1
             rcr   ebx,1
             or    edx,edx
             jz    short @@2
             inc   cx
             jmp   @@1
@@2:        test  eax,0C0000000H
             jz    short @@3
             inc   cx
             jmp   @@1
@@3:        mov   edx,eax
            mov   eax,ebx
            div   edi
            xor   edx,edx
            jcxz  short @@5
            shld  edx,eax,cl
            shl   eax,cl
@@5:        pop   cx
            ret
DoDiv      endp

;-------------------------------------------------------------------------
;  Die Mantisse einer Fliekommazahl besteht aus vier Worten.
;  Sei das Ergebnis (c,d) und die Eingabe (a,b). Dann soll gelten:
;  a = hi(c*c) , b = lo(c * c) + 2 * hi(c * d)
;  => c = isqrt(a)
;  => d = ((a,b) - c * c) / 2 / c
;  Die Wurzel wird in drei Schritten gezogen:
;  1) Exponent halbieren
;  2) c als "Integerwurzel" von a berechnen
;  3) i  )  Das Quadrat von c von (a,b) abziehen.
;     ii )  Das Ergebnis durch 2 teilen.
;     iii)  Das Ergebnis durch c teilen (incl. Normalisierung fr Division)
;-------------------------------------------------------------------------
_esqrt386  Proc near
            TEST  A_E,08000H
            JNE   Zero386
            MOV   AX,A_E
            SUB   AX,f_bias
            test  ax,1           ; Exponenten geradzahlig machen:
            je    short @@start
            inc   ax
            shr   A4,1
            rcr   A3,1
            rcr   A2,1
            rcr   A1,1
@@start:    sar   ax,1
            add   ax,f_bias
            mov   C_E,ax
            ; Input normalisieren (1. Word entspr. 2^-16 !)
            shr   A4,1
            rcr   A3,1
            rcr   A2,1
            rcr   A1,1
            mov   ebx,0AAAAAAAAH  ; Willkrlichen hohen (!) Startwert setzen
            ; Iterationsschleife Xn <= (Xn + A/Xn ) / 2 :
@@1:        mov   edx,A4    ; A / Xn berechnen:
            mov   eax,A3
            div   ebx
            add   eax,ebx    ; Xn addieren:
            rcr   eax,1     ; Durch 2 teilen
            mov   edi,eax    ; Abbruchbedingung testen
            cmp   edi,ebx
            jz    short @@2
            dec   edi
            cmp   edi,ebx
            jz    short @@2
            mov   ebx,eax    ; Xn := Xn+1
            jmp   @@1
@@2:        mov   edi,eax    ; Rest berechnen:
            mul   eax        ; a * a berechnen
            sub   A3,eax     ; und abziehen
            sbb   A4,edx
            mov   edx,A4
            mov   eax,A3
           call   DoDiv      ; (DX:) AX / DI berechnen
            mov   C4,edi     ; a ist fertig
@@B:        mov   C3,eax     ; b ist fertig
            mov   esi,eax    ; b sichern
           call  @@5
            mov   eax,esi
            mul   eax             ; b * b berechnen
             sub   A1,eax    ; und abziehen
             sbb   A2,edx
             sbb   A3,0
             sbb   A4,0
            mov   eax,esi          ; a * b berechnen
            mul   edi
             sub   A2,eax    ; und zweimal abziehen
             sbb   A3,edx
             sbb   A4,0
             sub   A2,eax
             sbb   A3,edx
             sbb   A4,0
            jns   short @@20
           call  @@6
            mov   eax,esi
            dec   eax
            jmp   @@B
@@20:       add   sp,F_Size
            mov   edx,A3
            mov   eax,A2
            call  DoDiv
             add   C3,edx
             adc   C4,0
             mov   ecx,edx
@@C:        mov   C2,eax    ; c ist fertig
            mov   ebx,eax         ; c sichern
            call  @@5
            mov   eax,ebx
            mul   edi            ; a * c berechnen
            push  ecx   ; evtl. bertrag aus Division sichern
            jcxz  short @@26
            xor   ecx,ecx
            add   edx,edi
            adc   ecx,0
@@26:        sub   A1,eax   ; und zweimal abziehen :
             sbb   A2,edx
             sbb   A3,ecx
             sbb   A4,0
             sub   A1,eax
             sbb   A2,edx
             sbb   A3,ecx
             sbb   A4,0
            pop   ecx
            mov   eax,ebx         ; b * c berechnen :
            mul   esi
            xor   eax,eax
            jcxz  short @@27          ; bertrag ?
            add   edx,esi
            adc   eax,0
@@27:        sub   A1,edx   ; und zweimal abziehen :
             sbb   A2,eax
             sbb   A3,0
             sbb   A4,0
             sub   A1,edx
             sbb   A2,eax
             sbb   A3,0
             sbb   A4,0
            jns   short @@44
            call  @@6
            mov   eax,ebx
            dec   eax
            jmp   @@C
@@44:       add   sp,F_Size
            mov   edx,A2
            mov   eax,A1
            call  dodiv
             mov  C1,eax  ; d ist fertig
             add  C2,edx
             adc  C3,0
             adc  C4,0
            test  C_4,08000H
            jne   short @@4
@@3:        ; Darstellung normalisieren:
            shl   C1,1
            rcl   C2,1
            rcl   C3,1
            rcl   C4,1
            dec   C_E
            test  C_4,08000H
            je    @@3
@@4:        RET
@@5:        pop   ax ; Rcksprungaddresse vom Stack nach AX
            push  A4
            push  A3
            push  A2
            push  A1
            jmp   ax ; Entspricht RET
@@6:        pop   ax ; Rcksprungaddresse vom Stack nach AX
            pop   A1
            pop   A2
            pop   A3
            pop   A4
            jmp   ax ; Entspricht RET
_ESQRT386  endp

SQR_M       PROC  NEAR ; Zwischenergebnis in EDI:ESI:ECX:EBX
            PUSH  ECX
            XOR   EBX,EBX
            MOV   EAX,A4   ; A4 * A4
            MUL   EAX
            MOV   ESI,EAX
            MOV   EDI,EDX
            MOV   EAX,A4   ; A4 * A3
            MUL   A3
            MOV   ECX,EAX
            ADD   ESI,EDX
            ADC   EDI,0
            ADD   ECX,EAX
            ADC   ESI,EDX
            ADC   EDI,0
            MOV   EAX,A3   ; A3 * A3
            MUL   EAX
            CALL  @@2
            MOV   EAX,A4   ; A4 * A2
            MUL   A2
            CALL  @@2
            CALL  @@2
            MOV   EAX,A4    ; A4 * A1
            MUL   A1
            CALL  @@1
            MOV   EAX,A3    ; A3 * A2
            MUL   A2
            CALL  @@1
            MOV   A4,EDI
            MOV   A3,ESI
            MOV   A2,ECX
            MOV   A1,EBX
            POP   ECX
            RET
@@1:        MOV   EAX,EDX
            XOR   EDX,EDX
            SHL   EAX,1
            RCL   EDX,1
@@2:        ADD   EBX,EAX
            ADC   ECX,EDX
            ADC   ESI,0
            ADC   EDI,0
            RET
SQR_M       ENDP

_ELOG2_386 PROC  NEAR
            XOR   EAX,EAX
            MOV   C1,EAX
            MOV   C2,EAX
            MOV   C3,EAX
            MOV   C4,EAX
            CMP   A4,080000000H
            JNE   Short @@_1
            CMP   A3,0
            JNE   Short @@_1
            CMP   A2,0
            JNE   Short @@_1
            CMP   A1,0
            JNE   Short @@_1
            MOV   C_E,AX
            RET
@@_1:       MOV   C_E,03FFEH
            MOV   CX,F_Words * 16+1
@@1:        CMP   A4,080000000H
            PUSHF
            RCL   C1,1
            RCL   C2,1
            RCL   C3,1
            RCL   C4,1
            POPF
            JNC   Short @@4
            SHL   A1,1
            RCL   A2,1
            RCL   A3,1
            RCL   A4,1
@@4:        CALL  SQR_M
            LOOP  @@1
            XOR   EAX,EAX
            XOR   EBX,EBX
            XOR   ECX,ECX
            XOR   EDX,EDX
            SUB   EDX,C1
            SBB   ECX,C2
            SBB   EBX,C3
            SBB   EAX,C4
            MOV   C1,EDX
            MOV   C2,ECX
            MOV   C3,EBX
            MOV   C4,EAX
@@5:        TEST  C_4,08000H
            JNE   @@6
            SHL   C1,1
            RCL   C2,1
            RCL   C3,1
            RCL   C4,1
            DEC   C_E
            JMP   @@5
@@6:        RET
_ELOG2_386 ENDP


CODE	ENDS
	END
