UNIT EXPANDED;
INTERFACE
TYPE tExpanded=record
      MX:Array[1..4] of word; { Erweiterung der Mantisse }
      Case Byte of
      0:(E :extended;);
      1:(M:array[1..4] of word;X:Word;);
     end;

PROCEDURE CONV2EXT(var a:tExpanded;var e:extended);
PROCEDURE CONV2EXP(a:extended;var e:tExpanded);
PROCEDURE STR2EXP(s:string;var e:texpanded;var error:integer);

FUNCTION ECMP386(var a,b:tExpanded):INTEGER;

PROCEDURE EMUL386(var a,b,result:tExpanded);
PROCEDURE EADD386(var a,b,result:tExpanded);
PROCEDURE ESUB386(var a,b,result:tExpanded);
PROCEDURE EDIV386(var a,b,result:tExpanded);
PROCEDURE ESQR386(var a,result:tExpanded);
PROCEDURE ESQRT386(var a,result:tExpanded);
PROCEDURE ELOG2_386(var a,result:tExpanded);

IMPLEMENTATION
CONST
 TEN:tEXPANDED = (MX:(0,0,0,0);E:10.0);


PROCEDURE CONV2EXT(var a:tExpanded;var e:extended);
 begin
  e:=a.e;
 end;

PROCEDURE CONV2EXP(a:extended;var e:tExpanded);
 begin
  fillchar(e.mx,8,0);
  e.e:=a;
 end;

PROCEDURE STR2EXP(s:string;var e:texpanded;var error:integer);
 const ef_neg   = 1;
       ef_point = 2;
       ef_exp   = 4;
       ef_e_neg = 8;
 var i,j,k:byte;
     Flags:byte;
     B,F:tExpanded;
     N,X:Word;
 begin
  Flags:=0;
  CONV2EXP(0.0,e);
  i:=1;
  while (i<=length(s)) and (s[i]=' ') do inc (i);
  if s[i]='+' then inc(i) else
  if s[i]='-' then begin Flags:=Flags or ef_neg; inc(i); end;
  {---------- Vorkommastellen: -------------------}
  while (i<=length(s)) and (s[i] in ['0'..'9']) do
  begin
   EMUL386(E,TEN,E);
   if S[I]<>'0' then
   begin
    CONV2EXP(ORD(S[I])-ORD('0'),B);
    EADD386(E,B,E);
   end;
   INC(I);
  end;
  {------ Nachkommastellen: --------------}
  if (I<=length(S)) and (S[I] = '.') then
  begin
   Flags:=Flags or ef_point;
   INC(I);
   CONV2EXP(1.0,F);
   While (i<=length(s)) and (s[i] in ['0'..'9']) do
   begin
    EDIV386(F,TEN,F);
    if S[I]<>'0' then
    begin
     CONV2EXP(ORD(S[I])-ORD('0'),B);
     EMUL386(B,F,B);
     EADD386(E,B,E);
    end;
    INC(I);
   end;
  end;
  while (i<=length(s)) and (s[i]=' ') do inc (i);
  {---------- EXPONENT: -----------------------}
  if (i<=length(s)) and (UPCASE(S[I]) = 'E') then
  begin
   Flags:=Flags or ef_exp;
   INC(i);
   while (i<=length(s)) and (s[i]=' ') do inc (i);
   if I<=length(S) then
   begin
    if S[I]='+' then inc(i) else if s[i]='-' then
    begin
     flags:=flags or ef_e_neg;
     inc(i);
    end;
    J:=I;
    While (I+1<=Length(s)) and (S[I+1] in ['0'..'9']) do INC(I);
    Val(copy(S,J,I-J+1),X,error);
    if flags and ef_e_neg>0 then
     For N:=1 to X do EDIV386(E,TEN,E) else
     For N:=1 to X do EMUL386(E,TEN,E);
   end;
  end;
  if Flags and ef_neg>0 then E.X:=E.X or $8000;
 end;

PROCEDURE _EMUL386; external;
PROCEDURE _EADD386; external;
PROCEDURE _ESUB386; external;
PROCEDURE _EDIV386; external;
PROCEDURE _EQDIV386;external;
PROCEDURE _ESQR386; external;
PROCEDURE _ESQRT386;external;
PROCEDURE _ELOG2_386;external;
PROCEDURE _ECMP386; external;
{$L Expanded.obj}

FUNCTION ECMP386(var a,b:tExpanded):INTEGER;
 var c1:Array[1..8] of word;
     a1,b1:tExpanded;
 begin
  a1:=a;
  b1:=b;
  asm
   call _ecmp386
   mov  @result,ax
  end;
 end;

PROCEDURE EMUL386(var a,b,result:tExpanded);
 var c1,a1,b1:tExpanded;
 begin
  a1:=a;
  b1:=b;
  asm
   call _emul386
  end;
  result:=c1;
 end;

PROCEDURE EADD386(var a,b,result:tExpanded);
 var c1,a1,b1:tExpanded;
 begin
  a1:=a;
  b1:=b;
  asm
   call _eadd386
  end;
  result:=c1;
 end;

PROCEDURE ESUB386(var a,b,result:tExpanded);
 var c1,a1,b1:tExpanded;
 begin
  a1:=a;
  b1:=b;
  asm
   call _esub386
  end;
  result:=c1;
 end;

PROCEDURE EDIV386(var a,b,result:tExpanded);
 var c1,a1,b1:tExpanded;
 begin
  a1:=a;
  b1:=b;
  asm
   call _eqdiv386
  end;
  result:=c1;
 end;

PROCEDURE ESQR386(var a,result:tExpanded);
 var c1,a1:tExpanded;
 begin
  a1:=a;
  asm
   call _esqr386
  end;
  result:=c1;
 end;

PROCEDURE ESQRT386(var a,result:tExpanded);
 var c1,a1:tExpanded;
 begin
  a1:=a;
  asm
   call _esqrt386
  end;
  result:=c1;
 end;

PROCEDURE ELOG2_386(var a,result:tExpanded);
 var c1,a1:tExpanded;
 begin
  a1:=a;
  asm
   call _elog2_386
  end;
  result:=c1;
 end;


END.